/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.interpol;

import java.awt.event.KeyEvent;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration.interpol.ConstantLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConstantLookup {
    private static final String CLS_NAME = ConfigurationInterpolator.class.getName() + '.';
    private static final String FIELD = "PREFIX_CONSTANTS";
    private static final String VARNAME = CLS_NAME + "PREFIX_CONSTANTS";
    private ConstantLookup lookup;

    @Before
    public void setUp() throws Exception {
        this.lookup = new ConstantLookup();
    }

    @After
    public void tearDown() throws Exception {
        ConstantLookup.clear();
    }

    @Test
    public void testLookupConstant() {
        Assert.assertEquals((String)"Wrong value of constant", (Object)"const", (Object)this.lookup.lookup(VARNAME));
    }

    @Test
    public void testLookupNonExisting() {
        Assert.assertNull((String)"Non null return value for non existing constant", (Object)this.lookup.lookup(CLS_NAME + "NO_FIELD"));
    }

    @Test
    public void testLookupPrivate() {
        Assert.assertNull((String)"Non null return value for non accessable field", (Object)this.lookup.lookup(CLS_NAME + "PREFIX_SEPARATOR"));
    }

    @Test
    public void testLookupUnknownClass() {
        Assert.assertNull((String)"Non null return value for unknown class", (Object)this.lookup.lookup("org.apache.commons.configuration.NonExistingConfig.PREFIX_CONSTANTS"));
    }

    @Test
    public void testLookupInvalidSyntax() {
        Assert.assertNull((String)"Non null return value for invalid variable name", (Object)this.lookup.lookup("InvalidVariableName"));
    }

    @Test
    public void testLookupNull() {
        Assert.assertNull((String)"Non null return value for null variable", (Object)this.lookup.lookup(null));
    }

    @Test
    public void testLookupCache() {
        this.testLookupConstant();
        this.testLookupConstant();
    }

    @Test
    public void testLookupNonStringFromCache() {
        String var = KeyEvent.class.getName() + ".VK_ESCAPE";
        String expected = String.valueOf(27);
        Assert.assertEquals((String)"Wrong result of first lookup", (Object)expected, (Object)this.lookup.lookup(var));
        Assert.assertEquals((String)"Wrong result of 2nd lookup", (Object)expected, (Object)this.lookup.lookup(var));
    }
}

