/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationErrorListenerImpl;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.apache.commons.configuration.DatabaseConfigurationTestHelper;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDatabaseConfiguration {
    private static final String CONFIG_NAME2 = "anotherTestConfig";
    private ConfigurationErrorListenerImpl listener;
    private DatabaseConfigurationTestHelper helper;

    @Before
    public void setUp() throws Exception {
        this.helper = new DatabaseConfigurationTestHelper();
        this.helper.setUp();
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            Assert.assertEquals((String)"An internal error occurred", (long)0L, (long)this.listener.getErrorCount());
        }
        this.helper.tearDown();
    }

    private PotentialErrorDatabaseConfiguration setUpConfig() {
        return new PotentialErrorDatabaseConfiguration(this.helper.getDatasource(), "configuration", "key", "value");
    }

    private void setUpErrorListener(PotentialErrorDatabaseConfiguration config) {
        config.removeErrorListener((ConfigurationErrorListener)config.getErrorListeners().iterator().next());
        this.listener = new ConfigurationErrorListenerImpl();
        config.addErrorListener(this.listener);
        config.failOnConnect = true;
    }

    private PotentialErrorDatabaseConfiguration setUpErrorConfig() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        this.setUpErrorListener(config);
        return config;
    }

    private void checkErrorListener(int type, String key, Object value) {
        this.listener.verify(type, key, value);
        Assert.assertTrue((String)"Wrong event source", (boolean)(this.listener.getLastEvent().getSource() instanceof DatabaseConfiguration));
        Assert.assertTrue((String)"Wrong exception", (boolean)(this.listener.getLastEvent().getCause() instanceof SQLException));
        this.listener = null;
    }

    @Test
    public void testDoCommitsDefault() {
        DatabaseConfiguration config = new DatabaseConfiguration(this.helper.getDatasource(), "configuration", "key", "value");
        Assert.assertFalse((String)"Wrong commits flag", (boolean)config.isDoCommits());
    }

    @Test
    public void testDoCommitsDefaultMulti() {
        DatabaseConfiguration config = new DatabaseConfiguration(this.helper.getDatasource(), "configuration", "name", "key", "value", "test");
        Assert.assertFalse((String)"Wrong commits flag", (boolean)config.isDoCommits());
    }

    @Test
    public void testAddPropertyDirectSingle() {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddPropertyDirectCommit() {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddPropertyDirectMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.addPropertyDirect("key", (Object)"value");
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("key"));
    }

    @Test
    public void testAddNonStringProperty() {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.addPropertyDirect("boolean", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"missing property", (boolean)config.containsKey("boolean"));
    }

    @Test
    public void testGetPropertyDirectSingle() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assert.assertEquals((String)"property1", (Object)"value1", (Object)config.getProperty("key1"));
        Assert.assertEquals((String)"property2", (Object)"value2", (Object)config.getProperty("key2"));
        Assert.assertEquals((String)"unknown property", null, (Object)config.getProperty("key3"));
    }

    @Test
    public void testGetPropertyDirectMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assert.assertEquals((String)"property1", (Object)"value1", (Object)config.getProperty("key1"));
        Assert.assertEquals((String)"property2", (Object)"value2", (Object)config.getProperty("key2"));
        Assert.assertEquals((String)"unknown property", null, (Object)config.getProperty("key3"));
    }

    @Test
    public void testClearPropertySingle() {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearPropertyMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearPropertyMultipleOtherConfig() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        DatabaseConfiguration config2 = this.helper.setUpMultiConfig(CONFIG_NAME2);
        config2.addProperty("key1", (Object)"some test");
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"Property cleared in other config", (boolean)config2.containsKey("key1"));
    }

    @Test
    public void testClearPropertyCommit() {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clearProperty("key1");
        Assert.assertFalse((String)"property not cleared", (boolean)config.containsKey("key1"));
    }

    @Test
    public void testClearSingle() {
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testClearMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testClearCommit() {
        this.helper.setAutoCommit(false);
        DatabaseConfiguration config = this.helper.setUpConfig();
        config.clear();
        Assert.assertTrue((String)"configuration is not cleared", (boolean)config.isEmpty());
    }

    @Test
    public void testGetKeysSingle() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Iterator it = config.getKeys();
        Assert.assertEquals((String)"1st key", (Object)"key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"key2", it.next());
    }

    @Test
    public void testGetKeysMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Iterator it = config.getKeys();
        Assert.assertEquals((String)"1st key", (Object)"key1", it.next());
        Assert.assertEquals((String)"2nd key", (Object)"key2", it.next());
    }

    @Test
    public void testContainsKeySingle() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Assert.assertTrue((String)"missing key1", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"missing key2", (boolean)config.containsKey("key2"));
    }

    @Test
    public void testContainsKeyMultiple() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        Assert.assertTrue((String)"missing key1", (boolean)config.containsKey("key1"));
        Assert.assertTrue((String)"missing key2", (boolean)config.containsKey("key2"));
    }

    @Test
    public void testIsEmptySingle() {
        PotentialErrorDatabaseConfiguration config1 = this.setUpConfig();
        Assert.assertFalse((String)"The configuration is empty", (boolean)config1.isEmpty());
    }

    @Test
    public void testIsEmptyMultiple() {
        DatabaseConfiguration config1 = this.helper.setUpMultiConfig();
        Assert.assertFalse((String)"The configuration named 'test' is empty", (boolean)config1.isEmpty());
        DatabaseConfiguration config2 = new DatabaseConfiguration(this.helper.getDatasource(), "configurations", "name", "key", "value", "testIsEmpty");
        Assert.assertTrue((String)"The configuration named 'testIsEmpty' is not empty", (boolean)config2.isEmpty());
    }

    @Test
    public void testGetList() {
        DatabaseConfiguration config1 = new DatabaseConfiguration(this.helper.getDatasource(), "configurationList", "key", "value");
        List list = config1.getList("key3");
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testGetKeys() {
        DatabaseConfiguration config1 = new DatabaseConfiguration(this.helper.getDatasource(), "configurationList", "key", "value");
        Iterator i = config1.getKeys();
        Assert.assertTrue((boolean)i.hasNext());
        Object key = i.next();
        Assert.assertEquals((Object)"key3", (Object)key.toString());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testClearSubset() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        Configuration subset = config.subset("key1");
        subset.clear();
        Assert.assertTrue((String)"the subset is not empty", (boolean)subset.isEmpty());
        Assert.assertFalse((String)"the parent configuration is empty", (boolean)config.isEmpty());
    }

    @Test
    public void testLogErrorListener() {
        DatabaseConfiguration config = new DatabaseConfiguration(this.helper.getDatasource(), "configuration", "key", "value");
        Assert.assertEquals((String)"No error listener registered", (long)1L, (long)config.getErrorListeners().size());
    }

    @Test
    public void testGetPropertyError() {
        this.setUpErrorConfig().getProperty("key1");
        this.checkErrorListener(5, "key1", null);
    }

    @Test
    public void testAddPropertyError() {
        this.setUpErrorConfig().addProperty("key1", "value");
        this.checkErrorListener(1, "key1", "value");
    }

    @Test
    public void testIsEmptyError() {
        Assert.assertTrue((String)"Wrong return value for failure", (boolean)this.setUpErrorConfig().isEmpty());
        this.checkErrorListener(5, null, null);
    }

    @Test
    public void testContainsKeyError() {
        Assert.assertFalse((String)"Wrong return value for failure", (boolean)this.setUpErrorConfig().containsKey("key1"));
        this.checkErrorListener(5, "key1", null);
    }

    @Test
    public void testClearPropertyError() {
        this.setUpErrorConfig().clearProperty("key1");
        this.checkErrorListener(2, "key1", null);
    }

    @Test
    public void testClearError() {
        this.setUpErrorConfig().clear();
        this.checkErrorListener(4, null, null);
    }

    @Test
    public void testGetKeysError() {
        Iterator it = this.setUpErrorConfig().getKeys();
        this.checkErrorListener(5, null, null);
        Assert.assertFalse((String)"Iteration is not empty", (boolean)it.hasNext());
    }

    @Test
    public void testGetListWithDelimiter() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiter(';');
        List values = config.getList("keyMulti");
        Assert.assertEquals((String)"Wrong number of list elements", (long)3L, (long)values.size());
        Assert.assertEquals((String)"Wrong list element 0", (Object)"a", values.get(0));
        Assert.assertEquals((String)"Wrong list element 2", (Object)"c", values.get(2));
    }

    @Test
    public void testGetListWithDelimiterParsingDisabled() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiter(';');
        config.setDelimiterParsingDisabled(true);
        Assert.assertEquals((String)"Wrong value of property", (Object)"a;b;c", (Object)config.getString("keyMulti"));
    }

    @Test
    public void testAddWithDelimiter() {
        PotentialErrorDatabaseConfiguration config = this.setUpConfig();
        config.setListDelimiter(';');
        config.addProperty("keyList", "1;2;3");
        String[] values = config.getStringArray("keyList");
        Assert.assertEquals((String)"Wrong number of property values", (long)3L, (long)values.length);
        Assert.assertEquals((String)"Wrong value at index 1", (Object)"2", (Object)values[1]);
    }

    @Test
    public void testSetPropertyWithDelimiter() {
        DatabaseConfiguration config = this.helper.setUpMultiConfig();
        config.setListDelimiter(';');
        config.setProperty("keyList", (Object)"1;2;3");
        String[] values = config.getStringArray("keyList");
        Assert.assertEquals((String)"Wrong number of property values", (long)3L, (long)values.length);
        Assert.assertEquals((String)"Wrong value at index 1", (Object)"2", (Object)values[1]);
    }

    static class PotentialErrorDatabaseConfiguration
    extends DatabaseConfiguration {
        boolean failOnConnect;

        public PotentialErrorDatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
            super(datasource, table, keyColumn, valueColumn);
        }

        protected Connection getConnection() throws SQLException {
            if (this.failOnConnect) {
                throw new SQLException("Simulated DB error");
            }
            return super.getConnection();
        }
    }
}

