/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.configuration.Configuration;

public class NonStringTestHolder {
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void testBoolean() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean");
        Assert.assertTrue((boolean)booleanValue);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.boolean").size());
    }

    public void testBooleanDefaultValue() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean.missing", true);
        Assert.assertTrue((boolean)booleanValue);
        Boolean booleanObject = this.configuration.getBoolean("test.boolean.missing", new Boolean(true));
        Assert.assertEquals((Object)new Boolean(true), (Object)booleanObject);
    }

    public void testByte() throws Exception {
        byte testValue = 10;
        byte byteValue = this.configuration.getByte("test.byte");
        Assert.assertEquals((byte)testValue, (byte)byteValue);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.byte").size());
    }

    public void testDouble() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double");
        Assert.assertEquals((double)testValue, (double)doubleValue, (double)0.01);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.double").size());
    }

    public void testDoubleDefaultValue() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double.missing", 10.25);
        Assert.assertEquals((double)testValue, (double)doubleValue, (double)0.01);
    }

    public void testFloat() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float");
        Assert.assertEquals((double)testValue, (double)floatValue, (double)0.01);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.float").size());
    }

    public void testFloatDefaultValue() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float.missing", testValue);
        Assert.assertEquals((double)testValue, (double)floatValue, (double)0.01);
    }

    public void testInteger() throws Exception {
        int intValue = this.configuration.getInt("test.integer");
        Assert.assertEquals((int)10, (int)intValue);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.integer").size());
    }

    public void testIntegerDefaultValue() throws Exception {
        int intValue = this.configuration.getInt("test.integer.missing", 10);
        Assert.assertEquals((int)10, (int)intValue);
    }

    public void testLong() throws Exception {
        long longValue = this.configuration.getLong("test.long");
        Assert.assertEquals((long)1000000L, (long)longValue);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.long").size());
    }

    public void testLongDefaultValue() throws Exception {
        long longValue = this.configuration.getLong("test.long.missing", 1000000L);
        Assert.assertEquals((long)1000000L, (long)longValue);
    }

    public void testShort() throws Exception {
        short shortValue = this.configuration.getShort("test.short");
        Assert.assertEquals((int)1, (int)shortValue);
        Assert.assertEquals((int)1, (int)this.configuration.getList("test.short").size());
    }

    public void testShortDefaultValue() throws Exception {
        short shortValue = this.configuration.getShort("test.short.missing", (short)1);
        Assert.assertEquals((int)1, (int)shortValue);
    }

    public void testListMissing() throws Exception {
        List list = this.configuration.getList("missing.list");
        Assert.assertTrue((String)"'missing.list' is not empty", (boolean)list.isEmpty());
    }

    public void testSubset() throws Exception {
        Configuration subset = this.configuration.subset("test");
        boolean foundKeyValue = false;
        Iterator it = subset.getKeys();
        while (it.hasNext() && !foundKeyValue) {
            String key = (String)it.next();
            foundKeyValue = "short".equals(key);
        }
        Assert.assertTrue((String)"'short' key not found in the subset key iterator", (boolean)foundKeyValue);
    }

    public void testIsEmpty() throws Exception {
        Assert.assertTrue((String)"Configuration should not be empty", (!this.configuration.isEmpty() ? 1 : 0) != 0);
    }
}

