/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.arj;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArjArchiveInputStreamTest
extends AbstractTest {
    ArjArchiveInputStreamTest() {
    }

    private void assertArjArchiveEntry(ArjArchiveEntry entry) {
        Assertions.assertNotNull((Object)entry.getName());
        Assertions.assertNotNull((Object)entry.getLastModifiedDate());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).getHostOs());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).getMethod());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).getMode());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).getSize());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).getUnixMode());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).isDirectory());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).isHostOsUnix());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveEntry)entry).hashCode());
        Assertions.assertDoesNotThrow(entry::toString);
        Assertions.assertDoesNotThrow(() -> entry.resolveIn(this.getTempDirPath()));
    }

    private void assertArjArchiveInputStream(ArjArchiveInputStream archive) {
        Assertions.assertDoesNotThrow(() -> archive.available());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).getArchiveComment());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).getArchiveName());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).getBytesRead());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).getCharset());
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).getCount());
        Assertions.assertDoesNotThrow(archive::hashCode);
        Assertions.assertDoesNotThrow(() -> ((ArjArchiveInputStream)archive).markSupported());
    }

    private void assertForEach(ArjArchiveInputStream archive) throws IOException {
        this.assertArjArchiveInputStream(archive);
        archive.forEach(entry -> {
            this.assertArjArchiveEntry((ArjArchiveEntry)entry);
            this.assertArjArchiveInputStream(archive);
        });
    }

    @Test
    void testFirstHeaderSizeSetToZero() throws Exception {
        try (InputStream in = ArjArchiveInputStreamTest.newInputStream("org/apache/commons/compress/arj/zero_sized_headers-fail.arj");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> {
                try (ArjArchiveInputStream archive = new ArjArchiveInputStream(in);){
                    Assertions.fail((String)"ArchiveException not thrown.");
                }
            });
            Assertions.assertTrue((boolean)(ex.getCause() instanceof IOException));
        }
    }

    @Test
    void testForEach() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            in.forEach(entry -> {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
                Assertions.assertFalse((boolean)entry.isDirectory());
                this.assertArjArchiveEntry((ArjArchiveEntry)entry);
            });
        }
        Assertions.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    @Test
    void testGetNextEntry() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            ArjArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
                Assertions.assertFalse((boolean)entry.isDirectory());
                this.assertArjArchiveEntry(entry);
            }
        }
        Assertions.assertEquals((Object)expected.toString(), (Object)result.toString());
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = ArjArchiveInputStreamTest.newInputStream("bla.arj");
             ArjArchiveInputStream archive = new ArjArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            this.assertForEach(archive);
        }
    }

    @Test
    void testRead() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        Charset charset = Charset.defaultCharset();
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();
             ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            ArjArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int tmp;
                result.write(entry.getName().getBytes(charset));
                while ((tmp = in.read()) != -1) {
                    result.write(tmp);
                }
                Assertions.assertFalse((boolean)entry.isDirectory());
                this.assertArjArchiveEntry(entry);
            }
            result.flush();
            Assertions.assertEquals((Object)expected.toString(), (Object)result.toString(charset));
        }
    }

    @Test
    void testReadByteArray() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        Charset charset = Charset.defaultCharset();
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();
             ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            in.forEach(entry -> {
                int count;
                result.write(entry.getName().getBytes(charset));
                byte[] tmp = new byte[2];
                while ((count = in.read(tmp)) != -1) {
                    result.write(tmp, 0, count);
                }
                Assertions.assertFalse((boolean)entry.isDirectory());
                this.assertArjArchiveEntry((ArjArchiveEntry)entry);
            });
            result.flush();
            Assertions.assertEquals((Object)expected.toString(), (Object)result.toString(charset));
        }
    }

    @Test
    void testReadByteArrayIndex() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        Charset charset = Charset.defaultCharset();
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();
             ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            in.forEach(entry -> {
                int count;
                result.write(entry.getName().getBytes(charset));
                byte[] tmp = new byte[10];
                while ((count = in.read(tmp, 0, 2)) != -1) {
                    result.write(tmp, 0, count);
                }
                Assertions.assertFalse((boolean)entry.isDirectory());
                this.assertArjArchiveEntry((ArjArchiveEntry)entry);
            });
            result.flush();
            Assertions.assertEquals((Object)expected.toString(), (Object)result.toString(charset));
        }
    }

    @Test
    void testReadingOfAttributesDosVersion() throws Exception {
        try (ArjArchiveInputStream archive = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.arj"));){
            ArjArchiveEntry entry = archive.getNextEntry();
            Assertions.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assertions.assertEquals((long)30L, (long)entry.getSize());
            Assertions.assertEquals((int)0, (int)entry.getUnixMode());
            Calendar cal = Calendar.getInstance();
            cal.set(2008, 9, 6, 23, 50, 52);
            cal.set(14, 0);
            Assertions.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
            this.assertForEach(archive);
        }
    }

    @Test
    void testReadingOfAttributesUnixVersion() throws Exception {
        try (ArjArchiveInputStream in = new ArjArchiveInputStream(ArjArchiveInputStreamTest.newInputStream("bla.unix.arj"));){
            ArjArchiveEntry entry = in.getNextEntry();
            Assertions.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assertions.assertEquals((long)30L, (long)entry.getSize());
            Assertions.assertEquals((int)436, (int)(entry.getUnixMode() & 0xFFF));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0000"));
            cal.set(2008, 9, 6, 21, 50, 52);
            cal.set(14, 0);
            Assertions.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
            this.assertForEach(in);
        }
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = ArjArchiveInputStreamTest.newInputStream("bla.arj");
             ArjArchiveInputStream archive = new ArjArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
            this.assertForEach(archive);
        }
    }
}

