/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.function.DoubleFunction;
import org.objectstyle.ashwood.graph.layout.NestedSubgraph;
import org.objectstyle.ashwood.graph.layout.NestingTreeNode;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.MedianUtils;

public class LayerVertex
implements Comparable,
NestingTreeNode {
    public static final Comparator LAYER_INDEX_COMPARATOR = new LayerIndexComparator();
    public static final DoubleFunction POSITION_IN_LAYER = new PositionInLayer();
    private int rank;
    private int indexInLayer;
    private double weight;
    private double centerX;
    private double centerY;
    private double width;
    private double height;
    private ArrayList predecessors;
    private ArrayList successors;
    private Object userVertex;
    private NestedSubgraph parentSubgraph;
    private double leftX = Double.NaN;
    private double rightX = Double.NaN;
    private int classIndex = -1;

    public LayerVertex(Object userVertex, int predCapacity, int succCapacity) {
        this.userVertex = userVertex;
        this.predecessors = new ArrayList(Math.max(predCapacity, 1));
        this.successors = new ArrayList(Math.max(succCapacity, 1));
    }

    public int[] getSuccessorIndices() {
        int succSize = this.successors.size();
        int[] succIndices = new int[succSize];
        for (int j = 0; j < succSize; ++j) {
            succIndices[j] = ((LayerVertex)this.successors.get((int)j)).indexInLayer;
        }
        Arrays.sort(succIndices);
        return succIndices;
    }

    public int compareTo(Object o) {
        return Double.compare(this.weight, ((LayerVertex)o).weight);
    }

    public double rubberForce() {
        int succSize;
        double forceValue = 0.0;
        int predSize = this.predecessors.size();
        if (predSize + (succSize = this.successors.size()) == 0) {
            return 0.0;
        }
        forceValue = this.deflection() / (double)(predSize + succSize);
        return forceValue;
    }

    public double predecessorPendulumForce() {
        return this.pendulumForce(this.predecessors);
    }

    public double successorPendulumForce() {
        return this.pendulumForce(this.successors);
    }

    public double predecessorDeflection() {
        return this.deflection(this.predecessors);
    }

    public double successorDeflection() {
        return this.deflection(this.successors);
    }

    public double deflection() {
        return this.deflection(this.predecessors) + this.deflection(this.successors);
    }

    public double successorMedianValue() {
        return this.medianValue(this.successors);
    }

    public double predecessorMedianValue() {
        return this.medianValue(this.predecessors);
    }

    public double distanceToLeft(LayerVertex leftNeighbor) {
        if (leftNeighbor == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getMinX() - leftNeighbor.getMaxX();
    }

    public boolean isTouchingToLeft(LayerVertex leftNeighbor, double minDistance) {
        return this.distanceToLeft(leftNeighbor) <= minDistance;
    }

    public double minCenterDistance(LayerVertex vertex, double spacing) {
        return (this.width + vertex.width) / 2.0 + spacing;
    }

    public double getMaxX() {
        return this.centerX + this.width / 2.0;
    }

    public double getMinX() {
        return this.centerX - this.width / 2.0;
    }

    public double getMaxY() {
        return this.centerY + this.height / 2.0;
    }

    public double getMinY() {
        return this.centerY - this.height / 2.0;
    }

    public double moveX(double distance) {
        return this.centerX += distance;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public int getIndexInLayer() {
        return this.indexInLayer;
    }

    public void setIndexInLayer(int indexInLayer) {
        this.indexInLayer = indexInLayer;
    }

    public ArrayList getPredecessors() {
        return this.predecessors;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList getSuccessors() {
        return this.successors;
    }

    public Object getUserVertex() {
        return this.userVertex;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getWidth() {
        return this.width;
    }

    public void setUserVertex(Object userVertex) {
        this.userVertex = userVertex;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setSuccessors(ArrayList successors) {
        this.successors = successors;
    }

    public void setPredecessors(ArrayList predecessors) {
        this.predecessors = predecessors;
    }

    private double pendulumForce(ArrayList adjacent) {
        double forceValue = 0.0;
        int size = adjacent.size();
        if (size == 0) {
            return 0.0;
        }
        forceValue = this.deflection(adjacent) / (double)size;
        return forceValue;
    }

    private double deflection(ArrayList adjacent) {
        double value = 0.0;
        int size = adjacent.size();
        for (int i = 0; i < size; ++i) {
            LayerVertex v = (LayerVertex)adjacent.get(i);
            value += v.centerX - this.centerX;
        }
        return value;
    }

    private double medianValue(ArrayList adjacent) {
        if (adjacent.size() > 1) {
            Collections.sort(adjacent, LAYER_INDEX_COMPARATOR);
        }
        this.weight = MedianUtils.weightedMedianValue(adjacent, POSITION_IN_LAYER);
        return this.weight;
    }

    public int inDegree() {
        return this.predecessors.size();
    }

    public int outDegree() {
        return this.successors.size();
    }

    public int degree() {
        return this.predecessors.size() + this.successors.size();
    }

    public LayerVertex getPredecessor(int index) {
        return index < this.inDegree() ? (LayerVertex)this.predecessors.get(index) : null;
    }

    public LayerVertex getSuccessor(int index) {
        return index < this.outDegree() ? (LayerVertex)this.successors.get(index) : null;
    }

    public int countLeftCrossings(int[] leftNeighborSuccIndices) {
        int succSize = this.successors.size();
        int count = 0;
        for (int k = 0; k < succSize; ++k) {
            LayerVertex successor = (LayerVertex)this.successors.get(k);
            int succIndex = successor.getIndexInLayer();
            for (int l = leftNeighborSuccIndices.length - 1; l >= 0 && leftNeighborSuccIndices[l] > succIndex; --l) {
                ++count;
            }
        }
        return count;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setGeometry(Attribute shapeAttribute) {
        RectangularShape shape = (RectangularShape)shapeAttribute.get(this.userVertex);
        if (shape != null) {
            this.width = shape.getWidth();
            this.height = shape.getHeight();
            this.centerX = shape.getCenterX();
            this.centerY = shape.getCenterY();
        } else {
            this.centerY = 0.0;
            this.centerX = 0.0;
            this.height = 0.0;
            this.width = 0.0;
        }
    }

    public void updateGeometry(Attribute shapeAttribute) {
        RectangularShape shape = (RectangularShape)shapeAttribute.get(this.userVertex);
        if (shape != null) {
            shape.setFrame(this.centerX - this.width / 2.0, this.centerY - this.height / 2.0, this.width, this.height);
        }
    }

    public boolean isDummy() {
        return this.userVertex == null;
    }

    public void setParentSubgraph(NestedSubgraph parentSubgraph) {
        this.parentSubgraph = parentSubgraph;
    }

    public NestedSubgraph getParentSubgraph() {
        return this.parentSubgraph;
    }

    public void setLeftX(double leftX) {
        this.leftX = leftX;
    }

    public double getLeftX() {
        return this.leftX;
    }

    public void setRightX(double rightX) {
        this.rightX = rightX;
    }

    public double getRightX() {
        return this.rightX;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public double getPosition() {
        return this.indexInLayer;
    }

    public int countVertices(int rank) {
        return rank != this.rank ? 0 : 1;
    }

    public int getVertexCount(int rank) {
        return rank != this.rank ? 0 : 1;
    }

    public double computePosition(int rank) {
        return rank != this.rank ? Double.NaN : (double)this.indexInLayer;
    }

    public int countVertices() {
        return 1;
    }

    public double getPosition(int rank) {
        return this.computePosition(rank);
    }

    public int getVertexCount() {
        return 1;
    }

    public double computePosition() {
        return this.indexInLayer;
    }

    public int reindex(int rank, int firstIndex, Comparator comparator, Predicate predicate) {
        this.indexInLayer = firstIndex++;
        return firstIndex;
    }

    public boolean isDefinedLeftX() {
        return !Double.isNaN(this.leftX);
    }

    public boolean isDefinedRightX() {
        return !Double.isNaN(this.rightX);
    }

    public String toString() {
        return this.userVertex != null ? this.userVertex.toString() : "*";
    }

    public boolean includesRank(int rank) {
        return this.rank == rank;
    }

    public static class PositionInLayer
    implements DoubleFunction {
        public double doubleValue(Object vertex) {
            return ((LayerVertex)vertex).indexInLayer;
        }
    }

    public static class LayerIndexComparator
    implements Comparator {
        public int compare(Object vertex1, Object vertex2) {
            return ((LayerVertex)vertex1).indexInLayer - ((LayerVertex)vertex2).indexInLayer;
        }
    }
}

