/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.dba.sqlserver.SQLServerActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerMergerFactory;
import org.apache.cayenne.dba.sqlserver.SQLServerTrimmingQualifierTranslator;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class SQLServerAdapter
extends SybaseAdapter {
    public static final String TRIM_FUNCTION = "RTRIM";

    public SQLServerAdapter() {
        this.setSupportsGeneratedKeys(true);
        this.setSupportsBatchUpdates(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new SQLServerActionBuilder(this, node.getEntityResolver()));
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new SQLServerTrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" IDENTITY (1, 1)");
        }
    }

    public MergerFactory mergerFactory() {
        return new SQLServerMergerFactory();
    }
}

