/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.HierarchicalObjectResolver;
import org.apache.cayenne.access.HierarchicalObjectResolverNode;
import org.apache.cayenne.access.JoinedIdParentAttachementStrategy;
import org.apache.cayenne.access.NoopParentAttachmentStrategy;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.PrefetchProcessorJointNode;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.ResultScanParentAttachmentStrategy;
import org.apache.cayenne.access.StackLookupParentAttachmentStrategy;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;

final class PrefetchProcessorTreeBuilder
implements PrefetchProcessor {
    private QueryMetadata queryMetadata;
    private DataContext context;
    private PrefetchProcessorNode root;
    private LinkedList<PrefetchProcessorNode> nodeStack;
    private ClassDescriptor descriptor;
    private List mainResultRows;
    private Map extraResultsByPath;

    PrefetchProcessorTreeBuilder(HierarchicalObjectResolver objectTreeResolver, List mainResultRows, Map extraResultsByPath) {
        this.context = objectTreeResolver.context;
        this.queryMetadata = objectTreeResolver.queryMetadata;
        this.mainResultRows = mainResultRows;
        this.extraResultsByPath = extraResultsByPath;
        this.descriptor = objectTreeResolver.descriptor;
    }

    PrefetchProcessorNode buildTree(PrefetchTreeNode tree) {
        this.nodeStack = new LinkedList();
        this.root = null;
        tree.traverse(this);
        if (this.root == null) {
            throw new CayenneRuntimeException("Failed to create prefetch processing tree.");
        }
        return this.root;
    }

    public boolean startPhantomPrefetch(PrefetchTreeNode node) {
        if (this.getParent() == null) {
            return this.startDisjointPrefetch(node);
        }
        PrefetchProcessorNode decorated = new PrefetchProcessorNode(this.getParent(), node.getName());
        decorated.setPhantom(true);
        return this.addNode(decorated);
    }

    public boolean startDisjointPrefetch(PrefetchTreeNode node) {
        PrefetchProcessorNode decorated = !node.adjacentJointNodes().isEmpty() ? new PrefetchProcessorJointNode(this.getParent(), node.getName()) : new PrefetchProcessorNode(this.getParent(), node.getName());
        decorated.setPhantom(false);
        decorated.setSemantics(2);
        return this.addNode(decorated);
    }

    public boolean startJointPrefetch(PrefetchTreeNode node) {
        PrefetchProcessorJointNode decorated = new PrefetchProcessorJointNode(this.getParent(), node.getName());
        decorated.setPhantom(false);
        decorated.setSemantics(1);
        boolean result = this.addNode(decorated);
        PrefetchProcessorNode groupNode = decorated;
        while (groupNode.getParent() != null && !groupNode.isDisjointPrefetch()) {
            groupNode = (PrefetchProcessorNode)groupNode.getParent();
            groupNode.setJointChildren(true);
        }
        return result;
    }

    public boolean startUnknownPrefetch(PrefetchTreeNode node) {
        return this.startDisjointPrefetch(node);
    }

    public void finishPrefetch(PrefetchTreeNode node) {
        this.nodeStack.removeLast();
    }

    boolean addNode(PrefetchProcessorNode node) {
        ClassDescriptor descriptor;
        ArcProperty arc;
        List rows;
        PrefetchProcessorNode currentNode = this.getParent();
        if (currentNode != null) {
            rows = (List)this.extraResultsByPath.get(node.getPath());
            arc = (ArcProperty)currentNode.getResolver().getDescriptor().getProperty(node.getName());
            if (arc == null) {
                throw new CayenneRuntimeException("No relationship with name '" + node.getName() + "' found in entity " + currentNode.getResolver().getEntity().getName());
            }
            descriptor = arc.getTargetDescriptor();
        } else {
            arc = null;
            descriptor = this.descriptor != null ? this.descriptor : this.queryMetadata.getClassDescriptor();
            rows = this.mainResultRows;
        }
        node.setDataRows(rows);
        node.setIncoming(arc);
        if (node.getParent() != null && !node.isJointPrefetch()) {
            node.setResolver(new HierarchicalObjectResolverNode(node, this.context, descriptor, this.queryMetadata.isRefreshingObjects()));
        } else {
            node.setResolver(new ObjectResolver(this.context, descriptor, this.queryMetadata.isRefreshingObjects()));
        }
        if (node.getParent() == null || node.getParent().isPhantom()) {
            node.setParentAttachmentStrategy(new NoopParentAttachmentStrategy());
        } else if (node.isJointPrefetch()) {
            node.setParentAttachmentStrategy(new StackLookupParentAttachmentStrategy(node));
        } else if (node.getIncoming().getRelationship().isSourceIndependentFromTargetChange()) {
            node.setParentAttachmentStrategy(new JoinedIdParentAttachementStrategy(this.context.getGraphManager(), node));
        } else {
            node.setParentAttachmentStrategy(new ResultScanParentAttachmentStrategy(node));
        }
        if (currentNode != null) {
            currentNode.addChild(node);
        }
        node.afterInit();
        if (this.nodeStack.isEmpty()) {
            this.root = node;
        }
        this.nodeStack.addLast(node);
        return true;
    }

    PrefetchProcessorNode getParent() {
        return this.nodeStack.isEmpty() ? null : this.nodeStack.getLast();
    }
}

