/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.select.CompoundRowReader;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.select.SelectColumn;
import org.apache.cayenne.access.select.SelectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundSelectDescriptor
implements SelectDescriptor<Object[]> {
    private SelectDescriptor<Object>[] segments;
    private CompoundRowReader rowReader;
    private List<SelectColumn> columns;

    CompoundSelectDescriptor(SelectDescriptor<Object>[] segments) {
        this.segments = segments;
    }

    @Override
    public List<SelectColumn> getColumns() {
        return this.columns;
    }

    @Override
    public RowReader<Object[]> getRowReader(ResultSet resultSet) throws CayenneException {
        if (this.rowReader == null) {
            this.willReadResultSet(resultSet);
        }
        return this.rowReader;
    }

    private void willReadResultSet(ResultSet resultSet) throws CayenneException {
        this.columns = new ArrayList<SelectColumn>();
        this.rowReader = new CompoundRowReader(this.segments.length);
        for (int i = 0; i < this.segments.length; ++i) {
            int offset = this.columns.size();
            this.columns.addAll(this.segments[i].getColumns());
            RowReader<Object> rowReader = this.segments[i].getRowReader(resultSet);
            rowReader.setColumnOffset(offset);
            this.rowReader.addRowReader(i, rowReader);
        }
    }
}

