/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDomainDBDiffBuilder
implements GraphChangeHandler {
    private ObjEntity objEntity;
    private DbEntity dbEntity;
    private Map<Object, Object> currentPropertyDiff;
    private Map<Object, Object> currentArcDiff;
    private Object currentId;

    DataDomainDBDiffBuilder() {
    }

    void reset(DbEntityClassDescriptor descriptor) {
        this.objEntity = descriptor.getEntity();
        this.dbEntity = descriptor.getDbEntity();
    }

    private void reset() {
        this.currentPropertyDiff = null;
        this.currentArcDiff = null;
        this.currentId = null;
    }

    Map<Object, Object> buildDBDiff(GraphDiff singleObjectDiff) {
        this.reset();
        singleObjectDiff.apply(this);
        if (this.currentPropertyDiff == null && this.currentArcDiff == null && this.currentId == null) {
            return null;
        }
        HashMap<Object, Object> dbDiff = new HashMap<Object, Object>();
        this.appendSimpleProperties(dbDiff);
        this.appendForeignKeys(dbDiff);
        this.appendPrimaryKeys(dbDiff);
        return dbDiff.isEmpty() ? null : dbDiff;
    }

    private void appendSimpleProperties(Map<Object, Object> dbDiff) {
        if (this.currentPropertyDiff != null) {
            for (Map.Entry<Object, Object> entry : this.currentPropertyDiff.entrySet()) {
                ObjAttribute attribute = (ObjAttribute)this.objEntity.getAttribute(entry.getKey().toString());
                DbAttribute dbAttribute = attribute.getDbAttribute();
                if (dbAttribute.getEntity() != this.dbEntity) continue;
                dbDiff.put(dbAttribute.getName(), entry.getValue());
            }
        }
    }

    private void appendForeignKeys(Map<Object, Object> dbDiff) {
        if (this.currentArcDiff != null) {
            for (Map.Entry<Object, Object> entry : this.currentArcDiff.entrySet()) {
                ObjRelationship relation = (ObjRelationship)this.objEntity.getRelationship(entry.getKey().toString());
                DbRelationship dbRelation = relation.getDbRelationships().get(0);
                ObjectId targetId = (ObjectId)entry.getValue();
                for (DbJoin join : dbRelation.getJoins()) {
                    DataDomainSyncBucket.PropagatedValueFactory value = targetId != null ? new DataDomainSyncBucket.PropagatedValueFactory(targetId, join.getTargetName()) : null;
                    dbDiff.put(join.getSourceName(), value);
                }
            }
        }
    }

    private void appendPrimaryKeys(Map<Object, Object> dbDiff) {
        if (this.currentId != null) {
            dbDiff.putAll(((ObjectId)this.currentId).getIdSnapshot());
        }
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        if (this.currentPropertyDiff == null) {
            this.currentPropertyDiff = new HashMap<Object, Object>();
        }
        this.currentPropertyDiff.put(property, newValue);
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap<Object, Object>();
            }
            this.currentArcDiff.put(arcId, targetNodeId);
        }
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap<Object, Object>();
                this.currentArcDiff.put(arcId, null);
            } else {
                Object existingTargetId = this.currentArcDiff.get(arcId);
                if (existingTargetId == null || targetNodeId.equals(existingTargetId)) {
                    this.currentArcDiff.put(arcId, null);
                }
            }
        }
    }

    @Override
    public void nodeCreated(Object nodeId) {
        this.currentId = nodeId;
    }

    @Override
    public void nodeRemoved(Object nodeId) {
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
    }
}

