/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.ProjectOpener;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.event.ProjectOnSaveEvent;
import org.apache.cayenne.modeler.event.ProjectSavedEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.validation.ProjectValidator;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.validation.ValidationResult;

public class SaveAsAction
extends CayenneAction {
    private ProjectOpener fileChooser = new ProjectOpener();

    public static String getActionName() {
        return "Save As...";
    }

    public SaveAsAction(Application application) {
        this(SaveAsAction.getActionName(), application);
    }

    protected SaveAsAction(String name, Application application) {
        super(name, application);
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40);
    }

    protected boolean saveAll() throws Exception {
        File projectDir;
        Project p = this.getCurrentProject();
        String oldPath = null;
        if (p.getConfigurationResource() != null) {
            oldPath = p.getConfigurationResource().getURL().getPath();
        }
        if ((projectDir = this.fileChooser.newProjectDir(Application.getFrame(), p)) == null) {
            return false;
        }
        if (projectDir.exists() && !projectDir.canWrite()) {
            JOptionPane.showMessageDialog(Application.getFrame(), "Can't save project - unable to write to file \"" + projectDir.getPath() + "\"", "Can't Save Project", 0);
            return false;
        }
        this.getProjectController().getFileChangeTracker().pauseWatching();
        URLResource res = new URLResource(projectDir.toURI().toURL());
        ProjectSaver saver = this.getApplication().getInjector().getInstance(ProjectSaver.class);
        boolean isNewProject = p.getConfigurationResource() == null;
        Preferences tempOldPref = null;
        if (isNewProject) {
            tempOldPref = this.getApplication().getMainPreferenceForProject();
        }
        saver.saveAs(p, res);
        if (oldPath != null && oldPath.length() != 0 && !oldPath.equals(p.getConfigurationResource().getURL().getPath())) {
            String newName = p.getConfigurationResource().getURL().getPath().replace(".xml", "");
            String oldName = oldPath.replace(".xml", "");
            Preferences oldPref = this.getProjectController().getPreferenceForProject();
            String projPath = oldPref.absolutePath().replace(oldName, "");
            Preferences newPref = this.getProjectController().getPreferenceForProject().node(projPath + newName);
            RenamedPreferences.copyPreferences(newPref, this.getProjectController().getPreferenceForProject(), false);
        } else if (isNewProject && tempOldPref != null) {
            String newProjectName = this.getApplication().getNewProjectTemporaryName();
            if (tempOldPref.absolutePath().contains(newProjectName)) {
                String projPath = tempOldPref.absolutePath().replace("/" + newProjectName, "");
                String newName = p.getConfigurationResource().getURL().getPath().replace(".xml", "");
                Preferences newPref = this.getApplication().getMainPreferenceForProject().node(projPath + newName);
                RenamedPreferences.copyPreferences(newPref, tempOldPref, false);
                tempOldPref.removeNode();
                Application.getInstance().getFrameController().getLastDirectory().setDirectory(projectDir);
            }
        }
        RenamedPreferences.removeNewPreferences();
        File file = new File(p.getConfigurationResource().getURL().toURI());
        this.getApplication().getFrameController().addToLastProjListAction(file);
        Application.getFrame().fireRecentFileListChanged();
        this.getProjectController().getFileChangeTracker().reconfigure();
        this.getProjectController().fireProjectSavedEvent(new ProjectSavedEvent(this.getProjectController()));
        return true;
    }

    @Override
    public void performAction(ActionEvent e) {
        this.performAction();
    }

    public void performAction() {
        ProjectValidator projectValidator = this.getApplication().getInjector().getInstance(ProjectValidator.class);
        ValidationResult validationResult = projectValidator.validate(this.getCurrentProject().getRootNode());
        this.getProjectController().fireProjectOnSaveEvent(new ProjectOnSaveEvent(SaveAsAction.class));
        try {
            if (!this.saveAll()) {
                return;
            }
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error on save", (Throwable)ex, new Object[0]);
        }
        this.getApplication().getFrameController().projectSavedAction();
        if (validationResult.getFailures().size() > 0) {
            ValidatorDialog.showDialog(Application.getFrame(), validationResult.getFailures());
        }
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        Project project = this.getApplication().getProject();
        return project != null && project.isModified();
    }
}

