/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.undo.RemoveAttributeUndoableEdit;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class RemoveAttributeAction
extends RemoveAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Remove Attribute";
    private static final String ACTION_NAME_MULTIPLE = "Remove Attributes";

    public static String getActionName() {
        return ACTION_NAME;
    }

    @Override
    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public RemoveAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        return object instanceof Attribute;
    }

    @Override
    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ProjectController mediator = this.getProjectController();
        EmbeddableAttribute[] embAttrs = this.getProjectController().getCurrentEmbAttributes();
        ObjAttribute[] objAttrs = this.getProjectController().getCurrentObjAttributes();
        DbAttribute[] dbAttrs = this.getProjectController().getCurrentDbAttributes();
        if (embAttrs != null && embAttrs.length > 0) {
            if (embAttrs.length == 1 && dialog.shouldDelete("Embeddable Attribute", embAttrs[0].getName()) || embAttrs.length > 1 && dialog.shouldDelete("selected EmbAttributes")) {
                Embeddable embeddable = mediator.getCurrentEmbeddable();
                this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(embeddable, embAttrs));
                this.removeEmbeddableAttributes(embeddable, embAttrs);
            }
        } else if (objAttrs != null && objAttrs.length > 0) {
            if (objAttrs.length == 1 && dialog.shouldDelete("ObjAttribute", objAttrs[0].getName()) || objAttrs.length > 1 && dialog.shouldDelete("selected ObjAttributes")) {
                ObjEntity entity = mediator.getCurrentObjEntity();
                this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(entity, objAttrs));
                this.removeObjAttributes(entity, objAttrs);
            }
        } else if (dbAttrs != null && dbAttrs.length > 0 && (dbAttrs.length == 1 && dialog.shouldDelete("DbAttribute", dbAttrs[0].getName()) || dbAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
            DbEntity entity = mediator.getCurrentDbEntity();
            this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(entity, dbAttrs));
            this.removeDbAttributes(mediator.getCurrentDataMap(), entity, dbAttrs);
        }
    }

    public void removeDbAttributes(DataMap dataMap, DbEntity entity, DbAttribute[] attribs) {
        ProjectController mediator = this.getProjectController();
        for (DbAttribute attrib : attribs) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), attrib, entity, 3);
            mediator.fireDbAttributeEvent(e);
        }
        ProjectUtil.cleanObjMappings(dataMap);
    }

    public void removeObjAttributes(ObjEntity entity, ObjAttribute[] attribs) {
        ProjectController mediator = this.getProjectController();
        for (ObjAttribute attrib : attribs) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), attrib, entity, 3);
            mediator.fireObjAttributeEvent(e);
            Collection<ObjEntity> objEntities = ProjectUtil.getCollectionOfChildren((ObjEntity)e.getEntity());
            for (ObjEntity objEntity : objEntities) {
                objEntity.removeAttributeOverride(e.getAttribute().getName());
            }
        }
    }

    public void removeEmbeddableAttributes(Embeddable embeddable, EmbeddableAttribute[] attrs) {
        ProjectController mediator = this.getProjectController();
        for (EmbeddableAttribute attrib : attrs) {
            embeddable.removeAttribute(attrib.getName());
            EmbeddableAttributeEvent e = new EmbeddableAttributeEvent(Application.getFrame(), attrib, embeddable, 3);
            mediator.fireEmbeddableAttributeEvent(e);
        }
    }
}

