/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Collection;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;
import org.apache.cayenne.exp.property.RelationshipProperty;

public class EntityProperty<E extends Persistent>
extends BaseProperty<E>
implements RelationshipProperty<E> {
    protected EntityProperty(CayennePath path, Expression expression, Class<E> type) {
        super(path, expression, type);
    }

    public Expression eqId(Object id) {
        return ExpressionFactory.matchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression inId(Collection<Object> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression idsInCollection(Collection<?> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression inId(Object firstId, Object ... moreIds) {
        Object[] ids = new Object[moreIds.length + 1];
        ids[0] = firstId;
        System.arraycopy(moreIds, 0, ids, 1, moreIds.length);
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression idsIn(Object ... ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression neqId(Object id) {
        return ExpressionFactory.noMatchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression ninId(Collection<Object> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression idsNotInCollection(Collection<?> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression ninId(Object firstId, Object ... moreIds) {
        Object[] ids = new Object[moreIds.length + 1];
        ids[0] = firstId;
        System.arraycopy(moreIds, 0, ids, 1, moreIds.length);
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression idsNotIn(Object ... ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    @Override
    public EntityProperty<E> alias(String alias) {
        ASTPath exp = PropertyUtils.createPathExp(this.getPath(), alias, this.getExpression().getPathAliases());
        return PropertyFactory.createEntity(exp.getPath(), (Expression)exp, this.getType());
    }

    @Override
    public EntityProperty<E> outer() {
        return this.getName().endsWith("+") ? this : PropertyFactory.createEntity(this.getName() + "+", this.getType());
    }

    @Override
    public EntityProperty<E> enclosing() {
        return PropertyFactory.createEntity(ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getType());
    }
}

