/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.AttributeProcessor;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerEntityLoader;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.map.DbEntity;

class FallbackAttributeLoader
extends PerEntityLoader {
    private final AttributeProcessor attributeProcessor;

    FallbackAttributeLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
        this.attributeProcessor = new AttributeProcessor(adapter);
    }

    @Override
    ResultSet getResultSet(DbEntity dbEntity, DatabaseMetaData metaData) throws SQLException {
        return metaData.getColumns(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName(), "%");
    }

    @Override
    boolean shouldLoad(DbEntity entity) {
        return entity.getAttributes().size() == 0;
    }

    @Override
    void processResultSet(DbEntity dbEntity, DbLoadDataStore map, ResultSet rs) throws SQLException {
        PatternFilter columnFilter = this.config.getFiltersConfig().tableFilter(dbEntity.getCatalog(), dbEntity.getSchema()).getIncludeTableColumnFilter(dbEntity.getName());
        this.attributeProcessor.processAttribute(rs, columnFilter, dbEntity);
    }
}

