/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeRelationship;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.IncludeTableFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;

public final class FiltersConfigBuilder {
    private final ReverseEngineering engineering;
    private DataSource dataSource;
    private DbAdapter dbAdapter;

    public FiltersConfigBuilder(ReverseEngineering engineering) {
        this.engineering = engineering;
    }

    public FiltersConfigBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public FiltersConfigBuilder dbAdapter(DbAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
        return this;
    }

    public FiltersConfig build() throws SQLException {
        if (this.dataSource != null && this.dbAdapter != null && this.isEmptyConfig()) {
            this.preBuildFilters(this.dataSource, this.dbAdapter);
        }
        this.compact();
        return new FiltersConfig(this.transformCatalogs(this.engineering.getCatalogs()));
    }

    private boolean isEmptyConfig() {
        return this.engineering.getCatalogs().isEmpty() && this.engineering.getSchemas().isEmpty();
    }

    private void preBuildFilters(DataSource dataSource, DbAdapter dbAdapter) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.processCatalogs(databaseMetaData, dbAdapter);
        }
    }

    private void processCatalogs(DatabaseMetaData databaseMetaData, DbAdapter dbAdapter) throws SQLException {
        try (ResultSet catalogRs = databaseMetaData.getCatalogs();){
            List<String> systemCatalogs = dbAdapter.getSystemCatalogs();
            List<String> systemSchemas = dbAdapter.getSystemSchemas();
            boolean hasCatalogs = false;
            while (catalogRs.next()) {
                hasCatalogs = true;
                String catalogName = catalogRs.getString("TABLE_CAT");
                if (systemCatalogs.contains(catalogName)) continue;
                Catalog catalog = new Catalog(catalogName);
                List<Schema> schemas = this.processSchemas(databaseMetaData, catalogName, systemSchemas);
                catalog.getSchemas().addAll(schemas);
                this.engineering.addCatalog(catalog);
            }
            if (!hasCatalogs) {
                List<Schema> schemas = this.processSchemas(databaseMetaData, null, systemSchemas);
                this.engineering.getSchemas().addAll(schemas);
            }
        }
    }

    private List<Schema> processSchemas(DatabaseMetaData databaseMetaData, String catalogName, List<String> systemSchemas) throws SQLException {
        if (!databaseMetaData.supportsSchemasInTableDefinitions()) {
            return Collections.emptyList();
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try (ResultSet schemaRs = databaseMetaData.getSchemas(catalogName, null);){
            while (schemaRs.next()) {
                String schemaName = schemaRs.getString("TABLE_SCHEM");
                if (systemSchemas.contains(schemaName)) continue;
                Schema schema = new Schema(schemaName);
                schemas.add(schema);
            }
        }
        return schemas;
    }

    private CatalogFilter[] transformCatalogs(Collection<Catalog> catalogs) {
        CatalogFilter[] catalogFilters = new CatalogFilter[catalogs.size()];
        int i = 0;
        for (Catalog catalog : catalogs) {
            catalogFilters[i] = new CatalogFilter(catalog.getName(), this.transformSchemas(catalog.getSchemas()));
            ++i;
        }
        return catalogFilters;
    }

    private SchemaFilter[] transformSchemas(Collection<Schema> schemas) {
        SchemaFilter[] schemaFilters = new SchemaFilter[schemas.size()];
        int i = 0;
        for (Schema schema : schemas) {
            schemaFilters[i] = new SchemaFilter(schema.getName(), new TableFilter(this.transformIncludeTable(schema.getIncludeTables()), this.transformExcludeTable(schema.getExcludeTables())), this.transform(schema.getIncludeProcedures(), schema.getExcludeProcedures()));
            ++i;
        }
        return schemaFilters;
    }

    private SortedSet<Pattern> transformExcludeTable(Collection<ExcludeTable> excludeTables) {
        TreeSet<Pattern> res = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        for (ExcludeTable exclude : excludeTables) {
            res.add(PatternFilter.pattern(exclude.getPattern()));
        }
        return res;
    }

    private SortedSet<IncludeTableFilter> transformIncludeTable(Collection<IncludeTable> includeTables) {
        TreeSet<IncludeTableFilter> includeTableFilters = new TreeSet<IncludeTableFilter>();
        for (IncludeTable includeTable : includeTables) {
            includeTableFilters.add(new IncludeTableFilter(includeTable.getPattern(), this.transform(includeTable.getIncludeColumns(), includeTable.getExcludeColumns()), this.transform(Collections.emptyList(), includeTable.getExcludeRelationship())));
        }
        return includeTableFilters;
    }

    private PatternFilter transform(Collection<? extends PatternParam> include, Collection<? extends PatternParam> exclude) {
        PatternFilter filter = new PatternFilter();
        for (PatternParam patternParam : include) {
            filter.include(patternParam.getPattern());
        }
        for (PatternParam patternParam : exclude) {
            filter.exclude(patternParam.getPattern());
        }
        return filter;
    }

    void compact() {
        this.addEmptyElements();
        this.compactColumnFilters();
        this.compactRelationshipFilters();
        this.compactTableFilter();
        this.compactProcedureFilter();
        this.compactSchemas();
        this.clearGlobalFilters();
    }

    private void compactSchemas() {
        for (Catalog catalog : this.engineering.getCatalogs()) {
            catalog.getSchemas().addAll(this.engineering.getSchemas());
        }
    }

    private void compactProcedureFilter() {
        List<IncludeProcedure> engIncludeProcedures = this.engineering.getIncludeProcedures();
        List<ExcludeProcedure> engExcludeProcedures = this.engineering.getExcludeProcedures();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            List<IncludeProcedure> catalogIncludeProcedures = catalog.getIncludeProcedures();
            List<ExcludeProcedure> catalogExcludeProcedures = catalog.getExcludeProcedures();
            for (Schema schema : catalog.getSchemas()) {
                schema.getIncludeProcedures().addAll(engIncludeProcedures);
                schema.getIncludeProcedures().addAll(catalogIncludeProcedures);
                schema.getExcludeProcedures().addAll(engExcludeProcedures);
                schema.getExcludeProcedures().addAll(catalogExcludeProcedures);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            schema.getIncludeProcedures().addAll(engIncludeProcedures);
            schema.getExcludeProcedures().addAll(engExcludeProcedures);
        }
    }

    private void compactTableFilter() {
        List<IncludeTable> engIncludeTables = this.engineering.getIncludeTables();
        List<ExcludeTable> engExcludeTables = this.engineering.getExcludeTables();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            List<IncludeTable> catalogIncludeTables = catalog.getIncludeTables();
            List<ExcludeTable> catalogExcludeTables = catalog.getExcludeTables();
            for (Schema schema : catalog.getSchemas()) {
                schema.getIncludeTables().addAll(engIncludeTables);
                schema.getIncludeTables().addAll(catalogIncludeTables);
                schema.getExcludeTables().addAll(engExcludeTables);
                schema.getExcludeTables().addAll(catalogExcludeTables);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            schema.getIncludeTables().addAll(engIncludeTables);
            schema.getExcludeTables().addAll(engExcludeTables);
        }
    }

    private void compactRelationshipFilters() {
        List<ExcludeRelationship> engExcludeRelationship = this.engineering.getExcludeRelationship();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            List<ExcludeRelationship> catalogExcludeRelationship = catalog.getExcludeRelationship();
            for (Schema schema : catalog.getSchemas()) {
                List<ExcludeRelationship> schemaExcludeRelationship = schema.getExcludeRelationship();
                for (IncludeTable includeTable : schema.getIncludeTables()) {
                    includeTable.getExcludeRelationship().addAll(engExcludeRelationship);
                    includeTable.getExcludeRelationship().addAll(catalogExcludeRelationship);
                    includeTable.getExcludeRelationship().addAll(schemaExcludeRelationship);
                }
            }
            for (IncludeTable includeTable : catalog.getIncludeTables()) {
                includeTable.getExcludeRelationship().addAll(engExcludeRelationship);
                includeTable.getExcludeRelationship().addAll(catalogExcludeRelationship);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            List<ExcludeRelationship> schemaExcludeRelationship = schema.getExcludeRelationship();
            for (IncludeTable includeTable : schema.getIncludeTables()) {
                includeTable.getExcludeRelationship().addAll(engExcludeRelationship);
                includeTable.getExcludeRelationship().addAll(schemaExcludeRelationship);
            }
        }
        for (IncludeTable includeTable : this.engineering.getIncludeTables()) {
            includeTable.getExcludeRelationship().addAll(engExcludeRelationship);
        }
    }

    private void compactColumnFilters() {
        List<IncludeColumn> engIncludeColumns = this.engineering.getIncludeColumns();
        List<ExcludeColumn> engExcludeColumns = this.engineering.getExcludeColumns();
        for (Catalog catalog : this.engineering.getCatalogs()) {
            List<IncludeColumn> catalogIncludeColumns = catalog.getIncludeColumns();
            List<ExcludeColumn> catalogExcludeColumns = catalog.getExcludeColumns();
            for (Schema schema : catalog.getSchemas()) {
                List<IncludeColumn> schemaIncludeColumns = schema.getIncludeColumns();
                List<ExcludeColumn> schemaExcludeColumns = schema.getExcludeColumns();
                for (IncludeTable includeTable : schema.getIncludeTables()) {
                    includeTable.getIncludeColumns().addAll(engIncludeColumns);
                    includeTable.getIncludeColumns().addAll(catalogIncludeColumns);
                    includeTable.getIncludeColumns().addAll(schemaIncludeColumns);
                    includeTable.getExcludeColumns().addAll(engExcludeColumns);
                    includeTable.getExcludeColumns().addAll(catalogExcludeColumns);
                    includeTable.getExcludeColumns().addAll(schemaExcludeColumns);
                }
            }
            for (IncludeTable includeTable : catalog.getIncludeTables()) {
                includeTable.getIncludeColumns().addAll(engIncludeColumns);
                includeTable.getIncludeColumns().addAll(catalogIncludeColumns);
                includeTable.getExcludeColumns().addAll(engExcludeColumns);
                includeTable.getExcludeColumns().addAll(catalogExcludeColumns);
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            List<IncludeColumn> schemaIncludeColumns = schema.getIncludeColumns();
            List<ExcludeColumn> schemaExcludeColumns = schema.getExcludeColumns();
            for (IncludeTable includeTable : schema.getIncludeTables()) {
                includeTable.getIncludeColumns().addAll(engIncludeColumns);
                includeTable.getIncludeColumns().addAll(schemaIncludeColumns);
                includeTable.getExcludeColumns().addAll(engExcludeColumns);
                includeTable.getExcludeColumns().addAll(schemaExcludeColumns);
            }
        }
        for (IncludeTable includeTable : this.engineering.getIncludeTables()) {
            includeTable.getIncludeColumns().addAll(engIncludeColumns);
            includeTable.getExcludeColumns().addAll(engExcludeColumns);
        }
    }

    private void clearGlobalFilters() {
        for (Catalog catalog : this.engineering.getCatalogs()) {
            catalog.clearIncludeTables();
            catalog.clearExcludeTables();
            catalog.clearIncludeProcedures();
            catalog.clearExcludeProcedures();
            catalog.clearIncludeColumns();
            catalog.clearExcludeColumns();
            catalog.clearExcludeRelationships();
            for (Schema schema : catalog.getSchemas()) {
                schema.clearIncludeColumns();
                schema.clearExcludeColumns();
                schema.clearExcludeRelationships();
            }
        }
        this.engineering.clearIncludeTables();
        this.engineering.clearExcludeTables();
        this.engineering.clearIncludeProcedures();
        this.engineering.clearExcludeProcedures();
        this.engineering.clearIncludeColumns();
        this.engineering.clearExcludeColumns();
        this.engineering.clearExcludeRelationships();
        this.engineering.getSchemas().clear();
    }

    private void addEmptyElements() {
        if (this.engineering.getCatalogs().isEmpty()) {
            this.engineering.addCatalog(new Catalog());
        }
        for (Catalog catalog : this.engineering.getCatalogs()) {
            if (catalog.getSchemas().isEmpty() && this.engineering.getSchemas().isEmpty()) {
                catalog.addSchema(new Schema());
            }
            for (Schema schema : catalog.getSchemas()) {
                if (!this.hasCatalogEmptyInclude(catalog, schema)) continue;
                schema.addIncludeTable(new IncludeTable());
            }
        }
        for (Schema schema : this.engineering.getSchemas()) {
            if (!this.hasSchemaEmptyInclude(schema)) continue;
            schema.addIncludeTable(new IncludeTable());
        }
    }

    private boolean hasCatalogEmptyInclude(Catalog catalog, Schema schema) {
        return catalog.getIncludeTables().isEmpty() && catalog.getIncludeProcedures().isEmpty() && this.hasSchemaEmptyInclude(schema);
    }

    private boolean hasSchemaEmptyInclude(Schema schema) {
        return schema.getIncludeTables().isEmpty() && this.engineering.getIncludeTables().isEmpty() && schema.getIncludeProcedures().isEmpty() && this.engineering.getIncludeProcedures().isEmpty();
    }
}

