/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v7;

import java.util.ArrayList;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.upgrade.BaseUpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.v6.ProjectUpgrader_V6;
import org.apache.cayenne.resource.Resource;

class UpgradeHandler_V7
extends BaseUpgradeHandler {
    static final String PREVIOUS_VERSION = "6";
    static final String TO_VERSION = "7";
    static final String USING_EXTERNAL_TRANSACTIONS_PROPERTY = "cayenne.DataDomain.usingExternalTransactions";
    @Inject
    protected Injector injector;
    @Inject
    private ProjectSaver projectSaver;

    public UpgradeHandler_V7(Resource source) {
        super(source);
    }

    @Override
    protected Resource doPerformUpgrade(UpgradeMetaData metaData) throws ConfigurationException {
        if (this.compareVersions(metaData.getProjectVersion(), PREVIOUS_VERSION) == -1) {
            ProjectUpgrader_V6 upgraderV6 = new ProjectUpgrader_V6();
            this.injector.injectMembers((Object)upgraderV6);
            UpgradeHandler handlerV6 = upgraderV6.getUpgradeHandler(this.projectSource);
            this.projectSource = handlerV6.performUpgrade();
        }
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        ConfigurationTree tree = loader.load(this.projectSource);
        Project project = new Project(tree);
        this.attachToNamespace((DataChannelDescriptor)project.getRootNode());
        this.removeExternalTxProperty(project);
        this.removeShadowAttributes(project);
        this.projectSaver.save(project);
        return project.getConfigurationResource();
    }

    private void removeExternalTxProperty(Project project) {
        DataChannelDescriptor rootNode = (DataChannelDescriptor)project.getRootNode();
        rootNode.getProperties().remove(USING_EXTERNAL_TRANSACTIONS_PROPERTY);
    }

    private void removeShadowAttributes(Project project) {
        DataChannelDescriptor rootNode = (DataChannelDescriptor)project.getRootNode();
        for (DataMap dataMap : rootNode.getDataMaps()) {
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                ObjEntity superEntity = objEntity.getSuperEntity();
                if (superEntity == null) continue;
                this.removeShadowAttributes(objEntity, superEntity);
            }
        }
    }

    private void removeShadowAttributes(ObjEntity objEntity, ObjEntity superEntity) {
        ArrayList<String> delList = new ArrayList<String>();
        for (ObjAttribute subAttr : objEntity.getDeclaredAttributes()) {
            for (ObjAttribute superAttr : superEntity.getAttributes()) {
                if (!subAttr.getName().equals(superAttr.getName())) continue;
                delList.add(subAttr.getName());
            }
        }
        if (!delList.isEmpty()) {
            for (String i : delList) {
                objEntity.removeAttribute(i);
            }
        }
    }

    @Override
    protected String getToVersion() {
        return TO_VERSION;
    }
}

