/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.ArrayList;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.util.state.DisplayEventType;
import org.apache.cayenne.util.XMLSerializable;

class MultipleObjectsDisplayEventType
extends DisplayEventType {
    public MultipleObjectsDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        ConfigurationNode[] multipleObjects;
        XMLSerializable parentObject;
        String parentObjectName;
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (dataChannel.getDataMap(parentObjectName = this.preferences.getParentObject()) != null) {
            DataMap dataMap;
            parentObject = dataMap = dataChannel.getDataMap(parentObjectName);
            multipleObjects = this.getLastMultipleObjects(dataMap);
        } else if (dataChannel.getNodeDescriptor(parentObjectName) != null) {
            DataNodeDescriptor dataNode = dataChannel.getNodeDescriptor(parentObjectName);
            parentObject = dataNode;
            multipleObjects = this.getLastMultipleObjects(dataNode);
        } else {
            parentObject = dataChannel;
            multipleObjects = this.getLastMultipleObjects(dataChannel);
        }
        MultipleObjectsDisplayEvent multipleDisplayEvent = new MultipleObjectsDisplayEvent(this, multipleObjects, (ConfigurationNode)((Object)parentObject));
        this.controller.fireMultipleObjectsDisplayEvent(multipleDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(MultipleObjectsDisplayEvent.class.getSimpleName());
        this.preferences.setParentObject(this.getObjectName(this.controller.getCurrentParentPath()));
        Object[] multipleObjects = this.controller.getCurrentPaths();
        if (multipleObjects == null) {
            this.preferences.setMultipleObjects("");
        } else {
            StringBuilder sb = new StringBuilder();
            for (Object object : multipleObjects) {
                String objectName = this.getObjectName(object);
                if (objectName.isEmpty()) continue;
                sb.append(objectName).append(",");
            }
            this.preferences.setMultipleObjects(sb.toString());
        }
    }

    protected ConfigurationNode[] getLastMultipleObjects(DataChannelDescriptor dataChannel) {
        ArrayList<ConfigurationNode> configurationNodeList = new ArrayList<ConfigurationNode>();
        ConfigurationNode[] nodes = new ConfigurationNode[]{};
        String multipleObjects = this.preferences.getMultipleObjects();
        if (multipleObjects.isEmpty()) {
            return configurationNodeList.toArray(nodes);
        }
        for (String objectName : multipleObjects.split(",")) {
            ConfigurationNode configNode = this.getConfigNode(dataChannel, objectName);
            if (configNode == null) continue;
            configurationNodeList.add(configNode);
        }
        return configurationNodeList.toArray(nodes);
    }

    protected ConfigurationNode[] getLastMultipleObjects(DataNodeDescriptor dataNode) {
        ArrayList<DataMap> configurationNodeList = new ArrayList<DataMap>();
        ConfigurationNode[] nodes = new ConfigurationNode[]{};
        String multipleObjects = this.preferences.getMultipleObjects();
        if (multipleObjects.isEmpty()) {
            return configurationNodeList.toArray(nodes);
        }
        for (String objectName : multipleObjects.split(",")) {
            if (!dataNode.getDataMapNames().contains(objectName)) continue;
            configurationNodeList.add(dataNode.getDataChannelDescriptor().getDataMap(objectName));
        }
        return configurationNodeList.toArray(nodes);
    }

    protected ConfigurationNode[] getLastMultipleObjects(DataMap dataMap) {
        ArrayList<XMLSerializable> configurationNodeList = new ArrayList<XMLSerializable>();
        ConfigurationNode[] nodes = new ConfigurationNode[]{};
        String multipleObjects = this.preferences.getMultipleObjects();
        if (multipleObjects.isEmpty()) {
            return configurationNodeList.toArray(nodes);
        }
        for (String objectName : multipleObjects.split(",")) {
            if (dataMap.getObjEntity(objectName) != null) {
                configurationNodeList.add(dataMap.getObjEntity(objectName));
                continue;
            }
            if (dataMap.getDbEntity(objectName) != null) {
                configurationNodeList.add(dataMap.getDbEntity(objectName));
                continue;
            }
            if (dataMap.getEmbeddable(objectName) != null) {
                configurationNodeList.add(dataMap.getEmbeddable(objectName));
                continue;
            }
            if (dataMap.getProcedure(objectName) != null) {
                configurationNodeList.add(dataMap.getProcedure(objectName));
                continue;
            }
            if (dataMap.getQueryDescriptor(objectName) == null) continue;
            configurationNodeList.add(dataMap.getQueryDescriptor(objectName));
        }
        return configurationNodeList.toArray(nodes);
    }

    private ConfigurationNode getConfigNode(DataChannelDescriptor dataChannel, String objectName) {
        if (dataChannel.getName().equals(objectName)) {
            return dataChannel;
        }
        for (DataNodeDescriptor dataNode : dataChannel.getNodeDescriptors()) {
            if (!dataNode.getName().equals(objectName)) continue;
            return dataNode;
        }
        for (DataMap dataMap : dataChannel.getDataMaps()) {
            if (!dataMap.getName().equals(objectName)) continue;
            return dataMap;
        }
        return null;
    }
}

