/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class CayenneTransferable
implements Transferable {
    public static final DataFlavor CAYENNE_FLAVOR = new DataFlavor(Serializable.class, "Cayenne Object");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{CAYENNE_FLAVOR, DataFlavor.stringFlavor};
    private Object data;

    public CayenneTransferable(Object data) {
        this.data = data;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == CAYENNE_FLAVOR) {
            return this.data;
        }
        StringWriter out = new StringWriter();
        XMLEncoder encoder = new XMLEncoder(new PrintWriter(out), "\t");
        encoder.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        if (this.data instanceof XMLSerializable) {
            ((XMLSerializable)this.data).encodeAsXML(encoder);
        } else if (this.data instanceof List) {
            for (Object o : (List)this.data) {
                ((XMLSerializable)o).encodeAsXML(encoder);
            }
        }
        return out.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == CAYENNE_FLAVOR || flavor == DataFlavor.stringFlavor;
    }
}

