/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.wrapper;

import java.util.List;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.editor.validation.ObjAttributeWrapperValidator;
import org.apache.cayenne.modeler.editor.wrapper.Wrapper;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ObjAttributeWrapper
implements Wrapper<ObjAttribute> {
    private ObjAttribute objAttribute;
    private ValidationResult validationResult;
    private ObjAttributeWrapperValidator validator = new ObjAttributeWrapperValidator();
    private String name;

    public ObjAttributeWrapper(ObjAttribute objAttribute) {
        if (objAttribute == null) {
            throw new IllegalArgumentException("Attribute cannot be null.");
        }
        this.objAttribute = objAttribute;
        this.validationResult = new ValidationResult();
    }

    @Override
    public ObjAttribute getValue() {
        return this.objAttribute;
    }

    @Override
    public boolean isValid() {
        return !this.validationResult.hasFailures();
    }

    public String getFailureDescription(int column) {
        String result = null;
        if (this.validationResult.hasFailures(column)) {
            List<ValidationFailure> failures = this.validationResult.getFailures(column);
            result = failures.get(0).getDescription();
        }
        return result;
    }

    @Override
    public void commitEdits() {
        if (this.isValid()) {
            ProjectUtil.setAttributeName(this.getValue(), this.name);
        }
    }

    @Override
    public void resetEdits() {
        this.name = null;
        this.validationResult.clear();
    }

    public ObjEntity getEntity() {
        return this.objAttribute.getEntity();
    }

    public void setEntity(Entity entity) {
        this.objAttribute.setEntity(entity);
    }

    public String getName() {
        return this.name == null ? this.objAttribute.getName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.validator.validate(this, this.validationResult);
    }

    public Object getParent() {
        return this.objAttribute.getEntity();
    }

    public void setParent(Object parent) {
        this.objAttribute.setParent(parent);
    }

    public Class<?> getJavaClass() {
        return this.objAttribute.getClass();
    }

    public String getType() {
        return this.objAttribute.getType();
    }

    public void setType(String type) {
        this.objAttribute.setType(type);
    }

    public boolean isUsedForLocking() {
        return this.objAttribute.isUsedForLocking();
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.objAttribute.setUsedForLocking(usedForLocking);
    }

    public DbAttribute getDbAttribute() {
        try {
            return this.objAttribute.getDbAttribute();
        }
        catch (ExpressionException e) {
            return null;
        }
    }

    public boolean isInherited() {
        return this.objAttribute.isInherited();
    }

    public String getDbAttributeName() {
        return this.objAttribute.getDbAttributeName();
    }

    public void setDbAttributePath(String dbAttributePath) {
        this.objAttribute.setDbAttributePath(dbAttributePath);
    }

    public String getDbAttributePath() {
        return this.objAttribute.getDbAttributePath();
    }
}

