/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.Comparators;

public class DbRelationshipTarget
extends CayenneController {
    private DbEntity source1;
    private DbEntity source2;
    protected DbEntity relTarget;
    protected List<DbEntity> relTargets;
    protected DbEntity source;
    protected ProjectController mediator;
    protected boolean source1Selected;
    protected DbRelationshipTargetView view;
    protected boolean toMany;
    protected boolean savePressed;

    public DbRelationshipTarget(ProjectController mediator, DbEntity source1, DbEntity source2) {
        super(mediator);
        this.view = new DbRelationshipTargetView(source1, source2);
        this.initController();
        this.view.getSource1Button().setSelected(true);
        this.view.getToManyCheckBox().setSelected(false);
        this.setSource(source1, true);
        this.mediator = mediator;
        this.source1 = source1;
        this.source2 = source2;
        this.relTargets = new ArrayList<DbEntity>(source1.getDataMap().getDbEntities());
        Collections.sort(this.relTargets, Comparators.getNamedObjectComparator());
        this.view.targetCombo.removeAllItems();
        for (DbEntity d : this.relTargets) {
            this.view.targetCombo.addItem(d.getName());
        }
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbRelationshipTarget.this.view.dispose();
            }
        });
        this.view.getSaveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbRelationshipTarget.this.save();
            }
        });
        this.view.getSource1Button().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbRelationshipTarget.this.setSource(DbRelationshipTarget.this.source1, true);
            }
        });
        this.view.getSource2Button().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbRelationshipTarget.this.setSource(DbRelationshipTarget.this.source2, false);
            }
        });
        this.view.getToManyCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DbRelationshipTarget.this.toMany = DbRelationshipTarget.this.view.getToManyCheckBox().isSelected();
            }
        });
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void save() {
        this.relTarget = this.relTargets.get(this.view.targetCombo.getSelectedIndex());
        DbEntity target = this.getTarget();
        if (target == null) {
            JOptionPane.showMessageDialog(this.getView(), "Please select target entity first.", "Warning", 2);
            return;
        }
        this.savePressed = true;
        this.view.dispose();
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    boolean isSavePressed() {
        return this.savePressed;
    }

    public List<DbEntity> getTargets() {
        return this.relTargets;
    }

    public DbEntity getTarget() {
        return this.relTarget;
    }

    public void setTarget(DbEntity newRelTarget) {
        this.relTarget = newRelTarget;
    }

    public boolean isSource1Selected() {
        return this.source1Selected;
    }

    public DbEntity getSource() {
        return this.source;
    }

    public void setSource(DbEntity source, boolean source1) {
        this.source = source;
        this.source1Selected = source1;
    }

    public boolean isToMany() {
        return this.toMany;
    }
}

