/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.OverwriteDialog;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.project.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectOpener
extends JFileChooser {
    private static Logger logObj = LoggerFactory.getLogger(ProjectOpener.class);

    ProjectOpener() {
    }

    File newProjectDir(Frame f, Project p) {
        if (p != null) {
            StringBuilder nameProject = new StringBuilder("cayenne");
            if (((DataChannelDescriptor)p.getRootNode()).getName() != null) {
                nameProject.append("-").append(((DataChannelDescriptor)p.getRootNode()).getName());
            }
            nameProject.append(".xml");
            return this.newProjectDir(f, nameProject.toString(), FileFilters.getApplicationFilter());
        }
        throw new CayenneRuntimeException("Null project.", new Object[0]);
    }

    File newProjectDir(Frame f, String location, FileFilter filter) {
        File selectedDir;
        block4: {
            OverwriteDialog dialog;
            this.setDialogTitle("Select Project Directory");
            this.setFileSelectionMode(2);
            this.setCurrentDirectory(this.getDefaultStartDir());
            if (this.getCurrentDirectory() != null) {
                this.setSelectedFile(this.getCurrentDirectory());
            }
            this.resetChoosableFileFilters();
            this.addChoosableFileFilter(filter);
            do {
                File projectFile;
                int status = this.showDialog(f, "Select");
                selectedDir = this.getSelectedFile();
                if (status != 0 || selectedDir == null) {
                    logObj.info("Save canceled.");
                    return null;
                }
                logObj.info("Selected: " + selectedDir);
                if (!selectedDir.isDirectory()) {
                    selectedDir = this.getSelectedFile().getParentFile();
                }
                if (!(projectFile = new File(selectedDir, location)).exists()) break block4;
                dialog = new OverwriteDialog(projectFile, f);
                dialog.show();
                if (dialog.shouldOverwrite()) break block4;
            } while (dialog.shouldSelectAnother());
            return null;
        }
        return selectedDir;
    }

    File openProjectFile(Frame f) {
        this.setDialogTitle("Select Project File");
        this.setFileSelectionMode(0);
        this.setCurrentDirectory(this.getDefaultStartDir());
        this.resetChoosableFileFilters();
        this.addChoosableFileFilter(FileFilters.getApplicationFilter());
        this.setFileFilter(FileFilters.getApplicationFilter());
        int status = this.showOpenDialog(f);
        if (status != 0) {
            return null;
        }
        return this.getSelectedFile();
    }

    File getDefaultStartDir() {
        File existingDir = Application.getInstance().getFrameController().getLastDirectory().getExistingDirectory(false);
        if (existingDir == null) {
            existingDir = new File(System.getProperty("user.dir"));
        }
        return existingDir;
    }
}

