/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.conn.PoolDataSource;
import org.apache.cayenne.di.ScopeEventListener;
import org.apache.cayenne.log.JdbcEventLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolManager
implements ScopeEventListener,
DataSource,
ConnectionEventListener {
    public static final int MAX_QUEUE_WAIT = 20000;
    protected ConnectionPoolDataSource poolDataSource;
    protected int minConnections;
    protected int maxConnections;
    protected String dataSourceUrl;
    protected String jdbcDriver;
    protected String password;
    protected String userName;
    protected List<PooledConnection> unusedPool;
    protected List<PooledConnection> usedPool;
    private PoolMaintenanceThread poolMaintenanceThread;
    private boolean shuttingDown;

    public PoolManager(String jdbcDriver, String dataSourceUrl, int minCons, int maxCons, String userName, String password) throws SQLException {
        this(jdbcDriver, dataSourceUrl, minCons, maxCons, userName, password, null);
    }

    public PoolManager(String jdbcDriver, String dataSourceUrl, int minCons, int maxCons, String userName, String password, JdbcEventLogger logger) throws SQLException {
        if (logger != null) {
            DataSourceInfo info = new DataSourceInfo();
            info.setJdbcDriver(jdbcDriver);
            info.setDataSourceUrl(dataSourceUrl);
            info.setMinConnections(minCons);
            info.setMaxConnections(maxCons);
            info.setUserName(userName);
            info.setPassword(password);
            logger.logPoolCreated(info);
        }
        this.jdbcDriver = jdbcDriver;
        this.dataSourceUrl = dataSourceUrl;
        DriverDataSource driverDS = new DriverDataSource(jdbcDriver, dataSourceUrl);
        driverDS.setLogger(logger);
        PoolDataSource poolDS = new PoolDataSource(driverDS);
        this.init(poolDS, minCons, maxCons, userName, password);
    }

    public PoolManager(ConnectionPoolDataSource poolDataSource, int minCons, int maxCons, String userName, String password) throws SQLException {
        this.init(poolDataSource, minCons, maxCons, userName, password);
    }

    protected void init(ConnectionPoolDataSource poolDataSource, int minCons, int maxCons, String userName, String password) throws SQLException {
        if (this.maxConnections < 0) {
            throw new SQLException("Maximum number of connections can not be negative (" + maxCons + ").");
        }
        if (this.minConnections < 0) {
            throw new SQLException("Minimum number of connections can not be negative (" + minCons + ").");
        }
        if (this.minConnections > this.maxConnections) {
            throw new SQLException("Minimum number of connections can not be bigger then maximum.");
        }
        this.userName = userName;
        this.password = password;
        this.minConnections = minCons;
        this.maxConnections = maxCons;
        this.poolDataSource = poolDataSource;
        this.usedPool = new LinkedList<PooledConnection>();
        this.unusedPool = new LinkedList<PooledConnection>();
        this.growPool(this.minConnections, userName, password);
        this.startMaintenanceThread();
    }

    protected synchronized void startMaintenanceThread() {
        this.disposeOfMaintenanceThread();
        this.poolMaintenanceThread = new PoolMaintenanceThread(this);
        this.poolMaintenanceThread.start();
    }

    protected PooledConnection newPooledConnection(String userName, String password) throws SQLException {
        PooledConnection connection = userName != null ? this.poolDataSource.getPooledConnection(userName, password) : this.poolDataSource.getPooledConnection();
        connection.addConnectionEventListener(this);
        return connection;
    }

    @Deprecated
    public void dispose() throws SQLException {
        this.shutdown();
    }

    public synchronized void shutdown() throws SQLException {
        this.disposeOfMaintenanceThread();
        this.shuttingDown = true;
        ListIterator<PooledConnection> unusedIterator = this.unusedPool.listIterator();
        while (unusedIterator.hasNext()) {
            PooledConnection con = unusedIterator.next();
            con.close();
            unusedIterator.remove();
        }
        ListIterator<PooledConnection> usedIterator = this.usedPool.listIterator();
        while (usedIterator.hasNext()) {
            PooledConnection con = usedIterator.next();
            con.removeConnectionEventListener(this);
            con.close();
            usedIterator.remove();
        }
    }

    @Override
    public void beforeScopeEnd() {
        try {
            this.shutdown();
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error while shutting down", new Object[0]);
        }
    }

    protected void disposeOfMaintenanceThread() {
        if (this.poolMaintenanceThread != null) {
            this.poolMaintenanceThread.shutdown();
            this.poolMaintenanceThread = null;
        }
    }

    protected synchronized boolean canGrowPool() {
        return this.getPoolSize() < this.maxConnections;
    }

    protected synchronized int growPool(int addConnections, String userName, String password) throws SQLException {
        int i;
        int startPoolSize = this.getPoolSize();
        for (i = 0; i < addConnections && startPoolSize + i < this.maxConnections; ++i) {
            PooledConnection newConnection = this.newPooledConnection(userName, password);
            this.unusedPool.add(newConnection);
        }
        return i;
    }

    protected synchronized void shrinkPool(int closeConnections) {
        int idleSize = this.unusedPool.size();
        for (int i = 0; i < closeConnections && i < idleSize; ++i) {
            PooledConnection con = this.unusedPool.remove(i);
            try {
                con.close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public String getDataSourceUrl() {
        return this.dataSourceUrl;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized int getPoolSize() {
        return this.usedPool.size() + this.unusedPool.size();
    }

    public synchronized int getCurrentlyInUse() {
        return this.usedPool.size();
    }

    public synchronized int getCurrentlyUnused() {
        return this.unusedPool.size();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public synchronized Connection getConnection(String userName, String password) throws SQLException {
        if (this.shuttingDown) {
            throw new SQLException("Pool manager is shutting down.");
        }
        PooledConnection pooledConnection = this.uncheckPooledConnection(userName, password);
        try {
            return this.uncheckConnection(pooledConnection);
        }
        catch (SQLException ex) {
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pooledConnection = this.uncheckPooledConnection(userName, password);
            try {
                return this.uncheckConnection(pooledConnection);
            }
            catch (SQLException reconnectEx) {
                try {
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw reconnectEx;
            }
        }
    }

    private Connection uncheckConnection(PooledConnection pooledConnection) throws SQLException {
        Connection c = pooledConnection.getConnection();
        this.usedPool.add(pooledConnection);
        return c;
    }

    private PooledConnection uncheckPooledConnection(String userName, String password) throws SQLException {
        if (this.unusedPool.size() == 0) {
            if (this.canGrowPool()) {
                return this.newPooledConnection(userName, password);
            }
            long waitTill = System.currentTimeMillis() + 20000L;
            do {
                try {
                    this.wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.unusedPool.size() == 0 && waitTill > System.currentTimeMillis());
            if (this.unusedPool.size() == 0) {
                throw new SQLException("Can't obtain connection. Request timed out. Total used connections: " + this.usedPool.size());
            }
        }
        return this.unusedPool.remove(0);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.poolDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.poolDataSource.setLoginTimeout(seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.poolDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.poolDataSource.setLogWriter(out);
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent event) {
        if (this.shuttingDown) {
            return;
        }
        PooledConnection closedConn = (PooledConnection)event.getSource();
        int usedInd = this.usedPool.indexOf(closedConn);
        if (usedInd >= 0) {
            this.usedPool.remove(usedInd);
            this.unusedPool.add(closedConn);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent event) {
        if (this.shuttingDown) {
            return;
        }
        PooledConnection errorSrc = (PooledConnection)event.getSource();
        int usedInd = this.usedPool.indexOf(errorSrc);
        if (usedInd >= 0) {
            this.usedPool.remove(usedInd);
        } else {
            int unusedInd = this.unusedPool.indexOf(errorSrc);
            if (unusedInd >= 0) {
                this.unusedPool.remove(unusedInd);
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }

    static class PoolMaintenanceThread
    extends Thread {
        private boolean shouldDie;
        private PoolManager pool;

        PoolMaintenanceThread(PoolManager pool) {
            super.setName("PoolManagerCleanup-" + pool.hashCode());
            super.setDaemon(true);
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    PoolMaintenanceThread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PoolManager poolManager = this.pool;
                synchronized (poolManager) {
                    if (this.shouldDie) {
                        break;
                    }
                    int unused = this.pool.getCurrentlyUnused();
                    int used = this.pool.getCurrentlyInUse();
                    int total = unused + used;
                    int median = this.pool.minConnections + 1 + (this.pool.maxConnections - this.pool.minConnections) / 2;
                    if (unused > 0 && total > median) {
                        this.pool.shrinkPool(1);
                    }
                }
            }
        }

        void shutdown() {
            this.shouldDie = true;
            this.interrupt();
        }
    }
}

