/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.Fault;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.reflect.generic.DataObjectBaseProperty;

class DataObjectToOneProperty
extends DataObjectBaseProperty
implements ToOneProperty {
    protected ObjRelationship relationship;
    protected String reverseName;
    protected ClassDescriptor targetDescriptor;
    protected Fault fault;

    DataObjectToOneProperty(ObjRelationship relationship, ClassDescriptor targetDescriptor, Fault fault) {
        this.relationship = relationship;
        this.targetDescriptor = targetDescriptor;
        this.reverseName = relationship.getReverseRelationshipName();
        this.fault = fault;
    }

    public ArcProperty getComplimentaryReverseArc() {
        return this.reverseName != null ? (ArcProperty)this.targetDescriptor.getProperty(this.reverseName) : null;
    }

    public ClassDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public String getName() {
        return this.relationship.getName();
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public void injectValueHolder(Object object) throws PropertyException {
    }

    public void setTarget(Object source, Object target, boolean setReverse) {
        try {
            this.toDataObject(source).setToOneTarget(this.getName(), this.toDataObject(target), setReverse);
        }
        catch (Throwable th) {
            throw new PropertyException("Error setting to-one DataObject property: " + this.getName(), (Property)this, source, th, new Object[0]);
        }
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitToOne(this);
    }

    public boolean isFault(Object object) {
        return this.readPropertyDirectly(object) instanceof Fault;
    }

    public void invalidate(Object object) {
        this.writePropertyDirectly(object, null, this.fault);
    }
}

