/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.SortButtonRenderer;
import org.apache.cayenne.modeler.util.TableHeaderSortingListener;

public class CayenneTable
extends JTable {
    private SortButtonRenderer renderer = new SortButtonRenderer();
    protected TableHeaderSortingListener tableHeaderListener;

    public CayenneTable() {
        this.setRowHeight(25);
        this.setRowMargin(3);
        JTableHeader header = this.getTableHeader();
        this.tableHeaderListener = new TableHeaderSortingListener(header, this.renderer);
        header.addMouseListener(this.tableHeaderListener);
        this.setSelectionModel(new CayenneListSelectionModel());
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (!(dataModel instanceof DefaultTableModel)) {
            TableColumnModel model = this.getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                model.getColumn(i).setHeaderRenderer(this.renderer);
            }
        }
    }

    protected void createDefaultEditors() {
        super.createDefaultEditors();
        JTextField textField = new JTextField(20);
        DefaultCellEditor textEditor = Application.getWidgetFactory().createCellEditor(textField);
        textEditor.setClickCountToStart(1);
        this.setDefaultEditor(Object.class, textEditor);
        this.setDefaultEditor(String.class, textEditor);
    }

    public CayenneTableModel getCayenneModel() {
        return (CayenneTableModel)this.getModel();
    }

    public void cancelEditing() {
        this.editingCanceled(new ChangeEvent(this));
    }

    public void select(Object row) {
        if (row == null) {
            return;
        }
        CayenneTableModel model = this.getCayenneModel();
        int ind = model.getObjectList().indexOf(row);
        if (ind >= 0) {
            this.getSelectionModel().setSelectionInterval(ind, ind);
        }
    }

    public void select(int index) {
        CayenneTableModel model = this.getCayenneModel();
        if (index >= model.getObjectList().size()) {
            index = model.getObjectList().size() - 1;
        }
        if (index >= 0) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void select(int[] rows) {
        ((CayenneListSelectionModel)this.getSelectionModel()).setSelection(rows);
    }

    public JTextComponent getSelectedTextComponent() {
        Component comp;
        int row = this.getSelectedRow();
        int column = this.getSelectedColumn();
        if (row < 0 || column < 0) {
            return null;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)editor).getComponent()) instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }

    public void tableChanged(TableModelEvent e) {
        this.cancelEditing();
        super.tableChanged(e);
    }

    public void sort(int column, boolean isAscend) {
        this.tableHeaderListener.sortByDefinedColumn(this.convertColumnIndexToView(column), column, isAscend);
    }

    public void setSortPreferenceSaver(TableColumnPreferences tableColumnPreferences) {
        this.tableHeaderListener.setPreferences(tableColumnPreferences);
    }

    class CayenneListSelectionModel
    extends DefaultListSelectionModel {
        boolean fireForbidden = false;

        CayenneListSelectionModel() {
        }

        public void setSelection(int[] rows) {
            boolean selectionChanged = false;
            for (int row : rows) {
                if (CayenneTable.this.isRowSelected(row)) continue;
                selectionChanged = true;
                break;
            }
            if (!selectionChanged) {
                for (int i = this.getMinSelectionIndex(); i < this.getMaxSelectionIndex(); ++i) {
                    if (!this.isSelectedIndex(i)) continue;
                    boolean inNewSelection = false;
                    for (int row : rows) {
                        if (row != i) continue;
                        inNewSelection = true;
                        break;
                    }
                    if (inNewSelection) continue;
                    selectionChanged = true;
                    break;
                }
            }
            if (!selectionChanged) {
                return;
            }
            this.fireForbidden = true;
            this.clearSelection();
            for (int row : rows) {
                if (row < 0 || row >= CayenneTable.this.getRowCount()) continue;
                CayenneTable.this.addRowSelectionInterval(row, row);
            }
            this.fireForbidden = false;
            this.fireValueChanged(this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            if (!this.fireForbidden) {
                super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
            }
        }
    }
}

