/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.DbMerger;
import org.apache.cayenne.merge.ExecutingMergerContext;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.ModelMergeDelegate;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ValidationResultBrowser;
import org.apache.cayenne.modeler.dialog.db.MergerOptionsView;
import org.apache.cayenne.modeler.dialog.db.MergerTokenSelectorController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationResult;

public class MergerOptions
extends CayenneController {
    protected MergerOptionsView view;
    protected ObjectBinding sqlBinding;
    protected DBConnectionInfo connectionInfo;
    protected DataMap dataMap;
    protected JdbcAdapter adapter;
    protected String textForSQL;
    protected DbMerger merger;
    protected MergerTokenSelectorController tokens;

    public MergerOptions(ProjectController parent, String title, DBConnectionInfo connectionInfo, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.tokens = new MergerTokenSelectorController(parent);
        this.view = new MergerOptionsView(this.tokens.getView());
        this.connectionInfo = connectionInfo;
        this.view.setTitle(title);
        this.initController();
        this.prepareMigrator();
        this.createSQL();
        this.refreshView();
    }

    public Component getView() {
        return this.view;
    }

    public String getTextForSQL() {
        return this.textForSQL;
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.sqlBinding = builder.bindToTextArea(this.view.getSql(), "textForSQL");
        builder.bindToAction(this.view.getGenerateButton(), "generateSchemaAction()");
        builder.bindToAction(this.view.getSaveSqlButton(), "storeSQLAction()");
        builder.bindToAction(this.view.getCancelButton(), "closeAction()");
        this.view.getTabs().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (MergerOptions.this.view.getTabs().getSelectedIndex() == 1) {
                    MergerOptions.this.refreshGeneratorAction();
                }
            }
        });
    }

    protected void prepareMigrator() {
        try {
            this.adapter = (JdbcAdapter)this.connectionInfo.makeAdapter(this.getApplication().getClassLoadingService());
            this.tokens.setMergerFactory(this.adapter.mergerFactory());
            this.merger = new DbMerger();
            List<MergerToken> mergerTokens = this.merger.createMergeTokens(this.adapter, this.connectionInfo.makeDataSource(this.getApplication().getClassLoadingService()), this.dataMap);
            this.tokens.setTokens(mergerTokens);
        }
        catch (Exception ex) {
            this.reportError("Error loading adapter", ex);
        }
    }

    protected void createSQL() {
        String lineEnd;
        StringBuffer buf = new StringBuffer();
        Iterator<MergerToken> it = this.tokens.getSelectedTokens().iterator();
        String batchTerminator = this.adapter.getBatchTerminator();
        String string = lineEnd = batchTerminator != null ? "\n" + batchTerminator + "\n\n" : "\n\n";
        while (it.hasNext()) {
            MergerToken token = it.next();
            if (!(token instanceof AbstractToDbToken)) continue;
            AbstractToDbToken tdb = (AbstractToDbToken)token;
            for (String sql : tdb.createSql(this.adapter)) {
                buf.append(sql);
                buf.append(lineEnd);
            }
        }
        this.textForSQL = buf.toString();
    }

    protected void refreshView() {
        this.sqlBinding.updateView();
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public void refreshGeneratorAction() {
        this.refreshSQLAction();
    }

    public void refreshSQLAction() {
        this.createSQL();
        this.sqlBinding.updateView();
    }

    public void generateSchemaAction() {
        this.refreshGeneratorAction();
        List<MergerToken> tokensToMigrate = this.tokens.getSelectedTokens();
        if (tokensToMigrate.isEmpty()) {
            JOptionPane.showMessageDialog(this.getView(), "Nothing to migrate.");
            return;
        }
        final ProjectController c = this.getProjectController();
        final MergerOptions src = this;
        final DataChannelDescriptor domain = (DataChannelDescriptor)this.getProjectController().getProject().getRootNode();
        final DataNodeDescriptor node = this.getProjectController().getCurrentDataNode();
        ModelMergeDelegate delegate = new ModelMergeDelegate(){

            public void dbAttributeAdded(DbAttribute att) {
                if (c.getCurrentDbEntity() == att.getEntity()) {
                    c.fireDbAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void dbAttributeModified(DbAttribute att) {
                if (c.getCurrentDbEntity() == att.getEntity()) {
                    c.fireDbAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void dbAttributeRemoved(DbAttribute att) {
                if (c.getCurrentDbEntity() == att.getEntity()) {
                    c.fireDbAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void dbEntityAdded(DbEntity ent) {
                c.fireDbEntityEvent(new EntityEvent(src, (Entity)ent, 2));
                c.fireDbEntityDisplayEvent(new EntityDisplayEvent(src, ent, MergerOptions.this.dataMap, node, domain));
            }

            public void dbEntityRemoved(DbEntity ent) {
                c.fireDbEntityEvent(new EntityEvent(src, (Entity)ent, 3));
                c.fireDbEntityDisplayEvent(new EntityDisplayEvent(src, ent, MergerOptions.this.dataMap, node, domain));
            }

            public void dbRelationshipAdded(DbRelationship rel) {
                if (c.getCurrentDbEntity() == rel.getSourceEntity()) {
                    c.fireDbRelationshipDisplayEvent(new RelationshipDisplayEvent(src, rel, rel.getSourceEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void dbRelationshipRemoved(DbRelationship rel) {
                if (c.getCurrentDbEntity() == rel.getSourceEntity()) {
                    c.fireDbRelationshipDisplayEvent(new RelationshipDisplayEvent(src, rel, rel.getSourceEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void objAttributeAdded(ObjAttribute att) {
                if (c.getCurrentObjEntity() == att.getEntity()) {
                    c.fireObjAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void objAttributeModified(ObjAttribute att) {
                if (c.getCurrentObjEntity() == att.getEntity()) {
                    c.fireObjAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void objAttributeRemoved(ObjAttribute att) {
                if (c.getCurrentObjEntity() == att.getEntity()) {
                    c.fireObjAttributeDisplayEvent(new AttributeDisplayEvent(src, att, att.getEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void objEntityAdded(ObjEntity ent) {
                c.fireObjEntityEvent(new EntityEvent(src, (Entity)ent, 2));
                c.fireObjEntityDisplayEvent(new EntityDisplayEvent(src, ent, MergerOptions.this.dataMap, node, domain));
            }

            public void objEntityRemoved(ObjEntity ent) {
                c.fireObjEntityEvent(new EntityEvent(src, (Entity)ent, 3));
                c.fireObjEntityDisplayEvent(new EntityDisplayEvent(src, ent, MergerOptions.this.dataMap, node, domain));
            }

            public void objRelationshipAdded(ObjRelationship rel) {
                if (c.getCurrentObjEntity() == rel.getSourceEntity()) {
                    c.fireObjRelationshipDisplayEvent(new RelationshipDisplayEvent(src, rel, rel.getSourceEntity(), MergerOptions.this.dataMap, domain));
                }
            }

            public void objRelationshipRemoved(ObjRelationship rel) {
                if (c.getCurrentObjEntity() == rel.getSourceEntity()) {
                    c.fireObjRelationshipDisplayEvent(new RelationshipDisplayEvent(src, rel, rel.getSourceEntity(), MergerOptions.this.dataMap, domain));
                }
            }
        };
        try {
            ValidationResult failures;
            DataSource dataSource = this.connectionInfo.makeDataSource(this.getApplication().getClassLoadingService());
            ExecutingMergerContext mergerContext = new ExecutingMergerContext(this.dataMap, dataSource, this.adapter, delegate);
            boolean modelChanged = false;
            for (MergerToken tok : tokensToMigrate) {
                int numOfFailuresBefore = mergerContext.getValidationResult().getFailures().size();
                tok.execute(mergerContext);
                if (!modelChanged && tok.getDirection().equals((Object)MergeDirection.TO_MODEL)) {
                    modelChanged = true;
                }
                if (numOfFailuresBefore != mergerContext.getValidationResult().getFailures().size()) continue;
                this.tokens.removeToken(tok);
            }
            if (modelChanged) {
                Project project = this.getApplication().getProject();
                project.setModified(true);
                ProjectController projectController = this.getApplication().getFrameController().getProjectController();
                projectController.setDirty(true);
            }
            if ((failures = mergerContext.getValidationResult()) == null || !failures.hasFailures()) {
                JOptionPane.showMessageDialog(this.getView(), "Migration Complete.");
            } else {
                new ValidationResultBrowser(this).startupAction("Migration Complete", "Migration finished. The following problem(s) were ignored.", failures);
            }
        }
        catch (Throwable th) {
            this.reportError("Migration Error", th);
        }
    }

    public void storeSQLAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setDialogTitle("Save SQL Script");
        Resource projectDir = this.getApplication().getProject().getConfigurationResource();
        if (projectDir != null) {
            fc.setCurrentDirectory(new File(projectDir.getURL().getPath()));
        }
        if (fc.showSaveDialog(this.getView()) == 0) {
            this.refreshGeneratorAction();
            try {
                File file = fc.getSelectedFile();
                FileWriter fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                pw.print(this.textForSQL);
                pw.flush();
                pw.close();
            }
            catch (IOException ex) {
                this.reportError("Error Saving SQL", ex);
            }
        }
    }

    private ProjectController getProjectController() {
        return this.getApplication().getFrameController().getProjectController();
    }

    public void closeAction() {
        this.view.dispose();
    }
}

