/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.util.NamedObjectFactory;

public class NewProjectAction
extends ProjectAction {
    public static String getActionName() {
        return "New Project";
    }

    public NewProjectAction(Application application) {
        super(NewProjectAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-new.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void performAction(ActionEvent e) {
        CayenneModelerController controller = Application.getInstance().getFrameController();
        if (this.getCurrentProject() != null && !this.closeProject(true)) {
            return;
        }
        DataChannelDescriptor domain = new DataChannelDescriptor();
        String name = NamedObjectFactory.createName(DataChannelDescriptor.class, domain);
        domain.setName(name);
        Project project = new Project(new ConfigurationTree<DataChannelDescriptor>(domain));
        controller.projectOpenedAction(project);
        this.getProjectController().fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, domain));
    }
}

