/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.NamedObjectFactory;

public class CreateProcedureParameterAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Parameter";
    }

    public CreateProcedureParameterAction(Application application) {
        super(CreateProcedureParameterAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-plus.gif";
    }

    public void performAction(ActionEvent e) {
        if (this.getProjectController().getCurrentProcedure() != null) {
            this.createProcedureParameter();
        }
    }

    public void createProcedureParameter() {
        Procedure procedure = this.getProjectController().getCurrentProcedure();
        ProcedureParameter parameter = (ProcedureParameter)NamedObjectFactory.createObject(ProcedureParameter.class, procedure);
        procedure.addCallParameter(parameter);
        ProjectController mediator = this.getProjectController();
        CreateProcedureParameterAction.fireProcedureParameterEvent(this, mediator, procedure, parameter);
    }

    static void fireProcedureParameterEvent(Object src, ProjectController mediator, Procedure procedure, ProcedureParameter parameter) {
        mediator.fireProcedureParameterEvent(new ProcedureParameterEvent(src, parameter, 2));
        mediator.fireProcedureParameterDisplayEvent(new ProcedureParameterDisplayEvent(src, parameter, procedure, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode()));
    }

    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((ProcedureParameter)object).getProcedure() != null;
    }
}

