/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.EntityUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.velocity.VelocityContext;

public class EntityArtifact
implements Artifact {
    public static String ENTITY_UTILS_KEY = "entityUtils";
    protected ObjEntity entity;

    public EntityArtifact(ObjEntity entity) {
        this.entity = entity;
    }

    public Object getObject() {
        return this.entity;
    }

    public String getQualifiedBaseClassName() {
        return this.entity.getSuperClassName() != null ? this.entity.getSuperClassName() : CayenneDataObject.class.getName();
    }

    public String getQualifiedClassName() {
        return this.entity.getClassName();
    }

    public TemplateType getSingleClassType() {
        return TemplateType.ENTITY_SINGLE_CLASS;
    }

    public TemplateType getSubclassType() {
        return TemplateType.ENTITY_SUBCLASS;
    }

    public TemplateType getSuperClassType() {
        return TemplateType.ENTITY_SUPERCLASS;
    }

    public TemplateType[] getTemplateTypes(ArtifactGenerationMode mode) {
        switch (mode) {
            case SINGLE_CLASS: {
                return new TemplateType[]{TemplateType.ENTITY_SINGLE_CLASS};
            }
            case GENERATION_GAP: {
                return new TemplateType[]{TemplateType.ENTITY_SUPERCLASS, TemplateType.ENTITY_SUBCLASS};
            }
        }
        return new TemplateType[0];
    }

    public void postInitContext(VelocityContext context) {
        EntityUtils metadata = new EntityUtils(this.entity.getDataMap(), this.entity, (String)context.get("baseClassName"), (String)context.get("basePackageName"), (String)context.get("superClassName"), (String)context.get("superPackageName"), (String)context.get("subClassName"), (String)context.get("subPackageName"));
        context.put(ENTITY_UTILS_KEY, metadata);
    }
}

