/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.access.trans.DeleteBatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

public class SoftDeleteBatchQueryBuilder
extends DeleteBatchQueryBuilder {
    private String deletedFieldName;

    public SoftDeleteBatchQueryBuilder(DbAdapter adapter, String deletedFieldName) {
        super(adapter);
        this.deletedFieldName = deletedFieldName;
    }

    public String createSqlString(BatchQuery batch) throws IOException {
        if (!this.needSoftDelete(batch)) {
            return super.createSqlString(batch);
        }
        boolean status = batch.getDbEntity().getDataMap() != null && batch.getDbEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy(status);
        StringBuffer query = new StringBuffer("UPDATE ");
        query.append(strategy.quoteFullyQualifiedName(batch.getDbEntity()));
        query.append(" SET ").append(strategy.quoteString(this.deletedFieldName)).append(" = ?");
        this.applyQualifier(query, batch);
        return query.toString();
    }

    protected int getFirstParameterIndex(BatchQuery query) {
        return this.needSoftDelete(query) ? 2 : 1;
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        if (this.needSoftDelete(query)) {
            this.adapter.bindParameter(statement, true, 1, 16, -1);
        }
        super.bindParameters(statement, query);
    }

    protected boolean needSoftDelete(BatchQuery query) {
        DbAttribute attr = (DbAttribute)query.getDbEntity().getAttribute(this.deletedFieldName);
        return attr != null && attr.getType() == 16;
    }
}

