/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.carbondata.cluster.sdv.generated

import org.apache.spark.sql.Row
import org.apache.spark.sql.common.util._
import org.scalatest.BeforeAndAfterAll

/**
 * Test Class for QueriesBasicTestCase to verify all scenerios
 */

class QueriesBasicTestCase extends QueryTest with BeforeAndAfterAll {
  // scalastyle:off lineLength
  // UNIQDATA_CreateTable
  test("UNIQDATA_CreateTable", Include) {
    sql(s"""drop table if exists uniqdata""").collect
    sql(s"""drop table if exists uniqdata_hive""").collect

    sql(s"""CREATE TABLE uniqdata (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata """).collect

    sql(s"""CREATE TABLE uniqdata_hive (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) ROW FORMAT DELIMITED FIELDS TERMINATED BY ','""").collect


  }


  // UNIQDATA_DataLoad1
  test("UNIQDATA_DataLoad1", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData_hive1.csv' into table uniqdata_hive """).collect


  }


  // UNIQDATA_DataLoad2
  test("UNIQDATA_DataLoad2", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/3000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // UNIQDATA_DataLoad3
  test("UNIQDATA_DataLoad3", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/4000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/4000_UniqData_hive1.csv' into table uniqdata_hive """).collect


  }


  // UNIQDATA_DataLoad4
  test("UNIQDATA_DataLoad4", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/5000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect
  }


  // UNIQDATA_DataLoad5
  test("UNIQDATA_DataLoad5", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/6000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/6000_UniqData_hive1.csv' into table uniqdata_hive """).collect


  }


  // UNIQDATA_DataLoad6
  test("UNIQDATA_DataLoad6", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/7000_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/7000_UniqData_hive1.csv' into table uniqdata_hive """).collect


  }


  // UNIQDATA_DataLoad7
  test("UNIQDATA_DataLoad7", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/3000_1_UniqData.csv' into table uniqdata OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/3000_1_UniqData_hive1.csv' into table uniqdata_hive """).collect
  }

  test("UNIQDATA_DeleteLoad1_3", Include) {
    sql(s"""delete from table uniqdata where segment.id in (1,3)""").collect
  }


  // UNIQDATA_DEFAULT_TC001
  test("UNIQDATA_DEFAULT_TC001", Include) {

    checkAnswer(s"""Select count(CUST_NAME) from UNIQDATA""",
      s"""Select count(CUST_NAME) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC001")

  }


  // UNIQDATA_DEFAULT_TC002
  test("UNIQDATA_DEFAULT_TC002", Include) {

    checkAnswer(s"""select count(DISTINCT CUST_NAME) as a from UNIQDATA""",
      s"""select count(DISTINCT CUST_NAME) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC002")

  }


  // UNIQDATA_DEFAULT_TC003
  test("UNIQDATA_DEFAULT_TC003", Include) {

    checkAnswer(s"""select sum(INTEGER_COLUMN1)+10 as a ,CUST_NAME  from UNIQDATA group by CUST_NAME order by CUST_NAME""",
      s"""select sum(INTEGER_COLUMN1)+10 as a ,CUST_NAME  from UNIQDATA_hive group by CUST_NAME order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC003")

  }


  // UNIQDATA_DEFAULT_TC004
  test("UNIQDATA_DEFAULT_TC004", Include) {

    checkAnswer(s"""select max(CUST_NAME),min(CUST_NAME) from UNIQDATA""",
      s"""select max(CUST_NAME),min(CUST_NAME) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC004")

  }


  // UNIQDATA_DEFAULT_TC005
  test("UNIQDATA_DEFAULT_TC005", Include) {

    checkAnswer(s"""select min(CUST_NAME), max(CUST_NAME) Total from UNIQDATA group by  ACTIVE_EMUI_VERSION order by Total""",
      s"""select min(CUST_NAME), max(CUST_NAME) Total from UNIQDATA_hive group by  ACTIVE_EMUI_VERSION order by Total""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC005")

  }


  // UNIQDATA_DEFAULT_TC006
  test("UNIQDATA_DEFAULT_TC006", Include) {

    checkAnswer(s"""select last(CUST_NAME) a from UNIQDATA  group by CUST_NAME order by CUST_NAME limit 1""",
      s"""select last(CUST_NAME) a from UNIQDATA_hive  group by CUST_NAME order by CUST_NAME limit 1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC006")

  }


  // UNIQDATA_DEFAULT_TC007
  test("UNIQDATA_DEFAULT_TC007", Include) {

    checkAnswer(s"""select FIRST(CUST_NAME) a from UNIQDATA group by CUST_NAME order by CUST_NAME limit 1""",
      s"""select FIRST(CUST_NAME) a from UNIQDATA_hive group by CUST_NAME order by CUST_NAME limit 1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC007")

  }


  // UNIQDATA_DEFAULT_TC008
  test("UNIQDATA_DEFAULT_TC008", Include) {

    checkAnswer(s"""select CUST_NAME,count(CUST_NAME) a from UNIQDATA group by CUST_NAME order by CUST_NAME""",
      s"""select CUST_NAME,count(CUST_NAME) a from UNIQDATA_hive group by CUST_NAME order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC008")

  }


  // UNIQDATA_DEFAULT_TC009
  test("UNIQDATA_DEFAULT_TC009", Include) {

    checkAnswer(s"""select Lower(CUST_NAME) a  from UNIQDATA order by CUST_NAME""",
      s"""select Lower(CUST_NAME) a  from UNIQDATA_hive order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC009")

  }


  // UNIQDATA_DEFAULT_TC010
  test("UNIQDATA_DEFAULT_TC010", Include) {

    checkAnswer(s"""select distinct CUST_NAME from UNIQDATA order by CUST_NAME""",
      s"""select distinct CUST_NAME from UNIQDATA_hive order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC010")

  }


  // UNIQDATA_DEFAULT_TC011
  test("UNIQDATA_DEFAULT_TC011", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA order by CUST_NAME limit 101 """,
      s"""select CUST_NAME from UNIQDATA_hive order by CUST_NAME limit 101 """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC011")

  }


  // UNIQDATA_DEFAULT_TC012
  test("UNIQDATA_DEFAULT_TC012", Include) {

    checkAnswer(s"""select CUST_NAME as a from UNIQDATA  order by a asc limit 10""",
      s"""select CUST_NAME as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC012")

  }


  // UNIQDATA_DEFAULT_TC013
  test("UNIQDATA_DEFAULT_TC013", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01844')""",
      s"""select CUST_NAME from UNIQDATA_hive where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01844')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC013")

  }


  // UNIQDATA_DEFAULT_TC014
  test("UNIQDATA_DEFAULT_TC014", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME !='CUST_NAME_01844' order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME !='CUST_NAME_01844' order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC014")

  }


  // UNIQDATA_DEFAULT_TC015
  test("UNIQDATA_DEFAULT_TC015", Include) {

    checkAnswer(s"""select CUST_NAME  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select CUST_NAME  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC015")

  }


  // UNIQDATA_DEFAULT_TC016
  test("UNIQDATA_DEFAULT_TC016", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME !='CUST_NAME_01840' order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME !='CUST_NAME_01840' order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC016")

  }


  // UNIQDATA_DEFAULT_TC017
  test("UNIQDATA_DEFAULT_TC017", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME >'CUST_NAME_01840' order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME >'CUST_NAME_01840' order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC017")

  }


  // UNIQDATA_DEFAULT_TC018
  test("UNIQDATA_DEFAULT_TC018", Include) {

    checkAnswer(s"""select CUST_NAME  from UNIQDATA where CUST_NAME<>CUST_NAME""",
      s"""select CUST_NAME  from UNIQDATA_hive where CUST_NAME<>CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC018")

  }


  // UNIQDATA_DEFAULT_TC019
  test("UNIQDATA_DEFAULT_TC019", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME != BIGINT_COLUMN2 order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME != BIGINT_COLUMN2 order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC019")

  }


  // UNIQDATA_DEFAULT_TC020
  test("UNIQDATA_DEFAULT_TC020", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where BIGINT_COLUMN2<CUST_NAME order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where BIGINT_COLUMN2<CUST_NAME order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC020")

  }


  // UNIQDATA_DEFAULT_TC021
  test("UNIQDATA_DEFAULT_TC021", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where DECIMAL_COLUMN1<=CUST_NAME order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where DECIMAL_COLUMN1<=CUST_NAME order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC021")

  }


  // UNIQDATA_DEFAULT_TC022
  test("UNIQDATA_DEFAULT_TC022", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME <'CUST_NAME_01844' order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME <'CUST_NAME_01844' order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC022")

  }


  // UNIQDATA_DEFAULT_TC023
  test("UNIQDATA_DEFAULT_TC023", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where CUST_NAME IS NULL""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where CUST_NAME IS NULL""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC023")

  }


  // UNIQDATA_DEFAULT_TC024
  test("UNIQDATA_DEFAULT_TC024", Include) {
    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where CUST_NAME IS NOT NULL order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where CUST_NAME IS NOT NULL order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC024")
  }


  // UNIQDATA_DEFAULT_TC025
  test("UNIQDATA_DEFAULT_TC025", Include) {

    checkAnswer(s"""Select count(CUST_NAME),min(CUST_NAME) from UNIQDATA """,
      s"""Select count(CUST_NAME),min(CUST_NAME) from UNIQDATA_hive """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC025")

  }


  // UNIQDATA_DEFAULT_TC026
  test("UNIQDATA_DEFAULT_TC026", Include) {

    checkAnswer(s"""select count(DISTINCT CUST_NAME,DECIMAL_COLUMN1) as a from UNIQDATA""",
      s"""select count(DISTINCT CUST_NAME,DECIMAL_COLUMN1) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC026")

  }


  // UNIQDATA_DEFAULT_TC027
  test("UNIQDATA_DEFAULT_TC027", Include) {

    checkAnswer(s"""select max(CUST_NAME),min(CUST_NAME),count(CUST_NAME) from UNIQDATA""",
      s"""select max(CUST_NAME),min(CUST_NAME),count(CUST_NAME) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC027")

  }


  // UNIQDATA_DEFAULT_TC028
  test("UNIQDATA_DEFAULT_TC028", Include) {

    checkAnswer(s"""select sum(CUST_NAME),avg(CUST_NAME),count(CUST_NAME) a  from UNIQDATA""",
      s"""select sum(CUST_NAME),avg(CUST_NAME),count(CUST_NAME) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC028")

  }


  // UNIQDATA_DEFAULT_TC029
  test("UNIQDATA_DEFAULT_TC029", Include) {

    sql(s"""select last(CUST_NAME),Min(CUST_NAME),max(CUST_NAME)  a from UNIQDATA  order by a""").collect

  }


  // UNIQDATA_DEFAULT_TC030
  test("UNIQDATA_DEFAULT_TC030", Include) {

    sql(s"""select FIRST(CUST_NAME),Last(CUST_NAME) a from UNIQDATA group by CUST_NAME order by CUST_NAME limit 1""").collect

  }


  // UNIQDATA_DEFAULT_TC031
  test("UNIQDATA_DEFAULT_TC031", Include) {

    checkAnswer(s"""select CUST_NAME,count(CUST_NAME) a from UNIQDATA group by CUST_NAME order by CUST_NAME""",
      s"""select CUST_NAME,count(CUST_NAME) a from UNIQDATA_hive group by CUST_NAME order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC031")

  }


  // UNIQDATA_DEFAULT_TC032
  test("UNIQDATA_DEFAULT_TC032", Include) {

    checkAnswer(s"""select Lower(CUST_NAME),upper(CUST_NAME)  a  from UNIQDATA order by CUST_NAME""",
      s"""select Lower(CUST_NAME),upper(CUST_NAME)  a  from UNIQDATA_hive order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC032")

  }


  // UNIQDATA_DEFAULT_TC033
  test("UNIQDATA_DEFAULT_TC033", Include) {

    checkAnswer(s"""select CUST_NAME as a from UNIQDATA  order by a asc limit 10""",
      s"""select CUST_NAME as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC033")

  }


  // UNIQDATA_DEFAULT_TC034
  test("UNIQDATA_DEFAULT_TC034", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01840')""",
      s"""select CUST_NAME from UNIQDATA_hive where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC034")

  }


  // UNIQDATA_DEFAULT_TC035
  test("UNIQDATA_DEFAULT_TC035", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME !='CUST_NAME_01840' order by CUST_NAME""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME !='CUST_NAME_01840' order by CUST_NAME""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC035")

  }


  // UNIQDATA_DEFAULT_TC036
  test("UNIQDATA_DEFAULT_TC036", Include) {

    checkAnswer(s"""select CUST_NAME  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select CUST_NAME  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC036")

  }


  // UNIQDATA_DEFAULT_TC037
  test("UNIQDATA_DEFAULT_TC037", Include) {

    checkAnswer(s"""Select count(BIGINT_COLUMN1) from UNIQDATA""",
      s"""Select count(BIGINT_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC037")

  }


  // UNIQDATA_DEFAULT_TC038
  test("UNIQDATA_DEFAULT_TC038", Include) {

    checkAnswer(s"""select count(DISTINCT BIGINT_COLUMN1) as a from UNIQDATA""",
      s"""select count(DISTINCT BIGINT_COLUMN1) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC038")

  }


  // UNIQDATA_DEFAULT_TC039
  test("UNIQDATA_DEFAULT_TC039", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1)+10 as a ,BIGINT_COLUMN1  from UNIQDATA group by BIGINT_COLUMN1""",
      s"""select sum(BIGINT_COLUMN1)+10 as a ,BIGINT_COLUMN1  from UNIQDATA_hive group by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC039")

  }


  // UNIQDATA_DEFAULT_TC040
  test("UNIQDATA_DEFAULT_TC040", Include) {

    checkAnswer(s"""select max(BIGINT_COLUMN1),min(BIGINT_COLUMN1) from UNIQDATA""",
      s"""select max(BIGINT_COLUMN1),min(BIGINT_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC040")

  }


  // UNIQDATA_DEFAULT_TC041
  test("UNIQDATA_DEFAULT_TC041", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1) a  from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC041")

  }


  // UNIQDATA_DEFAULT_TC042
  test("UNIQDATA_DEFAULT_TC042", Include) {

    checkAnswer(s"""select avg(BIGINT_COLUMN1) a  from UNIQDATA""",
      s"""select avg(BIGINT_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC042")

  }


  // UNIQDATA_DEFAULT_TC043
  test("UNIQDATA_DEFAULT_TC043", Include) {

    checkAnswer(s"""select min(BIGINT_COLUMN1) a  from UNIQDATA""",
      s"""select min(BIGINT_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC043")

  }


  // UNIQDATA_DEFAULT_TC044
  test("UNIQDATA_DEFAULT_TC044", Include) {

    sql(s"""select variance(BIGINT_COLUMN1) as a   from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC045
  test("UNIQDATA_DEFAULT_TC045", Include) {

    sql(s"""select var_pop(BIGINT_COLUMN1)  as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC046
  test("UNIQDATA_DEFAULT_TC046", Include) {

    sql(s"""select var_samp(BIGINT_COLUMN1) as a  from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC047
  test("UNIQDATA_DEFAULT_TC047", Include) {

    sql(s"""select stddev_pop(BIGINT_COLUMN1) as a  from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC048
  test("UNIQDATA_DEFAULT_TC048", Include) {

    sql(s"""select stddev_samp(BIGINT_COLUMN1)  as a from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC049
  test("UNIQDATA_DEFAULT_TC049", Include) {

    sql(s"""select covar_pop(BIGINT_COLUMN1,BIGINT_COLUMN1) as a  from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC050
  test("UNIQDATA_DEFAULT_TC050", Include) {

    sql(s"""select covar_samp(BIGINT_COLUMN1,BIGINT_COLUMN1) as a  from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC051
  test("UNIQDATA_DEFAULT_TC051", Include) {

    sql(s"""select corr(BIGINT_COLUMN1,BIGINT_COLUMN1)  as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC052
  test("UNIQDATA_DEFAULT_TC052", Include) {

    sql(s"""select percentile_approx(BIGINT_COLUMN1,0.2) as a  from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC053
  test("UNIQDATA_DEFAULT_TC053", Include) {

    sql(s"""select percentile_approx(BIGINT_COLUMN1,0.2,5) as a  from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC054
  test("UNIQDATA_DEFAULT_TC054", Include) {

    sql(s"""select percentile_approx(BIGINT_COLUMN1,array(0.2,0.3,0.99))  as a from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC055
  test("UNIQDATA_DEFAULT_TC055", Include) {

    sql(s"""select percentile_approx(BIGINT_COLUMN1,array(0.2,0.3,0.99),5) as a from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC056
  test("UNIQDATA_DEFAULT_TC056", Include) {

    sql(s"""select histogram_numeric(BIGINT_COLUMN1,2)  as a from (select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC057
  test("UNIQDATA_DEFAULT_TC057", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1+ 10 as a  from UNIQDATA order by a""",
      s"""select BIGINT_COLUMN1+ 10 as a  from UNIQDATA_hive order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC057")

  }


  // UNIQDATA_DEFAULT_TC058
  test("UNIQDATA_DEFAULT_TC058", Include) {

    checkAnswer(s"""select min(BIGINT_COLUMN1), max(BIGINT_COLUMN1+ 10) Total from UNIQDATA group by  ACTIVE_EMUI_VERSION order by Total""",
      s"""select min(BIGINT_COLUMN1), max(BIGINT_COLUMN1+ 10) Total from UNIQDATA_hive group by  ACTIVE_EMUI_VERSION order by Total""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC058")

  }


  // UNIQDATA_DEFAULT_TC059
  test("UNIQDATA_DEFAULT_TC059", Include) {

    sql(s"""select last(BIGINT_COLUMN1) a from UNIQDATA  order by a""").collect

  }


  // UNIQDATA_DEFAULT_TC060
  test("UNIQDATA_DEFAULT_TC060", Include) {

    sql(s"""select FIRST(BIGINT_COLUMN1) a from UNIQDATA order by a""").collect

  }


  // UNIQDATA_DEFAULT_TC061
  test("UNIQDATA_DEFAULT_TC061", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1,count(BIGINT_COLUMN1) a from UNIQDATA group by BIGINT_COLUMN1 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1,count(BIGINT_COLUMN1) a from UNIQDATA_hive group by BIGINT_COLUMN1 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC061")

  }


  // UNIQDATA_DEFAULT_TC062
  test("UNIQDATA_DEFAULT_TC062", Include) {

    checkAnswer(s"""select Lower(BIGINT_COLUMN1) a  from UNIQDATA order by BIGINT_COLUMN1""",
      s"""select Lower(BIGINT_COLUMN1) a  from UNIQDATA_hive order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC062")

  }


  // UNIQDATA_DEFAULT_TC063
  test("UNIQDATA_DEFAULT_TC063", Include) {

    checkAnswer(s"""select distinct BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1""",
      s"""select distinct BIGINT_COLUMN1 from UNIQDATA_hive order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC063")

  }


  // UNIQDATA_DEFAULT_TC064
  test("UNIQDATA_DEFAULT_TC064", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA order by BIGINT_COLUMN1 limit 101""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive order by BIGINT_COLUMN1 limit 101""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC064")

  }


  // UNIQDATA_DEFAULT_TC065
  test("UNIQDATA_DEFAULT_TC065", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 as a from UNIQDATA  order by a asc limit 10""",
      s"""select BIGINT_COLUMN1 as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC065")

  }


  // UNIQDATA_DEFAULT_TC066
  test("UNIQDATA_DEFAULT_TC066", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01840')""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where  (BIGINT_COLUMN1 == 123372038698) and (CUST_NAME=='CUST_NAME_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC066")

  }


  // UNIQDATA_DEFAULT_TC067
  test("UNIQDATA_DEFAULT_TC067", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 !=123372038698 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 !=123372038698 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC067")

  }


  // UNIQDATA_DEFAULT_TC068
  test("UNIQDATA_DEFAULT_TC068", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840') order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840') order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC068")

  }


  // UNIQDATA_DEFAULT_TC069
  test("UNIQDATA_DEFAULT_TC069", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 !=123372038698 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 !=123372038698 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC069")

  }


  // UNIQDATA_DEFAULT_TC070
  test("UNIQDATA_DEFAULT_TC070", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 >123372038698 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 >123372038698 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC070")

  }


  // UNIQDATA_DEFAULT_TC071
  test("UNIQDATA_DEFAULT_TC071", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1  from UNIQDATA where BIGINT_COLUMN1<>BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1  from UNIQDATA_hive where BIGINT_COLUMN1<>BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC071")

  }


  // UNIQDATA_DEFAULT_TC072
  test("UNIQDATA_DEFAULT_TC072", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 != BIGINT_COLUMN2 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 != BIGINT_COLUMN2 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC072")

  }


  // UNIQDATA_DEFAULT_TC073
  test("UNIQDATA_DEFAULT_TC073", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1, BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN2<BIGINT_COLUMN1 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1, BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN2<BIGINT_COLUMN1 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC073")

  }


  // UNIQDATA_DEFAULT_TC074
  test("UNIQDATA_DEFAULT_TC074", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1, BIGINT_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1<=BIGINT_COLUMN1 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1, BIGINT_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1<=BIGINT_COLUMN1 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC074")

  }


  // UNIQDATA_DEFAULT_TC075
  test("UNIQDATA_DEFAULT_TC075", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 <1000 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 <1000 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC075")

  }


  // UNIQDATA_DEFAULT_TC076
  test("UNIQDATA_DEFAULT_TC076", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 >1000 order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 >1000 order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC076")

  }


  // UNIQDATA_DEFAULT_TC077
  test("UNIQDATA_DEFAULT_TC077", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1  from UNIQDATA where BIGINT_COLUMN1 IS NULL order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1  from UNIQDATA_hive where BIGINT_COLUMN1 IS NULL order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC077")

  }


  // UNIQDATA_DEFAULT_TC078
  test("UNIQDATA_DEFAULT_TC078", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1  from UNIQDATA where DECIMAL_COLUMN1 IS NOT NULL order by BIGINT_COLUMN1""",
      s"""select BIGINT_COLUMN1  from UNIQDATA_hive where DECIMAL_COLUMN1 IS NOT NULL order by BIGINT_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC078")

  }


  // UNIQDATA_DEFAULT_TC079
  test("UNIQDATA_DEFAULT_TC079", Include) {

    checkAnswer(s"""Select count(DECIMAL_COLUMN1) from UNIQDATA""",
      s"""Select count(DECIMAL_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC079")

  }


  // UNIQDATA_DEFAULT_TC080
  test("UNIQDATA_DEFAULT_TC080", Include) {

    checkAnswer(s"""select count(DISTINCT DECIMAL_COLUMN1) as a from UNIQDATA""",
      s"""select count(DISTINCT DECIMAL_COLUMN1) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC080")

  }


  // UNIQDATA_DEFAULT_TC081
  test("UNIQDATA_DEFAULT_TC081", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1)+10 as a ,DECIMAL_COLUMN1  from UNIQDATA group by DECIMAL_COLUMN1 order by a""",
      s"""select sum(DECIMAL_COLUMN1)+10 as a ,DECIMAL_COLUMN1  from UNIQDATA_hive group by DECIMAL_COLUMN1 order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC081")

  }


  // UNIQDATA_DEFAULT_TC082
  test("UNIQDATA_DEFAULT_TC082", Include) {

    checkAnswer(s"""select max(DECIMAL_COLUMN1),min(DECIMAL_COLUMN1) from UNIQDATA""",
      s"""select max(DECIMAL_COLUMN1),min(DECIMAL_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC082")

  }


  // UNIQDATA_DEFAULT_TC083
  test("UNIQDATA_DEFAULT_TC083", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1) a  from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC083")

  }


  // UNIQDATA_DEFAULT_TC084
  test("UNIQDATA_DEFAULT_TC084", Include) {

    checkAnswer(s"""select avg(DECIMAL_COLUMN1) a  from UNIQDATA""",
      s"""select avg(DECIMAL_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC084")

  }


  // UNIQDATA_DEFAULT_TC085
  test("UNIQDATA_DEFAULT_TC085", Include) {

    checkAnswer(s"""select min(DECIMAL_COLUMN1) a  from UNIQDATA""",
      s"""select min(DECIMAL_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC085")

  }


  // UNIQDATA_DEFAULT_TC086
  test("UNIQDATA_DEFAULT_TC086", Include) {

    sql(s"""select variance(DECIMAL_COLUMN1) as a   from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC087
  test("UNIQDATA_DEFAULT_TC087", Include) {

    sql(s"""select var_pop(DECIMAL_COLUMN1)  as a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC088
  test("UNIQDATA_DEFAULT_TC088", Include) {

    sql(s"""select var_samp(DECIMAL_COLUMN1) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC089
  test("UNIQDATA_DEFAULT_TC089", Include) {

    sql(s"""select stddev_pop(DECIMAL_COLUMN1) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC090
  test("UNIQDATA_DEFAULT_TC090", Include) {

    sql(s"""select stddev_samp(DECIMAL_COLUMN1)  as a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC091
  test("UNIQDATA_DEFAULT_TC091", Include) {

    sql(s"""select covar_pop(DECIMAL_COLUMN1,DECIMAL_COLUMN1) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC092
  test("UNIQDATA_DEFAULT_TC092", Include) {

    sql(s"""select covar_samp(DECIMAL_COLUMN1,DECIMAL_COLUMN1) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC093
  test("UNIQDATA_DEFAULT_TC093", Include) {

    checkAnswer(s"""select corr(DECIMAL_COLUMN1,DECIMAL_COLUMN1)  as a from UNIQDATA""",
      s"""select corr(DECIMAL_COLUMN1,DECIMAL_COLUMN1)  as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC093")

  }


  // UNIQDATA_DEFAULT_TC094
  test("UNIQDATA_DEFAULT_TC094", Include) {

    sql(s"""select percentile_approx(DECIMAL_COLUMN1,0.2) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC095
  test("UNIQDATA_DEFAULT_TC095", Include) {

    sql(s"""select percentile_approx(DECIMAL_COLUMN1,0.2,5) as a  from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC096
  test("UNIQDATA_DEFAULT_TC096", Include) {

    sql(s"""select percentile_approx(DECIMAL_COLUMN1,array(0.2,0.3,0.99))  as a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC097
  test("UNIQDATA_DEFAULT_TC097", Include) {

    sql(s"""select percentile_approx(DECIMAL_COLUMN1,array(0.2,0.3,0.99),5) as a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC098
  test("UNIQDATA_DEFAULT_TC098", Include) {

    sql(s"""select histogram_numeric(DECIMAL_COLUMN1,2)  as a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC099
  test("UNIQDATA_DEFAULT_TC099", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1+ 10 as a  from UNIQDATA order by a""",
      s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1+ 10 as a  from UNIQDATA_hive order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC099")

  }


  // UNIQDATA_DEFAULT_TC100
  test("UNIQDATA_DEFAULT_TC100", Include) {

    checkAnswer(s"""select min(DECIMAL_COLUMN1), max(DECIMAL_COLUMN1+ 10) Total from UNIQDATA group by  ACTIVE_EMUI_VERSION order by Total""",
      s"""select min(DECIMAL_COLUMN1), max(DECIMAL_COLUMN1+ 10) Total from UNIQDATA_hive group by  ACTIVE_EMUI_VERSION order by Total""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC100")

  }


  // UNIQDATA_DEFAULT_TC101
  test("UNIQDATA_DEFAULT_TC101", Include) {

    sql(s"""select last(DECIMAL_COLUMN1) a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC102
  test("UNIQDATA_DEFAULT_TC102", Include) {

    sql(s"""select FIRST(DECIMAL_COLUMN1) a from (select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC103
  test("UNIQDATA_DEFAULT_TC103", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1,count(DECIMAL_COLUMN1) a from UNIQDATA group by DECIMAL_COLUMN1 order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1,count(DECIMAL_COLUMN1) a from UNIQDATA_hive group by DECIMAL_COLUMN1 order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC103")

  }


  // UNIQDATA_DEFAULT_TC104
  test("UNIQDATA_DEFAULT_TC104", Include) {

    checkAnswer(s"""select Lower(DECIMAL_COLUMN1) a  from UNIQDATA order by a""",
      s"""select Lower(DECIMAL_COLUMN1) a  from UNIQDATA_hive order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC104")

  }


  // UNIQDATA_DEFAULT_TC105
  test("UNIQDATA_DEFAULT_TC105", Include) {

    checkAnswer(s"""select distinct DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1""",
      s"""select distinct DECIMAL_COLUMN1 from UNIQDATA_hive order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC105")

  }


  // UNIQDATA_DEFAULT_TC106
  test("UNIQDATA_DEFAULT_TC106", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA order by DECIMAL_COLUMN1 limit 101""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive order by DECIMAL_COLUMN1 limit 101""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC106")

  }


  // UNIQDATA_DEFAULT_TC107
  test("UNIQDATA_DEFAULT_TC107", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 as a from UNIQDATA  order by a asc limit 10""",
      s"""select DECIMAL_COLUMN1 as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC107")

  }


  // UNIQDATA_DEFAULT_TC108
  test("UNIQDATA_DEFAULT_TC108", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where  (DECIMAL_COLUMN1 == 12345680745.1234000000)  and (CUST_NAME=='CUST_NAME_01844')""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where  (DECIMAL_COLUMN1 == 12345680745.1234000000)  and (CUST_NAME=='CUST_NAME_01844')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC108")

  }


  // UNIQDATA_DEFAULT_TC109
  test("UNIQDATA_DEFAULT_TC109", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 !=12345680745.1234000000  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 !=12345680745.1234000000  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC109")

  }


  // UNIQDATA_DEFAULT_TC110
  test("UNIQDATA_DEFAULT_TC110", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC110")

  }


  // UNIQDATA_DEFAULT_TC111
  test("UNIQDATA_DEFAULT_TC111", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 !=12345680745.1234000000  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 !=12345680745.1234000000  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC111")

  }


  // UNIQDATA_DEFAULT_TC112
  test("UNIQDATA_DEFAULT_TC112", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 >12345680745.1234000000  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 >12345680745.1234000000  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC112")

  }


  // UNIQDATA_DEFAULT_TC113
  test("UNIQDATA_DEFAULT_TC113", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where DECIMAL_COLUMN1<>DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where DECIMAL_COLUMN1<>DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC113")

  }


  // UNIQDATA_DEFAULT_TC114
  test("UNIQDATA_DEFAULT_TC114", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 != BIGINT_COLUMN2 order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 != BIGINT_COLUMN2 order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC114")

  }


  // UNIQDATA_DEFAULT_TC115
  test("UNIQDATA_DEFAULT_TC115", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1 from UNIQDATA where BIGINT_COLUMN2<DECIMAL_COLUMN1 order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN2<DECIMAL_COLUMN1 order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC115")

  }


  // UNIQDATA_DEFAULT_TC116
  test("UNIQDATA_DEFAULT_TC116", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1<=DECIMAL_COLUMN1  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1, DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1<=DECIMAL_COLUMN1  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC116")

  }


  // UNIQDATA_DEFAULT_TC117
  test("UNIQDATA_DEFAULT_TC117", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 <1000  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 <1000  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC117")

  }


  // UNIQDATA_DEFAULT_TC118
  test("UNIQDATA_DEFAULT_TC118", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 >1000  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 >1000  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC118")

  }


  // UNIQDATA_DEFAULT_TC119
  test("UNIQDATA_DEFAULT_TC119", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where DECIMAL_COLUMN1 IS NULL  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where DECIMAL_COLUMN1 IS NULL  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC119")

  }


  // UNIQDATA_DEFAULT_TC120
  test("UNIQDATA_DEFAULT_TC120", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1  from UNIQDATA where DECIMAL_COLUMN1 IS NOT NULL  order by DECIMAL_COLUMN1""",
      s"""select DECIMAL_COLUMN1  from UNIQDATA_hive where DECIMAL_COLUMN1 IS NOT NULL  order by DECIMAL_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC120")

  }


  // UNIQDATA_DEFAULT_TC121
  test("UNIQDATA_DEFAULT_TC121", Include) {

    checkAnswer(s"""Select count(Double_COLUMN1) from UNIQDATA""",
      s"""Select count(Double_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC121")

  }


  // UNIQDATA_DEFAULT_TC122
  test("UNIQDATA_DEFAULT_TC122", Include) {

    checkAnswer(s"""select count(DISTINCT Double_COLUMN1) as a from UNIQDATA""",
      s"""select count(DISTINCT Double_COLUMN1) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC122")

  }


  // UNIQDATA_DEFAULT_TC123
  test("UNIQDATA_DEFAULT_TC123", Include) {

    sql(s"""select sum(Double_COLUMN1)+10 as a ,Double_COLUMN1  from UNIQDATA group by Double_COLUMN1 order by a""").collect

  }


  // UNIQDATA_DEFAULT_TC124
  test("UNIQDATA_DEFAULT_TC124", Include) {

    checkAnswer(s"""select max(Double_COLUMN1),min(Double_COLUMN1) from UNIQDATA""",
      s"""select max(Double_COLUMN1),min(Double_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC124")

  }


  // UNIQDATA_DEFAULT_TC125
  test("UNIQDATA_DEFAULT_TC125", Include) {

    sql(s"""select sum(Double_COLUMN1) a  from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC126
  ignore("UNIQDATA_DEFAULT_TC126", Include) {

    checkAnswer(s"""select avg(Double_COLUMN1) a  from UNIQDATA""",
      Seq(Row(1.1234567489797018E10d)), "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC126")
  }


  // UNIQDATA_DEFAULT_TC127
  test("UNIQDATA_DEFAULT_TC127", Include) {

    checkAnswer(s"""select min(Double_COLUMN1) a  from UNIQDATA""",
      s"""select min(Double_COLUMN1) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC127")

  }


  // UNIQDATA_DEFAULT_TC128
  test("UNIQDATA_DEFAULT_TC128", Include) {

    sql(s"""select variance(Double_COLUMN1) as a   from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC129
  test("UNIQDATA_DEFAULT_TC129", Include) {

    sql(s"""select var_pop(Double_COLUMN1)  as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC130
  test("UNIQDATA_DEFAULT_TC130", Include) {

    sql(s"""select var_samp(Double_COLUMN1) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC131
  test("UNIQDATA_DEFAULT_TC131", Include) {

    sql(s"""select stddev_pop(Double_COLUMN1) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC132
  test("UNIQDATA_DEFAULT_TC132", Include) {

    sql(s"""select stddev_samp(Double_COLUMN1)  as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC133
  test("UNIQDATA_DEFAULT_TC133", Include) {

    sql(s"""select covar_pop(Double_COLUMN1,Double_COLUMN1) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC134
  test("UNIQDATA_DEFAULT_TC134", Include) {

    sql(s"""select covar_samp(Double_COLUMN1,Double_COLUMN1) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC135
  test("UNIQDATA_DEFAULT_TC135", Include) {

    checkAnswer(s"""select corr(Double_COLUMN1,Double_COLUMN1)  as a from UNIQDATA""",
      s"""select corr(Double_COLUMN1,Double_COLUMN1)  as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC135")

  }


  // UNIQDATA_DEFAULT_TC136
  test("UNIQDATA_DEFAULT_TC136", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,0.2) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC137
  test("UNIQDATA_DEFAULT_TC137", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,0.2,5) as a  from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC138
  test("UNIQDATA_DEFAULT_TC138", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,array(0.2,0.3,0.99))  as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC139
  test("UNIQDATA_DEFAULT_TC139", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,array(0.2,0.3,0.99),5) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC140
  test("UNIQDATA_DEFAULT_TC140", Include) {

    sql(s"""select histogram_numeric(Double_COLUMN1,2)  as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC141
  test("UNIQDATA_DEFAULT_TC141", Include) {

    checkAnswer(s"""select Double_COLUMN1, Double_COLUMN1+ 10 as a  from UNIQDATA order by a""",
      s"""select Double_COLUMN1, Double_COLUMN1+ 10 as a  from UNIQDATA_hive order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC141")

  }


  // UNIQDATA_DEFAULT_TC142
  test("UNIQDATA_DEFAULT_TC142", Include) {

    checkAnswer(s"""select min(Double_COLUMN1), max(Double_COLUMN1+ 10) Total from UNIQDATA group by  ACTIVE_EMUI_VERSION order by Total""",
      s"""select min(Double_COLUMN1), max(Double_COLUMN1+ 10) Total from UNIQDATA_hive group by  ACTIVE_EMUI_VERSION order by Total""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC142")

  }


  // UNIQDATA_DEFAULT_TC143
  test("UNIQDATA_DEFAULT_TC143", Include) {

    sql(s"""select last(Double_COLUMN1) a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC144
  test("UNIQDATA_DEFAULT_TC144", Include) {

    checkAnswer(s"""select FIRST(Double_COLUMN1) a from UNIQDATA order by a""",
      s"""select FIRST(Double_COLUMN1) a from UNIQDATA_hive order by a""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC144")

  }


  // UNIQDATA_DEFAULT_TC145
  test("UNIQDATA_DEFAULT_TC145", Include) {

    checkAnswer(s"""select Double_COLUMN1,count(Double_COLUMN1) a from UNIQDATA group by Double_COLUMN1 order by Double_COLUMN1""",
      s"""select Double_COLUMN1,count(Double_COLUMN1) a from UNIQDATA_hive group by Double_COLUMN1 order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC145")

  }


  // UNIQDATA_DEFAULT_TC146
  test("UNIQDATA_DEFAULT_TC146", Include) {

    checkAnswer(s"""select Lower(Double_COLUMN1) a  from UNIQDATA order by Double_COLUMN1""",
      s"""select Lower(Double_COLUMN1) a  from UNIQDATA_hive order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC146")

  }


  // UNIQDATA_DEFAULT_TC147
  test("UNIQDATA_DEFAULT_TC147", Include) {

    checkAnswer(s"""select distinct Double_COLUMN1 from UNIQDATA order by Double_COLUMN1""",
      s"""select distinct Double_COLUMN1 from UNIQDATA_hive order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC147")

  }


  // UNIQDATA_DEFAULT_TC148
  test("UNIQDATA_DEFAULT_TC148", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA  order by Double_COLUMN1 limit 101""",
      s"""select Double_COLUMN1 from UNIQDATA_hive  order by Double_COLUMN1 limit 101""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC148")

  }


  // UNIQDATA_DEFAULT_TC149
  test("UNIQDATA_DEFAULT_TC149", Include) {

    checkAnswer(s"""select Double_COLUMN1 as a from UNIQDATA  order by a asc limit 10""",
      s"""select Double_COLUMN1 as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC149")

  }


  // UNIQDATA_DEFAULT_TC150
  test("UNIQDATA_DEFAULT_TC150", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where  (Double_COLUMN1 == 12345680745.1234000000) and (CUST_NAME=='CUST_NAME_01844')""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where  (Double_COLUMN1 == 12345680745.1234000000) and (CUST_NAME=='CUST_NAME_01844')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC150")

  }


  // UNIQDATA_DEFAULT_TC151
  test("UNIQDATA_DEFAULT_TC151", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 !=12345680745.1234000000  order by Double_COLUMN1""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 !=12345680745.1234000000  order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC151")

  }


  // UNIQDATA_DEFAULT_TC152
  test("UNIQDATA_DEFAULT_TC152", Include) {

    checkAnswer(s"""select Double_COLUMN1  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select Double_COLUMN1  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC152")

  }


  // UNIQDATA_DEFAULT_TC153
  test("UNIQDATA_DEFAULT_TC153", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 !=12345680745.1234000000""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 !=12345680745.1234000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC153")

  }


  // UNIQDATA_DEFAULT_TC154
  test("UNIQDATA_DEFAULT_TC154", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 >12345680745.1234000000""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 >12345680745.1234000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC154")

  }


  // UNIQDATA_DEFAULT_TC155
  test("UNIQDATA_DEFAULT_TC155", Include) {

    checkAnswer(s"""select Double_COLUMN1  from UNIQDATA where Double_COLUMN1<>Double_COLUMN1""",
      s"""select Double_COLUMN1  from UNIQDATA_hive where Double_COLUMN1<>Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC155")

  }


  // UNIQDATA_DEFAULT_TC156
  test("UNIQDATA_DEFAULT_TC156", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 != BIGINT_COLUMN2  order by Double_COLUMN1""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 != BIGINT_COLUMN2  order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC156")

  }


  // UNIQDATA_DEFAULT_TC157
  test("UNIQDATA_DEFAULT_TC157", Include) {

    checkAnswer(s"""select Double_COLUMN1, Double_COLUMN1 from UNIQDATA where BIGINT_COLUMN2<Double_COLUMN1  order by Double_COLUMN1""",
      s"""select Double_COLUMN1, Double_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN2<Double_COLUMN1  order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC157")

  }


  // UNIQDATA_DEFAULT_TC158
  test("UNIQDATA_DEFAULT_TC158", Include) {

    checkAnswer(s"""select Double_COLUMN1, Double_COLUMN1 from UNIQDATA where Double_COLUMN1<=Double_COLUMN1  order by Double_COLUMN1""",
      s"""select Double_COLUMN1, Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1<=Double_COLUMN1  order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC158")

  }


  // UNIQDATA_DEFAULT_TC159
  test("UNIQDATA_DEFAULT_TC159", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 <1000 order by Double_COLUMN1""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 <1000 order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC159")

  }


  // UNIQDATA_DEFAULT_TC160
  test("UNIQDATA_DEFAULT_TC160", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 >1000 order by Double_COLUMN1""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 >1000 order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC160")

  }


  // UNIQDATA_DEFAULT_TC161
  test("UNIQDATA_DEFAULT_TC161", Include) {

    checkAnswer(s"""select Double_COLUMN1  from UNIQDATA where Double_COLUMN1 IS NULL order by Double_COLUMN1""",
      s"""select Double_COLUMN1  from UNIQDATA_hive where Double_COLUMN1 IS NULL order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC161")

  }


  // UNIQDATA_DEFAULT_TC162
  test("UNIQDATA_DEFAULT_TC162", Include) {

    checkAnswer(s"""select Double_COLUMN1  from UNIQDATA where Double_COLUMN1 IS NOT NULL order by Double_COLUMN1""",
      s"""select Double_COLUMN1  from UNIQDATA_hive where Double_COLUMN1 IS NOT NULL order by Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC162")

  }


  // UNIQDATA_DEFAULT_TC163
  test("UNIQDATA_DEFAULT_TC163", Include) {

    checkAnswer(s"""Select count(DOB) from UNIQDATA""",
      s"""Select count(DOB) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC163")

  }


  // UNIQDATA_DEFAULT_TC164
  test("UNIQDATA_DEFAULT_TC164", Include) {

    checkAnswer(s"""select count(DISTINCT DOB) as a from UNIQDATA""",
      s"""select count(DISTINCT DOB) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC164")

  }


  // UNIQDATA_DEFAULT_TC165
  test("UNIQDATA_DEFAULT_TC165", Include) {

    checkAnswer(s"""select sum(DOB)+10 as a ,DOB  from UNIQDATA group by DOB order by DOB""",
      s"""select sum(DOB)+10 as a ,DOB  from UNIQDATA_hive group by DOB order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC165")

  }


  // UNIQDATA_DEFAULT_TC166
  test("UNIQDATA_DEFAULT_TC166", Include) {

    checkAnswer(s"""select max(DOB),min(DOB) from UNIQDATA""",
      s"""select max(DOB),min(DOB) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC166")

  }


  // UNIQDATA_DEFAULT_TC167
  test("UNIQDATA_DEFAULT_TC167", Include) {

    checkAnswer(s"""select sum(DOB) a  from UNIQDATA""",
      s"""select sum(DOB) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC167")

  }


  // UNIQDATA_DEFAULT_TC168
  test("UNIQDATA_DEFAULT_TC168", Include) {

    checkAnswer(s"""select avg(DOB) a  from UNIQDATA""",
      s"""select avg(DOB) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC168")

  }


  // UNIQDATA_DEFAULT_TC169
  test("UNIQDATA_DEFAULT_TC169", Include) {

    checkAnswer(s"""select min(DOB) a  from UNIQDATA""",
      s"""select min(DOB) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC169")

  }


  // UNIQDATA_DEFAULT_TC170
  test("UNIQDATA_DEFAULT_TC170", Include) {

    sql(s"""select variance(Double_COLUMN1) as a from (select Double_COLUMN1 from UNIQDATA order by  Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC171
  test("UNIQDATA_DEFAULT_TC171", Include) {

    sql(s"""select var_pop(Double_COLUMN1) as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC172
  test("UNIQDATA_DEFAULT_TC172", Include) {

    sql(s"""select var_samp(Double_COLUMN1) as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC173
  test("UNIQDATA_DEFAULT_TC173", Include) {

    sql(s"""select stddev_pop(Double_COLUMN1) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC174
  test("UNIQDATA_DEFAULT_TC174", Include) {

    sql(s"""select stddev_samp(Double_COLUMN1) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC175
  test("UNIQDATA_DEFAULT_TC175", Include) {

    sql(s"""select covar_pop(Double_COLUMN1,Double_COLUMN1) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC176
  test("UNIQDATA_DEFAULT_TC176", Include) {

    sql(s"""select covar_samp(Double_COLUMN1,Double_COLUMN1) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC177
  test("UNIQDATA_DEFAULT_TC177", Include) {

    checkAnswer(s"""select corr(Double_COLUMN1,Double_COLUMN1) as a from UNIQDATA""",
      s"""select corr(Double_COLUMN1,Double_COLUMN1) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC177")

  }


  // UNIQDATA_DEFAULT_TC178
  test("UNIQDATA_DEFAULT_TC178", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,0.2) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC179
  test("UNIQDATA_DEFAULT_TC179", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,0.2,5) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC180
  test("UNIQDATA_DEFAULT_TC180", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,array(0.2,0.3,0.99)) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC181
  test("UNIQDATA_DEFAULT_TC181", Include) {

    sql(s"""select percentile_approx(Double_COLUMN1,array(0.2,0.3,0.99),5) as a from (select Double_COLUMN1 from UNIQDATA order by Double_COLUMN1) t""").collect

  }


  // UNIQDATA_DEFAULT_TC182
  test("UNIQDATA_DEFAULT_TC182", Include) {

    sql(s"""select histogram_numeric(DOB,2)  as a from (select DOB from UNIQDATA order by DOB) t""").collect

  }


  // UNIQDATA_DEFAULT_TC183
  test("UNIQDATA_DEFAULT_TC183", Include) {

    sql(s"""select last(DOB) a from (select DOB from UNIQDATA order by DOB) t""").collect

  }


  // UNIQDATA_DEFAULT_TC184
  test("UNIQDATA_DEFAULT_TC184", Include) {

    sql(s"""select FIRST(DOB) a from (select DOB from UNIQDATA order by DOB) t""").collect

  }


  // UNIQDATA_DEFAULT_TC185
  test("UNIQDATA_DEFAULT_TC185", Include) {

    checkAnswer(s"""select DOB,count(DOB) a from UNIQDATA group by DOB order by DOB""",
      s"""select DOB,count(DOB) a from UNIQDATA_hive group by DOB order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC185")

  }


  // UNIQDATA_DEFAULT_TC186
  test("UNIQDATA_DEFAULT_TC186", Include) {

    checkAnswer(s"""select Lower(DOB) a  from UNIQDATA order by DOB""",
      s"""select Lower(DOB) a  from UNIQDATA_hive order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC186")

  }


  // UNIQDATA_DEFAULT_TC187
  test("UNIQDATA_DEFAULT_TC187", Include) {

    checkAnswer(s"""select distinct DOB from UNIQDATA order by DOB""",
      s"""select distinct DOB from UNIQDATA_hive order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC187")

  }


  // UNIQDATA_DEFAULT_TC188
  test("UNIQDATA_DEFAULT_TC188", Include) {

    sql(s"""select DOB from UNIQDATA order by DOB limit 101""").collect

  }


  // UNIQDATA_DEFAULT_TC189
  test("UNIQDATA_DEFAULT_TC189", Include) {

    sql(s"""select DOB as a from UNIQDATA  order by a asc limit 10""").collect

  }


  // UNIQDATA_DEFAULT_TC190
  test("UNIQDATA_DEFAULT_TC190", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where  (DOB == '1970-06-19 01:00:03') and (DOJ=='1970-06-19 02:00:03')""",
      s"""select DOB from UNIQDATA_hive where  (DOB == '1970-06-19 01:00:03') and (DOJ=='1970-06-19 02:00:03')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC190")

  }


  // UNIQDATA_DEFAULT_TC191
  test("UNIQDATA_DEFAULT_TC191", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB !='1970-06-19 01:00:03' order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB !='1970-06-19 01:00:03' order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC191")

  }


  // UNIQDATA_DEFAULT_TC192
  test("UNIQDATA_DEFAULT_TC192", Include) {

    checkAnswer(s"""select DOB  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select DOB  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC192")

  }


  // UNIQDATA_DEFAULT_TC193
  test("UNIQDATA_DEFAULT_TC193", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB !='1970-06-19 01:00:03' order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB !='1970-06-19 01:00:03' order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC193")

  }


  // UNIQDATA_DEFAULT_TC194
  ignore("UNIQDATA_DEFAULT_TC194", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB >'1970-06-19 01:00:03' order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB >'1970-06-19 01:00:03' order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC194")

  }


  // UNIQDATA_DEFAULT_TC195
  test("UNIQDATA_DEFAULT_TC195", Include) {

    checkAnswer(s"""select DOB  from UNIQDATA where DOB<>DOB order by DOB""",
      s"""select DOB  from UNIQDATA_hive where DOB<>DOB order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC195")

  }


  // UNIQDATA_DEFAULT_TC196
  test("UNIQDATA_DEFAULT_TC196", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB != DOJ order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB != DOJ order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC196")

  }


  // UNIQDATA_DEFAULT_TC197
  test("UNIQDATA_DEFAULT_TC197", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOJ<DOB order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOJ<DOB order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC197")

  }


  // UNIQDATA_DEFAULT_TC198
  test("UNIQDATA_DEFAULT_TC198", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB<=DOB order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB<=DOB order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC198")

  }


  // UNIQDATA_DEFAULT_TC199
  test("UNIQDATA_DEFAULT_TC199", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB <cast('1970-06-19 01:00:03' as timestamp) order by DOB""",
      s"""select DOB from UNIQDATA_hive where DOB <cast('1970-06-19 01:00:03' as timestamp) order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC199")

  }


  // UNIQDATA_DEFAULT_TC200
  test("UNIQDATA_DEFAULT_TC200", Include) {

    checkAnswer(s"""select DOB  from UNIQDATA where DOB IS NULL""",
      s"""select DOB  from UNIQDATA_hive where DOB IS NULL""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC200")

  }


  // UNIQDATA_DEFAULT_TC201
  test("UNIQDATA_DEFAULT_TC201", Include) {

    checkAnswer(s"""select DOB  from UNIQDATA where DOB IS NOT NULL order by DOB""",
      s"""select DOB  from UNIQDATA_hive where DOB IS NOT NULL order by DOB""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC201")

  }


  // UNIQDATA_DEFAULT_TC202
  test("UNIQDATA_DEFAULT_TC202", Include) {

    checkAnswer(s"""Select count(CUST_ID) from UNIQDATA""",
      s"""Select count(CUST_ID) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC202")

  }


  // UNIQDATA_DEFAULT_TC203
  test("UNIQDATA_DEFAULT_TC203", Include) {

    checkAnswer(s"""select count(DISTINCT CUST_ID) as a from UNIQDATA""",
      s"""select count(DISTINCT CUST_ID) as a from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC203")

  }


  // UNIQDATA_DEFAULT_TC204
  test("UNIQDATA_DEFAULT_TC204", Include) {

    checkAnswer(s"""select sum(CUST_ID)+10 as a ,CUST_ID  from UNIQDATA group by CUST_ID order by CUST_ID""",
      s"""select sum(CUST_ID)+10 as a ,CUST_ID  from UNIQDATA_hive group by CUST_ID order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC204")

  }


  // UNIQDATA_DEFAULT_TC205
  test("UNIQDATA_DEFAULT_TC205", Include) {

    checkAnswer(s"""select max(CUST_ID),min(CUST_ID) from UNIQDATA""",
      s"""select max(CUST_ID),min(CUST_ID) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC205")

  }


  // UNIQDATA_DEFAULT_TC206
  test("UNIQDATA_DEFAULT_TC206", Include) {

    checkAnswer(s"""select sum(CUST_ID) a  from UNIQDATA""",
      s"""select sum(CUST_ID) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC206")

  }


  // UNIQDATA_DEFAULT_TC207
  test("UNIQDATA_DEFAULT_TC207", Include) {

    checkAnswer(s"""select avg(CUST_ID) a  from UNIQDATA""",
      s"""select avg(CUST_ID) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC207")

  }


  // UNIQDATA_DEFAULT_TC208
  test("UNIQDATA_DEFAULT_TC208", Include) {

    checkAnswer(s"""select min(CUST_ID) a  from UNIQDATA""",
      s"""select min(CUST_ID) a  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC208")

  }


  // UNIQDATA_DEFAULT_TC209
  test("UNIQDATA_DEFAULT_TC209", Include) {

    sql(s"""select variance(CUST_ID) as a   from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC210
  test("UNIQDATA_DEFAULT_TC210", Include) {

    sql(s"""select var_pop(CUST_ID)  as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC211
  test("UNIQDATA_DEFAULT_TC211", Include) {

    sql(s"""select var_samp(CUST_ID) as a  from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC212
  test("UNIQDATA_DEFAULT_TC212", Include) {

    sql(s"""select stddev_pop(CUST_ID) as a  from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC213
  test("UNIQDATA_DEFAULT_TC213", Include) {

    sql(s"""select stddev_samp(CUST_ID)  as a from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC214
  test("UNIQDATA_DEFAULT_TC214", Include) {

    sql(s"""select covar_pop(CUST_ID,CUST_ID) as a  from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC215
  test("UNIQDATA_DEFAULT_TC215", Include) {

    sql(s"""select covar_samp(CUST_ID,CUST_ID) as a  from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC216
  test("UNIQDATA_DEFAULT_TC216", Include) {

    sql(s"""select corr(CUST_ID,CUST_ID)  as a from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC217
  test("UNIQDATA_DEFAULT_TC217", Include) {

    sql(s"""select percentile_approx(CUST_ID,0.2) as a  from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC218
  test("UNIQDATA_DEFAULT_TC218", Include) {

    sql(s"""select percentile_approx(CUST_ID,0.2,5) as a  from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC219
  test("UNIQDATA_DEFAULT_TC219", Include) {

    sql(s"""select percentile_approx(CUST_ID,array(0.2,0.3,0.99))  as a from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC220
  test("UNIQDATA_DEFAULT_TC220", Include) {

    sql(s"""select percentile_approx(CUST_ID,array(0.2,0.3,0.99),5) as a from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC221
  test("UNIQDATA_DEFAULT_TC221", Include) {

    sql(s"""select histogram_numeric(CUST_ID,2)  as a from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC222
  test("UNIQDATA_DEFAULT_TC222", Include) {

    checkAnswer(s"""select CUST_ID, CUST_ID+ 10 as a  from UNIQDATA order by CUST_ID""",
      s"""select CUST_ID, CUST_ID+ 10 as a  from UNIQDATA_hive order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC222")

  }


  // UNIQDATA_DEFAULT_TC223
  test("UNIQDATA_DEFAULT_TC223", Include) {

    checkAnswer(s"""select min(CUST_ID), max(CUST_ID+ 10) Total from UNIQDATA group by  ACTIVE_EMUI_VERSION order by Total""",
      s"""select min(CUST_ID), max(CUST_ID+ 10) Total from UNIQDATA_hive group by  ACTIVE_EMUI_VERSION order by Total""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC223")

  }


  // UNIQDATA_DEFAULT_TC224
  test("UNIQDATA_DEFAULT_TC224", Include) {

    sql(s"""select last(CUST_ID) a from (select CUST_ID from UNIQDATA order by CUST_ID) t""").collect

  }


  // UNIQDATA_DEFAULT_TC225
  test("UNIQDATA_DEFAULT_TC225", Include) {

    sql(s"""select FIRST(CUST_ID) a from UNIQDATA order by a""").collect

  }


  // UNIQDATA_DEFAULT_TC226
  test("UNIQDATA_DEFAULT_TC226", Include) {

    checkAnswer(s"""select CUST_ID,count(CUST_ID) a from UNIQDATA group by CUST_ID order by CUST_ID""",
      s"""select CUST_ID,count(CUST_ID) a from UNIQDATA_hive group by CUST_ID order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC226")

  }


  // UNIQDATA_DEFAULT_TC227
  test("UNIQDATA_DEFAULT_TC227", Include) {

    checkAnswer(s"""select Lower(CUST_ID) a  from UNIQDATA order by CUST_ID""",
      s"""select Lower(CUST_ID) a  from UNIQDATA_hive order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC227")

  }


  // UNIQDATA_DEFAULT_TC228
  test("UNIQDATA_DEFAULT_TC228", Include) {

    checkAnswer(s"""select distinct CUST_ID from UNIQDATA order by CUST_ID""",
      s"""select distinct CUST_ID from UNIQDATA_hive order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC228")

  }


  // UNIQDATA_DEFAULT_TC229
  test("UNIQDATA_DEFAULT_TC229", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA order by CUST_ID limit 101""",
      s"""select CUST_ID from UNIQDATA_hive order by CUST_ID limit 101""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC229")

  }


  // UNIQDATA_DEFAULT_TC230
  test("UNIQDATA_DEFAULT_TC230", Include) {

    checkAnswer(s"""select CUST_ID as a from UNIQDATA  order by a asc limit 10""",
      s"""select CUST_ID as a from UNIQDATA_hive  order by a asc limit 10""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC230")

  }


  // UNIQDATA_DEFAULT_TC231
  test("UNIQDATA_DEFAULT_TC231", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where  (CUST_ID == 100084) and (CUST_ID==100084)""",
      s"""select CUST_ID from UNIQDATA_hive where  (CUST_ID == 100084) and (CUST_ID==100084)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC231")

  }


  // UNIQDATA_DEFAULT_TC232
  test("UNIQDATA_DEFAULT_TC232", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID !='100084' order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID !='100084' order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC232")

  }


  // UNIQDATA_DEFAULT_TC233
  test("UNIQDATA_DEFAULT_TC233", Include) {

    checkAnswer(s"""select CUST_ID  from UNIQDATA where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""",
      s"""select CUST_ID  from UNIQDATA_hive where (CUST_ID=10844 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01844') OR (CUST_ID=10840 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_01840')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC233")

  }


  // UNIQDATA_DEFAULT_TC234
  test("UNIQDATA_DEFAULT_TC234", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID !=100084 order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID !=100084 order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC234")

  }


  // UNIQDATA_DEFAULT_TC235
  test("UNIQDATA_DEFAULT_TC235", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID >100084 order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID >100084 order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC235")

  }


  // UNIQDATA_DEFAULT_TC236
  test("UNIQDATA_DEFAULT_TC236", Include) {

    checkAnswer(s"""select CUST_ID  from UNIQDATA where CUST_ID<>CUST_ID order by CUST_ID""",
      s"""select CUST_ID  from UNIQDATA_hive where CUST_ID<>CUST_ID order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC236")

  }


  // UNIQDATA_DEFAULT_TC237
  test("UNIQDATA_DEFAULT_TC237", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID != BIGINT_COLUMN2 order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID != BIGINT_COLUMN2 order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC237")

  }


  // UNIQDATA_DEFAULT_TC238
  test("UNIQDATA_DEFAULT_TC238", Include) {

    checkAnswer(s"""select CUST_ID, CUST_ID from UNIQDATA where BIGINT_COLUMN2<CUST_ID order by CUST_ID""",
      s"""select CUST_ID, CUST_ID from UNIQDATA_hive where BIGINT_COLUMN2<CUST_ID order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC238")

  }


  // UNIQDATA_DEFAULT_TC239
  test("UNIQDATA_DEFAULT_TC239", Include) {

    checkAnswer(s"""select CUST_ID, CUST_ID from UNIQDATA where CUST_ID<=CUST_ID order by CUST_ID""",
      s"""select CUST_ID, CUST_ID from UNIQDATA_hive where CUST_ID<=CUST_ID order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC239")

  }


  // UNIQDATA_DEFAULT_TC240
  test("UNIQDATA_DEFAULT_TC240", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID <1000 order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID <1000 order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC240")

  }


  // UNIQDATA_DEFAULT_TC241
  test("UNIQDATA_DEFAULT_TC241", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID >1000 order by CUST_ID""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID >1000 order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC241")

  }


  // UNIQDATA_DEFAULT_TC242
  test("UNIQDATA_DEFAULT_TC242", Include) {

    checkAnswer(s"""select CUST_ID  from UNIQDATA where CUST_ID IS NULL order by CUST_ID""",
      s"""select CUST_ID  from UNIQDATA_hive where CUST_ID IS NULL order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC242")

  }


  // UNIQDATA_DEFAULT_TC243
  test("UNIQDATA_DEFAULT_TC243", Include) {

    checkAnswer(s"""select CUST_ID  from UNIQDATA where CUST_ID IS NOT NULL order by CUST_ID""",
      s"""select CUST_ID  from UNIQDATA_hive where CUST_ID IS NOT NULL order by CUST_ID""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC243")

  }


  // UNIQDATA_DEFAULT_TC244
  test("UNIQDATA_DEFAULT_TC244", Include) {

    checkAnswer(s"""select sum(CUST_NAME)+10 as a   from UNIQDATA""",
      s"""select sum(CUST_NAME)+10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC244")

  }


  // UNIQDATA_DEFAULT_TC245
  test("UNIQDATA_DEFAULT_TC245", Include) {

    checkAnswer(s"""select sum(CUST_NAME)*10 as a   from UNIQDATA""",
      s"""select sum(CUST_NAME)*10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC245")

  }


  // UNIQDATA_DEFAULT_TC246
  test("UNIQDATA_DEFAULT_TC246", Include) {

    checkAnswer(s"""select sum(CUST_NAME)/10 as a   from UNIQDATA""",
      s"""select sum(CUST_NAME)/10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC246")

  }


  // UNIQDATA_DEFAULT_TC247
  test("UNIQDATA_DEFAULT_TC247", Include) {

    checkAnswer(s"""select sum(CUST_NAME)-10 as a   from UNIQDATA""",
      s"""select sum(CUST_NAME)-10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC247")

  }


  // UNIQDATA_DEFAULT_TC248
  test("UNIQDATA_DEFAULT_TC248", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1)+10 as a   from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1)+10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC248")

  }


  // UNIQDATA_DEFAULT_TC249
  test("UNIQDATA_DEFAULT_TC249", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1)*10 as a   from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1)*10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC249")

  }


  // UNIQDATA_DEFAULT_TC250
  test("UNIQDATA_DEFAULT_TC250", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1)/10 as a   from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1)/10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC250")

  }


  // UNIQDATA_DEFAULT_TC251
  test("UNIQDATA_DEFAULT_TC251", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1)-10 as a   from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1)-10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC251")

  }


  // UNIQDATA_DEFAULT_TC252
  test("UNIQDATA_DEFAULT_TC252", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1)+10 as a   from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1)+10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC252")

  }


  // UNIQDATA_DEFAULT_TC253
  test("UNIQDATA_DEFAULT_TC253", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1)*10 as a   from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1)*10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC253")

  }


  // UNIQDATA_DEFAULT_TC254
  test("UNIQDATA_DEFAULT_TC254", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1)/10 as a   from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1)/10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC254")

  }


  // UNIQDATA_DEFAULT_TC255
  test("UNIQDATA_DEFAULT_TC255", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1)-10 as a   from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1)-10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC255")

  }


  // UNIQDATA_DEFAULT_TC256
  test("UNIQDATA_DEFAULT_TC256", Include) {

    sql(s"""select sum(Double_COLUMN1)+10 as a   from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC257
  test("UNIQDATA_DEFAULT_TC257", Include) {

    sql(s"""select sum(Double_COLUMN1)*10 as a   from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC258
  test("UNIQDATA_DEFAULT_TC258", Include) {

    sql(s"""select sum(Double_COLUMN1)/10 as a   from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC259
  test("UNIQDATA_DEFAULT_TC259", Include) {

    sql(s"""select sum(Double_COLUMN1)-10 as a   from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC260
  test("UNIQDATA_DEFAULT_TC260", Include) {

    checkAnswer(s"""select sum(DOB)+10 as a   from UNIQDATA""",
      s"""select sum(DOB)+10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC260")

  }


  // UNIQDATA_DEFAULT_TC261
  test("UNIQDATA_DEFAULT_TC261", Include) {

    checkAnswer(s"""select sum(DOB)*10 as a   from UNIQDATA""",
      s"""select sum(DOB)*10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC261")

  }


  // UNIQDATA_DEFAULT_TC262
  test("UNIQDATA_DEFAULT_TC262", Include) {

    checkAnswer(s"""select sum(DOB)/10 as a   from UNIQDATA""",
      s"""select sum(DOB)/10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC262")

  }


  // UNIQDATA_DEFAULT_TC263
  test("UNIQDATA_DEFAULT_TC263", Include) {

    checkAnswer(s"""select sum(DOB)-10 as a   from UNIQDATA""",
      s"""select sum(DOB)-10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC263")

  }


  // UNIQDATA_DEFAULT_TC264
  test("UNIQDATA_DEFAULT_TC264", Include) {

    checkAnswer(s"""select sum(CUST_ID)+10 as a   from UNIQDATA""",
      s"""select sum(CUST_ID)+10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC264")

  }


  // UNIQDATA_DEFAULT_TC265
  test("UNIQDATA_DEFAULT_TC265", Include) {

    checkAnswer(s"""select sum(CUST_ID)*10 as a   from UNIQDATA""",
      s"""select sum(CUST_ID)*10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC265")

  }


  // UNIQDATA_DEFAULT_TC266
  test("UNIQDATA_DEFAULT_TC266", Include) {

    checkAnswer(s"""select sum(CUST_ID)/10 as a   from UNIQDATA""",
      s"""select sum(CUST_ID)/10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC266")

  }


  // UNIQDATA_DEFAULT_TC267
  test("UNIQDATA_DEFAULT_TC267", Include) {

    checkAnswer(s"""select sum(CUST_ID)-10 as a   from UNIQDATA""",
      s"""select sum(CUST_ID)-10 as a   from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC267")

  }


  // UNIQDATA_DEFAULT_TC292
  test("UNIQDATA_DEFAULT_TC292", Include) {

    checkAnswer(s"""SELECT DOB from UNIQDATA where DOB LIKE '2015-09-30%'""",
      s"""SELECT DOB from UNIQDATA_hive where DOB LIKE '2015-09-30%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC292")

  }


  // UNIQDATA_DEFAULT_TC293
  test("UNIQDATA_DEFAULT_TC293", Include) {

    checkAnswer(s"""SELECT DOB from UNIQDATA where DOB LIKE '% %'""",
      s"""SELECT DOB from UNIQDATA_hive where DOB LIKE '% %'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC293")

  }


  // UNIQDATA_DEFAULT_TC294
  test("UNIQDATA_DEFAULT_TC294", Include) {

    checkAnswer(s"""SELECT DOB from UNIQDATA where DOB LIKE '%01:00:03'""",
      s"""SELECT DOB from UNIQDATA_hive where DOB LIKE '%01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC294")

  }


  // UNIQDATA_DEFAULT_TC295
  test("UNIQDATA_DEFAULT_TC295", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 like '123372038%' """,
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 like '123372038%' """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC295")

  }


  // UNIQDATA_DEFAULT_TC296
  test("UNIQDATA_DEFAULT_TC296", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 like '%2038'""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 like '%2038'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC296")

  }


  // UNIQDATA_DEFAULT_TC297
  test("UNIQDATA_DEFAULT_TC297", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 like '%2038%'""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 like '%2038%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC297")

  }


  // UNIQDATA_DEFAULT_TC298
  test("UNIQDATA_DEFAULT_TC298", Include) {

    checkAnswer(s"""SELECT DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 like '123456790%'""",
      s"""SELECT DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 like '123456790%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC298")

  }


  // UNIQDATA_DEFAULT_TC299
  test("UNIQDATA_DEFAULT_TC299", Include) {

    checkAnswer(s"""SELECT DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 like '%456790%'""",
      s"""SELECT DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 like '%456790%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC299")

  }


  // UNIQDATA_DEFAULT_TC300
  test("UNIQDATA_DEFAULT_TC300", Include) {

    checkAnswer(s"""SELECT DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 like '123456790%'""",
      s"""SELECT DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 like '123456790%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC300")

  }


  // UNIQDATA_DEFAULT_TC301
  test("UNIQDATA_DEFAULT_TC301", Include) {

    checkAnswer(s"""SELECT Double_COLUMN1 from UNIQDATA where Double_COLUMN1 like '1.123456748%'""",
      s"""SELECT Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 like '1.123456748%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC301")

  }


  // UNIQDATA_DEFAULT_TC302
  test("UNIQDATA_DEFAULT_TC302", Include) {

    checkAnswer(s"""SELECT Double_COLUMN1 from UNIQDATA where Double_COLUMN1 like '%23456%'""",
      s"""SELECT Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 like '%23456%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC302")

  }


  // UNIQDATA_DEFAULT_TC303
  test("UNIQDATA_DEFAULT_TC303", Include) {

    checkAnswer(s"""SELECT Double_COLUMN1 from UNIQDATA where Double_COLUMN1 like '%976E10'""",
      s"""SELECT Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 like '%976E10'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC303")

  }


  // UNIQDATA_DEFAULT_TC304
  test("UNIQDATA_DEFAULT_TC304", Include) {

    checkAnswer(s"""SELECT CUST_ID from UNIQDATA where CUST_ID like '1000%'""",
      s"""SELECT CUST_ID from UNIQDATA_hive where CUST_ID like '1000%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC304")

  }


  // UNIQDATA_DEFAULT_TC305
  test("UNIQDATA_DEFAULT_TC305", Include) {

    checkAnswer(s"""SELECT CUST_ID from UNIQDATA where CUST_ID like '%00%'""",
      s"""SELECT CUST_ID from UNIQDATA_hive where CUST_ID like '%00%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC305")

  }


  // UNIQDATA_DEFAULT_TC306
  test("UNIQDATA_DEFAULT_TC306", Include) {

    checkAnswer(s"""SELECT CUST_ID from UNIQDATA where CUST_ID like '%0084'""",
      s"""SELECT CUST_ID from UNIQDATA_hive where CUST_ID like '%0084'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC306")

  }


  // UNIQDATA_DEFAULT_TC307
  test("UNIQDATA_DEFAULT_TC307", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME like 'CUST_NAME_0184%'""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME like 'CUST_NAME_0184%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC307")

  }


  // UNIQDATA_DEFAULT_TC308
  test("UNIQDATA_DEFAULT_TC308", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME like '%E_01%'""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME like '%E_01%'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC308")

  }


  // UNIQDATA_DEFAULT_TC309
  test("UNIQDATA_DEFAULT_TC309", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME like '%ST_NAME_018'""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME like '%ST_NAME_018'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC309")

  }


  // UNIQDATA_DEFAULT_TC310
  test("UNIQDATA_DEFAULT_TC310", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME in ('CUST_NAME_0184400074','CUST_NAME_0184400075','CUST_NAME_0184400077')""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME in ('CUST_NAME_0184400074','CUST_NAME_0184400075','CUST_NAME_0184400077')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC310")

  }


  // UNIQDATA_DEFAULT_TC311
  test("UNIQDATA_DEFAULT_TC311", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME not in ('CUST_NAME_0184400074','CUST_NAME_0184400075','CUST_NAME_0184400077')""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME not in ('CUST_NAME_0184400074','CUST_NAME_0184400075','CUST_NAME_0184400077')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC311")

  }


  // UNIQDATA_DEFAULT_TC312
  test("UNIQDATA_DEFAULT_TC312", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID in (9137,10137,14137)""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID in (9137,10137,14137)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC312")

  }


  // UNIQDATA_DEFAULT_TC313
  test("UNIQDATA_DEFAULT_TC313", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID not in (9137,10137,14137)""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID not in (9137,10137,14137)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC313")

  }


  // UNIQDATA_DEFAULT_TC314
  test("UNIQDATA_DEFAULT_TC314", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB in ('2015-10-04 01:00:03','2015-10-07%','2015-10-07 01:00:03')""",
      s"""select DOB from UNIQDATA_hive where DOB in ('2015-10-04 01:00:03','2015-10-07%','2015-10-07 01:00:03')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC314")

  }


  // UNIQDATA_DEFAULT_TC315
  test("UNIQDATA_DEFAULT_TC315", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB not in (cast('2015-10-04 01:00:03' as timestamp),cast('2015-10-07 01:00:03' as timestamp))""",
      s"""select DOB from UNIQDATA_hive where DOB not in (cast('2015-10-04 01:00:03' as timestamp),cast('2015-10-07 01:00:03' as timestamp))""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC315")

  }


  // UNIQDATA_DEFAULT_TC316
  test("UNIQDATA_DEFAULT_TC316", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 in (11234567489.7976000000,11234567589.7976000000,11234569489.7976000000)""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 in (11234567489.7976000000,11234567589.7976000000,11234569489.7976000000)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC316")

  }


  // UNIQDATA_DEFAULT_TC317
  test("UNIQDATA_DEFAULT_TC317", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 not in (11234567489.7976000000,11234567589.7976000000,11234569489.7976000000)""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 not in (11234567489.7976000000,11234567589.7976000000,11234569489.7976000000)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC317")

  }


  // UNIQDATA_DEFAULT_TC318
  test("UNIQDATA_DEFAULT_TC318", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 in (22345680745.1234000000,22345680741.1234000000)""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 in (22345680745.1234000000,22345680741.1234000000)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC318")

  }


  // UNIQDATA_DEFAULT_TC319
  test("UNIQDATA_DEFAULT_TC319", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 not in (22345680745.1234000000,22345680741.1234000000)""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 not in (22345680745.1234000000,22345680741.1234000000)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC319")

  }


  // UNIQDATA_DEFAULT_TC322
  test("UNIQDATA_DEFAULT_TC322", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME !='CUST_NAME_0184400077'""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME !='CUST_NAME_0184400077'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC322")

  }


  // UNIQDATA_DEFAULT_TC323
  test("UNIQDATA_DEFAULT_TC323", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME NOT LIKE 'CUST_NAME_0184400077'""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME NOT LIKE 'CUST_NAME_0184400077'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC323")

  }


  // UNIQDATA_DEFAULT_TC324
  test("UNIQDATA_DEFAULT_TC324", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID !=100078""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID !=100078""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC324")

  }


  // UNIQDATA_DEFAULT_TC325
  test("UNIQDATA_DEFAULT_TC325", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID NOT LIKE 100079""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID NOT LIKE 100079""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC325")

  }


  // UNIQDATA_DEFAULT_TC326
  test("UNIQDATA_DEFAULT_TC326", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB !='2015-10-07 01:00:03'""",
      s"""select DOB from UNIQDATA_hive where DOB !='2015-10-07 01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC326")

  }


  // UNIQDATA_DEFAULT_TC327
  ignore("UNIQDATA_DEFAULT_TC327", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB NOT LIKE '2015-10-07 01:00:03'""",
      s"""select DOB from UNIQDATA_hive where DOB NOT LIKE '2015-10-07 01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC327")

  }


  // UNIQDATA_DEFAULT_TC328
  test("UNIQDATA_DEFAULT_TC328", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 !=11234569489.7976000000""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 !=11234569489.7976000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC328")

  }


  // UNIQDATA_DEFAULT_TC329
  test("UNIQDATA_DEFAULT_TC329", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 NOT LIKE 11234569489.7976000000""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 NOT LIKE 11234569489.7976000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC329")

  }


  // UNIQDATA_DEFAULT_TC330
  test("UNIQDATA_DEFAULT_TC330", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 != 22345680741.1234000000""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 != 22345680741.1234000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC330")

  }


  // UNIQDATA_DEFAULT_TC331
  test("UNIQDATA_DEFAULT_TC331", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 NOT LIKE 22345680741.1234000000""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 NOT LIKE 22345680741.1234000000""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC331")

  }


  // UNIQDATA_DEFAULT_TC335
  test("UNIQDATA_DEFAULT_TC335", Include) {

    checkAnswer(s"""SELECT DOB,CUST_NAME from UNIQDATA where CUST_NAME RLIKE 'CUST_NAME_0184400077'""",
      s"""SELECT DOB,CUST_NAME from UNIQDATA_hive where CUST_NAME RLIKE 'CUST_NAME_0184400077'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC335")

  }


  // UNIQDATA_DEFAULT_TC336
  test("UNIQDATA_DEFAULT_TC336", Include) {

    checkAnswer(s"""SELECT CUST_ID from UNIQDATA where CUST_ID RLIKE '100079'""",
      s"""SELECT CUST_ID from UNIQDATA_hive where CUST_ID RLIKE '100079'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC336")

  }


  // UNIQDATA_DEFAULT_TC337
  test("UNIQDATA_DEFAULT_TC337", Include) {

    checkAnswer(s"""SELECT Double_COLUMN1 from UNIQDATA where Double_COLUMN1 RLIKE '11234569489.7976000000'""",
      s"""SELECT Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 RLIKE '11234569489.7976000000'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC337")

  }


  // UNIQDATA_DEFAULT_TC338
  test("UNIQDATA_DEFAULT_TC338", Include) {

    checkAnswer(s"""SELECT DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 RLIKE '1234567890123550.0000000000'""",
      s"""SELECT DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 RLIKE '1234567890123550.0000000000'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC338")

  }


  // UNIQDATA_DEFAULT_TC339
  test("UNIQDATA_DEFAULT_TC339", Include) {

    checkAnswer(s"""SELECT BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 RLIKE '123372038698'""",
      s"""SELECT BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 RLIKE '123372038698'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC339")

  }


  // UNIQDATA_DEFAULT_TC340
  ignore("UNIQDATA_DEFAULT_TC340", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.DOB=b.DOB and a.DOB NOT LIKE '2015-10-07 01:00:03'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.DOB=b.DOB and a.DOB NOT LIKE '2015-10-07 01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC340")

  }


  // UNIQDATA_DEFAULT_TC341
  ignore("UNIQDATA_DEFAULT_TC341", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.CUST_ID=b.CUST_ID and a.DOB NOT LIKE '2015-10-07 01:00:03'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.CUST_ID=b.CUST_ID and a.DOB NOT LIKE '2015-10-07 01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC341")

  }


  // UNIQDATA_DEFAULT_TC342
  ignore("UNIQDATA_DEFAULT_TC342", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.CUST_NAME=b.CUST_NAME and a.DOB NOT LIKE '2015-10-07 01:00:03'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.CUST_NAME=b.CUST_NAME and a.DOB NOT LIKE '2015-10-07 01:00:03'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC342")

  }


  // UNIQDATA_DEFAULT_TC343
  test("UNIQDATA_DEFAULT_TC343", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.Double_COLUMN1=b.Double_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.Double_COLUMN1=b.Double_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC343")

  }


  // UNIQDATA_DEFAULT_TC344
  test("UNIQDATA_DEFAULT_TC344", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.DECIMAL_COLUMN1=b.DECIMAL_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.DECIMAL_COLUMN1=b.DECIMAL_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC344")

  }


  // UNIQDATA_DEFAULT_TC345
  test("UNIQDATA_DEFAULT_TC345", Include) {

    checkAnswer(s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA a join UNIQDATA b on a.BIGINT_COLUMN1=b.BIGINT_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""",
      s"""select  b.BIGINT_COLUMN1,b.DECIMAL_COLUMN1,b.Double_COLUMN1,b.DOB,b.CUST_ID,b.CUST_NAME from UNIQDATA_hive a join UNIQDATA_hive b on a.BIGINT_COLUMN1=b.BIGINT_COLUMN1 and a.DECIMAL_COLUMN1 RLIKE '12345678901.1234000058'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC345")

  }


  // UNIQDATA_DEFAULT_TC346
  test("UNIQDATA_DEFAULT_TC346", Include) {

    checkAnswer(s"""select count( BIGINT_COLUMN1 ),sum( BIGINT_COLUMN1 ),count(distinct BIGINT_COLUMN1 ),avg( BIGINT_COLUMN1 ),max( BIGINT_COLUMN1 ),min( BIGINT_COLUMN1 ),1 from UNIQDATA""",
      s"""select count( BIGINT_COLUMN1 ),sum( BIGINT_COLUMN1 ),count(distinct BIGINT_COLUMN1 ),avg( BIGINT_COLUMN1 ),max( BIGINT_COLUMN1 ),min( BIGINT_COLUMN1 ),1 from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC346")

  }


  // UNIQDATA_DEFAULT_TC347
  test("UNIQDATA_DEFAULT_TC347", Include) {

    checkAnswer(s"""select count( DECIMAL_COLUMN1 ),sum( DECIMAL_COLUMN1 ),count(distinct DECIMAL_COLUMN1 ),avg( DECIMAL_COLUMN1 ),max( DECIMAL_COLUMN1 ),min( DECIMAL_COLUMN1 ),1 from UNIQDATA""",
      s"""select count( DECIMAL_COLUMN1 ),sum( DECIMAL_COLUMN1 ),count(distinct DECIMAL_COLUMN1 ),avg( DECIMAL_COLUMN1 ),max( DECIMAL_COLUMN1 ),min( DECIMAL_COLUMN1 ),1 from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC347")

  }


  // UNIQDATA_DEFAULT_TC348
  test("UNIQDATA_DEFAULT_TC348", Include) {

    sql(s"""select count( Double_COLUMN1),sum( Double_COLUMN1 ),count(distinct Double_COLUMN1 ),avg(Double_COLUMN1),max(Double_COLUMN1),min(Double_COLUMN1),1 from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC349
  test("UNIQDATA_DEFAULT_TC349", Include) {

    checkAnswer(s"""select count(CUST_ID),sum(CUST_ID),count(CUST_ID),avg(CUST_ID),max(CUST_ID),min(CUST_ID),1 from UNIQDATA""",
      s"""select count(CUST_ID),sum(CUST_ID),count(CUST_ID),avg(CUST_ID),max(CUST_ID),min(CUST_ID),1 from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC349")

  }


  // UNIQDATA_DEFAULT_TC350
  test("UNIQDATA_DEFAULT_TC350", Include) {

    checkAnswer(s"""select count(DOB),sum(DOB),count(distinct DOB ),avg(DOB),max(DOB ),min(DOB),1 from UNIQDATA""",
      s"""select count(DOB),sum(DOB),count(distinct DOB ),avg(DOB),max(DOB ),min(DOB),1 from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC350")

  }


  // UNIQDATA_DEFAULT_TC351
  test("UNIQDATA_DEFAULT_TC351", Include) {

    checkAnswer(s"""select count(CUST_NAME ),sum(CUST_NAME ),count(distinct CUST_NAME ),avg(CUST_NAME ),max(CUST_NAME ),min(CUST_NAME ),1 from UNIQDATA""",
      s"""select count(CUST_NAME ),sum(CUST_NAME ),count(distinct CUST_NAME ),avg(CUST_NAME ),max(CUST_NAME ),min(CUST_NAME ),1 from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC351")

  }


  // UNIQDATA_DEFAULT_TC352
  test("UNIQDATA_DEFAULT_TC352", Include) {

    checkAnswer(s"""select sum(BIGINT_COLUMN1),count(BIGINT_COLUMN1),avg(BIGINT_COLUMN1),sum(BIGINT_COLUMN1)/count(BIGINT_COLUMN1) from UNIQDATA""",
      s"""select sum(BIGINT_COLUMN1),count(BIGINT_COLUMN1),avg(BIGINT_COLUMN1),sum(BIGINT_COLUMN1)/count(BIGINT_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC352")

  }


  // UNIQDATA_DEFAULT_TC353
  test("UNIQDATA_DEFAULT_TC353", Include) {

    checkAnswer(s"""select sum(DECIMAL_COLUMN1),count(DECIMAL_COLUMN1),avg(DECIMAL_COLUMN1),sum(DECIMAL_COLUMN1)/count(DECIMAL_COLUMN1) from UNIQDATA""",
      s"""select sum(DECIMAL_COLUMN1),count(DECIMAL_COLUMN1),avg(DECIMAL_COLUMN1),sum(DECIMAL_COLUMN1)/count(DECIMAL_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC353")

  }


  // UNIQDATA_DEFAULT_TC354
  test("UNIQDATA_DEFAULT_TC354", Include) {

    sql(s"""select sum(Double_COLUMN1),count(Double_COLUMN1),avg(Double_COLUMN1),sum(Double_COLUMN1)/count(Double_COLUMN1) from UNIQDATA""").collect

  }


  // UNIQDATA_DEFAULT_TC355
  test("UNIQDATA_DEFAULT_TC355", Include) {

    checkAnswer(s"""select sum(CUST_ID),count(CUST_ID),avg(CUST_ID),sum(CUST_ID)/count(CUST_ID) from UNIQDATA""",
      s"""select sum(CUST_ID),count(CUST_ID),avg(CUST_ID),sum(CUST_ID)/count(CUST_ID) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC355")

  }


  // UNIQDATA_DEFAULT_TC356
  test("UNIQDATA_DEFAULT_TC356", Include) {

    checkAnswer(s"""select sum(CUST_NAME),count(CUST_NAME),avg(CUST_NAME),sum(CUST_NAME)/count(CUST_NAME) from UNIQDATA""",
      s"""select sum(CUST_NAME),count(CUST_NAME),avg(CUST_NAME),sum(CUST_NAME)/count(CUST_NAME) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC356")

  }


  // UNIQDATA_DEFAULT_TC357
  test("UNIQDATA_DEFAULT_TC357", Include) {

    checkAnswer(s"""select sum(DOB),count(DOB),avg(DOB),sum(DOB)/count(DOB) from UNIQDATA""",
      s"""select sum(DOB),count(DOB),avg(DOB),sum(DOB)/count(DOB) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC357")

  }


  // UNIQDATA_DEFAULT_TC358
  test("UNIQDATA_DEFAULT_TC358", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,DOB,CUST_ID,CUST_NAME  from UNIQDATA""",
      s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,DOB,CUST_ID,CUST_NAME  from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC358")

  }


  // UNIQDATA_DEFAULT_TC359
  test("UNIQDATA_DEFAULT_TC359", Include) {

    checkAnswer(s"""select count(DECIMAL_COLUMN2) from UNIQDATA""",
      s"""select count(DECIMAL_COLUMN2) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC359")

  }


  // UNIQDATA_DEFAULT_TC360
  test("UNIQDATA_DEFAULT_TC360", Include) {

    checkAnswer(s"""select count(Double_COLUMN1) from UNIQDATA""",
      s"""select count(Double_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC360")

  }


  // UNIQDATA_DEFAULT_TC361
  test("UNIQDATA_DEFAULT_TC361", Include) {

    checkAnswer(s"""select count(BIGINT_COLUMN1) from UNIQDATA""",
      s"""select count(BIGINT_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC361")

  }


  // UNIQDATA_DEFAULT_TC362
  test("UNIQDATA_DEFAULT_TC362", Include) {

    checkAnswer(s"""select count(DECIMAL_COLUMN1) from UNIQDATA""",
      s"""select count(DECIMAL_COLUMN1) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC362")

  }


  // UNIQDATA_DEFAULT_TC363
  test("UNIQDATA_DEFAULT_TC363", Include) {

    checkAnswer(s"""select count(DOB) from UNIQDATA""",
      s"""select count(DOB) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC363")

  }


  // UNIQDATA_DEFAULT_TC364
  test("UNIQDATA_DEFAULT_TC364", Include) {

    checkAnswer(s"""select count(CUST_ID) from UNIQDATA""",
      s"""select count(CUST_ID) from UNIQDATA_hive""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC364")

  }


  // UNIQDATA_DEFAULT_TC365
  test("UNIQDATA_DEFAULT_TC365", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  BIGINT_COLUMN1  != '123372038698'""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  BIGINT_COLUMN1  != '123372038698'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC365")

  }


  // UNIQDATA_DEFAULT_TC366
  test("UNIQDATA_DEFAULT_TC366", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  DECIMAL_COLUMN1  != '1234567890123480.0000000000' order by CUST_ID limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  DECIMAL_COLUMN1  != '1234567890123480.0000000000' order by CUST_ID limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC366")

  }


  // UNIQDATA_DEFAULT_TC367
  test("UNIQDATA_DEFAULT_TC367", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  Double_COLUMN1  != '11234569489.7976000000' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  Double_COLUMN1  != '11234569489.7976000000' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC367")

  }


  // UNIQDATA_DEFAULT_TC368
  test("UNIQDATA_DEFAULT_TC368", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  DOB  != '2015-09-18 01:00:03.0' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  DOB  != '2015-09-18 01:00:03.0' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC368")

  }


  // UNIQDATA_DEFAULT_TC369
  test("UNIQDATA_DEFAULT_TC369", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  CUST_ID  != '100075' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  CUST_ID  != '100075' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC369")

  }


  // UNIQDATA_DEFAULT_TC370
  test("UNIQDATA_DEFAULT_TC370", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  BIGINT_COLUMN1  not like '123372038698' order by  CUST_ID limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  BIGINT_COLUMN1  not like '123372038698' order by  CUST_ID limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC370")

  }


  // UNIQDATA_DEFAULT_TC371
  test("UNIQDATA_DEFAULT_TC371", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  DECIMAL_COLUMN1  not like '11234569489.79760000000' order by CUST_ID limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  DECIMAL_COLUMN1  not like '11234569489.79760000000' order by CUST_ID limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC371")

  }


  // UNIQDATA_DEFAULT_TC372
  test("UNIQDATA_DEFAULT_TC372", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  Double_COLUMN1  not like '11234569489.7976000000' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  Double_COLUMN1  not like '11234569489.7976000000' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC372")

  }


  // UNIQDATA_DEFAULT_TC373
  test("UNIQDATA_DEFAULT_TC373", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  DOB  not like '2015-09-18 01:00:03.0' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  DOB  not like '2015-09-18 01:00:03.0' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC373")

  }


  // UNIQDATA_DEFAULT_TC374
  test("UNIQDATA_DEFAULT_TC374", Include) {

    checkAnswer(s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA where  CUST_ID  not like '100075' order by CUST_NAME limit 5""",
      s"""select CUST_NAME,CUST_ID,DECIMAL_COLUMN2,ACTIVE_EMUI_VERSION from UNIQDATA_hive where  CUST_ID  not like '100075' order by CUST_NAME limit 5""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC374")

  }


  // UNIQDATA_DEFAULT_TC375
  test("UNIQDATA_DEFAULT_TC375", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME is not null""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC375")

  }


  // UNIQDATA_DEFAULT_TC376
  test("UNIQDATA_DEFAULT_TC376", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 is not null""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC376")

  }


  // UNIQDATA_DEFAULT_TC377
  test("UNIQDATA_DEFAULT_TC377", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 is not null""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC377")

  }


  // UNIQDATA_DEFAULT_TC378
  test("UNIQDATA_DEFAULT_TC378", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 is not null""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC378")

  }


  // UNIQDATA_DEFAULT_TC379
  test("UNIQDATA_DEFAULT_TC379", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB is not null""",
      s"""select DOB from UNIQDATA_hive where DOB is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC379")

  }


  // UNIQDATA_DEFAULT_TC380
  test("UNIQDATA_DEFAULT_TC380", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID is not null""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID is not null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC380")

  }


  // UNIQDATA_DEFAULT_TC381
  test("UNIQDATA_DEFAULT_TC381", Include) {

    checkAnswer(s"""select CUST_NAME from UNIQDATA where CUST_NAME is  null""",
      s"""select CUST_NAME from UNIQDATA_hive where CUST_NAME is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC381")

  }


  // UNIQDATA_DEFAULT_TC382
  test("UNIQDATA_DEFAULT_TC382", Include) {

    checkAnswer(s"""select Double_COLUMN1 from UNIQDATA where Double_COLUMN1 is  null""",
      s"""select Double_COLUMN1 from UNIQDATA_hive where Double_COLUMN1 is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC382")

  }


  // UNIQDATA_DEFAULT_TC383
  test("UNIQDATA_DEFAULT_TC383", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1 from UNIQDATA where BIGINT_COLUMN1 is  null""",
      s"""select BIGINT_COLUMN1 from UNIQDATA_hive where BIGINT_COLUMN1 is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC383")

  }


  // UNIQDATA_DEFAULT_TC384
  test("UNIQDATA_DEFAULT_TC384", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1 from UNIQDATA where DECIMAL_COLUMN1 is  null""",
      s"""select DECIMAL_COLUMN1 from UNIQDATA_hive where DECIMAL_COLUMN1 is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC384")

  }


  // UNIQDATA_DEFAULT_TC385
  test("UNIQDATA_DEFAULT_TC385", Include) {

    checkAnswer(s"""select DOB from UNIQDATA where DOB is  null""",
      s"""select DOB from UNIQDATA_hive where DOB is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC385")

  }


  // UNIQDATA_DEFAULT_TC386
  test("UNIQDATA_DEFAULT_TC386", Include) {

    checkAnswer(s"""select CUST_ID from UNIQDATA where CUST_ID is  null""",
      s"""select CUST_ID from UNIQDATA_hive where CUST_ID is  null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC386")

  }


  // UNIQDATA_DEFAULT_TC387
  test("UNIQDATA_DEFAULT_TC387", Include) {

    checkAnswer(s"""select count(*) from UNIQDATA where CUST_NAME = 'CUST_NAME_01844'""",
      s"""select count(*) from UNIQDATA_hive where CUST_NAME = 'CUST_NAME_01844'""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_TC387")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_001
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_001", Include) {

    checkAnswer(s"""select CUST_ID,INTEGER_COLUMN1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME from uniqdata where cust_id=9056 and INTEGER_COLUMN1=57  and BIGINT_COLUMN1=123372036910 and  BIGINT_COLUMN2=-223372036798 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_00056' and cust_name='CUST_NAME_00056' and cust_id!=1 and ACTIVE_EMUI_VERSION!='abc' """,
      s"""select CUST_ID,INTEGER_COLUMN1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME from uniqdata_hive where cust_id=9056 and INTEGER_COLUMN1=57  and BIGINT_COLUMN1=123372036910 and  BIGINT_COLUMN2=-223372036798 and ACTIVE_EMUI_VERSION='ACTIVE_EMUI_VERSION_00056' and cust_name='CUST_NAME_00056' and cust_id!=1 and ACTIVE_EMUI_VERSION!='abc' """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_001")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_002
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_002", Include) {

    checkAnswer(s"""select DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata where DECIMAL_COLUMN1=12345680900.1234 and DECIMAL_COLUMN2=22345680900.1234 and Double_COLUMN1=1.12345674897976E10 and Double_COLUMN2=-4.8E-4 and dob='1975-06-23 01:00:03'  and doj='1975-06-23 02:00:03' and dob!='1970-03-29 01:00:03' and doj!='1970-04-03 02:00:03' and Double_COLUMN2!=12345678987.1234""",
      s"""select DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata_hive where DECIMAL_COLUMN1=12345680900.1234 and DECIMAL_COLUMN2=22345680900.1234 and Double_COLUMN1=1.12345674897976E10 and Double_COLUMN2=-4.8E-4 and dob='1975-06-23 01:00:03'  and doj='1975-06-23 02:00:03' and dob!='1970-03-29 01:00:03' and doj!='1970-04-03 02:00:03' and Double_COLUMN2!=12345678987.1234""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_002")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_003
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_003", Include) {

    checkAnswer(s"""select CUST_ID,INTEGER_COLUMN1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME from uniqdata where cust_id>=9000 and CUST_ID<=10000 and INTEGER_COLUMN1>=1 and INTEGER_COLUMN1<=400 and BIGINT_COLUMN1>=123372036854 and BIGINT_COLUMN1<=123372037254 and BIGINT_COLUMN2>=-223372036854  and BIGINT_COLUMN2<=-223372036454""",
      s"""select CUST_ID,INTEGER_COLUMN1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME from uniqdata_hive where cust_id>=9000 and CUST_ID<=10000 and INTEGER_COLUMN1>=1 and INTEGER_COLUMN1<=400 and BIGINT_COLUMN1>=123372036854 and BIGINT_COLUMN1<=123372037254 and BIGINT_COLUMN2>=-223372036854  and BIGINT_COLUMN2<=-223372036454""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_003")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_004
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_004", Include) {

    checkAnswer(s"""select DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata where DECIMAL_COLUMN1>=12345678901.1234 and DECIMAL_COLUMN1<=12345679301.12344 and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976 and Double_COLUMN1<=1.12345674897976E10 and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<= -4.8E-4 and dob>='1970-01-02 01:00:03' and dob<= '1971-02-05 01:00:03' and doj>='1970-01-02 02:00:03' and doj<='1971-02-05 02:00:03' order by DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2""",
      s"""select DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata_hive where DECIMAL_COLUMN1>=12345678901.1234 and DECIMAL_COLUMN1<=12345679301.12344 and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976 and Double_COLUMN1<=1.12345674897976E10 and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<= -4.8E-4 and dob>='1970-01-02 01:00:03' and dob<= '1971-02-05 01:00:03' and doj>='1970-01-02 02:00:03' and doj<='1971-02-05 02:00:03' order by DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_004")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_005
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_005", Include) {

    checkAnswer(s"""select distinct INTEGER_COLUMN1,BIGINT_COLUMN1,ACTIVE_EMUI_VERSION,cust_name from uniqdata where INTEGER_COLUMN1<cust_id and BIGINT_COLUMN2<BIGINT_COLUMN1 and substr(cust_name,10,length(cust_name))=substr(ACTIVE_EMUI_VERSION,20,length(ACTIVE_EMUI_VERSION))""",
      s"""select distinct INTEGER_COLUMN1,BIGINT_COLUMN1,ACTIVE_EMUI_VERSION,cust_name from uniqdata_hive where INTEGER_COLUMN1<cust_id and BIGINT_COLUMN2<BIGINT_COLUMN1 and substr(cust_name,10,length(cust_name))=substr(ACTIVE_EMUI_VERSION,20,length(ACTIVE_EMUI_VERSION))""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_005")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_006
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_006", Include) {

    checkAnswer(s"""select DECIMAL_COLUMN1,Double_COLUMN1,distinct(dob) from uniqdata where  DECIMAL_COLUMN1<DECIMAL_COLUMN2 and Double_COLUMN1>Double_COLUMN2  and day(dob)=day(doj) order by DECIMAL_COLUMN1,Double_COLUMN1""",
      s"""select DECIMAL_COLUMN1,Double_COLUMN1,distinct(dob) from uniqdata_hive where  DECIMAL_COLUMN1<DECIMAL_COLUMN2 and Double_COLUMN1>Double_COLUMN2  and day(dob)=day(doj) order by DECIMAL_COLUMN1,Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_006")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_007
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_007", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,DOJ,INTEGER_COLUMN1,ACTIVE_EMUI_VERSION from uniqdata where cust_id in(9011,9012,9013,9014,9015,9016) and INTEGER_COLUMN1 in (12,13,14,15,16,17,18)and ACTIVE_EMUI_VERSION  in('ACTIVE_EMUI_VERSION_00011','ACTIVE_EMUI_VERSION_00012','ACTIVE_EMUI_VERSION_00013','ACTIVE_EMUI_VERSION_00014','ACTIVE_EMUI_VERSION_00015') and CUST_NAME in ('CUST_NAME_00011','CUST_NAME_00012','CUST_NAME_00013','CUST_NAME_00016') and DOB in('1970-01-12 01:00:03','1970-01-13 01:00:03','1970-01-14 01:00:03','1970-01-15 01:00:03')""",
      s"""select CUST_ID,CUST_NAME,DOB,DOJ,INTEGER_COLUMN1,ACTIVE_EMUI_VERSION from uniqdata_hive where cust_id in(9011,9012,9013,9014,9015,9016) and INTEGER_COLUMN1 in (12,13,14,15,16,17,18)and ACTIVE_EMUI_VERSION  in('ACTIVE_EMUI_VERSION_00011','ACTIVE_EMUI_VERSION_00012','ACTIVE_EMUI_VERSION_00013','ACTIVE_EMUI_VERSION_00014','ACTIVE_EMUI_VERSION_00015') and CUST_NAME in ('CUST_NAME_00011','CUST_NAME_00012','CUST_NAME_00013','CUST_NAME_00016') and DOB in('1970-01-12 01:00:03','1970-01-13 01:00:03','1970-01-14 01:00:03','1970-01-15 01:00:03')""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_007")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_008
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_008", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,BIGINT_COLUMN2 from uniqdata where BIGINT_COLUMN1 in (123372036869,123372036870,123372036871,123372036872) and BIGINT_COLUMN2 not in (-223372034862,-223372034889,-223372034902,-223372034860) and DECIMAL_COLUMN1 not in(12345678916.1234,12345678917.1234,12345678918.1234,2345678919.1234,2345678920.1234) and DECIMAL_COLUMN2 not in (22345680900.1234,22345680895.1234,22345680892.1234)  and Double_COLUMN2 not in(1234567890,6789076,11234567489.7976)""",
      s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,BIGINT_COLUMN2 from uniqdata_hive where BIGINT_COLUMN1 in (123372036869,123372036870,123372036871,123372036872) and BIGINT_COLUMN2 not in (-223372034862,-223372034889,-223372034902,-223372034860) and DECIMAL_COLUMN1 not in(12345678916.1234,12345678917.1234,12345678918.1234,2345678919.1234,2345678920.1234) and DECIMAL_COLUMN2 not in (22345680900.1234,22345680895.1234,22345680892.1234)  and Double_COLUMN2 not in(1234567890,6789076,11234567489.7976)""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_008")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_009
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_009", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,DOJ,INTEGER_COLUMN1,ACTIVE_EMUI_VERSION from uniqdata where (cust_id in(9011,9012,9013,9014,9015,9016) or INTEGER_COLUMN1 in (17,18,19,20))and (ACTIVE_EMUI_VERSION not in('ACTIVE_EMUI_VERSION_00028','ACTIVE_EMUI_VERSION_00029','ACTIVE_EMUI_VERSION_00030') or CUST_NAME in ('CUST_NAME_00011','CUST_NAME_00012','CUST_NAME_00013','CUST_NAME_00016') )and (DOB in('1970-01-12 01:00:03','1970-01-13 01:00:03','1970-01-14 01:00:03','1970-01-15 01:00:03') or doj not in('1970-01-30 02:00:03','1970-01-31 02:00:03','1970-02-01 02:00:03','1970-02-02 02:00:03','1970-02-03 02:00:03','1970-02-04 02:00:03','1970-02-05 02:00:03'))""",
      s"""select CUST_ID,CUST_NAME,DOB,DOJ,INTEGER_COLUMN1,ACTIVE_EMUI_VERSION from uniqdata_hive where (cust_id in(9011,9012,9013,9014,9015,9016) or INTEGER_COLUMN1 in (17,18,19,20))and (ACTIVE_EMUI_VERSION not in('ACTIVE_EMUI_VERSION_00028','ACTIVE_EMUI_VERSION_00029','ACTIVE_EMUI_VERSION_00030') or CUST_NAME in ('CUST_NAME_00011','CUST_NAME_00012','CUST_NAME_00013','CUST_NAME_00016') )and (DOB in('1970-01-12 01:00:03','1970-01-13 01:00:03','1970-01-14 01:00:03','1970-01-15 01:00:03') or doj not in('1970-01-30 02:00:03','1970-01-31 02:00:03','1970-02-01 02:00:03','1970-02-02 02:00:03','1970-02-03 02:00:03','1970-02-04 02:00:03','1970-02-05 02:00:03'))""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_009")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_010
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_010", Include) {

    checkAnswer(s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,BIGINT_COLUMN2 from uniqdata where (BIGINT_COLUMN1 in (123372036869,123372036870,123372036871,123372036872) or BIGINT_COLUMN2 not in (-223372034862,-223372034889,-223372034902,-223372034860) )and (DECIMAL_COLUMN1 in(12345678916.1234,12345678917.1234,12345678918.1234,2345678919.1234,2345678920.1234) or DECIMAL_COLUMN2 not in (22345680900.1234,22345680895.1234,22345680892.1234)) and (Double_COLUMN1 in (11234567489.7976,11234567489.7976,11234567489.7976,11234567489.7976) or Double_COLUMN2 not in(1234567890,6789076,11234567489.7976))""",
      s"""select BIGINT_COLUMN1,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,BIGINT_COLUMN2 from uniqdata_hive where (BIGINT_COLUMN1 in (123372036869,123372036870,123372036871,123372036872) or BIGINT_COLUMN2 not in (-223372034862,-223372034889,-223372034902,-223372034860) )and (DECIMAL_COLUMN1 in(12345678916.1234,12345678917.1234,12345678918.1234,2345678919.1234,2345678920.1234) or DECIMAL_COLUMN2 not in (22345680900.1234,22345680895.1234,22345680892.1234)) and (Double_COLUMN1 in (11234567489.7976,11234567489.7976,11234567489.7976,11234567489.7976) or Double_COLUMN2 not in(1234567890,6789076,11234567489.7976))""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_010")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_011
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_011", Include) {

    checkAnswer(s"""select cust_id,BIGINT_COLUMN1,ACTIVE_EMUI_VERSION,BIGINT_COLUMN2 from uniqdata where INTEGER_COLUMN1>=50 and INTEGER_COLUMN1<=59 and BIGINT_COLUMN2>=-223372036805 and BIGINT_COLUMN2<=-223372036796 and ACTIVE_EMUI_VERSION rlike 'ACTIVE'
  """,
      s"""select cust_id,BIGINT_COLUMN1,ACTIVE_EMUI_VERSION,BIGINT_COLUMN2 from uniqdata_hive where INTEGER_COLUMN1>=50 and INTEGER_COLUMN1<=59 and BIGINT_COLUMN2>=-223372036805 and BIGINT_COLUMN2<=-223372036796 and ACTIVE_EMUI_VERSION rlike 'ACTIVE'
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_011")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_012
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_012", Include) {

    checkAnswer(s"""select dob,DECIMAL_COLUMN1,Double_COLUMN1 from uniqdata where doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and
  Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976 order by dob,DECIMAL_COLUMN1,Double_COLUMN1""",
      s"""select dob,DECIMAL_COLUMN1,Double_COLUMN1 from uniqdata_hive where doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and
  Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976 order by dob,DECIMAL_COLUMN1,Double_COLUMN1""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_012")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_013
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_013", Include) {

    checkAnswer(s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata where cust_id rlike 9 and
  BIGINT_COLUMN1 rlike 12 and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and CUST_NAME rlike 'CUST' and DOB rlike '19' and DECIMAL_COLUMN1 rlike 1234 and Double_COLUMN1 >=1111 and integer_column1 is not null and BIGINT_COLUMN2 is not null and CUST_NAME is not null and DOJ is not null and  DECIMAL_COLUMN2 is not null and Double_COLUMN2 is not null order by cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2""",
      s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata_hive where cust_id rlike 9 and
  BIGINT_COLUMN1 rlike 12 and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and CUST_NAME rlike 'CUST' and DOB rlike '19' and DECIMAL_COLUMN1 rlike 1234 and Double_COLUMN1 >=1111 and integer_column1 is not null and BIGINT_COLUMN2 is not null and CUST_NAME is not null and DOJ is not null and  DECIMAL_COLUMN2 is not null and Double_COLUMN2 is not null order by cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_013")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_014
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_014", Include) {

    checkAnswer(s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata where integer_column1 like '5%' and BIGINT_COLUMN2 like '-22%' and CUST_NAME like 'CUST%' and ACTIVE_EMUI_VERSION like 'ACTIVE%' and dob like '19%' and decimal_column2 like '22%' and  Double_COLUMN2 >=-111""",
      s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata_hive where integer_column1 like '5%' and BIGINT_COLUMN2 like '-22%' and CUST_NAME like 'CUST%' and ACTIVE_EMUI_VERSION like 'ACTIVE%' and dob like '19%' and decimal_column2 like '22%' and  Double_COLUMN2 >=-111""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_014")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_015
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_015", Include) {

    checkAnswer(s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata where integer_column1 is null and BIGINT_COLUMN2 is null and cust_id is null and dob  is null and decimal_column2 is null and  Double_COLUMN2 is null""",
      s"""select cust_id,integer_column1,BIGINT_COLUMN1,BIGINT_COLUMN2,ACTIVE_EMUI_VERSION,CUST_NAME,DOB,DOJ,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2 from uniqdata_hive where integer_column1 is null and BIGINT_COLUMN2 is null and cust_id is null and dob  is null and decimal_column2 is null and  Double_COLUMN2 is null""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_015")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_017
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_017", Include) {

    checkAnswer(s"""select avg(cust_id),avg(integer_column1),avg(BIGINT_COLUMN1),avg(BIGINT_COLUMN2),avg(DECIMAL_COLUMN1),avg(Double_COLUMN1),avg(Double_COLUMN2),count(cust_id),count(integer_column1),count(ACTIVE_EMUI_VERSION),count(CUST_NAME),count(CUST_NAME),count(DOB),count(doj),count(BIGINT_COLUMN2),count(DECIMAL_COLUMN1),count(Double_COLUMN1),count(Double_COLUMN2),avg(DECIMAL_COLUMN2),sum(cust_id),sum(integer_column1),sum(BIGINT_COLUMN1),sum(BIGINT_COLUMN2),sum(DECIMAL_COLUMN1),sum(Double_COLUMN1),sum(DECIMAL_COLUMN2),min(cust_id),min(integer_column1),min(ACTIVE_EMUI_VERSION),min(CUST_NAME),min(CUST_NAME),min(DOB),min(doj),min(BIGINT_COLUMN2),min(DECIMAL_COLUMN1),min(Double_COLUMN1),min(Double_COLUMN2),max(cust_id),max(integer_column1),max(ACTIVE_EMUI_VERSION),max(CUST_NAME),max(CUST_NAME),max(DOB),max(doj),max(BIGINT_COLUMN2),max(DECIMAL_COLUMN1),max(Double_COLUMN1),max(Double_COLUMN2)from uniqdata where cust_id between 9000 and 9100 and dob between '1970-01-01 01:00:03' and '1972-09-27 02:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1972-09-27 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and
  Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976""",
      s"""select avg(cust_id),avg(integer_column1),avg(BIGINT_COLUMN1),avg(BIGINT_COLUMN2),avg(DECIMAL_COLUMN1),avg(Double_COLUMN1),avg(Double_COLUMN2),count(cust_id),count(integer_column1),count(ACTIVE_EMUI_VERSION),count(CUST_NAME),count(CUST_NAME),count(DOB),count(doj),count(BIGINT_COLUMN2),count(DECIMAL_COLUMN1),count(Double_COLUMN1),count(Double_COLUMN2),avg(DECIMAL_COLUMN2),sum(cust_id),sum(integer_column1),sum(BIGINT_COLUMN1),sum(BIGINT_COLUMN2),sum(DECIMAL_COLUMN1),sum(Double_COLUMN1),sum(DECIMAL_COLUMN2),min(cust_id),min(integer_column1),min(ACTIVE_EMUI_VERSION),min(CUST_NAME),min(CUST_NAME),min(DOB),min(doj),min(BIGINT_COLUMN2),min(DECIMAL_COLUMN1),min(Double_COLUMN1),min(Double_COLUMN2),max(cust_id),max(integer_column1),max(ACTIVE_EMUI_VERSION),max(CUST_NAME),max(CUST_NAME),max(DOB),max(doj),max(BIGINT_COLUMN2),max(DECIMAL_COLUMN1),max(Double_COLUMN1),max(Double_COLUMN2)from uniqdata_hive where cust_id between 9000 and 9100 and dob between '1970-01-01 01:00:03' and '1972-09-27 02:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1972-09-27 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and
  Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_017")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_019
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_019", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1 from uniqdata where cust_name not like '%abc%' and cust_id in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030) and ACTIVE_EMUI_VERSION like 'ACTIVE%' group by CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1 having count(DECIMAL_COLUMN1) <=2  order by CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1
  """,
      s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1 from uniqdata_hive where cust_name not like '%abc%' and cust_id in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030) and ACTIVE_EMUI_VERSION like 'ACTIVE%' group by CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1 having count(DECIMAL_COLUMN1) <=2  order by CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_019")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_020
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_020", Include) {

    checkAnswer(s"""select (avg(DECIMAL_COLUMN1)),(avg(CUST_ID)),(avg(BIGINT_COLUMN1)), (avg(Double_COLUMN1)) from uniqdata  where cust_id between 9000 and  9100 and dob between '1970-01-01 01:00:03' and '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976
  """,
      s"""select (avg(DECIMAL_COLUMN1)),(avg(CUST_ID)),(avg(BIGINT_COLUMN1)), (avg(Double_COLUMN1)) from uniqdata_hive  where cust_id between 9000 and  9100 and dob between '1970-01-01 01:00:03' and '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_020")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_021
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_021", Include) {

    checkAnswer(s"""select (sum(DECIMAL_COLUMN2)),(sum(integer_column1)),(sum(BIGINT_COLUMN2)),(sum(Double_COLUMN2)) from uniqdata  where cust_id between 9000 and  9100 and dob between '1970-01-01 01:00:03' and '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976""",
      s"""select (sum(DECIMAL_COLUMN2)),(sum(integer_column1)),(sum(BIGINT_COLUMN2)),(sum(Double_COLUMN2)) from uniqdata_hive  where cust_id between 9000 and  9100 and dob between '1970-01-01 01:00:03' and '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1968-02-26 02:00:03' and doj<='1973-02-26 02:00:03' and DECIMAL_COLUMN2>=22348957.1234 and Double_COLUMN1>=11267489.7976  and Double_COLUMN2>=-1123224567489.7976 and Double_COLUMN2<=-3457489.7976""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_021")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_022
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_022", Include) {

    checkAnswer(s"""select distinct(count(Double_COLUMN2)),(count(integer_column1)),(count(BIGINT_COLUMN2)),(count(DECIMAL_COLUMN2)),count(ACTIVE_EMUI_VERSION),count(dob) from uniqdata where doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 ) """,
      s"""select distinct(count(Double_COLUMN2)),(count(integer_column1)),(count(BIGINT_COLUMN2)),(count(DECIMAL_COLUMN2)),count(ACTIVE_EMUI_VERSION),count(dob) from uniqdata_hive where doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 ) """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_022")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_024
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_024", Include) {

    checkAnswer(s"""select distinct(max(BIGINT_COLUMN2)),(max(integer_column1)),(max(DECIMAL_COLUMN2)),(max(Double_COLUMN2)),max(ACTIVE_EMUI_VERSION),max(dob) from uniqdata where cust_name not rlike 'abc' and cust_name like 'CUST%' and doj>='1970-01-07 02:00:03' and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 )
  """,
      s"""select distinct(max(BIGINT_COLUMN2)),(max(integer_column1)),(max(DECIMAL_COLUMN2)),(max(Double_COLUMN2)),max(ACTIVE_EMUI_VERSION),max(dob) from uniqdata_hive where cust_name not rlike 'abc' and cust_name like 'CUST%' and doj>='1970-01-07 02:00:03' and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 )
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_024")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_025
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_025", Include) {

    checkAnswer(s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata where cust_id between 9006 and 9080 and cust_name not rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 ) group by CUST_ID,dob,ACTIVE_EMUI_VERSION order by CUST_ID,dob,ACTIVE_EMUI_VERSION""",
      s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata_hive where cust_id between 9006 and 9080 and cust_name not rlike 'ACTIVE' and cust_name like 'CUST%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between -223372036853 and -223372036773   and Double_COLUMN2 in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567489.7976 ) group by CUST_ID,dob,ACTIVE_EMUI_VERSION order by CUST_ID,dob,ACTIVE_EMUI_VERSION""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_025")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_026
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_026", Include) {

    checkAnswer(s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'cust%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between 23372036853 and -223372034863   and Double_COLUMN2 not in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490) group by CUST_ID,dob,ACTIVE_EMUI_VERSION sort by CUST_ID,dob,ACTIVE_EMUI_VERSION""",
      s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata_hive where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'cust%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between 23372036853 and -223372034863   and Double_COLUMN2 not in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490) group by CUST_ID,dob,ACTIVE_EMUI_VERSION sort by CUST_ID,dob,ACTIVE_EMUI_VERSION""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_026")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_027
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_027", Include) {

    checkAnswer(s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'cust%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between 23372036853 and -223372034863   and Double_COLUMN2 not in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490 )group by CUST_ID,dob,ACTIVE_EMUI_VERSION sort by CUST_ID,dob,ACTIVE_EMUI_VERSION""",
      s"""select avg(CUST_ID),sum(integer_column1),count(integer_column1),max(CUST_NAME),min(dob),avg(BIGINT_COLUMN2),sum(DECIMAL_COLUMN2),count(Double_COLUMN2),dob,ACTIVE_EMUI_VERSION from uniqdata_hive where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'cust%' and doj>='1970-01-07 02:00:03'
  and doj<='1970-03-22 02:00:03' and  BIGINT_COLUMN2 between 23372036853 and -223372034863   and Double_COLUMN2 not in (-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490,-11234567490 )group by CUST_ID,dob,ACTIVE_EMUI_VERSION sort by CUST_ID,dob,ACTIVE_EMUI_VERSION""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_027")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_028
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_028", Include) {

    sql(s"""select distinct(instr(ACTIVE_EMUI_VERSION,'Active')),length(cust_name),locate(ACTIVE_EMUI_VERSION,'Active'),lower(cust_name),ltrim(cust_name),repeat(ACTIVE_EMUI_VERSION,1),reverse(cust_name),rpad(ACTIVE_EMUI_VERSION,5,'Cust'),rtrim(cust_name),space(ACTIVE_EMUI_VERSION),split(cust_name,2),substr(ACTIVE_EMUI_VERSION,5,length(ACTIVE_EMUI_VERSION)),trim(cust_name),unbase64(ACTIVE_EMUI_VERSION),Upper(cust_name),initcap(ACTIVE_EMUI_VERSION),soundex(cust_name) from uniqdata where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'CUST%' and doj>='1970-04-06 02:00:03' and doj<='1971-02-05 02:00:03' and  BIGINT_COLUMN2 between -223372036759  and -223372036454   and cust_id not in(9500,9501,9506,9600,9700,9800,10000,9788)""").collect

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_029
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_029", Include) {

    sql(s"""select(instr(ACTIVE_EMUI_VERSION,'Active')),length(cust_name),locate(ACTIVE_EMUI_VERSION,'Active'),lower(cust_name),ltrim(cust_name),repeat(ACTIVE_EMUI_VERSION,1),reverse(cust_name),rpad(ACTIVE_EMUI_VERSION,5,'Cust'),rtrim(cust_name),space(ACTIVE_EMUI_VERSION),split(cust_name,2),substr(ACTIVE_EMUI_VERSION,5,length(ACTIVE_EMUI_VERSION)),trim(cust_name),unbase64(ACTIVE_EMUI_VERSION),Upper(cust_name),initcap(ACTIVE_EMUI_VERSION),soundex(cust_name) from uniqdata where cust_id between 9095 and 9400 and cust_name not rlike 'abc' and cust_name like 'CUST%' and doj>='1970-04-06 02:00:03'
  and doj<='1971-02-05 02:00:03' and  BIGINT_COLUMN2 between -223372036759  and -223372036454   and cust_id not in(9500,9501,9506,9600,9700,9800,10000,9788) group by ACTIVE_EMUI_VERSION,cust_name having count(length(cust_name))>=1 and min(lower(cust_name))not like '%abc%'""").collect

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_030
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_030", Include) {

    sql(s"""select cust_id,cust_name,to_date(doj),quarter(dob),month(doj),day(dob),hour(doj),minute(dob),second(doj),weekofyear(dob),datediff(doj,current_date),date_add(dob,4),date_sub(doj,1),to_utc_timestamp(doj,current_date),add_months(dob,5),last_day(doj),months_between(doj,current_date),date_format(dob,current_date) from uniqdata where substr(cust_name,0,4)='CUST' and length(cust_name)in(15,14,13,16) and ACTIVE_EMUI_VERSION rlike 'ACTIVE' and month(dob)=01  and minute(dob)=0  group by doj,cust_id,cust_name,ACTIVE_EMUI_VERSION,dob having  max(cust_id)=10830 and count(distinct(cust_id))<=2001 and max(cust_name) not like '%def%' order by cust_id,cust_name""").collect

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_031
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_031", Include) {

    sql(s"""select (round(DECIMAL_COLUMN2)),bround(DECIMAL_COLUMN1),floor(BIGINT_COLUMN2),Ceil(BIGINT_COLUMN1),rand(1),exp(integer_column1),log10(Double_COLUMN2),ln(Double_COLUMN1),log2(DECIMAL_COLUMN2),log(DECIMAL_COLUMN1,3),power(BIGINT_COLUMN2,3),pow(BIGINT_COLUMN1,4),sqrt(cust_id),bin(integer_column1),hex(DECIMAL_COLUMN2),unhex(DECIMAL_COLUMN1),abs(BIGINT_COLUMN1),pmod(Double_COLUMN2,5),sin(Double_COLUMN1),asin(Double_COLUMN1),cos(DECIMAL_COLUMN2),acos(DECIMAL_COLUMN1),tan(BIGINT_COLUMN2),atan(BIGINT_COLUMN1),degrees(cust_id),radians(integer_column1),positive(Double_COLUMN2),negative(DECIMAL_COLUMN2),sign(DECIMAL_COLUMN1),factorial(BIGINT_COLUMN2),cbrt(BIGINT_COLUMN1),greatest(cust_id,integer_column1),least(integer_column1,cust_id) from uniqdata where cust_id not in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030) and cust_name like 'CUST%' and dob> '1970-01-01 01:00:03' and dob< '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION not like '%abc%' """).collect

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_032
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_032", Include) {

    sql(s"""select variance(Double_COLUMN2),var_pop(Double_COLUMN1),var_samp(BIGINT_COLUMN2),stddev_pop(Double_COLUMN2),stddev_samp(DECIMAL_COLUMN2),covar_pop(DECIMAL_COLUMN2,DECIMAL_COLUMN1),covar_samp(DECIMAL_COLUMN2,DECIMAL_COLUMN1),corr(Double_COLUMN2,Double_COLUMN1),corr(DECIMAL_COLUMN2,DECIMAL_COLUMN1),percentile(cust_id,0.25),percentile_approx(BIGINT_COLUMN1,0.25,5) from uniqdata where cust_id not in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030) and cust_name like 'CUST%' and dob> '1970-01-01 01:00:03' and dob< '1975-06-23 01:00:03' and ACTIVE_EMUI_VERSION not like '%abc%' """).collect

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_034
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_034", Include) {

    checkAnswer(s"""select  CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 from uniqdata where cust_name = (select max(cust_name) from uniqdata where cust_id not in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030)  and cust_name rlike 'cust' and ACTIVE_EMUI_VERSION like '%active%' and dob not in ('1970-01-14 01:00:03','1970-01-15 01:00:03','1970-01-16 01:00:03'))""",
      s"""select  CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 from uniqdata_hive where cust_name = (select max(cust_name) from uniqdata_hive where cust_id not in (9002,9003,9004,9005,9006,9007,9008,9009,9010,9011,9012,9013,9014,9015,9016,9017,9018,9019,9021,9022,9023,9024,9025,9027,9028,9029,9030)  and cust_name rlike 'cust' and ACTIVE_EMUI_VERSION like '%active%' and dob not in ('1970-01-14 01:00:03','1970-01-15 01:00:03','1970-01-16 01:00:03'))""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_034")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_036
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_036", Include) {

    checkAnswer(s"""select covar_pop(Double_COLUMN2,Double_COLUMN2) as a  from (select Double_COLUMN2 from uniqdata where cust_id between 9000 and 10000 and cust_name like 'Cust%' and dob>='1970-01-01 00:00:00'  order by Double_COLUMN2 ) t""",
      s"""select covar_pop(Double_COLUMN2,Double_COLUMN2) as a  from (select Double_COLUMN2 from uniqdata_hive where cust_id between 9000 and 10000 and cust_name like 'Cust%' and dob>='1970-01-01 00:00:00'  order by Double_COLUMN2 ) t""", "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_036")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_037
  test("UNIQDATA_DEFAULT_MultiBitSet_TC_037", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 as a  from (select * from uniqdata order by Double_COLUMN2)t where cust_name in ('CUST_NAME_01987','CUST_NAME_01988','CUST_NAME_01989','CUST_NAME_01990','CUST_NAME_01991' ,'CUST_NAME_01992')
  """,
      s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 as a  from (select * from uniqdata_hive order by Double_COLUMN2)t where cust_name in ('CUST_NAME_01987','CUST_NAME_01988','CUST_NAME_01989','CUST_NAME_01990','CUST_NAME_01991' ,'CUST_NAME_01992')
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_037")

  }


  // UNIQDATA_DEFAULT_MultiBitSet_TC_038
  ignore("UNIQDATA_DEFAULT_MultiBitSet_TC_038", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 from uniqdata where  ACTIVE_EMUI_VERSION rlike 'ACTIVE' and dob between '1970-10-15 01:00:03' and '1971-04-29 01:00:03' and doj between '1970-10-15 02:00:03' and '1971-04-29 02:00:03' and cust_name like 'CUST%' order by CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB
  """,
      s"""select CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1 from uniqdata_hive where  ACTIVE_EMUI_VERSION rlike 'ACTIVE' and dob between '1970-10-15 01:00:03' and '1971-04-29 01:00:03' and doj between '1970-10-15 02:00:03' and '1971-04-29 02:00:03' and cust_name like 'CUST%' order by CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB
  """, "QueriesBasicTestCase_UNIQDATA_DEFAULT_MultiBitSet_TC_038")

  }


  // PushUP_FILTER_uniqdata_TC001
  test("PushUP_FILTER_uniqdata_TC001", Include) {

    checkAnswer(s"""select to_date(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select to_date(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC001")

  }


  // PushUP_FILTER_uniqdata_TC002
  test("PushUP_FILTER_uniqdata_TC002", Include) {

    checkAnswer(s"""select max(to_date(DOB)),min(to_date(DOB)),count(to_date(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(to_date(DOB)),min(to_date(DOB)),count(to_date(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC002")

  }


  // PushUP_FILTER_uniqdata_TC003
  test("PushUP_FILTER_uniqdata_TC003", Include) {

    checkAnswer(s"""select max(to_date(DOB)),min(to_date(DOB)),count(to_date(DOB)) from uniqdata where to_date(DOB)='1975-06-11' or to_date(DOB)='1975-06-23' """,
      s"""select max(to_date(DOB)),min(to_date(DOB)),count(to_date(DOB)) from uniqdata_hive where to_date(DOB)='1975-06-11' or to_date(DOB)='1975-06-23' """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC003")

  }


  // PushUP_FILTER_uniqdata_TC004
  test("PushUP_FILTER_uniqdata_TC004", Include) {

    checkAnswer(s"""select year(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select year(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC004")

  }


  // PushUP_FILTER_uniqdata_TC005
  test("PushUP_FILTER_uniqdata_TC005", Include) {

    checkAnswer(s"""select max(year(DOB)),min(year(DOB)),count(year(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(year(DOB)),min(year(DOB)),count(year(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC005")

  }


  // PushUP_FILTER_uniqdata_TC006
  test("PushUP_FILTER_uniqdata_TC006", Include) {

    checkAnswer(s"""select max(year(DOB)),min(year(DOB)),count(year(DOB)) from uniqdata where year(DOB)=1975 or year(DOB) is NOT NULL or year(DOB) IS NULL""",
      s"""select max(year(DOB)),min(year(DOB)),count(year(DOB)) from uniqdata_hive where year(DOB)=1975 or year(DOB) is NOT NULL or year(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC006")

  }


  // PushUP_FILTER_uniqdata_TC007
  test("PushUP_FILTER_uniqdata_TC007", Include) {

    checkAnswer(s"""select month(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select month(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC007")

  }


  // PushUP_FILTER_uniqdata_TC008
  test("PushUP_FILTER_uniqdata_TC008", Include) {

    checkAnswer(s"""select max(month(DOB)),min(month(DOB)),count(month(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(month(DOB)),min(month(DOB)),count(month(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC008")

  }


  // PushUP_FILTER_uniqdata_TC009
  test("PushUP_FILTER_uniqdata_TC009", Include) {

    checkAnswer(s"""select max(month(DOB)),min(month(DOB)),count(month(DOB)) from uniqdata where month(DOB)=6 or month(DOB) is NOT NULL or month(DOB) IS NULL""",
      s"""select max(month(DOB)),min(month(DOB)),count(month(DOB)) from uniqdata_hive where month(DOB)=6 or month(DOB) is NOT NULL or month(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC009")

  }


  // PushUP_FILTER_uniqdata_TC010
  test("PushUP_FILTER_uniqdata_TC010", Include) {

    checkAnswer(s"""select day(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select day(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC010")

  }


  // PushUP_FILTER_uniqdata_TC011
  test("PushUP_FILTER_uniqdata_TC011", Include) {

    checkAnswer(s"""select max(day(DOB)),min(day(DOB)),count(day(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(day(DOB)),min(day(DOB)),count(day(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC011")

  }


  // PushUP_FILTER_uniqdata_TC012
  test("PushUP_FILTER_uniqdata_TC012", Include) {

    checkAnswer(s"""select max(day(DOB)),min(day(DOB)),count(day(DOB)) from uniqdata where day(DOB)=23 or day(DOB) is NOT NULL or day(DOB) IS NULL""",
      s"""select max(day(DOB)),min(day(DOB)),count(day(DOB)) from uniqdata_hive where day(DOB)=23 or day(DOB) is NOT NULL or day(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC012")

  }


  // PushUP_FILTER_uniqdata_TC013
  test("PushUP_FILTER_uniqdata_TC013", Include) {

    checkAnswer(s"""select hour(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select hour(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC013")

  }


  // PushUP_FILTER_uniqdata_TC014
  test("PushUP_FILTER_uniqdata_TC014", Include) {

    checkAnswer(s"""select max(hour(DOB)),min(hour(DOB)),count(hour(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(hour(DOB)),min(hour(DOB)),count(hour(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC014")

  }


  // PushUP_FILTER_uniqdata_TC015
  test("PushUP_FILTER_uniqdata_TC015", Include) {

    checkAnswer(s"""select max(hour(DOB)),min(hour(DOB)),count(hour(DOB)) from uniqdata where hour(DOB)=1 or hour(DOB) is NOT NULL or hour(DOB) IS NULL""",
      s"""select max(hour(DOB)),min(hour(DOB)),count(hour(DOB)) from uniqdata_hive where hour(DOB)=1 or hour(DOB) is NOT NULL or hour(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC015")

  }


  // PushUP_FILTER_uniqdata_TC016
  test("PushUP_FILTER_uniqdata_TC016", Include) {

    checkAnswer(s"""select minute(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select minute(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC016")

  }


  // PushUP_FILTER_uniqdata_TC017
  test("PushUP_FILTER_uniqdata_TC017", Include) {

    checkAnswer(s"""select max(minute(DOB)),min(minute(DOB)),count(minute(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(minute(DOB)),min(minute(DOB)),count(minute(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC017")

  }


  // PushUP_FILTER_uniqdata_TC018
  test("PushUP_FILTER_uniqdata_TC018", Include) {

    checkAnswer(s"""select max(minute(DOB)),min(minute(DOB)),count(minute(DOB)) from uniqdata where minute(DOB)=23 or minute(DOB) is NOT NULL or minute(DOB) IS NULL""",
      s"""select max(minute(DOB)),min(minute(DOB)),count(minute(DOB)) from uniqdata_hive where minute(DOB)=23 or minute(DOB) is NOT NULL or minute(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC018")

  }


  // PushUP_FILTER_uniqdata_TC019
  test("PushUP_FILTER_uniqdata_TC019", Include) {

    checkAnswer(s"""select second(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select second(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC019")

  }


  // PushUP_FILTER_uniqdata_TC020
  test("PushUP_FILTER_uniqdata_TC020", Include) {

    checkAnswer(s"""select max(second(DOB)),min(second(DOB)),count(second(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(second(DOB)),min(second(DOB)),count(second(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC020")

  }


  // PushUP_FILTER_uniqdata_TC021
  test("PushUP_FILTER_uniqdata_TC021", Include) {

    checkAnswer(s"""select max(second(DOB)),min(second(DOB)),count(second(DOB)) from uniqdata where second(DOB)=3 or second(DOB) is NOT NULL or second(DOB) IS NULL""",
      s"""select max(second(DOB)),min(second(DOB)),count(second(DOB)) from uniqdata_hive where second(DOB)=3 or second(DOB) is NOT NULL or second(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC021")

  }


  // PushUP_FILTER_uniqdata_TC022
  test("PushUP_FILTER_uniqdata_TC022", Include) {

    checkAnswer(s"""select weekofyear(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select weekofyear(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC022")

  }


  // PushUP_FILTER_uniqdata_TC023
  test("PushUP_FILTER_uniqdata_TC023", Include) {

    checkAnswer(s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC023")

  }


  // PushUP_FILTER_uniqdata_TC024
  test("PushUP_FILTER_uniqdata_TC024", Include) {

    checkAnswer(s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata where weekofyear(DOB)=26 or weekofyear(DOB) is NOT NULL or weekofyear(DOB) IS NULL""",
      s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata_hive where weekofyear(DOB)=26 or weekofyear(DOB) is NOT NULL or weekofyear(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC024")

  }


  // PushUP_FILTER_uniqdata_TC025
  test("PushUP_FILTER_uniqdata_TC025", Include) {

    checkAnswer(s"""select datediff(DOB,DOJ) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select datediff(DOB,DOJ) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC025")

  }


  // PushUP_FILTER_uniqdata_TC026
  test("PushUP_FILTER_uniqdata_TC026", Include) {

    checkAnswer(s"""select max(datediff(DOB,DOJ)),min(datediff(DOB,DOJ)),count(datediff(DOB,DOJ)) from uniqdata where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(datediff(DOB,DOJ)),min(datediff(DOB,DOJ)),count(datediff(DOB,DOJ)) from uniqdata_hive where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC026")

  }


  // PushUP_FILTER_uniqdata_TC027
  test("PushUP_FILTER_uniqdata_TC027", Include) {

    checkAnswer(s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata where datediff(DOB,DOJ)=0 or datediff(DOB,DOJ) is NOT NULL or datediff(DOB,DOJ) IS NULL""",
      s"""select max(weekofyear(DOB)),min(weekofyear(DOB)),count(weekofyear(DOB)) from uniqdata_hive where datediff(DOB,DOJ)=0 or datediff(DOB,DOJ) is NOT NULL or datediff(DOB,DOJ) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC027")

  }


  // PushUP_FILTER_uniqdata_TC028
  test("PushUP_FILTER_uniqdata_TC028", Include) {

    checkAnswer(s"""select date_add(DOB,1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select date_add(DOB,1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC028")

  }


  // PushUP_FILTER_uniqdata_TC029
  test("PushUP_FILTER_uniqdata_TC029", Include) {

    checkAnswer(s"""select max(date_add(DOB,1)),min(date_add(DOB,1)),count(date_add(DOB,1)) from uniqdata where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(date_add(DOB,1)),min(date_add(DOB,1)),count(date_add(DOB,1)) from uniqdata_hive where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC029")

  }


  // PushUP_FILTER_uniqdata_TC030
  test("PushUP_FILTER_uniqdata_TC030", Include) {

    checkAnswer(s"""select max(date_add(DOB,1)),min(date_add(DOB,1)),count(date_add(DOB,1)) from uniqdata where date_add(DOB,1)='1975-06-12' or date_add(DOB,1) is NOT NULL or date_add(DOB,1) IS NULL""",
      s"""select max(date_add(DOB,1)),min(date_add(DOB,1)),count(date_add(DOB,1)) from uniqdata_hive where date_add(DOB,1)='1975-06-12' or date_add(DOB,1) is NOT NULL or date_add(DOB,1) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC030")

  }


  // PushUP_FILTER_uniqdata_TC031
  test("PushUP_FILTER_uniqdata_TC031", Include) {

    checkAnswer(s"""select date_sub(DOB,1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select date_sub(DOB,1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC031")

  }


  // PushUP_FILTER_uniqdata_TC032
  test("PushUP_FILTER_uniqdata_TC032", Include) {

    checkAnswer(s"""select max(date_sub(DOB,1)),min(date_sub(DOB,1)),count(date_sub(DOB,1)) from uniqdata where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(date_sub(DOB,1)),min(date_sub(DOB,1)),count(date_sub(DOB,1)) from uniqdata_hive where CUST_ID IS NULL or DOJ IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC032")

  }


  // PushUP_FILTER_uniqdata_TC033
  test("PushUP_FILTER_uniqdata_TC033", Include) {

    checkAnswer(s"""select max(date_sub(DOB,1)),min(date_sub(DOB,1)),count(date_sub(DOB,1)) from uniqdata where date_sub(DOB,1)='1975-06-12' or date_sub(DOB,1) is NOT NULL or date_sub(DOB,1) IS NULL""",
      s"""select max(date_sub(DOB,1)),min(date_sub(DOB,1)),count(date_sub(DOB,1)) from uniqdata_hive where date_sub(DOB,1)='1975-06-12' or date_sub(DOB,1) is NOT NULL or date_sub(DOB,1) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC033")

  }


  // PushUP_FILTER_uniqdata_TC034
  test("PushUP_FILTER_uniqdata_TC034", Include) {

    checkAnswer(s"""select concat(CUST_ID),concat(CUST_NAME),concat(DOB),concat(BIGINT_COLUMN1),concat(DECIMAL_COLUMN1),concat(Double_COLUMN1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select concat(CUST_ID),concat(CUST_NAME),concat(DOB),concat(BIGINT_COLUMN1),concat(DECIMAL_COLUMN1),concat(Double_COLUMN1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC034")

  }


  // PushUP_FILTER_uniqdata_TC035
  test("PushUP_FILTER_uniqdata_TC035", Include) {

    checkAnswer(s"""select max(concat(CUST_ID)),max(concat(CUST_NAME)),max(concat(DOB)),max(concat(BIGINT_COLUMN1)),max(concat(DECIMAL_COLUMN1)),max(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(concat(CUST_ID)),max(concat(CUST_NAME)),max(concat(DOB)),max(concat(BIGINT_COLUMN1)),max(concat(DECIMAL_COLUMN1)),max(concat(Double_COLUMN1)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC035")

  }


  // PushUP_FILTER_uniqdata_TC036
  test("PushUP_FILTER_uniqdata_TC036", Include) {

    checkAnswer(s"""select min(concat(CUST_ID)),min(concat(CUST_NAME)),min(concat(DOB)),min(concat(BIGINT_COLUMN1)),min(concat(DECIMAL_COLUMN1)),min(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select min(concat(CUST_ID)),min(concat(CUST_NAME)),min(concat(DOB)),min(concat(BIGINT_COLUMN1)),min(concat(DECIMAL_COLUMN1)),min(concat(Double_COLUMN1)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC036")

  }


  // PushUP_FILTER_uniqdata_TC037
  test("PushUP_FILTER_uniqdata_TC037", Include) {

    sql(s"""select sum(concat(CUST_ID)),sum(concat(CUST_NAME)),sum(concat(DOB)),sum(concat(BIGINT_COLUMN1)),sum(concat(DECIMAL_COLUMN1)),sum(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """).collect

  }


  // PushUP_FILTER_uniqdata_TC038
  test("PushUP_FILTER_uniqdata_TC038", Include) {

    checkAnswer(s"""select count(concat(CUST_ID)),count(concat(CUST_NAME)),count(concat(DOB)),count(concat(BIGINT_COLUMN1)),count(concat(DECIMAL_COLUMN1)),count(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select count(concat(CUST_ID)),count(concat(CUST_NAME)),count(concat(DOB)),count(concat(BIGINT_COLUMN1)),count(concat(DECIMAL_COLUMN1)),count(concat(Double_COLUMN1)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC038")

  }


  // PushUP_FILTER_uniqdata_TC039
  ignore("PushUP_FILTER_uniqdata_TC039", Include) {

    checkAnswer(s"""select avg(concat(CUST_ID)),avg(concat(CUST_NAME)),avg(concat(DOB)),avg(concat(BIGINT_COLUMN1)),avg(concat(DECIMAL_COLUMN1)),avg(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select avg(concat(CUST_ID)),avg(concat(CUST_NAME)),avg(concat(DOB)),avg(concat(BIGINT_COLUMN1)),avg(concat(DECIMAL_COLUMN1)),avg(concat(Double_COLUMN1)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC039")

  }


  // PushUP_FILTER_uniqdata_TC040
  test("PushUP_FILTER_uniqdata_TC040", Include) {

    sql(s"""select variance(concat(CUST_ID)),variance(concat(CUST_NAME)),variance(concat(DOB)),variance(concat(BIGINT_COLUMN1)),variance(concat(DECIMAL_COLUMN1)),variance(concat(Double_COLUMN1)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """).collect

  }


  // PushUP_FILTER_uniqdata_TC041
  test("PushUP_FILTER_uniqdata_TC041", Include) {

    checkAnswer(s"""select max(concat(CUST_ID)),max(concat(CUST_NAME)),max(concat(DOB)),max(concat(BIGINT_COLUMN1)),max(concat(DECIMAL_COLUMN1)),max(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""",
      s"""select max(concat(CUST_ID)),max(concat(CUST_NAME)),max(concat(DOB)),max(concat(BIGINT_COLUMN1)),max(concat(DECIMAL_COLUMN1)),max(concat(Double_COLUMN1)) from uniqdata_hive where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC041")

  }


  // PushUP_FILTER_uniqdata_TC042
  test("PushUP_FILTER_uniqdata_TC042", Include) {

    checkAnswer(s"""select min(concat(CUST_ID)),min(concat(CUST_NAME)),min(concat(DOB)),min(concat(BIGINT_COLUMN1)),min(concat(DECIMAL_COLUMN1)),min(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""",
      s"""select min(concat(CUST_ID)),min(concat(CUST_NAME)),min(concat(DOB)),min(concat(BIGINT_COLUMN1)),min(concat(DECIMAL_COLUMN1)),min(concat(Double_COLUMN1)) from uniqdata_hive where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC042")

  }


  // PushUP_FILTER_uniqdata_TC043
  test("PushUP_FILTER_uniqdata_TC043", Include) {

    sql(s"""select sum(concat(CUST_ID)),sum(concat(CUST_NAME)),sum(concat(DOB)),sum(concat(BIGINT_COLUMN1)),sum(concat(DECIMAL_COLUMN1)),sum(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""").collect

  }


  // PushUP_FILTER_uniqdata_TC044
  test("PushUP_FILTER_uniqdata_TC044", Include) {

    checkAnswer(s"""select count(concat(CUST_ID)),count(concat(CUST_NAME)),count(concat(DOB)),count(concat(BIGINT_COLUMN1)),count(concat(DECIMAL_COLUMN1)),count(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""",
      s"""select count(concat(CUST_ID)),count(concat(CUST_NAME)),count(concat(DOB)),count(concat(BIGINT_COLUMN1)),count(concat(DECIMAL_COLUMN1)),count(concat(Double_COLUMN1)) from uniqdata_hive where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC044")

  }


  // PushUP_FILTER_uniqdata_TC045
  ignore("PushUP_FILTER_uniqdata_TC045", Include) {

    checkAnswer(s"""select avg(concat(CUST_ID)),avg(concat(CUST_NAME)),avg(concat(DOB)),avg(concat(BIGINT_COLUMN1)),avg(concat(DECIMAL_COLUMN1)),avg(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""",
      s"""select avg(concat(CUST_ID)),avg(concat(CUST_NAME)),avg(concat(DOB)),avg(concat(BIGINT_COLUMN1)),avg(concat(DECIMAL_COLUMN1)),avg(concat(Double_COLUMN1)) from uniqdata_hive where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC045")

  }


  // PushUP_FILTER_uniqdata_TC046
  test("PushUP_FILTER_uniqdata_TC046", Include) {

    sql(s"""select variance(concat(CUST_ID)),variance(concat(CUST_NAME)),variance(concat(DOB)),variance(concat(BIGINT_COLUMN1)),variance(concat(DECIMAL_COLUMN1)),variance(concat(Double_COLUMN1)) from uniqdata where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""").collect

  }


  // PushUP_FILTER_uniqdata_TC047
  test("PushUP_FILTER_uniqdata_TC047", Include) {

    checkAnswer(s"""select length(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select length(CUST_NAME) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC047")

  }


  // PushUP_FILTER_uniqdata_TC048
  test("PushUP_FILTER_uniqdata_TC048", Include) {

    checkAnswer(s"""select max(length(CUST_NAME)),min(length(CUST_NAME)),avg(length(CUST_NAME)),count(length(CUST_NAME)),sum(length(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(length(CUST_NAME)),min(length(CUST_NAME)),avg(length(CUST_NAME)),count(length(CUST_NAME)),sum(length(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC048")

  }


  // PushUP_FILTER_uniqdata_TC049
  test("PushUP_FILTER_uniqdata_TC049", Include) {

    checkAnswer(s"""select max(length(CUST_NAME)),min(length(CUST_NAME)),avg(length(CUST_NAME)),count(length(CUST_NAME)),sum(length(CUST_NAME)) from uniqdata where length(CUST_NAME)=15 or length(CUST_NAME) is NULL or length(CUST_NAME) is NOT NULL""",
      s"""select max(length(CUST_NAME)),min(length(CUST_NAME)),avg(length(CUST_NAME)),count(length(CUST_NAME)),sum(length(CUST_NAME)) from uniqdata_hive where length(CUST_NAME)=15 or length(CUST_NAME) is NULL or length(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC049")

  }


  // PushUP_FILTER_uniqdata_TC050
  test("PushUP_FILTER_uniqdata_TC050", Include) {

    checkAnswer(s"""select lower(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select lower(CUST_NAME) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC050")

  }


  // PushUP_FILTER_uniqdata_TC051
  test("PushUP_FILTER_uniqdata_TC051", Include) {

    checkAnswer(s"""select max(lower(CUST_NAME)),min(lower(CUST_NAME)),avg(lower(CUST_NAME)),count(lower(CUST_NAME)),sum(lower(CUST_NAME)),variance(lower(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(lower(CUST_NAME)),min(lower(CUST_NAME)),avg(lower(CUST_NAME)),count(lower(CUST_NAME)),sum(lower(CUST_NAME)),variance(lower(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC051")

  }


  // PushUP_FILTER_uniqdata_TC052
  test("PushUP_FILTER_uniqdata_TC052", Include) {

    checkAnswer(s"""select max(lower(CUST_NAME)),min(lower(CUST_NAME)),avg(lower(CUST_NAME)),count(lower(CUST_NAME)),sum(lower(CUST_NAME)),variance(lower(CUST_NAME)) from uniqdata where lower(CUST_NAME)=15 or lower(CUST_NAME) is NULL or lower(CUST_NAME) is NOT NULL""",
      s"""select max(lower(CUST_NAME)),min(lower(CUST_NAME)),avg(lower(CUST_NAME)),count(lower(CUST_NAME)),sum(lower(CUST_NAME)),variance(lower(CUST_NAME)) from uniqdata_hive where lower(CUST_NAME)=15 or lower(CUST_NAME) is NULL or lower(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC052")

  }


  // PushUP_FILTER_uniqdata_TC053
  test("PushUP_FILTER_uniqdata_TC053", Include) {

    checkAnswer(s"""select lcase(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select lcase(CUST_NAME) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC053")

  }


  // PushUP_FILTER_uniqdata_TC054
  test("PushUP_FILTER_uniqdata_TC054", Include) {

    checkAnswer(s"""select max(lcase(CUST_NAME)),min(lcase(CUST_NAME)),avg(lcase(CUST_NAME)),count(lcase(CUST_NAME)),sum(lcase(CUST_NAME)),variance(lcase(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(lcase(CUST_NAME)),min(lcase(CUST_NAME)),avg(lcase(CUST_NAME)),count(lcase(CUST_NAME)),sum(lcase(CUST_NAME)),variance(lcase(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC054")

  }


  // PushUP_FILTER_uniqdata_TC055
  test("PushUP_FILTER_uniqdata_TC055", Include) {

    checkAnswer(s"""select max(lcase(CUST_NAME)),min(lcase(CUST_NAME)),avg(lcase(CUST_NAME)),count(lcase(CUST_NAME)),sum(lcase(CUST_NAME)),variance(lcase(CUST_NAME)) from uniqdata where lcase(CUST_NAME)=15 or lcase(CUST_NAME) is NULL or lcase(CUST_NAME) is NOT NULL""",
      s"""select max(lcase(CUST_NAME)),min(lcase(CUST_NAME)),avg(lcase(CUST_NAME)),count(lcase(CUST_NAME)),sum(lcase(CUST_NAME)),variance(lcase(CUST_NAME)) from uniqdata_hive where lcase(CUST_NAME)=15 or lcase(CUST_NAME) is NULL or lcase(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC055")

  }


  // PushUP_FILTER_uniqdata_TC056
  test("PushUP_FILTER_uniqdata_TC056", Include) {

    checkAnswer(s"""select regexp_replace(CUST_NAME,'a','b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select regexp_replace(CUST_NAME,'a','b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC056")

  }


  // PushUP_FILTER_uniqdata_TC057
  test("PushUP_FILTER_uniqdata_TC057", Include) {

    checkAnswer(s"""select substr(CUST_NAME,1,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select substr(CUST_NAME,1,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC057")

  }


  // PushUP_FILTER_uniqdata_TC058
  test("PushUP_FILTER_uniqdata_TC058", Include) {

    checkAnswer(s"""select max(substr(CUST_NAME,1,2)),min(substr(CUST_NAME,1,2)),avg(substr(CUST_NAME,1,2)),count(substr(CUST_NAME,1,2)),sum(substr(CUST_NAME,1,2)),variance(substr(CUST_NAME,1,2)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(substr(CUST_NAME,1,2)),min(substr(CUST_NAME,1,2)),avg(substr(CUST_NAME,1,2)),count(substr(CUST_NAME,1,2)),sum(substr(CUST_NAME,1,2)),variance(substr(CUST_NAME,1,2)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC058")

  }


  // PushUP_FILTER_uniqdata_TC059
  test("PushUP_FILTER_uniqdata_TC059", Include) {

    checkAnswer(s"""select max(substr(CUST_NAME,1,2)),min(substr(CUST_NAME,1,2)),avg(substr(CUST_NAME,1,2)),count(substr(CUST_NAME,1,2)),sum(substr(CUST_NAME,1,2)),variance(substr(CUST_NAME,1,2)) from uniqdata where substr(CUST_NAME,1,2)='CU' or substr(CUST_NAME,1,2) is NULL or substr(CUST_NAME,1,2) is NOT NULL""",
      s"""select max(substr(CUST_NAME,1,2)),min(substr(CUST_NAME,1,2)),avg(substr(CUST_NAME,1,2)),count(substr(CUST_NAME,1,2)),sum(substr(CUST_NAME,1,2)),variance(substr(CUST_NAME,1,2)) from uniqdata_hive where substr(CUST_NAME,1,2)='CU' or substr(CUST_NAME,1,2) is NULL or substr(CUST_NAME,1,2) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC059")

  }


  // PushUP_FILTER_uniqdata_TC060
  test("PushUP_FILTER_uniqdata_TC060", Include) {

    checkAnswer(s"""select substring(CUST_NAME,1,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select substring(CUST_NAME,1,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC060")

  }


  // PushUP_FILTER_uniqdata_TC061
  test("PushUP_FILTER_uniqdata_TC061", Include) {

    checkAnswer(s"""select max(substring(CUST_NAME,1,2)),min(substring(CUST_NAME,1,2)),avg(substring(CUST_NAME,1,2)),count(substring(CUST_NAME,1,2)),sum(substring(CUST_NAME,1,2)),variance(substring(CUST_NAME,1,2)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(substring(CUST_NAME,1,2)),min(substring(CUST_NAME,1,2)),avg(substring(CUST_NAME,1,2)),count(substring(CUST_NAME,1,2)),sum(substring(CUST_NAME,1,2)),variance(substring(CUST_NAME,1,2)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC061")

  }


  // PushUP_FILTER_uniqdata_TC062
  test("PushUP_FILTER_uniqdata_TC062", Include) {

    checkAnswer(s"""select max(substring(CUST_NAME,1,2)),min(substring(CUST_NAME,1,2)),avg(substring(CUST_NAME,1,2)),count(substring(CUST_NAME,1,2)),sum(substring(CUST_NAME,1,2)),variance(substring(CUST_NAME,1,2)) from uniqdata where substring(CUST_NAME,1,2)='CU' or substring(CUST_NAME,1,2) is NULL or substring(CUST_NAME,1,2) is NOT NULL""",
      s"""select max(substring(CUST_NAME,1,2)),min(substring(CUST_NAME,1,2)),avg(substring(CUST_NAME,1,2)),count(substring(CUST_NAME,1,2)),sum(substring(CUST_NAME,1,2)),variance(substring(CUST_NAME,1,2)) from uniqdata_hive where substring(CUST_NAME,1,2)='CU' or substring(CUST_NAME,1,2) is NULL or substring(CUST_NAME,1,2) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC062")

  }


  // PushUP_FILTER_uniqdata_TC063
  test("PushUP_FILTER_uniqdata_TC063", Include) {

    checkAnswer(s"""select upper(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select upper(CUST_NAME) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC063")

  }


  // PushUP_FILTER_uniqdata_TC064
  test("PushUP_FILTER_uniqdata_TC064", Include) {

    checkAnswer(s"""select max(upper(CUST_NAME)),min(upper(CUST_NAME)),avg(upper(CUST_NAME)),count(upper(CUST_NAME)),sum(upper(CUST_NAME)),variance(upper(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select max(upper(CUST_NAME)),min(upper(CUST_NAME)),avg(upper(CUST_NAME)),count(upper(CUST_NAME)),sum(upper(CUST_NAME)),variance(upper(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC064")

  }


  // PushUP_FILTER_uniqdata_TC065
  test("PushUP_FILTER_uniqdata_TC065", Include) {

    checkAnswer(s"""select max(upper(CUST_NAME)),min(upper(CUST_NAME)),avg(upper(CUST_NAME)),count(upper(CUST_NAME)),sum(upper(CUST_NAME)),variance(upper(CUST_NAME)) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select max(upper(CUST_NAME)),min(upper(CUST_NAME)),avg(upper(CUST_NAME)),count(upper(CUST_NAME)),sum(upper(CUST_NAME)),variance(upper(CUST_NAME)) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC065")

  }


  // PushUP_FILTER_uniqdata_TC066
  test("PushUP_FILTER_uniqdata_TC066", Include) {

    checkAnswer(s"""select var_pop(upper(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select var_pop(upper(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC066")

  }


  // PushUP_FILTER_uniqdata_TC067
  test("PushUP_FILTER_uniqdata_TC067", Include) {

    checkAnswer(s"""select var_samp(upper(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select var_samp(upper(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC067")

  }


  // PushUP_FILTER_uniqdata_TC068
  test("PushUP_FILTER_uniqdata_TC068", Include) {

    checkAnswer(s"""select var_samp(upper(CUST_NAME)) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select var_samp(upper(CUST_NAME)) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC068")

  }


  // PushUP_FILTER_uniqdata_TC069
  test("PushUP_FILTER_uniqdata_TC069", Include) {

    checkAnswer(s"""select stddev_pop(upper(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select stddev_pop(upper(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC069")

  }


  // PushUP_FILTER_uniqdata_TC070
  test("PushUP_FILTER_uniqdata_TC070", Include) {

    checkAnswer(s"""select stddev_pop(upper(CUST_NAME)) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select stddev_pop(upper(CUST_NAME)) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC070")

  }


  // PushUP_FILTER_uniqdata_TC071
  test("PushUP_FILTER_uniqdata_TC071", Include) {

    checkAnswer(s"""select stddev_samp(upper(CUST_NAME)) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select stddev_samp(upper(CUST_NAME)) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC071")

  }


  // PushUP_FILTER_uniqdata_TC072
  test("PushUP_FILTER_uniqdata_TC072", Include) {

    checkAnswer(s"""select stddev_samp(upper(CUST_NAME)) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select stddev_samp(upper(CUST_NAME)) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC072")

  }


  // PushUP_FILTER_uniqdata_TC073
  test("PushUP_FILTER_uniqdata_TC073", Include) {

    checkAnswer(s"""select round(covar_pop(1,2), 4) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select round(covar_pop(1,2), 4) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC073")

  }


  // PushUP_FILTER_uniqdata_TC074
  test("PushUP_FILTER_uniqdata_TC074", Include) {

    checkAnswer(s"""select round(covar_pop(1,2), 4) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select round(covar_pop(1,2), 4) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC074")

  }


  // PushUP_FILTER_uniqdata_TC075
  test("PushUP_FILTER_uniqdata_TC075", Include) {

    checkAnswer(s"""select round(covar_samp(1,2), 4) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select round(covar_samp(1,2), 4) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC075")

  }


  // PushUP_FILTER_uniqdata_TC076
  test("PushUP_FILTER_uniqdata_TC076", Include) {

    checkAnswer(s"""select round(covar_samp(1,2), 4) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select round(covar_samp(1,2), 4) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC076")

  }


  // PushUP_FILTER_uniqdata_TC077
  ignore("PushUP_FILTER_uniqdata_TC077", Include) {

    checkAnswer(s"""select corr(1,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select corr(1,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC077")

  }


  // PushUP_FILTER_uniqdata_TC078
  ignore("PushUP_FILTER_uniqdata_TC078", Include) {

    checkAnswer(s"""select corr(1,2) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""",
      s"""select corr(1,2) from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC078")

  }


  // PushUP_FILTER_uniqdata_TC079
  test("PushUP_FILTER_uniqdata_TC079", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1,2) as hist_table from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL) t lateral view explode(hist_table) exploded_table as hist) group by x""",
      s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1,2) as hist_table from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL) t lateral view explode(hist_table) exploded_table as hist) group by x""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC079")

  }


  // PushUP_FILTER_uniqdata_TC080
  test("PushUP_FILTER_uniqdata_TC080", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1,2) as hist_table from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL) t lateral view explode(hist_table) exploded_table as hist) group by x""",
      s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1,2) as hist_table from uniqdata_hive where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL) t lateral view explode(hist_table) exploded_table as hist) group by x""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC080")

  }


  // PushUP_FILTER_uniqdata_TC081
  test("PushUP_FILTER_uniqdata_TC081", Include) {

    sql(s"""select collect_set(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """).collect

  }


  // PushUP_FILTER_uniqdata_TC082
  test("PushUP_FILTER_uniqdata_TC082", Include) {

    sql(s"""select collect_set(CUST_NAME) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""").collect

  }


  // PushUP_FILTER_uniqdata_TC083
  test("PushUP_FILTER_uniqdata_TC083", Include) {

    sql(s"""select collect_list(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """).collect

  }


  // PushUP_FILTER_uniqdata_TC084
  test("PushUP_FILTER_uniqdata_TC084", Include) {

    sql(s"""select collect_list(CUST_NAME) from uniqdata where upper(CUST_NAME)=15 or upper(CUST_NAME) is NULL or upper(CUST_NAME) is NOT NULL""").collect

  }


  // PushUP_FILTER_uniqdata_TC085
  test("PushUP_FILTER_uniqdata_TC085", Include) {

    checkAnswer(s"""select bin(CUST_ID),bin(CUST_NAME),bin(BIGINT_COLUMN1),bin(DECIMAL_COLUMN1),bin(Double_COLUMN1),bin(INTEGER_COLUMN1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 <=> 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """,
      s"""select bin(CUST_ID),bin(CUST_NAME),bin(BIGINT_COLUMN1),bin(DECIMAL_COLUMN1),bin(Double_COLUMN1),bin(INTEGER_COLUMN1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 <=> 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC085")

  }


  // PushUP_FILTER_uniqdata_TC086
  test("PushUP_FILTER_uniqdata_TC086", Include) {

    checkAnswer(s"""select bin(CUST_ID), bin(CUST_NAME), bin(BIGINT_COLUMN1), bin(DECIMAL_COLUMN1), bin(Double_COLUMN1), bin(INTEGER_COLUMN1) from uniqdata where bin(CUST_ID)=10001100100111 or bin(CUST_NAME) is NULL or bin(BIGINT_COLUMN1)='10001111100111111011101101101110111000010' or bin(Double_COLUMN1)<=>'10001111100111111011101101101110111000010' or bin(INTEGER_COLUMN1)=0""",
      s"""select bin(CUST_ID), bin(CUST_NAME), bin(BIGINT_COLUMN1), bin(DECIMAL_COLUMN1), bin(Double_COLUMN1), bin(INTEGER_COLUMN1) from uniqdata_hive where bin(CUST_ID)=10001100100111 or bin(CUST_NAME) is NULL or bin(BIGINT_COLUMN1)='10001111100111111011101101101110111000010' or bin(Double_COLUMN1)<=>'10001111100111111011101101101110111000010' or bin(INTEGER_COLUMN1)=0""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC086")

  }


  // PushUP_FILTER_uniqdata_TC087
  test("PushUP_FILTER_uniqdata_TC087", Include) {

    checkAnswer(s"""select hex(CUST_ID),hex(CUST_NAME),hex(BIGINT_COLUMN1),hex(DECIMAL_COLUMN1),hex(Double_COLUMN1),hex(INTEGER_COLUMN1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL or hex(DOB)='313937352D30362D31312030313A30303A3033' """,
      s"""select hex(CUST_ID),hex(CUST_NAME),hex(BIGINT_COLUMN1),hex(DECIMAL_COLUMN1),hex(Double_COLUMN1),hex(INTEGER_COLUMN1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL or hex(DOB)='313937352D30362D31312030313A30303A3033' """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC087")

  }


  // PushUP_FILTER_uniqdata_TC088
  test("PushUP_FILTER_uniqdata_TC088", Include) {

    checkAnswer(s"""select hex(CUST_ID),hex(CUST_NAME),hex(BIGINT_COLUMN1),hex(DECIMAL_COLUMN1),hex(Double_COLUMN1),hex(INTEGER_COLUMN1) from uniqdata where hex(CUST_ID)='2AEF' or hex(CUST_NAME) is NULL or hex(BIGINT_COLUMN1)='1CB98BEABA' or hex(Double_COLUMN1)='29DA1E541' or hex(INTEGER_COLUMN1)='7C7'""",
      s"""select hex(CUST_ID),hex(CUST_NAME),hex(BIGINT_COLUMN1),hex(DECIMAL_COLUMN1),hex(Double_COLUMN1),hex(INTEGER_COLUMN1) from uniqdata_hive where hex(CUST_ID)='2AEF' or hex(CUST_NAME) is NULL or hex(BIGINT_COLUMN1)='1CB98BEABA' or hex(Double_COLUMN1)='29DA1E541' or hex(INTEGER_COLUMN1)='7C7'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC088")

  }


  // PushUP_FILTER_uniqdata_TC089
  test("PushUP_FILTER_uniqdata_TC089", Include) {

    sql(s"""select unhex(CUST_ID),unhex(CUST_NAME),unhex(BIGINT_COLUMN1),unhex(DECIMAL_COLUMN1),unhex(Double_COLUMN1),unhex(INTEGER_COLUMN1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """).collect

  }


  // PushUP_FILTER_uniqdata_TC090
  test("PushUP_FILTER_uniqdata_TC090", Include) {

    sql(s"""select unhex(CUST_ID),unhex(CUST_NAME),unhex(BIGINT_COLUMN1),unhex(DECIMAL_COLUMN1),unhex(Double_COLUMN1),unhex(INTEGER_COLUMN1) from uniqdata where unhex(CUST_NAME) is NULL or unhex(BIGINT_COLUMN1) IS NOT NULL or unhex(Double_COLUMN1) IS NULL or unhex(DOB) IS NULL""").collect

  }


  // PushUP_FILTER_uniqdata_TC091
  test("PushUP_FILTER_uniqdata_TC091", Include) {

    checkAnswer(s"""select conv(CUST_ID,1,2),conv(CUST_NAME,1,2),conv(BIGINT_COLUMN1,1,2),conv(DECIMAL_COLUMN1,1,2),conv(Double_COLUMN1,1,2),conv(INTEGER_COLUMN1,1,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select conv(CUST_ID,1,2),conv(CUST_NAME,1,2),conv(BIGINT_COLUMN1,1,2),conv(DECIMAL_COLUMN1,1,2),conv(Double_COLUMN1,1,2),conv(INTEGER_COLUMN1,1,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC091")

  }


  // PushUP_FILTER_uniqdata_TC092
  test("PushUP_FILTER_uniqdata_TC092", Include) {

    checkAnswer(s"""select conv(CUST_ID,1,2),conv(CUST_NAME,1,2),conv(BIGINT_COLUMN1,1,2),conv(DECIMAL_COLUMN1,1,2),conv(Double_COLUMN1,1,2),conv(INTEGER_COLUMN1,1,2) from uniqdata where conv(CUST_NAME,1,2) is NULL or conv(BIGINT_COLUMN1,1,2) IS NOT NULL or conv(Double_COLUMN1,1,2) IS NULL or conv(DOB,1,2) IS NULL""",
      s"""select conv(CUST_ID,1,2),conv(CUST_NAME,1,2),conv(BIGINT_COLUMN1,1,2),conv(DECIMAL_COLUMN1,1,2),conv(Double_COLUMN1,1,2),conv(INTEGER_COLUMN1,1,2) from uniqdata_hive where conv(CUST_NAME,1,2) is NULL or conv(BIGINT_COLUMN1,1,2) IS NOT NULL or conv(Double_COLUMN1,1,2) IS NULL or conv(DOB,1,2) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC092")

  }


  // PushUP_FILTER_uniqdata_TC093
  test("PushUP_FILTER_uniqdata_TC093", Include) {

    checkAnswer(s"""select abs(CUST_ID),abs(BIGINT_COLUMN1),abs(DECIMAL_COLUMN1),abs(Double_COLUMN1),abs(INTEGER_COLUMN1) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select abs(CUST_ID),abs(BIGINT_COLUMN1),abs(DECIMAL_COLUMN1),abs(Double_COLUMN1),abs(INTEGER_COLUMN1) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC093")

  }


  // PushUP_FILTER_uniqdata_TC094
  test("PushUP_FILTER_uniqdata_TC094", Include) {

    checkAnswer(s"""select abs(CUST_ID),abs(BIGINT_COLUMN1),abs(DECIMAL_COLUMN1),abs(Double_COLUMN1),abs(INTEGER_COLUMN1) from uniqdata where abs(BIGINT_COLUMN1) IS NOT NULL or abs(Double_COLUMN1) IS NULL """,
      s"""select abs(CUST_ID),abs(BIGINT_COLUMN1),abs(DECIMAL_COLUMN1),abs(Double_COLUMN1),abs(INTEGER_COLUMN1) from uniqdata_hive where abs(BIGINT_COLUMN1) IS NOT NULL or abs(Double_COLUMN1) IS NULL """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC094")

  }


  // PushUP_FILTER_uniqdata_TC095
  test("PushUP_FILTER_uniqdata_TC095", Include) {

    checkAnswer(s"""select unix_timestamp(CUST_NAME,'a'),unix_timestamp(DOB,'a') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select unix_timestamp(CUST_NAME,'a'),unix_timestamp(DOB,'a') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC095")

  }


  // PushUP_FILTER_uniqdata_TC096
  test("PushUP_FILTER_uniqdata_TC096", Include) {

    checkAnswer(s"""select unix_timestamp(CUST_NAME,'a'),unix_timestamp(DOB,'a')from uniqdata where unix_timestamp(CUST_NAME,'a') is not null or unix_timestamp(DOB,'a') IS NOT NULL""",
      s"""select unix_timestamp(CUST_NAME,'a'),unix_timestamp(DOB,'a')from uniqdata_hive where unix_timestamp(CUST_NAME,'a') is not null or unix_timestamp(DOB,'a') IS NOT NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC096")

  }


  // PushUP_FILTER_uniqdata_TC097
  test("PushUP_FILTER_uniqdata_TC097", Include) {

    checkAnswer(s"""select quarter(CUST_NAME),quarter(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select quarter(CUST_NAME),quarter(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC097")

  }


  // PushUP_FILTER_uniqdata_TC098
  test("PushUP_FILTER_uniqdata_TC098", Include) {

    checkAnswer(s"""select quarter(CUST_NAME),quarter(DOB)from uniqdata where quarter(CUST_NAME) is not null or quarter(DOB) =2""",
      s"""select quarter(CUST_NAME),quarter(DOB)from uniqdata_hive where quarter(CUST_NAME) is not null or quarter(DOB) =2""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC098")

  }


  // PushUP_FILTER_uniqdata_TC099
  test("PushUP_FILTER_uniqdata_TC099", Include) {

    checkAnswer(s"""select from_utc_timestamp(CUST_NAME,'a'),from_utc_timestamp(DOB,'a') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select from_utc_timestamp(CUST_NAME,'a'),from_utc_timestamp(DOB,'a') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC099")

  }


  // PushUP_FILTER_uniqdata_TC100
  test("PushUP_FILTER_uniqdata_TC100", Include) {

    checkAnswer(s"""select from_utc_timestamp(CUST_NAME,'a'),from_utc_timestamp(DOB,'a')from uniqdata where from_utc_timestamp(CUST_NAME,'a') is not null or from_utc_timestamp(DOB,'a') ='1975-06-15 01:00:03.0'""",
      s"""select from_utc_timestamp(CUST_NAME,'a'),from_utc_timestamp(DOB,'a')from uniqdata_hive where from_utc_timestamp(CUST_NAME,'a') is not null or from_utc_timestamp(DOB,'a') ='1975-06-15 01:00:03.0'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC100")

  }


  // PushUP_FILTER_uniqdata_TC101
  test("PushUP_FILTER_uniqdata_TC101", Include) {

    checkAnswer(s"""select to_utc_timestamp(CUST_NAME,'a'),to_utc_timestamp(DOB,'a') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select to_utc_timestamp(CUST_NAME,'a'),to_utc_timestamp(DOB,'a') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC101")

  }


  // PushUP_FILTER_uniqdata_TC102
  test("PushUP_FILTER_uniqdata_TC102", Include) {

    checkAnswer(s"""select to_utc_timestamp(CUST_NAME,'a'),to_utc_timestamp(DOB,'a')from uniqdata where to_utc_timestamp(CUST_NAME,'a') is not null or to_utc_timestamp(DOB,'a') ='1975-06-15 01:00:03.0'""",
      s"""select to_utc_timestamp(CUST_NAME,'a'),to_utc_timestamp(DOB,'a')from uniqdata_hive where to_utc_timestamp(CUST_NAME,'a') is not null or to_utc_timestamp(DOB,'a') ='1975-06-15 01:00:03.0'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC102")

  }


  // PushUP_FILTER_uniqdata_TC103
  test("PushUP_FILTER_uniqdata_TC103", Include) {

    checkAnswer(s"""select add_months(CUST_NAME,1),add_months(DOB,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select add_months(CUST_NAME,1),add_months(DOB,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC103")

  }


  // PushUP_FILTER_uniqdata_TC104
  test("PushUP_FILTER_uniqdata_TC104", Include) {

    checkAnswer(s"""select add_months(CUST_NAME,1),add_months(DOB,2)from uniqdata where add_months(CUST_NAME,1) is not null or add_months(DOB,2) ='1975-08-19'""",
      s"""select add_months(CUST_NAME,1),add_months(DOB,2)from uniqdata_hive where add_months(CUST_NAME,1) is not null or add_months(DOB,2) ='1975-08-19'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC104")

  }


  // PushUP_FILTER_uniqdata_TC105
  test("PushUP_FILTER_uniqdata_TC105", Include) {

    checkAnswer(s"""select last_day(CUST_NAME),last_day(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select last_day(CUST_NAME),last_day(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC105")

  }


  // PushUP_FILTER_uniqdata_TC106
  test("PushUP_FILTER_uniqdata_TC106", Include) {

    checkAnswer(s"""select last_day(CUST_NAME),last_day(DOB)from uniqdata where last_day(CUST_NAME) is not null or last_day(DOB) ='1975-06-30'""",
      s"""select last_day(CUST_NAME),last_day(DOB)from uniqdata_hive where last_day(CUST_NAME) is not null or last_day(DOB) ='1975-06-30'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC106")

  }


  // PushUP_FILTER_uniqdata_TC107
  test("PushUP_FILTER_uniqdata_TC107", Include) {

    checkAnswer(s"""select next_day(CUST_NAME,1),next_day(DOB,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select next_day(CUST_NAME,1),next_day(DOB,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC107")

  }


  // PushUP_FILTER_uniqdata_TC108
  test("PushUP_FILTER_uniqdata_TC108", Include) {

    checkAnswer(s"""select next_day(CUST_NAME,1),next_day(DOB,2)from uniqdata where next_day(CUST_NAME,1) is not null or next_day(DOB,2) IS NULL""",
      s"""select next_day(CUST_NAME,1),next_day(DOB,2)from uniqdata_hive where next_day(CUST_NAME,1) is not null or next_day(DOB,2) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC108")

  }


  // PushUP_FILTER_uniqdata_TC109
  test("PushUP_FILTER_uniqdata_TC109", Include) {

    checkAnswer(s"""select months_between(CUST_NAME,'a'),months_between(DOB,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select months_between(CUST_NAME,'a'),months_between(DOB,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC109")

  }


  // PushUP_FILTER_uniqdata_TC110
  test("PushUP_FILTER_uniqdata_TC110", Include) {

    checkAnswer(s"""select months_between(CUST_NAME,'a'),months_between(DOB,'b')from uniqdata where months_between(CUST_NAME,'a') is not null or months_between(DOB,'b') IS NULL""",
      s"""select months_between(CUST_NAME,'a'),months_between(DOB,'b')from uniqdata_hive where months_between(CUST_NAME,'a') is not null or months_between(DOB,'b') IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC110")

  }


  // PushUP_FILTER_uniqdata_TC112
  test("PushUP_FILTER_uniqdata_TC112", Include) {

    checkAnswer(s"""select ascii(CUST_NAME),ascii(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select ascii(CUST_NAME),ascii(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC112")

  }


  // PushUP_FILTER_uniqdata_TC113
  test("PushUP_FILTER_uniqdata_TC113", Include) {

    checkAnswer(s"""select ascii(CUST_NAME),ascii(DOB)from uniqdata where ascii(CUST_NAME) =67 or ascii(DOB) IS NULL""",
      s"""select ascii(CUST_NAME),ascii(DOB)from uniqdata_hive where ascii(CUST_NAME) =67 or ascii(DOB) IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC113")

  }


  // PushUP_FILTER_uniqdata_TC114
  test("PushUP_FILTER_uniqdata_TC114", Include) {

    checkAnswer(s"""select base64(CUST_NAME) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select base64(CUST_NAME) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC114")

  }


  // PushUP_FILTER_uniqdata_TC115
  test("PushUP_FILTER_uniqdata_TC115", Include) {

    checkAnswer(s"""select base64(CUST_NAME)from uniqdata where base64(CUST_NAME) ='Q1VTVF9OQU1FXzAxOTg3' or base64(CUST_NAME) is not null""",
      s"""select base64(CUST_NAME)from uniqdata_hive where base64(CUST_NAME) ='Q1VTVF9OQU1FXzAxOTg3' or base64(CUST_NAME) is not null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC115")

  }


  // PushUP_FILTER_uniqdata_TC116
  test("PushUP_FILTER_uniqdata_TC116", Include) {

    checkAnswer(s"""select concat_ws(CUST_NAME),concat_ws(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select concat_ws(CUST_NAME),concat_ws(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC116")

  }


  // PushUP_FILTER_uniqdata_TC117
  test("PushUP_FILTER_uniqdata_TC117", Include) {

    checkAnswer(s"""select concat_ws(CUST_NAME)from uniqdata where concat_ws(CUST_NAME) IS NOT NULL or concat_ws(DOB) is null""",
      s"""select concat_ws(CUST_NAME)from uniqdata_hive where concat_ws(CUST_NAME) IS NOT NULL or concat_ws(DOB) is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC117")

  }


  // PushUP_FILTER_uniqdata_TC118
  test("PushUP_FILTER_uniqdata_TC118", Include) {

    checkAnswer(s"""select find_in_set(CUST_NAME,'a') , find_in_set(DOB,'a')from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select find_in_set(CUST_NAME,'a') , find_in_set(DOB,'a')from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC118")

  }


  // PushUP_FILTER_uniqdata_TC119
  test("PushUP_FILTER_uniqdata_TC119", Include) {

    checkAnswer(s"""select find_in_set(CUST_NAME,'a')from uniqdata where find_in_set(CUST_NAME,'a') =0 or find_in_set(DOB,'b') is null""",
      s"""select find_in_set(CUST_NAME,'a')from uniqdata_hive where find_in_set(CUST_NAME,'a') =0 or find_in_set(DOB,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC119")

  }


  // PushUP_FILTER_uniqdata_TC120
  test("PushUP_FILTER_uniqdata_TC120", Include) {

    checkAnswer(s"""select format_number(CUST_ID,1)from uniqdata where format_number(CUST_ID,1) ='10,987.0' or format_number(BIGINT_COLUMN1,2) = '123,372,038,841.00' or format_number(DECIMAL_COLUMN1,3)='12,345,680,888.123'""",
      s"""select format_number(CUST_ID,1)from uniqdata_hive where format_number(CUST_ID,1) ='10,987.0' or format_number(BIGINT_COLUMN1,2) = '123,372,038,841.00' or format_number(DECIMAL_COLUMN1,3)='12,345,680,888.123'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC120")

  }


  // PushUP_FILTER_uniqdata_TC121
  test("PushUP_FILTER_uniqdata_TC121", Include) {

    checkAnswer(s"""select get_json_object(CUST_NAME,'a') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select get_json_object(CUST_NAME,'a') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC121")

  }


  // PushUP_FILTER_uniqdata_TC122
  test("PushUP_FILTER_uniqdata_TC122", Include) {

    checkAnswer(s"""select get_json_object(CUST_NAME,'a')from uniqdata where get_json_object(CUST_NAME,'a') is null or get_json_object(CUST_NAME,'a') is not null""",
      s"""select get_json_object(CUST_NAME,'a')from uniqdata_hive where get_json_object(CUST_NAME,'a') is null or get_json_object(CUST_NAME,'a') is not null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC122")

  }


  // PushUP_FILTER_uniqdata_TC123
  test("PushUP_FILTER_uniqdata_TC123", Include) {

    checkAnswer(s"""select instr(CUST_NAME,'a'),instr(DOB,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select instr(CUST_NAME,'a'),instr(DOB,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC123")

  }


  // PushUP_FILTER_uniqdata_TC124
  test("PushUP_FILTER_uniqdata_TC124", Include) {

    checkAnswer(s"""select instr(CUST_NAME,'a')from uniqdata where instr(CUST_NAME,'a') =0 or instr(DOB,'b') is null""",
      s"""select instr(CUST_NAME,'a')from uniqdata_hive where instr(CUST_NAME,'a') =0 or instr(DOB,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC124")

  }


  // PushUP_FILTER_uniqdata_TC125
  test("PushUP_FILTER_uniqdata_TC125", Include) {

    checkAnswer(s"""select locate(CUST_NAME,'a',1),locate(DOB,'b',2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select locate(CUST_NAME,'a',1),locate(DOB,'b',2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC125")

  }


  // PushUP_FILTER_uniqdata_TC126
  test("PushUP_FILTER_uniqdata_TC126", Include) {

    checkAnswer(s"""select locate(CUST_NAME,'a',1)from uniqdata where locate(CUST_NAME,'a',1) =1 or locate(DOB,'b',2) is null""",
      s"""select locate(CUST_NAME,'a',1)from uniqdata_hive where locate(CUST_NAME,'a',1) =1 or locate(DOB,'b',2) is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC126")

  }


  // PushUP_FILTER_uniqdata_TC127
  test("PushUP_FILTER_uniqdata_TC127", Include) {

    checkAnswer(s"""select lpad(CUST_NAME,1,'a'),lpad(DOB,2,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select lpad(CUST_NAME,1,'a'),lpad(DOB,2,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC127")

  }


  // PushUP_FILTER_uniqdata_TC128
  test("PushUP_FILTER_uniqdata_TC128", Include) {

    checkAnswer(s"""select lpad(CUST_NAME,1,'a')from uniqdata where lpad(CUST_NAME,1,'a') =1 or lpad(DOB,2,'b') is null""",
      s"""select lpad(CUST_NAME,1,'a')from uniqdata_hive where lpad(CUST_NAME,1,'a') =1 or lpad(DOB,2,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC128")

  }


  // PushUP_FILTER_uniqdata_TC129
  test("PushUP_FILTER_uniqdata_TC129", Include) {

    checkAnswer(s"""select ltrim(CUST_NAME),ltrim(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select ltrim(CUST_NAME),ltrim(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC129")

  }


  // PushUP_FILTER_uniqdata_TC130
  test("PushUP_FILTER_uniqdata_TC130", Include) {

    checkAnswer(s"""select ltrim(CUST_NAME)from uniqdata where ltrim(CUST_NAME) =1 or ltrim(DOB) is null""",
      s"""select ltrim(CUST_NAME)from uniqdata_hive where ltrim(CUST_NAME) =1 or ltrim(DOB) is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC130")

  }


  // PushUP_FILTER_uniqdata_TC131
  test("PushUP_FILTER_uniqdata_TC131", Include) {

    checkAnswer(s"""select parse_url(CUST_NAME,'a'),parse_url(CUST_NAME,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL""",
      s"""select parse_url(CUST_NAME,'a'),parse_url(CUST_NAME,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC131")

  }


  // PushUP_FILTER_uniqdata_TC132
  test("PushUP_FILTER_uniqdata_TC132", Include) {

    checkAnswer(s"""select parse_url(CUST_NAME,'a')from uniqdata where parse_url(CUST_NAME,'b') is null or parse_url(CUST_NAME,'b') is null""",
      s"""select parse_url(CUST_NAME,'a')from uniqdata_hive where parse_url(CUST_NAME,'b') is null or parse_url(CUST_NAME,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC132")

  }


  // PushUP_FILTER_uniqdata_TC133
  test("PushUP_FILTER_uniqdata_TC133", Include) {

    checkAnswer(s"""select printf(CUST_NAME,'a'),printf(DOB,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select printf(CUST_NAME,'a'),printf(DOB,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC133")

  }


  // PushUP_FILTER_uniqdata_TC134
  test("PushUP_FILTER_uniqdata_TC134", Include) {

    checkAnswer(s"""select printf(CUST_NAME,'a')from uniqdata where printf(CUST_NAME,'b') ='CUST_NAME_01987' or printf(DOB,'b')= '1975-06-11 01:00:03' or printf(DOB,'b') is null""",
      s"""select printf(CUST_NAME,'a')from uniqdata_hive where printf(CUST_NAME,'b') ='CUST_NAME_01987' or printf(DOB,'b')= '1975-06-11 01:00:03' or printf(DOB,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC134")

  }


  // PushUP_FILTER_uniqdata_TC135
  test("PushUP_FILTER_uniqdata_TC135", Include) {

    checkAnswer(s"""select regexp_extract(CUST_NAME,'a',1),regexp_extract(DOB,'b',2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select regexp_extract(CUST_NAME,'a',1),regexp_extract(DOB,'b',2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC135")

  }


  // PushUP_FILTER_uniqdata_TC136
  test("PushUP_FILTER_uniqdata_TC136", Include) {

    checkAnswer(s"""select regexp_extract(CUST_NAME,'a',1)from uniqdata where regexp_extract(CUST_NAME,'a',1) IS NULL or regexp_extract(DOB,'b',2) is NULL""",
      s"""select regexp_extract(CUST_NAME,'a',1)from uniqdata_hive where regexp_extract(CUST_NAME,'a',1) IS NULL or regexp_extract(DOB,'b',2) is NULL""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC136")

  }


  // PushUP_FILTER_uniqdata_TC137
  test("PushUP_FILTER_uniqdata_TC137", Include) {

    checkAnswer(s"""select repeat(CUST_NAME,1),repeat(DOB,2) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select repeat(CUST_NAME,1),repeat(DOB,2) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC137")

  }


  // PushUP_FILTER_uniqdata_TC138
  test("PushUP_FILTER_uniqdata_TC138", Include) {

    checkAnswer(s"""select repeat(CUST_NAME,1)from uniqdata where repeat(CUST_NAME,1) ='CUST_NAME_01987' or repeat(DOB,2) ='1975-06-11 01:00:031975-06-11 01:00:03'""",
      s"""select repeat(CUST_NAME,1)from uniqdata_hive where repeat(CUST_NAME,1) ='CUST_NAME_01987' or repeat(DOB,2) ='1975-06-11 01:00:031975-06-11 01:00:03'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC138")

  }


  // PushUP_FILTER_uniqdata_TC139
  test("PushUP_FILTER_uniqdata_TC139", Include) {

    checkAnswer(s"""select reverse(CUST_NAME),reverse(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select reverse(CUST_NAME),reverse(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC139")

  }


  // PushUP_FILTER_uniqdata_TC140
  test("PushUP_FILTER_uniqdata_TC140", Include) {

    checkAnswer(s"""select reverse(CUST_NAME)from uniqdata where reverse(CUST_NAME) ='78910_EMAN_TSUC' or reverse(DOB) ='30:00:10 11-60-5791'""",
      s"""select reverse(CUST_NAME)from uniqdata_hive where reverse(CUST_NAME) ='78910_EMAN_TSUC' or reverse(DOB) ='30:00:10 11-60-5791'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC140")

  }


  // PushUP_FILTER_uniqdata_TC141
  test("PushUP_FILTER_uniqdata_TC141", Include) {

    checkAnswer(s"""select rpad(CUST_NAME,1,'a'),rpad(DOB,2,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select rpad(CUST_NAME,1,'a'),rpad(DOB,2,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC141")

  }


  // PushUP_FILTER_uniqdata_TC142
  test("PushUP_FILTER_uniqdata_TC142", Include) {

    checkAnswer(s"""select rpad(CUST_NAME,1,'a')from uniqdata where rpad(CUST_NAME,1,'a') ='a' or rpad(DOB,2,'b') =19""",
      s"""select rpad(CUST_NAME,1,'a')from uniqdata_hive where rpad(CUST_NAME,1,'a') ='a' or rpad(DOB,2,'b') =19""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC142")

  }


  // PushUP_FILTER_uniqdata_TC143
  test("PushUP_FILTER_uniqdata_TC143", Include) {

    checkAnswer(s"""select rtrim(CUST_NAME),rtrim(DOB) from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select rtrim(CUST_NAME),rtrim(DOB) from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC143")

  }


  // PushUP_FILTER_uniqdata_TC144
  test("PushUP_FILTER_uniqdata_TC144", Include) {

    checkAnswer(s"""select rtrim(CUST_NAME)from uniqdata where rtrim(CUST_NAME) ='CUST_NAME_01987' or rtrim(DOB) ='1975-06-11 01:00:03'""",
      s"""select rtrim(CUST_NAME)from uniqdata_hive where rtrim(CUST_NAME) ='CUST_NAME_01987' or rtrim(DOB) ='1975-06-11 01:00:03'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC144")

  }


  // PushUP_FILTER_uniqdata_TC145
  test("PushUP_FILTER_uniqdata_TC145", Include) {

    checkAnswer(s"""select sentences(CUST_NAME,'a','b'),sentences(DOB,'a','b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select sentences(CUST_NAME,'a','b'),sentences(DOB,'a','b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC145")

  }


  // PushUP_FILTER_uniqdata_TC146
  test("PushUP_FILTER_uniqdata_TC146", Include) {

    checkAnswer(s"""select sentences(CUST_NAME,'a','b')from uniqdata where sentences(CUST_NAME,'a','b') IS NULL or sentences(DOB,'a','b') is not null""",
      s"""select sentences(CUST_NAME,'a','b')from uniqdata_hive where sentences(CUST_NAME,'a','b') IS NULL or sentences(DOB,'a','b') is not null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC146")

  }


  // PushUP_FILTER_uniqdata_TC147
  test("PushUP_FILTER_uniqdata_TC147", Include) {

    checkAnswer(s"""select split(CUST_NAME,'a'),split(DOB,'b') from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select split(CUST_NAME,'a'),split(DOB,'b') from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC147")

  }


  // PushUP_FILTER_uniqdata_TC148
  test("PushUP_FILTER_uniqdata_TC148", Include) {

    checkAnswer(s"""select split(CUST_NAME,'a')from uniqdata where split(CUST_NAME,'a') IS NULL or split(DOB,'b') is not null""",
      s"""select split(CUST_NAME,'a')from uniqdata_hive where split(CUST_NAME,'a') IS NULL or split(DOB,'b') is not null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC148")

  }


  // PushUP_FILTER_uniqdata_TC149
  test("PushUP_FILTER_uniqdata_TC149", Include) {

    checkAnswer(s"""select str_to_map(CUST_NAME)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select str_to_map(CUST_NAME)from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC149")

  }


  // PushUP_FILTER_uniqdata_TC152
  test("PushUP_FILTER_uniqdata_TC152", Include) {

    checkAnswer(s"""select translate('test','t','s'),translate(CUST_NAME,'a','b')from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select translate('test','t','s'),translate(CUST_NAME,'a','b')from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC152")

  }


  // PushUP_FILTER_uniqdata_TC153
  test("PushUP_FILTER_uniqdata_TC153", Include) {

    checkAnswer(s"""select translate('test','t','s')from uniqdata where translate(CUST_NAME,'a','b') ='CUST_NAME_01987' or translate('test','t','s')='sess'""",
      s"""select translate('test','t','s')from uniqdata_hive where translate(CUST_NAME,'a','b') ='CUST_NAME_01987' or translate('test','t','s')='sess'""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC153")

  }


  // PushUP_FILTER_uniqdata_TC154
  test("PushUP_FILTER_uniqdata_TC154", Include) {

    checkAnswer(s"""select trim(CUST_NAME),trim(DOB)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select trim(CUST_NAME),trim(DOB)from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC154")

  }


  // PushUP_FILTER_uniqdata_TC155
  test("PushUP_FILTER_uniqdata_TC155", Include) {

    checkAnswer(s"""select trim(CUST_NAME)from uniqdata where trim(CUST_NAME) ='CUST_NAME_01988' or trim(DOB) is null""",
      s"""select trim(CUST_NAME)from uniqdata_hive where trim(CUST_NAME) ='CUST_NAME_01988' or trim(DOB) is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC155")

  }


  // PushUP_FILTER_uniqdata_TC156
  test("PushUP_FILTER_uniqdata_TC156", Include) {

    sql(s"""select unbase64(CUST_NAME),unbase64(DOB)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """).collect

  }


  // PushUP_FILTER_uniqdata_TC157
  test("PushUP_FILTER_uniqdata_TC157", Include) {

    sql(s"""select unbase64(CUST_NAME)from uniqdata where unbase64(CUST_NAME) is not null or unbase64(DOB) is null""").collect

  }


  // PushUP_FILTER_uniqdata_TC158
  test("PushUP_FILTER_uniqdata_TC158", Include) {

    checkAnswer(s"""select ucase(CUST_NAME),ucase(DOB)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select ucase(CUST_NAME),ucase(DOB)from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC158")

  }


  // PushUP_FILTER_uniqdata_TC159
  test("PushUP_FILTER_uniqdata_TC159", Include) {

    checkAnswer(s"""select ucase(CUST_NAME)from uniqdata where ucase(CUST_NAME) ='CUST_NAME_01987' or ucase(DOB) is null""",
      s"""select ucase(CUST_NAME)from uniqdata_hive where ucase(CUST_NAME) ='CUST_NAME_01987' or ucase(DOB) is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC159")

  }


  // PushUP_FILTER_uniqdata_TC160
  test("PushUP_FILTER_uniqdata_TC160", Include) {

    sql(s"""select initcap(CUST_NAME),initcap(DOB)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """).collect

  }


  // PushUP_FILTER_uniqdata_TC161
  test("PushUP_FILTER_uniqdata_TC161", Include) {

    sql(s"""select initcap(CUST_NAME)from uniqdata where initcap(CUST_NAME) ='CUST_NAME_01987' or initcap(DOB) is null""").collect

  }


  // PushUP_FILTER_uniqdata_TC162
  test("PushUP_FILTER_uniqdata_TC162", Include) {

    checkAnswer(s"""select levenshtein(CUST_NAME,'a'),levenshtein(DOB,'b')from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select levenshtein(CUST_NAME,'a'),levenshtein(DOB,'b')from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC162")

  }


  // PushUP_FILTER_uniqdata_TC163
  test("PushUP_FILTER_uniqdata_TC163", Include) {

    checkAnswer(s"""select levenshtein(CUST_NAME,'a')from uniqdata where levenshtein(CUST_NAME,'a') =1 or levenshtein(DOB,'b') is null""",
      s"""select levenshtein(CUST_NAME,'a')from uniqdata_hive where levenshtein(CUST_NAME,'a') =1 or levenshtein(DOB,'b') is null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC163")

  }


  // PushUP_FILTER_uniqdata_TC164
  test("PushUP_FILTER_uniqdata_TC164", Include) {

    checkAnswer(s"""select soundex(CUST_NAME)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """,
      s"""select soundex(CUST_NAME)from uniqdata_hive where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """, "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC164")

  }


  // PushUP_FILTER_uniqdata_TC165
  test("PushUP_FILTER_uniqdata_TC165", Include) {

    checkAnswer(s"""select soundex(CUST_NAME)from uniqdata where soundex(CUST_NAME) is null or soundex(CUST_NAME) is not null""",
      s"""select soundex(CUST_NAME)from uniqdata_hive where soundex(CUST_NAME) is null or soundex(CUST_NAME) is not null""", "QueriesBasicTestCase_PushUP_FILTER_uniqdata_TC165")

  }


  // PushUP_FILTER_uniqdata_TC167
  test("PushUP_FILTER_uniqdata_TC167", Include) {

    sql(s"""select first_value(CUST_ID),first_value(CUST_NAME),first_value(DOB),first_value(BIGINT_COLUMN1),first_value(DECIMAL_COLUMN1),first_value(Double_COLUMN2)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """).collect

  }


  // PushUP_FILTER_uniqdata_TC168
  test("PushUP_FILTER_uniqdata_TC168", Include) {

    sql(s"""select last_value(CUST_ID),last_value(CUST_NAME),last_value(DOB),last_value(BIGINT_COLUMN1),last_value(DECIMAL_COLUMN1),last_value(Double_COLUMN2)from uniqdata where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL  """).collect

  }


  // PushDown_INSERT_uniqdata_TC001
  test("PushDown_INSERT_uniqdata_TC001", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  BIGINT_COLUMN1 in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')
  """,
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata_hive where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  BIGINT_COLUMN1 in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')
  """, "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC001")

  }


  // PushDown_INSERT_uniqdata_TC002
  test("PushDown_INSERT_uniqdata_TC002", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  BIGINT_COLUMN1 not in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata_hive where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  BIGINT_COLUMN1 not in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC002")

  }


  // PushDown_INSERT_uniqdata_TC003
  test("PushDown_INSERT_uniqdata_TC003", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  BIGINT_COLUMN1 in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata_hive where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  BIGINT_COLUMN1 in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC003")

  }


  // PushDown_INSERT_uniqdata_TC004
  test("PushDown_INSERT_uniqdata_TC004", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  BIGINT_COLUMN1 not in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata_hive where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  BIGINT_COLUMN1 not in (123372037874,123372037884,123372037886,123372037889,'',NULL,' ')""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC004")

  }


  // PushDown_INSERT_uniqdata_TC008
  test("PushDown_INSERT_uniqdata_TC008", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ') or Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ')""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN1,INTEGER_COLUMN1 from uniqdata_hive where CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ') or Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ')""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC008")

  }


  // PushDown_INSERT_uniqdata_TC009
  test("PushDown_INSERT_uniqdata_TC009", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ')) or (Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ') and  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata_hive where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ')) or (Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ') and  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC009")

  }


  // PushDown_INSERT_uniqdata_TC011
  test("PushDown_INSERT_uniqdata_TC011", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata_hive where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC011")

  }


  // PushDown_INSERT_uniqdata_TC012
  test("PushDown_INSERT_uniqdata_TC012", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) or (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') and  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata_hive where (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  and  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) or (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') and  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC012")

  }


  // PushDown_INSERT_uniqdata_TC014
  test("PushDown_INSERT_uniqdata_TC014", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata where  CUST_NAME in ((lower('CUST_NAME_01020')),(upper('cust_name_01040')),(upper('')),(upper('NULL')),(upper(' '))) and  ACTIVE_EMUI_VERSION in ((upper('ACTIVE_EMUI_VERSION_01026')),(upper('active_emui_version_01020')))""",
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata_hive where  CUST_NAME in ((lower('CUST_NAME_01020')),(upper('cust_name_01040')),(upper('')),(upper('NULL')),(upper(' '))) and  ACTIVE_EMUI_VERSION in ((upper('ACTIVE_EMUI_VERSION_01026')),(upper('active_emui_version_01020')))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC014")

  }


  // PushDown_INSERT_uniqdata_TC015
  ignore("PushDown_INSERT_uniqdata_TC015", Include) {

    checkAnswer(s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata where  CUST_NAME in ((lower('CUST_NAME_01020')),(upper('cust_name_01040')),(upper('')),(upper('NULL')),(upper(' '))) and  ACTIVE_EMUI_VERSION not in ((upper('ACTIVE_EMUI_VERSION_01026')),'',NULL,(upper('active_emui_version_01020')))
  """,
      s"""select CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from uniqdata_hive where  CUST_NAME in ((lower('CUST_NAME_01020')),(upper('cust_name_01040')),(upper('')),(upper('NULL')),(upper(' '))) and  ACTIVE_EMUI_VERSION not in ((upper('ACTIVE_EMUI_VERSION_01026')),'',NULL,(upper('active_emui_version_01020')))
  """, "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC015")

  }


  // PushDown_INSERT_uniqdata_TC016
  test("PushDown_INSERT_uniqdata_TC016", Include) {

    checkAnswer(s"""SELECT CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from (select * from uniqdata) SUB_QRY WHERE (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""",
      s"""SELECT CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from (select * from uniqdata_hive) SUB_QRY WHERE (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 not in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 not in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC016")

  }


  // PushDown_INSERT_uniqdata_TC017
  test("PushDown_INSERT_uniqdata_TC017", Include) {

    checkAnswer(s"""SELECT CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from (select * from uniqdata) SUB_QRY WHERE (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""",
      s"""SELECT CUST_ID,CUST_NAME,DOB,BIGINT_COLUMN1,DECIMAL_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN2 from (select * from uniqdata_hive) SUB_QRY WHERE (CUST_ID in ('10020','10030','10032','10035','10040','10060','',NULL,' ')  or  INTEGER_COLUMN1 in (1021,1031,1032,1033,'',NULL,' ')) and (Double_COLUMN1 in ('1.12345674897976E10','',NULL,' ') or  DECIMAL_COLUMN2 in ('22345679921.1234000000','',NULL,' '))""", "QueriesBasicTestCase_PushDown_INSERT_uniqdata_TC017")

  }


  // create_table_blocksize_01
  test("create_table_blocksize_01", Include) {
    sql(s"""drop table if exists uniqdata_1mb""").collect

    sql(s"""CREATE TABLE uniqdata_1mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='1')""").collect
  }


  // create_table_blocksize_02
  test("create_table_blocksize_02", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_1mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // create_table_blocksize_03
  test("create_table_blocksize_03", Include) {

    sql(s"""select max(to_date(DOB)),min(to_date(DOB)),count(to_date(DOB)) from uniqdata_1mb where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL """).collect

  }


  // create_table_blocksize_04
  test("create_table_blocksize_04", Include) {
    sql(s"""drop table if exists uniqdata_2048mb""").collect

    sql(s"""CREATE TABLE uniqdata_2048mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='2048')""").collect


  }


  // create_table_blocksize_05
  test("create_table_blocksize_05", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_2048mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // create_table_blocksize_06
  test("create_table_blocksize_06", Include) {

    sql(s"""select max(concat(CUST_ID)),max(concat(CUST_NAME)),max(concat(DOB)),max(concat(BIGINT_COLUMN1)),max(concat(DECIMAL_COLUMN1)),max(concat(Double_COLUMN1)) from uniqdata_2048mb where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL limit 10""").collect

  }


  // create_table_blocksize_07
  test("create_table_blocksize_07", Include) {
    sql(s"""drop table if exists uniqdata_50mb""").collect

    sql(s"""CREATE TABLE uniqdata_50mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='50')""").collect

  }


  // create_table_blocksize_08
  test("create_table_blocksize_08", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_50mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // create_table_blocksize_09
  test("create_table_blocksize_09", Include) {

    sql(s"""select sum(concat(CUST_ID)),sum(concat(CUST_NAME)),sum(concat(DOB)),sum(concat(BIGINT_COLUMN1)),sum(concat(DECIMAL_COLUMN1)),sum(concat(Double_COLUMN1)) from uniqdata_50mb where concat(CUST_ID)=10999 or concat(CUST_NAME)='CUST_NAME_01987' or concat(CUST_NAME)='1975-06-11 01:00:03' or  concat(BIGINT_COLUMN1)=123372038844 or concat(DECIMAL_COLUMN1)=12345680888.1234000000 or concat(Double_COLUMN1)=1.12345674897976E10""").collect

  }


  // create_table_blocksize_10
  test("create_table_blocksize_10", Include) {
    sql(s"""drop table if exists uniqdata_1024mb""").collect

    sql(s"""CREATE TABLE uniqdata_1024mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='1024')""").collect

  }


  // create_table_blocksize_11
  test("create_table_blocksize_11", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_1024mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // create_table_blocksize_12
  test("create_table_blocksize_12", Include) {

    sql(s"""select length(CUST_NAME) from uniqdata_1024mb where CUST_ID IS NULL or DOB IS NOT NULL or BIGINT_COLUMN1 =1233720368578 or DECIMAL_COLUMN1 = 12345678901.1234000058 or Double_COLUMN1 = 1.12345674897976E10 or INTEGER_COLUMN1 IS NULL limit 10""").collect

  }


  // create_table_blocksize_13
  test("create_table_blocksize_13", Include) {
    sql(s"""drop table if exists uniqdata_2000mb""").collect

    sql(s"""CREATE TABLE uniqdata_2000mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='2000')""").collect

  }


  // create_table_blocksize_14
  test("create_table_blocksize_14", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_2000mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // create_table_blocksize_15
  test("create_table_blocksize_15", Include) {

    sql(s"""select max(length(CUST_NAME)),min(length(CUST_NAME)),avg(length(CUST_NAME)),count(length(CUST_NAME)),sum(length(CUST_NAME)),variance(length(CUST_NAME)) from uniqdata_2000mb where length(CUST_NAME)=15 or length(CUST_NAME) is NULL or length(CUST_NAME) is NOT NULL""").collect

  }


  // create_table_blocksize_16
  test("create_table_blocksize_16", Include) {
    sql(s"""drop table if exists uniqdata_1000mb""").collect

    sql(s"""CREATE TABLE uniqdata_1000mb (CUST_ID int,CUST_NAME String,ACTIVE_EMUI_VERSION string, DOB timestamp, DOJ timestamp, BIGINT_COLUMN1 bigint,BIGINT_COLUMN2 bigint,DECIMAL_COLUMN1 decimal(30,10), DECIMAL_COLUMN2 decimal(36,10),Double_COLUMN1 double, Double_COLUMN2 double,INTEGER_COLUMN1 int) STORED AS carbondata TBLPROPERTIES('table_blocksize'='1000')""").collect

  }


  // create_table_blocksize_17
  test("create_table_blocksize_17", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/uniqdata/2000_UniqData.csv' into table uniqdata_1000mb OPTIONS('DELIMITER'=',' , 'QUOTECHAR'='"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='CUST_ID,CUST_NAME,ACTIVE_EMUI_VERSION,DOB,DOJ,BIGINT_COLUMN1,BIGINT_COLUMN2,DECIMAL_COLUMN1,DECIMAL_COLUMN2,Double_COLUMN1,Double_COLUMN2,INTEGER_COLUMN1')""").collect

  }


  // TC_000_
  test("TC_000_", Include) {
    sql(s"""drop table if exists Carbon_automation""").collect
    sql(s"""drop table if exists Carbon_automation_hive""").collect

    sql(s"""create table Carbon_automation (imei string,deviceInformationId int,MAC string,deviceColor string,device_backColor string,modelId string,marketName string,AMSize string,ROMSize string,CUPAudit string,CPIClocked string,series string,productionDate timestamp,bomCode string,internalModels string, deliveryTime string, channelsId string, channelsName string , deliveryAreaId string, deliveryCountry string, deliveryProvince string, deliveryCity string,deliveryDistrict string, deliveryStreet string, oxSingleNumber string, ActiveCheckTime string, ActiveAreaId string, ActiveCountry string, ActiveProvince string, Activecity string, ActiveDistrict string, ActiveStreet string, ActiveOperatorId string, Active_releaseId string, Active_EMUIVersion string, Active_operaSysVersion string, Active_BacVerNumber string, Active_BacFlashVer string, Active_webUIVersion string, Active_webUITypeCarrVer string,Active_webTypeDataVerNumber string, Active_operatorsVersion string, Active_phonePADPartitionedVersions string, Latest_YEAR int, Latest_MONTH int, Latest_DAY int, Latest_HOUR string, Latest_areaId string, Latest_country string, Latest_province string, Latest_city string, Latest_district string, Latest_street string, Latest_releaseId string, Latest_EMUIVersion string, Latest_operaSysVersion string, Latest_BacVerNumber string, Latest_BacFlashVer string, Latest_webUIVersion string, Latest_webUITypeCarrVer string, Latest_webTypeDataVerNumber string, Latest_operatorsVersion string, Latest_phonePADPartitionedVersions string, Latest_operatorId string, gamePointDescription string,gamePointId double,contractNumber double,imei_count int) STORED AS carbondata """).collect

    sql(s"""create table Carbon_automation_hive (imei string,deviceInformationId int,MAC string,deviceColor string,device_backColor string,modelId string,marketName string,AMSize string,ROMSize string,CUPAudit string,CPIClocked string,series string,productionDate timestamp,bomCode string,internalModels string, deliveryTime string, channelsId string, channelsName string , deliveryAreaId string, deliveryCountry string, deliveryProvince string, deliveryCity string,deliveryDistrict string, deliveryStreet string, oxSingleNumber string, contractNumber double,ActiveCheckTime string, ActiveAreaId string, ActiveCountry string, ActiveProvince string, Activecity string, ActiveDistrict string, ActiveStreet string, ActiveOperatorId string, Active_releaseId string, Active_EMUIVersion string, Active_operaSysVersion string, Active_BacVerNumber string, Active_BacFlashVer string, Active_webUIVersion string, Active_webUITypeCarrVer string,Active_webTypeDataVerNumber string, Active_operatorsVersion string, Active_phonePADPartitionedVersions string, Latest_YEAR int, Latest_MONTH int, Latest_DAY int, Latest_HOUR string, Latest_areaId string, Latest_country string, Latest_province string, Latest_city string, Latest_district string, Latest_street string, Latest_releaseId string, Latest_EMUIVersion string, Latest_operaSysVersion string, Latest_BacVerNumber string, Latest_BacFlashVer string, Latest_webUIVersion string, Latest_webUITypeCarrVer string, Latest_webTypeDataVerNumber string, Latest_operatorsVersion string, Latest_phonePADPartitionedVersions string, Latest_operatorId string, gamePointId double,gamePointDescription string,imei_count int)  ROW FORMAT DELIMITED FIELDS TERMINATED BY ','""").collect
  }


  // TC_000_1
  test("TC_000_1", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/HiveData/100_hive_test.csv' INTO TABLE Carbon_automation OPTIONS('DELIMITER'=',','QUOTECHAR'='"','BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='imei,deviceInformationId,MAC,deviceColor,device_backColor,modelId,marketName,AMSize,ROMSize,CUPAudit,CPIClocked,series,productionDate,bomCode,internalModels,deliveryTime,channelsId,channelsName,deliveryAreaId,deliveryCountry,deliveryProvince,deliveryCity,deliveryDistrict,deliveryStreet,oxSingleNumber,contractNumber,ActiveCheckTime,ActiveAreaId,ActiveCountry,ActiveProvince,Activecity,ActiveDistrict,ActiveStreet,ActiveOperatorId,Active_releaseId,Active_EMUIVersion,Active_operaSysVersion,Active_BacVerNumber,Active_BacFlashVer,Active_webUIVersion,Active_webUITypeCarrVer,Active_webTypeDataVerNumber,Active_operatorsVersion,Active_phonePADPartitionedVersions,Latest_YEAR,Latest_MONTH,Latest_DAY,Latest_HOUR,Latest_areaId,Latest_country,Latest_province,Latest_city,Latest_district,Latest_street,Latest_releaseId,Latest_EMUIVersion,Latest_operaSysVersion,Latest_BacVerNumber,Latest_BacFlashVer,Latest_webUIVersion,Latest_webUITypeCarrVer,Latest_webTypeDataVerNumber,Latest_operatorsVersion,Latest_phonePADPartitionedVersions,Latest_operatorId,gamePointId,gamePointDescription,imei_count')""").collect

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/HiveData/100_hive_test_hive1.csv' INTO TABLE Carbon_automation_hive """).collect
  }


  // TC_0000
  test("TC_0000", Include) {
    sql(s"""drop table if exists Carbon_automation1""").collect

    sql(s"""create table Carbon_automation1 (imei string,deviceInformationId int,MAC string,deviceColor string,device_backColor string,modelId string,marketName string,AMSize string,ROMSize string,CUPAudit string,CPIClocked string,series string,productionDate timestamp,bomCode string,internalModels string, deliveryTime string, channelsId string, channelsName string , deliveryAreaId string, deliveryCountry string, deliveryProvince string, deliveryCity string,deliveryDistrict string, deliveryStreet string, oxSingleNumber string, ActiveCheckTime string, ActiveAreaId string, ActiveCountry string, ActiveProvince string, Activecity string, ActiveDistrict string, ActiveStreet string, ActiveOperatorId string, Active_releaseId string, Active_EMUIVersion string, Active_operaSysVersion string, Active_BacVerNumber string, Active_BacFlashVer string, Active_webUIVersion string, Active_webUITypeCarrVer string,Active_webTypeDataVerNumber string, Active_operatorsVersion string, Active_phonePADPartitionedVersions string, Latest_YEAR int, Latest_MONTH int, Latest_DAY int, Latest_HOUR string, Latest_areaId string, Latest_country string, Latest_province string, Latest_city string, Latest_district string, Latest_street string, Latest_releaseId string, Latest_EMUIVersion string, Latest_operaSysVersion string, Latest_BacVerNumber string, Latest_BacFlashVer string, Latest_webUIVersion string, Latest_webUITypeCarrVer string, Latest_webTypeDataVerNumber string, Latest_operatorsVersion string, Latest_phonePADPartitionedVersions string, Latest_operatorId string, gamePointDescription string,gamePointId double,contractNumber double) STORED AS carbondata """).collect

  }


  // TC_00001
  test("TC_00001", Include) {

    sql(s"""LOAD DATA INPATH '$resourcesPath/Data/VmaLL100' INTO TABLE Carbon_automation1 OPTIONS('DELIMITER'=',','QUOTECHAR'='"','FILEHEADER'='imei,deviceInformationId,MAC,deviceColor,device_backColor,modelId,marketName,AMSize,ROMSize,CUPAudit,CPIClocked,series,productionDate,bomCode,internalModels,deliveryTime,channelsId,channelsName,deliveryAreaId,deliveryCountry,deliveryProvince,deliveryCity,deliveryDistrict,deliveryStreet,oxSingleNumber,contractNumber,ActiveCheckTime,ActiveAreaId,ActiveCountry,ActiveProvince,Activecity,ActiveDistrict,ActiveStreet,ActiveOperatorId,Active_releaseId,Active_EMUIVersion,Active_operaSysVersion,Active_BacVerNumber,Active_BacFlashVer,Active_webUIVersion,Active_webUITypeCarrVer,Active_webTypeDataVerNumber,Active_operatorsVersion,Active_phonePADPartitionedVersions,Latest_YEAR,Latest_MONTH,Latest_DAY,Latest_HOUR,Latest_areaId,Latest_country,Latest_province,Latest_city,Latest_district,Latest_street,Latest_releaseId,Latest_EMUIVersion,Latest_operaSysVersion,Latest_BacVerNumber,Latest_BacFlashVer,Latest_webUIVersion,Latest_webUITypeCarrVer,Latest_webTypeDataVerNumber,Latest_operatorsVersion,Latest_phonePADPartitionedVersions,Latest_operatorId,gamePointId,gamePointDescription')""").collect

  }


  // create_table_blocksize_18
  test("create_table_blocksize_18", Include) {

    sql(s"""select max(lower(CUST_NAME)),min(lower(CUST_NAME)),avg(lower(CUST_NAME)),count(lower(CUST_NAME)),sum(lower(CUST_NAME)),variance(lower(CUST_NAME)) from uniqdata_1000mb where lower(CUST_NAME)=15 or lower(CUST_NAME) is NULL or lower(CUST_NAME) is NOT NULL""").collect

  }


  // POC_TableJoin_AllRecords_01
  test("POC_TableJoin_AllRecords_01", Include) {

    sql(s"""select a.* from Carbon_automation a inner join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_02
  test("POC_TableJoin_AllRecords_02", Include) {

    sql(s"""select a.devicecolor from Carbon_automation a inner join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_03
  test("POC_TableJoin_AllRecords_03", Include) {

    sql(s"""select a.*,a.deviceinformationid from Carbon_automation a inner join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_04
  test("POC_TableJoin_AllRecords_04", Include) {

    sql(s"""select a.*,b.device_backcolor from Carbon_automation a inner join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_05
  test("POC_TableJoin_AllRecords_05", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a inner join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_06
  test("POC_TableJoin_AllRecords_06", Include) {

    sql(s"""select b.*,a.marketname,b.* from Carbon_automation a inner join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_07
  test("POC_TableJoin_AllRecords_07", Include) {

    sql(s"""select b.*,a.* from Carbon_automation a inner join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_08
  test("POC_TableJoin_AllRecords_08", Include) {

    sql(s"""select a.* from Carbon_automation a left outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_09
  test("POC_TableJoin_AllRecords_09", Include) {

    sql(s"""select a.devicecolor from Carbon_automation a left outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_10
  test("POC_TableJoin_AllRecords_10", Include) {

    sql(s"""select a.*,a.deviceinformationid from Carbon_automation a left outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_11
  test("POC_TableJoin_AllRecords_11", Include) {

    sql(s"""select a.*,b.device_backcolor from Carbon_automation a left outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_12
  test("POC_TableJoin_AllRecords_12", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a left outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_13
  test("POC_TableJoin_AllRecords_13", Include) {

    sql(s"""select b.*,a.marketname,b.* from Carbon_automation a left outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_14
  test("POC_TableJoin_AllRecords_14", Include) {

    sql(s"""select b.*,a.* from Carbon_automation a left outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_15
  test("POC_TableJoin_AllRecords_15", Include) {

    sql(s"""select a.* from Carbon_automation a right outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_16
  test("POC_TableJoin_AllRecords_16", Include) {

    sql(s"""select a.devicecolor from Carbon_automation a right outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_17
  test("POC_TableJoin_AllRecords_17", Include) {

    sql(s"""select a.*,a.deviceinformationid from Carbon_automation a right outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_18
  test("POC_TableJoin_AllRecords_18", Include) {

    sql(s"""select a.*,b.device_backcolor from Carbon_automation a right outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_19
  test("POC_TableJoin_AllRecords_19", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a right outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_20
  test("POC_TableJoin_AllRecords_20", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a right outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_21
  test("POC_TableJoin_AllRecords_21", Include) {

    sql(s"""select b.*,a.* from Carbon_automation a right outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_22
  test("POC_TableJoin_AllRecords_22", Include) {

    sql(s"""select a.* from Carbon_automation a full outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_23
  test("POC_TableJoin_AllRecords_23", Include) {

    sql(s"""select a.devicecolor from Carbon_automation a full outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_24
  test("POC_TableJoin_AllRecords_24", Include) {

    sql(s"""select a.*,a.deviceinformationid from Carbon_automation a full outer join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_25
  test("POC_TableJoin_AllRecords_25", Include) {

    sql(s"""select a.*,b.device_backcolor from Carbon_automation a full outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_26
  test("POC_TableJoin_AllRecords_26", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a full outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_27
  test("POC_TableJoin_AllRecords_27", Include) {

    sql(s"""select b.*,a.contractnumber from Carbon_automation a full outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_28
  test("POC_TableJoin_AllRecords_28", Include) {

    sql(s"""select b.*,a.* from Carbon_automation a full outer join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_29
  test("POC_TableJoin_AllRecords_29", Include) {

    sql(s"""select a.* from Carbon_automation a left semi join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_30
  test("POC_TableJoin_AllRecords_30", Include) {

    sql(s"""select a.devicecolor from Carbon_automation a left semi join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_31
  test("POC_TableJoin_AllRecords_31", Include) {

    sql(s"""select a.*,a.deviceinformationid from Carbon_automation a left semi join Carbon_automation1 b on a.imei = b.imei and b.mac = 'MAC'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_32
  test("POC_TableJoin_AllRecords_32", Include) {

    sql(s"""select a.*,a.contractnumber from Carbon_automation a left semi join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_33
  test("POC_TableJoin_AllRecords_33", Include) {

    sql(s"""select a.*,a.contractnumber from Carbon_automation a left semi join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // POC_TableJoin_AllRecords_34
  test("POC_TableJoin_AllRecords_34", Include) {

    sql(s"""select a.*,a.* from Carbon_automation a left semi join Carbon_automation1 b on a.mac = b.mac and b.imei = '1AA100'  where a.productionDate between '2015-07-01 12:07:28.0' and '2015-07-20 12:07:28.0' and a.amsize in ('8RAM size','7RAM size')""").collect

  }


  // SparkSQL_Compatibility_01
  test("SparkSQL_Compatibility_01", Include) {

    sql(s"""select Carbon_automation.activeareaid,Carbon_automation1.activeareaid from Carbon_automation JOIN Carbon_automation1 ON (Carbon_automation.activeareaid<>Carbon_automation1.activeareaid)""").collect

  }


  // SparkSQL_Compatibility_02
  test("SparkSQL_Compatibility_02", Include) {

    sql(s"""select Carbon_automation.latest_year,Carbon_automation1.latest_year from Carbon_automation JOIN Carbon_automation1 ON (Carbon_automation.latest_year<>Carbon_automation1.latest_year)""").collect

  }


  // SparkSQL_Compatibility_03
  test("SparkSQL_Compatibility_03", Include) {

    sql(s"""select Carbon_automation.imei,Carbon_automation1.mac from Carbon_automation JOIN Carbon_automation1 ON (1=1)""").collect

  }


  // SparkSQL_Compatibility_04
  ignore("SparkSQL_Compatibility_04", Include) {

    sql(s"""SELECT Carbon_automation.* FROM Carbon_automation UNION SELECT * FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_05
  test("SparkSQL_Compatibility_05", Include) {

    sql(s"""SELECT Carbon_automation.imei FROM Carbon_automation UNION SELECT Carbon_automation1.imei FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_06
  test("SparkSQL_Compatibility_06", Include) {

    sql(s"""SELECT Carbon_automation.imei,latest_year FROM Carbon_automation UNION SELECT imei,latest_year FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_07
  ignore("SparkSQL_Compatibility_07", Include) {

    sql(s"""SELECT Carbon_automation.* FROM Carbon_automation INTERSECT SELECT * FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_08
  test("SparkSQL_Compatibility_08", Include) {

    sql(s"""SELECT Carbon_automation.imei FROM Carbon_automation INTERSECT select Carbon_automation1.imei FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_09
  test("SparkSQL_Compatibility_09", Include) {

    sql(s"""SELECT Carbon_automation.imei,latest_year FROM Carbon_automation INTERSECT SELECT imei,latest_year FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_10
  ignore("SparkSQL_Compatibility_10", Include) {

    sql(s"""SELECT Carbon_automation.* FROM Carbon_automation EXCEPT SELECT * FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_11
  test("SparkSQL_Compatibility_11", Include) {

    sql(s"""SELECT Carbon_automation.imei FROM Carbon_automation EXCEPT select Carbon_automation1.imei FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_12
  test("SparkSQL_Compatibility_12", Include) {

    sql(s"""SELECT Carbon_automation.imei,latest_year FROM Carbon_automation EXCEPT SELECT imei,latest_year FROM Carbon_automation1""").collect

  }


  // SparkSQL_Compatibility_15
  test("SparkSQL_Compatibility_15", Include) {

    sql(s"""SELECT Carbon_automation.*, count(imei) OVER (ORDER BY imei ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) FROM Carbon_automation""").collect

  }


  // SparkSQL_Compatibility_16
  test("SparkSQL_Compatibility_16", Include) {

    sql(s"""SELECT imei, count(imei), avg(deviceinformationid),min(deviceinformationid),max(deviceinformationid),sum(deviceinformationid) OVER (ORDER BY imei,deviceinformationid ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) FROM Carbon_automation group by imei,deviceinformationid order by imei,deviceinformationid""").collect

  }


  // SparkSQL_Compatibility_17
  test("SparkSQL_Compatibility_17", Include) {

    sql(s"""SELECT activeareaid,imei, SUM(latest_year) FROM Carbon_automation GROUP BY ROLLUP(activeareaid, imei)""").collect

  }


  // SparkSQL_Compatibility_18
  test("SparkSQL_Compatibility_18", Include) {

    sql(s"""SELECT activeareaid,imei, SUM(latest_year) FROM Carbon_automation GROUP BY activeareaid, imei with rollup""").collect

  }


  // SparkSQL_Compatibility_19
  test("SparkSQL_Compatibility_19", Include) {

    sql(s"""SELECT activeareaid,imei, SUM(latest_year) FROM Carbon_automation GROUP BY CUBE(activeareaid, imei)""").collect

  }


  // SparkSQL_Compatibility_20
  test("SparkSQL_Compatibility_20", Include) {

    sql(s"""SELECT activeareaid,imei, SUM(latest_year) FROM Carbon_automation GROUP BY activeareaid, imei grouping sets(activeareaid, imei)""").collect

  }


  // SparkSQL_Compatibility_21
  test("SparkSQL_Compatibility_21", Include) {

    sql(s"""select imei from (select imei,deviceInformationId from (select imei,deviceInformationId,MAC from Carbon_automation a)b)c""").collect

  }


  // Select_coalesce_01
  test("Select_coalesce_01", Include) {

    sql(s"""select imei,deviceInformationId,MAC,deviceColor from Carbon_automation where coalesce( imei ,1) != '1AA1'""").collect

  }


  // Select_coalesce_02
  test("Select_coalesce_02", Include) {

    sql(s"""select imei,deviceInformationId,productionDate from Carbon_automation where coalesce(deviceInformationId ,1) = 1000""").collect

  }


  // TC_016
  test("TC_016", Include) {

    checkAnswer(s"""select imei, Latest_DAY+ 10 as a  from Carbon_automation""",
      s"""select imei, Latest_DAY+ 10 as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_016")

  }


  // TC_017
  test("TC_017", Include) {

    checkAnswer(s"""select imei, gamePointId+ 10 Total from Carbon_automation""",
      s"""select imei, gamePointId+ 10 Total from Carbon_automation_hive""", "QueriesBasicTestCase_TC_017")

  }


  // TC_018
  test("TC_018", Include) {

    checkAnswer(s"""select imei, modelId+ 10 Total from Carbon_automation""",
      s"""select imei, modelId+ 10 Total from Carbon_automation_hive""", "QueriesBasicTestCase_TC_018")

  }


  // TC_019
  test("TC_019", Include) {

    checkAnswer(s"""select imei, gamePointId+contractNumber as a  from Carbon_automation""",
      s"""select imei, gamePointId+contractNumber as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_019")

  }


  // TC_020
  test("TC_020", Include) {

    checkAnswer(s"""select imei, deviceInformationId+gamePointId as Total from Carbon_automation""",
      s"""select imei, deviceInformationId+gamePointId as Total from Carbon_automation_hive""", "QueriesBasicTestCase_TC_020")

  }


  // TC_021
  test("TC_021", Include) {

    checkAnswer(s"""select imei, deviceInformationId+deviceInformationId Total from Carbon_automation""",
      s"""select imei, deviceInformationId+deviceInformationId Total from Carbon_automation_hive""", "QueriesBasicTestCase_TC_021")

  }


  // TC_022
  test("TC_022", Include) {

    checkAnswer(s"""select channelsId, sum(Latest_DAY+ 10) as a from Carbon_automation group by  channelsId""",
      s"""select channelsId, sum(Latest_DAY+ 10) as a from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_022")

  }


  // TC_023
  test("TC_023", Include) {

    checkAnswer(s"""select channelsId, sum(gamePointId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, sum(gamePointId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_023")

  }


  // TC_024
  test("TC_024", Include) {

    checkAnswer(s"""select channelsId, sum(channelsId+ 10)  Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, sum(channelsId+ 10)  Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_024")

  }


  // TC_025
  test("TC_025", Include) {

    checkAnswer(s"""select channelsId, sum(channelsId+channelsId) Total from Carbon_automation group by  channelsId order by channelsId,Total""",
      s"""select channelsId, sum(channelsId+channelsId) Total from Carbon_automation_hive group by  channelsId order by channelsId,Total""", "QueriesBasicTestCase_TC_025")

  }


  // TC_026
  test("TC_026", Include) {

    checkAnswer(s"""select channelsId, sum(channelsId+channelsId) Total from Carbon_automation group by  channelsId""",
      s"""select channelsId, sum(channelsId+channelsId) Total from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_026")

  }


  // TC_027
  test("TC_027", Include) {

    checkAnswer(s"""select channelsId, avg(Latest_DAY+ 10) as a from Carbon_automation group by  channelsId""",
      s"""select channelsId, avg(Latest_DAY+ 10) as a from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_027")

  }


  // TC_028
  test("TC_028", Include) {

    checkAnswer(s"""select channelsId, avg(gamePointId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, avg(gamePointId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_028")

  }


  // TC_029
  test("TC_029", Include) {

    checkAnswer(s"""select channelsId, avg(channelsId+ 10)  Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, avg(channelsId+ 10)  Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_029")

  }


  // TC_030
  test("TC_030", Include) {

    checkAnswer(s"""select channelsId, avg(channelsId+channelsId) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, avg(channelsId+channelsId) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_030")

  }


  // TC_031
  test("TC_031", Include) {

    checkAnswer(s"""select channelsId, count(Latest_DAY+ 10) as a  from Carbon_automation group by  channelsId""",
      s"""select channelsId, count(Latest_DAY+ 10) as a  from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_031")

  }


  // TC_032
  test("TC_032", Include) {

    checkAnswer(s"""select channelsId, count(gamePointId+ 10) Total from Carbon_automation group by  channelsId order by channelsId""",
      s"""select channelsId, count(gamePointId+ 10) Total from Carbon_automation_hive group by  channelsId order by channelsId""", "QueriesBasicTestCase_TC_032")

  }


  // TC_033
  test("TC_033", Include) {

    checkAnswer(s"""select channelsId, count(channelsId+ 10) Total from Carbon_automation group by  channelsId order by channelsId, Total""",
      s"""select channelsId, count(channelsId+ 10) Total from Carbon_automation_hive group by  channelsId order by channelsId, Total""", "QueriesBasicTestCase_TC_033")

  }


  // TC_034
  test("TC_034", Include) {

    checkAnswer(s"""select channelsId, count(channelsId+channelsId)  Total from Carbon_automation group by  channelsId order by channelsId, Total""",
      s"""select channelsId, count(channelsId+channelsId)  Total from Carbon_automation_hive group by  channelsId order by channelsId, Total""", "QueriesBasicTestCase_TC_034")

  }


  // TC_035
  test("TC_035", Include) {

    checkAnswer(s"""select channelsId, min(Latest_DAY+ 10) as a  from Carbon_automation group by  channelsId""",
      s"""select channelsId, min(Latest_DAY+ 10) as a  from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_035")

  }


  // TC_036
  test("TC_036", Include) {

    checkAnswer(s"""select channelsId, min(gamePointId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, min(gamePointId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_036")

  }


  // TC_037
  test("TC_037", Include) {

    checkAnswer(s"""select channelsId, min(channelsId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, min(channelsId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_037")

  }


  // TC_038
  test("TC_038", Include) {

    checkAnswer(s"""select channelsId, min(channelsId+channelsId)  Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, min(channelsId+channelsId)  Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_038")

  }


  // TC_039
  test("TC_039", Include) {

    checkAnswer(s"""select channelsId, max(Latest_DAY+ 10) as a  from Carbon_automation group by  channelsId""",
      s"""select channelsId, max(Latest_DAY+ 10) as a  from Carbon_automation_hive group by  channelsId""", "QueriesBasicTestCase_TC_039")

  }


  // TC_040
  test("TC_040", Include) {

    checkAnswer(s"""select channelsId, max(gamePointId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, max(gamePointId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_040")

  }


  // TC_041
  test("TC_041", Include) {

    checkAnswer(s"""select channelsId, max(channelsId+ 10) Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, max(channelsId+ 10) Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_041")

  }


  // TC_042
  test("TC_042", Include) {

    checkAnswer(s"""select channelsId, max(channelsId+channelsId)  Total from Carbon_automation group by  channelsId order by Total""",
      s"""select channelsId, max(channelsId+channelsId)  Total from Carbon_automation_hive group by  channelsId order by Total""", "QueriesBasicTestCase_TC_042")

  }


  // TC_043
  test("TC_043", Include) {

    checkAnswer(s"""select Latest_YEAR ,sum(distinct Latest_YEAR)+10 from Carbon_automation group by Latest_YEAR""",
      s"""select Latest_YEAR ,sum(distinct Latest_YEAR)+10 from Carbon_automation_hive group by Latest_YEAR""", "QueriesBasicTestCase_TC_043")

  }


  // TC_044
  test("TC_044", Include) {

    sql(s"""select Latest_YEAR ,sum(distinct Latest_YEAR)+10 from Carbon_automation group by Latest_YEAR""").collect

  }


  // TC_045
  test("TC_045", Include) {

    sql(s"""select Latest_YEAR ,count(distinct Latest_YEAR) from Carbon_automation group by Latest_YEAR""").collect

  }


  // TC_046
  test("TC_046", Include) {

    checkAnswer(s"""select sum(deviceinformationid)+10 as a ,series  from Carbon_automation group by series""",
      s"""select sum(deviceinformationid)+10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_046")

  }


  // TC_047
  test("TC_047", Include) {

    checkAnswer(s"""select sum(gamepointid) +10 as a ,series  from Carbon_automation group by series""",
      s"""select sum(gamepointid) +10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_047")

  }


  // TC_048
  test("TC_048", Include) {

    checkAnswer(s"""select sum(latest_year)+10 as a ,series  from Carbon_automation group by series""",
      s"""select sum(latest_year)+10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_048")

  }


  // TC_049
  test("TC_049", Include) {

    checkAnswer(s"""select sum(deviceinformationid)+10.32 as a ,series  from Carbon_automation group by series""",
      s"""select sum(deviceinformationid)+10.32 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_049")

  }


  // TC_050
  test("TC_050", Include) {

    checkAnswer(s"""select sum(gamepointid) +10.36 as a ,series  from Carbon_automation group by series""",
      s"""select sum(gamepointid) +10.36 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_050")

  }


  // TC_051
  test("TC_051", Include) {

    checkAnswer(s"""select sum(latest_year)+10.364 as a,series  from Carbon_automation group by series""",
      s"""select sum(latest_year)+10.364 as a,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_051")

  }


  // TC_052
  test("TC_052", Include) {

    checkAnswer(s"""select avg(deviceinformationid)+10 as a ,series  from Carbon_automation group by series""",
      s"""select avg(deviceinformationid)+10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_052")

  }


  // TC_053
  test("TC_053", Include) {

    checkAnswer(s"""select avg(gamepointid) +10 as a ,series  from Carbon_automation group by series""",
      s"""select avg(gamepointid) +10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_053")

  }


  // TC_054
  test("TC_054", Include) {

    checkAnswer(s"""select avg(latest_year)+10 as a ,series  from Carbon_automation group by series""",
      s"""select avg(latest_year)+10 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_054")

  }


  // TC_055
  test("TC_055", Include) {

    checkAnswer(s"""select count(deviceinformationid)+10.32 as a ,series  from Carbon_automation group by series""",
      s"""select count(deviceinformationid)+10.32 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_055")

  }


  // TC_056
  test("TC_056", Include) {

    checkAnswer(s"""select count(gamepointid) +10.36 as a ,series  from Carbon_automation group by series""",
      s"""select count(gamepointid) +10.36 as a ,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_056")

  }


  // TC_057
  test("TC_057", Include) {

    checkAnswer(s"""select count(latest_year)+10.364 as a,series  from Carbon_automation group by series""",
      s"""select count(latest_year)+10.364 as a,series  from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_057")

  }


  // TC_058
  test("TC_058", Include) {

    checkAnswer(s"""select count(distinct series)+10 as a,series from Carbon_automation group by series""",
      s"""select count(distinct series)+10 as a,series from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_058")

  }


  // TC_059
  test("TC_059", Include) {

    checkAnswer(s"""select count(distinct gamepointid)+10 as a,series from Carbon_automation group by series""",
      s"""select count(distinct gamepointid)+10 as a,series from Carbon_automation_hive group by series""", "QueriesBasicTestCase_TC_059")

  }


  // TC_060
  test("TC_060", Include) {

    checkAnswer(s"""select count(*) as a  from Carbon_automation""",
      s"""select count(*) as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_060")

  }


  // TC_061
  test("TC_061", Include) {

    checkAnswer(s"""Select count(1) as a  from Carbon_automation""",
      s"""Select count(1) as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_061")

  }


  // TC_062
  test("TC_062", Include) {

    checkAnswer(s"""select count(imei) as a   from Carbon_automation""",
      s"""select count(imei) as a   from Carbon_automation_hive""", "QueriesBasicTestCase_TC_062")

  }


  // TC_063
  test("TC_063", Include) {

    checkAnswer(s"""select count(device_backColor)  as a from Carbon_automation""",
      s"""select count(device_backColor)  as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_063")

  }


  // TC_064
  test("TC_064", Include) {

    checkAnswer(s"""select count(DISTINCT imei) as a  from Carbon_automation""",
      s"""select count(DISTINCT imei) as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_064")

  }


  // TC_065
  test("TC_065", Include) {

    checkAnswer(s"""select count(DISTINCT series) as a from Carbon_automation""",
      s"""select count(DISTINCT series) as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_065")

  }


  // TC_066
  test("TC_066", Include) {

    checkAnswer(s"""select count(DISTINCT  device_backColor)  as a from Carbon_automation""",
      s"""select count(DISTINCT  device_backColor)  as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_066")

  }


  // TC_067
  test("TC_067", Include) {

    checkAnswer(s"""select count (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation""",
      s"""select count (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_067")

  }


  // TC_068
  test("TC_068", Include) {

    checkAnswer(s"""select count (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation""",
      s"""select count (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_068")

  }


  // TC_069
  test("TC_069", Include) {

    checkAnswer(s"""select count(gamePointId)  as a from Carbon_automation""",
      s"""select count(gamePointId)  as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_069")

  }


  // TC_070
  test("TC_070", Include) {

    checkAnswer(s"""select count(DISTINCT gamePointId) as a from Carbon_automation""",
      s"""select count(DISTINCT gamePointId) as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_070")

  }


  // TC_071
  test("TC_071", Include) {

    checkAnswer(s"""select sum(gamePointId) a  from Carbon_automation""",
      s"""select sum(gamePointId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_071")

  }


  // TC_072
  test("TC_072", Include) {

    checkAnswer(s"""select sum(deviceInformationId) a  from Carbon_automation""",
      s"""select sum(deviceInformationId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_072")

  }


  // TC_073
  test("TC_073", Include) {

    checkAnswer(s"""select sum(channelsId) a  from Carbon_automation""",
      s"""select sum(channelsId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_073")

  }


  // TC_074
  test("TC_074", Include) {

    checkAnswer(s"""select sum(bomCode)  a  from Carbon_automation""",
      s"""select sum(bomCode)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_074")

  }


  // TC_075
  test("TC_075", Include) {

    checkAnswer(s"""select sum(Latest_MONTH)  a  from Carbon_automation""",
      s"""select sum(Latest_MONTH)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_075")

  }


  // TC_076
  test("TC_076", Include) {

    sql(s"""select sum( DISTINCT gamePointId) a  from Carbon_automation""").collect

  }


  // TC_077
  test("TC_077", Include) {

    checkAnswer(s"""select sum(DISTINCT  deviceInformationId) a  from Carbon_automation""",
      s"""select sum(DISTINCT  deviceInformationId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_077")

  }


  // TC_078
  test("TC_078", Include) {

    checkAnswer(s"""select sum( DISTINCT channelsId) a  from Carbon_automation""",
      s"""select sum( DISTINCT channelsId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_078")

  }


  // TC_079
  test("TC_079", Include) {

    checkAnswer(s"""select sum (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation""",
      s"""select sum (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_079")

  }


  // TC_080
  test("TC_080", Include) {

    checkAnswer(s"""select sum (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation""",
      s"""select sum (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_080")

  }


  // TC_081
  test("TC_081", Include) {

    checkAnswer(s"""select sum( DISTINCT Latest_MONTH)  a from Carbon_automation""",
      s"""select sum( DISTINCT Latest_MONTH)  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_081")

  }


  // TC_082
  test("TC_082", Include) {

    checkAnswer(s"""select avg(gamePointId) a  from Carbon_automation""",
      s"""select avg(gamePointId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_082")

  }


  // TC_083
  test("TC_083", Include) {

    checkAnswer(s"""select avg(deviceInformationId) a  from Carbon_automation""",
      s"""select avg(deviceInformationId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_083")

  }


  // TC_084
  test("TC_084", Include) {

    checkAnswer(s"""select avg(channelsId) a  from Carbon_automation""",
      s"""select avg(channelsId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_084")

  }


  // TC_085
  test("TC_085", Include) {

    checkAnswer(s"""select avg(bomCode)  a  from Carbon_automation""",
      s"""select avg(bomCode)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_085")

  }


  // TC_086
  test("TC_086", Include) {

    checkAnswer(s"""select avg(Latest_MONTH)  a  from Carbon_automation""",
      s"""select avg(Latest_MONTH)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_086")

  }


  // TC_087
  test("TC_087", Include) {

    checkAnswer(s"""select avg (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation""",
      s"""select avg (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_087")

  }


  // TC_088
  test("TC_088", Include) {

    checkAnswer(s"""select avg (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation""",
      s"""select avg (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_088")

  }


  // TC_089
  test("TC_089", Include) {

    checkAnswer(s"""select min(gamePointId) a  from Carbon_automation""",
      s"""select min(gamePointId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_089")

  }


  // TC_090
  test("TC_090", Include) {

    checkAnswer(s"""select min(deviceInformationId) a  from Carbon_automation""",
      s"""select min(deviceInformationId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_090")

  }


  // TC_091
  test("TC_091", Include) {

    checkAnswer(s"""select min(channelsId) a  from Carbon_automation""",
      s"""select min(channelsId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_091")

  }


  // TC_092
  test("TC_092", Include) {

    checkAnswer(s"""select min(bomCode)  a  from Carbon_automation""",
      s"""select min(bomCode)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_092")

  }


  // TC_093
  test("TC_093", Include) {

    checkAnswer(s"""select min(Latest_MONTH)  a  from Carbon_automation""",
      s"""select min(Latest_MONTH)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_093")

  }


  // TC_094
  test("TC_094", Include) {

    checkAnswer(s"""select min (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation""",
      s"""select min (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_094")

  }


  // TC_095
  test("TC_095", Include) {

    checkAnswer(s"""select min (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation""",
      s"""select min (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_095")

  }


  // TC_096
  test("TC_096", Include) {

    checkAnswer(s"""select max(gamePointId) a  from Carbon_automation""",
      s"""select max(gamePointId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_096")

  }


  // TC_097
  test("TC_097", Include) {

    checkAnswer(s"""select max(deviceInformationId) a  from Carbon_automation""",
      s"""select max(deviceInformationId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_097")

  }


  // TC_098
  test("TC_098", Include) {

    checkAnswer(s"""select max(channelsId) a  from Carbon_automation""",
      s"""select max(channelsId) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_098")

  }


  // TC_099
  test("TC_099", Include) {

    checkAnswer(s"""select max(bomCode)  a  from Carbon_automation""",
      s"""select max(bomCode)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_099")

  }


  // TC_100
  test("TC_100", Include) {

    checkAnswer(s"""select max(Latest_MONTH)  a  from Carbon_automation""",
      s"""select max(Latest_MONTH)  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_100")

  }


  // TC_101
  test("TC_101", Include) {

    checkAnswer(s"""select max (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation""",
      s"""select max (if(gamePointId>100,NULL,gamePointId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_101")

  }


  // TC_102
  test("TC_102", Include) {

    checkAnswer(s"""select max (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation""",
      s"""select max (if(deviceInformationId>100,NULL,deviceInformationId))  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_102")

  }


  // TC_103
  test("TC_103", Include) {

    sql(s"""select variance(deviceInformationId) as a   from Carbon_automation""").collect

  }


  // TC_104
  test("TC_104", Include) {

    sql(s"""select var_pop(deviceInformationId)  as a from Carbon_automation""").collect

  }


  // TC_105
  test("TC_105", Include) {

    sql(s"""select var_samp(deviceInformationId) as a  from Carbon_automation""").collect

  }


  // TC_106
  test("TC_106", Include) {

    sql(s"""select stddev_pop(deviceInformationId) as a  from Carbon_automation""").collect

  }


  // TC_107
  test("TC_107", Include) {

    sql(s"""select stddev_samp(deviceInformationId)  as a from Carbon_automation""").collect

  }


  // TC_108
  test("TC_108", Include) {

    sql(s"""select covar_pop(deviceInformationId,deviceInformationId) as a  from Carbon_automation""").collect

  }


  // TC_109
  test("TC_109", Include) {

    sql(s"""select covar_samp(deviceInformationId,deviceInformationId) as a  from Carbon_automation""").collect

  }


  // TC_110
  test("TC_110", Include) {

    sql(s"""select corr(deviceInformationId,deviceInformationId)  as a from Carbon_automation""").collect

  }


  // TC_111
  test("TC_111", Include) {

    checkAnswer(s"""select percentile(deviceInformationId,0.2) as  a  from Carbon_automation""",
      s"""select percentile(deviceInformationId,0.2) as  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_111")

  }


  // TC_112
  test("TC_112", Include) {

    checkAnswer(s"""select percentile(deviceInformationId,array(0,0.2,0.3,1))  as  a from Carbon_automation""",
      s"""select percentile(deviceInformationId,array(0,0.2,0.3,1))  as  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_112")

  }


  // TC_113
  test("TC_113", Include) {

    checkAnswer(s"""select percentile_approx(deviceInformationId,0.2) as a  from Carbon_automation""",
      s"""select percentile_approx(deviceInformationId,0.2) as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_113")

  }


  // TC_114
  test("TC_114", Include) {

    sql(s"""select percentile_approx(deviceInformationId,0.2,5) as a  from Carbon_automation""").collect

  }


  // TC_115
  test("TC_115", Include) {

    checkAnswer(s"""select percentile_approx(deviceInformationId,array(0.2,0.3,0.99))  as a from Carbon_automation""",
      s"""select percentile_approx(deviceInformationId,array(0.2,0.3,0.99))  as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_115")

  }


  // TC_116
  test("TC_116", Include) {

    sql(s"""select percentile_approx(deviceInformationId,array(0.2,0.3,0.99),5) as a from Carbon_automation""").collect

  }


  // TC_117
  test("TC_117", Include) {

    sql(s"""select histogram_numeric(deviceInformationId,2)  as a from Carbon_automation""").collect

  }


  // TC_119
  test("TC_119", Include) {

    sql(s"""select variance(gamePointId) as a   from Carbon_automation""").collect

  }


  // TC_120
  test("TC_120", Include) {

    sql(s"""select var_pop(gamePointId)  as a from Carbon_automation""").collect

  }


  // TC_121
  test("TC_121", Include) {

    sql(s"""select var_samp(gamePointId) as a  from Carbon_automation""").collect

  }


  // TC_122
  test("TC_122", Include) {

    sql(s"""select stddev_pop(gamePointId) as a  from Carbon_automation""").collect

  }


  // TC_123
  test("TC_123", Include) {

    sql(s"""select stddev_samp(gamePointId)  as a from Carbon_automation""").collect

  }


  // TC_124
  test("TC_124", Include) {

    sql(s"""select covar_pop(gamePointId,gamePointId) as a  from Carbon_automation""").collect

  }


  // TC_125
  test("TC_125", Include) {

    sql(s"""select covar_samp(gamePointId,gamePointId) as a  from Carbon_automation""").collect

  }


  // TC_126
  test("TC_126", Include) {

    sql(s"""select corr(gamePointId,gamePointId)  as a from Carbon_automation""").collect

  }


  // TC_127
  test("TC_127", Include) {

    checkAnswer(s"""select percentile(deviceInformationId,0.2) as  a  from Carbon_automation""",
      s"""select percentile(deviceInformationId,0.2) as  a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_127")

  }


  // TC_128
  test("TC_128", Include) {

    checkAnswer(s"""select percentile(deviceInformationId,array(0,0.2,0.3,1))  as  a from Carbon_automation""",
      s"""select percentile(deviceInformationId,array(0,0.2,0.3,1))  as  a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_128")

  }


  // TC_129
  test("TC_129", Include) {

    checkAnswer(s"""select percentile_approx(gamePointId,0.2) as a  from Carbon_automation""",
      s"""select percentile_approx(gamePointId,0.2) as a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_129")

  }


  // TC_130
  test("TC_130", Include) {

    sql(s"""select percentile_approx(gamePointId,0.2,5) as a  from Carbon_automation""").collect

  }


  // TC_131
  test("TC_131", Include) {

    checkAnswer(s"""select percentile_approx(gamePointId,array(0.2,0.3,0.99))  as a from Carbon_automation""",
      s"""select percentile_approx(gamePointId,array(0.2,0.3,0.99))  as a from Carbon_automation_hive""", "QueriesBasicTestCase_TC_131")

  }


  // TC_132
  test("TC_132", Include) {

    sql(s"""select percentile_approx(gamePointId,array(0.2,0.3,0.99),5) as a from Carbon_automation""").collect

  }


  // TC_133
  test("TC_133", Include) {

    sql(s"""select histogram_numeric(gamePointId,2)  as a from Carbon_automation""").collect

  }


  // TC_134
  test("TC_134", Include) {

    sql(s"""select last(imei) a from Carbon_automation""").collect

  }


  // TC_135
  test("TC_135", Include) {

    sql(s"""select FIRST(imei) a from Carbon_automation""").collect

  }


  // TC_136
  test("TC_136", Include) {

    checkAnswer(s"""select series,count(imei) a from Carbon_automation group by series order by series""",
      s"""select series,count(imei) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_136")

  }


  // TC_137
  test("TC_137", Include) {

    checkAnswer(s"""select series,count(imei) a from Carbon_automation group by series order by series""",
      s"""select series,count(imei) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_137")

  }


  // TC_138
  test("TC_138", Include) {

    checkAnswer(s"""select series,ActiveProvince,count(imei)  a from Carbon_automation group by ActiveProvince,series order by series,ActiveProvince""",
      s"""select series,ActiveProvince,count(imei)  a from Carbon_automation_hive group by ActiveProvince,series order by series,ActiveProvince""", "QueriesBasicTestCase_TC_138")

  }


  // TC_139
  test("TC_139", Include) {

    checkAnswer(s"""select count(distinct deviceColor) a,deliveryProvince from Carbon_automation group by deliveryProvince""",
      s"""select count(distinct deviceColor) a,deliveryProvince from Carbon_automation_hive group by deliveryProvince""", "QueriesBasicTestCase_TC_139")

  }


  // TC_140
  test("TC_140", Include) {

    checkAnswer(s"""select count(distinct deviceColor) a,deliveryProvince,series from Carbon_automation group by deliveryProvince,series order by deliveryProvince,series""",
      s"""select count(distinct deviceColor) a,deliveryProvince,series from Carbon_automation_hive group by deliveryProvince,series order by deliveryProvince,series""", "QueriesBasicTestCase_TC_140")

  }


  // TC_141
  test("TC_141", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_141")

  }


  // TC_142
  test("TC_142", Include) {

    checkAnswer(s"""select deliveryCountry,deliveryProvince,series,sum(gamePointId) a from Carbon_automation group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""",
      s"""select deliveryCountry,deliveryProvince,series,sum(gamePointId) a from Carbon_automation_hive group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""", "QueriesBasicTestCase_TC_142")

  }


  // TC_146
  test("TC_146", Include) {

    checkAnswer(s"""select series,avg(gamePointId) a from Carbon_automation group by series order by series""",
      s"""select series,avg(gamePointId) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_146")

  }


  // TC_147
  test("TC_147", Include) {

    checkAnswer(s"""select deliveryCountry,deliveryProvince,series,avg(gamePointId) a from Carbon_automation group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""",
      s"""select deliveryCountry,deliveryProvince,series,avg(gamePointId) a from Carbon_automation_hive group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""", "QueriesBasicTestCase_TC_147")

  }


  // TC_151
  test("TC_151", Include) {

    checkAnswer(s"""select series,min(gamePointId) a from Carbon_automation group by series order by series""",
      s"""select series,min(gamePointId) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_151")

  }


  // TC_152
  test("TC_152", Include) {

    checkAnswer(s"""select deliveryCountry,deliveryProvince,series,min(gamePointId) a from Carbon_automation group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""",
      s"""select deliveryCountry,deliveryProvince,series,min(gamePointId) a from Carbon_automation_hive group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""", "QueriesBasicTestCase_TC_152")

  }


  // TC_156
  test("TC_156", Include) {

    checkAnswer(s"""select series,max(gamePointId) a from Carbon_automation group by series order by series""",
      s"""select series,max(gamePointId) a from Carbon_automation_hive group by series order by series""", "QueriesBasicTestCase_TC_156")

  }


  // TC_157
  test("TC_157", Include) {

    checkAnswer(s"""select deliveryCountry,deliveryProvince,series,max(gamePointId) a from Carbon_automation group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""",
      s"""select deliveryCountry,deliveryProvince,series,max(gamePointId) a from Carbon_automation_hive group by deliveryCountry,deliveryProvince,series order by deliveryCountry,deliveryProvince,series""", "QueriesBasicTestCase_TC_157")

  }


  // TC_161
  test("TC_161", Include) {

    checkAnswer(s"""select Latest_DAY from Carbon_automation where Latest_DAY in (select  Latest_DAY from Carbon_automation) order by Latest_DAY""",
      s"""select Latest_DAY from Carbon_automation_hive where Latest_DAY in (select  Latest_DAY from Carbon_automation_hive) order by Latest_DAY""", "QueriesBasicTestCase_TC_161")

  }


  // TC_162
  test("TC_162", Include) {

    checkAnswer(s"""select imei,series from Carbon_automation where Carbon_automation.series IN ('1Series','7Series')""",
      s"""select imei,series from Carbon_automation_hive where Carbon_automation_hive.series IN ('1Series','7Series')""", "QueriesBasicTestCase_TC_162")

  }


  // TC_163
  test("TC_163", Include) {

    checkAnswer(s"""select imei,series from Carbon_automation where Carbon_automation.series  NOT IN ('1Series','7Series')""",
      s"""select imei,series from Carbon_automation_hive where Carbon_automation_hive.series  NOT IN ('1Series','7Series')""", "QueriesBasicTestCase_TC_163")

  }


  // TC_164
  test("TC_164", Include) {

    checkAnswer(s"""select channelsId from Carbon_automation where channelsId in (select  channelsId from Carbon_automation) order by channelsId""",
      s"""select channelsId from Carbon_automation_hive where channelsId in (select  channelsId from Carbon_automation_hive) order by channelsId""", "QueriesBasicTestCase_TC_164")

  }


  // TC_165
  test("TC_165", Include) {

    checkAnswer(s"""select  imei, sum(deviceInformationId) as a  from Carbon_automation where deviceInformationId in (select deviceInformationId  from Carbon_automation) group by deviceInformationId,imei""",
      s"""select  imei, sum(deviceInformationId) as a  from Carbon_automation_hive where deviceInformationId in (select deviceInformationId  from Carbon_automation_hive) group by deviceInformationId,imei""", "QueriesBasicTestCase_TC_165")

  }


  // TC_166
  test("TC_166", Include) {

    checkAnswer(s"""select Upper(series) a  from Carbon_automation""",
      s"""select Upper(series) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_166")

  }


  // TC_167
  test("TC_167", Include) {

    checkAnswer(s"""select Upper(Latest_DAY) a  from Carbon_automation""",
      s"""select Upper(Latest_DAY) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_167")

  }


  // TC_168
  test("TC_168", Include) {

    sql(s"""select imei,series from Carbon_automation limit 10""").collect

  }


  // TC_169
  test("TC_169", Include) {

    sql(s"""select imei,series,gamePointId from Carbon_automation limit 10""").collect

  }


  // TC_170
  test("TC_170", Include) {

    checkAnswer(s"""select Upper(series) a ,channelsId from Carbon_automation group by series,channelsId order by Upper(series), channelsId""",
      s"""select Upper(series) a ,channelsId from Carbon_automation_hive group by series,channelsId order by Upper(series), channelsId""", "QueriesBasicTestCase_TC_170")

  }


  // TC_171
  test("TC_171", Include) {

    checkAnswer(s"""select Lower(series) a  from Carbon_automation""",
      s"""select Lower(series) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_171")

  }


  // TC_172
  test("TC_172", Include) {

    checkAnswer(s"""select Lower(Latest_DAY) a  from Carbon_automation""",
      s"""select Lower(Latest_DAY) a  from Carbon_automation_hive""", "QueriesBasicTestCase_TC_172")

  }


  // TC_173
  test("TC_173", Include) {

    checkAnswer(s"""select distinct  Latest_DAY from Carbon_automation""",
      s"""select distinct  Latest_DAY from Carbon_automation_hive""", "QueriesBasicTestCase_TC_173")

  }


  // TC_174
  test("TC_174", Include) {

    checkAnswer(s"""select distinct gamePointId from Carbon_automation""",
      s"""select distinct gamePointId from Carbon_automation_hive""", "QueriesBasicTestCase_TC_174")

  }


  // TC_175
  test("TC_175", Include) {

    checkAnswer(s"""select distinct  channelsId from Carbon_automation""",
      s"""select distinct  channelsId from Carbon_automation_hive""", "QueriesBasicTestCase_TC_175")

  }


  // TC_176
  test("TC_176", Include) {

    checkAnswer(s"""select distinct  series from Carbon_automation""",
      s"""select distinct  series from Carbon_automation_hive""", "QueriesBasicTestCase_TC_176")

  }


  // TC_179
  test("TC_179", Include) {

    checkAnswer(s"""select imei,series from Carbon_automation limit 101""",
      s"""select imei,series from Carbon_automation_hive limit 101""", "QueriesBasicTestCase_TC_179")

  }


  // TC_180
  test("TC_180", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series desc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series desc""", "QueriesBasicTestCase_TC_180")

  }


  // TC_181
  test("TC_181", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by a desc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by a desc""", "QueriesBasicTestCase_TC_181")

  }


  // TC_182
  test("TC_182", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series desc ,a desc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series desc ,a desc""", "QueriesBasicTestCase_TC_182")

  }


  // TC_183
  test("TC_183", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series asc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series asc""", "QueriesBasicTestCase_TC_183")

  }


  // TC_184
  test("TC_184", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by a asc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by a asc""", "QueriesBasicTestCase_TC_184")

  }


  // TC_185
  test("TC_185", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series asc ,a asc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series asc ,a asc""", "QueriesBasicTestCase_TC_185")

  }


  // TC_186
  test("TC_186", Include) {

    checkAnswer(s"""select series,sum(gamePointId) a from Carbon_automation group by series order by series desc ,a asc""",
      s"""select series,sum(gamePointId) a from Carbon_automation_hive group by series order by series desc ,a asc""", "QueriesBasicTestCase_TC_186")

  }


  // TC_187
  test("TC_187", Include) {

    checkAnswer(s"""select series,ActiveProvince,sum(gamePointId) a from Carbon_automation group by series,ActiveProvince order by series desc,ActiveProvince asc""",
      s"""select series,ActiveProvince,sum(gamePointId) a from Carbon_automation_hive group by series,ActiveProvince order by series desc,ActiveProvince asc""", "QueriesBasicTestCase_TC_187")

  }


  // TC_188
  test("TC_188", Include) {

    checkAnswer(s"""select series,gamePointId as a from Carbon_automation  order by a asc limit 10""",
      s"""select series,gamePointId as a from Carbon_automation_hive  order by a asc limit 10""", "QueriesBasicTestCase_TC_188")

  }


  // TC_189
  test("TC_189", Include) {

    checkAnswer(s"""select series,gamePointId as a from Carbon_automation  order by a desc limit 10""",
      s"""select series,gamePointId as a from Carbon_automation_hive  order by a desc limit 10""", "QueriesBasicTestCase_TC_189")

  }


  // TC_190
  test("TC_190", Include) {

    sql(s"""select series,gamePointId as a from Carbon_automation  order by series asc limit 10""").collect

  }


  // TC_191
  test("TC_191", Include) {

    sql(s"""select series,gamePointId as a from Carbon_automation  order by series desc limit 10""").collect

  }


  // TC_193
  test("TC_193", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where  (contractNumber == 5281803) and (gamePointId==2738.562)""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where  (contractNumber == 5281803) and (gamePointId==2738.562)""", "QueriesBasicTestCase_TC_193")

  }


  // TC_194
  test("TC_194", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series='8Series'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series='8Series'""", "QueriesBasicTestCase_TC_194")

  }


  // TC_195
  test("TC_195", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series='8Series' and internalModels='8Internal models'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series='8Series' and internalModels='8Internal models'""", "QueriesBasicTestCase_TC_195")

  }


  // TC_196
  test("TC_196", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series='8Series' or  internalModels='8Internal models'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series='8Series' or  internalModels='8Internal models'""", "QueriesBasicTestCase_TC_196")

  }


  // TC_197
  test("TC_197", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series='8Series' or series='7Series'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series='8Series' or series='7Series'""", "QueriesBasicTestCase_TC_197")

  }


  // TC_198
  test("TC_198", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where gamePointId=2738.562""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where gamePointId=2738.562""", "QueriesBasicTestCase_TC_198")

  }


  // TC_199
  test("TC_199", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where deviceInformationId=10""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where deviceInformationId=10""", "QueriesBasicTestCase_TC_199")

  }


  // TC_200
  test("TC_200", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series  from Carbon_automation where (deviceInformationId=100 and deviceColor='1Device Color') OR (deviceInformationId=10 and deviceColor='0Device Color')""",
      s"""select contractNumber,gamePointId,series  from Carbon_automation_hive where (deviceInformationId=100 and deviceColor='1Device Color') OR (deviceInformationId=10 and deviceColor='0Device Color')""", "QueriesBasicTestCase_TC_200")

  }


  // TC_201
  test("TC_201", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series !='8Series'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series !='8Series'""", "QueriesBasicTestCase_TC_201")

  }


  // TC_202
  test("TC_202", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series !='8Series' and internalModels !='8Internal models'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series !='8Series' and internalModels !='8Internal models'""", "QueriesBasicTestCase_TC_202")

  }


  // TC_203
  test("TC_203", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series !='8Series' or  internalModels !='8Internal models'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series !='8Series' or  internalModels !='8Internal models'""", "QueriesBasicTestCase_TC_203")

  }


  // TC_204
  test("TC_204", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where series !='8Series' or series !='7Series'""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where series !='8Series' or series !='7Series'""", "QueriesBasicTestCase_TC_204")

  }


  // TC_205
  test("TC_205", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where gamePointId !=2738.562""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where gamePointId !=2738.562""", "QueriesBasicTestCase_TC_205")

  }


  // TC_206
  test("TC_206", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where deviceInformationId !=10""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where deviceInformationId !=10""", "QueriesBasicTestCase_TC_206")

  }


  // TC_207
  test("TC_207", Include) {

    checkAnswer(s"""select contractNumber,gamePointId,series from Carbon_automation where gamePointId >2738.562""",
      s"""select contractNumber,gamePointId,series from Carbon_automation_hive where gamePointId >2738.562""", "QueriesBasicTestCase_TC_207")

  }


  // TC_208
  test("TC_208", Include) {

    checkAnswer(s"""select Latest_DAY as a from Carbon_automation where Latest_DAY<=>Latest_areaId""",
      s"""select Latest_DAY as a from Carbon_automation_hive where Latest_DAY<=>Latest_areaId""", "QueriesBasicTestCase_TC_208")

  }


  // TC_210
  test("TC_210", Include) {

    checkAnswer(s"""select Latest_DAY  from Carbon_automation where Latest_DAY<>Latest_areaId""",
      s"""select Latest_DAY  from Carbon_automation_hive where Latest_DAY<>Latest_areaId""", "QueriesBasicTestCase_TC_210")

  }


  // TC_211
  test("TC_211", Include) {

    checkAnswer(s"""select Latest_DAY from Carbon_automation where Latest_DAY != Latest_areaId""",
      s"""select Latest_DAY from Carbon_automation_hive where Latest_DAY != Latest_areaId""", "QueriesBasicTestCase_TC_211")

  }


  // TC_212
  test("TC_212", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY<Latest_areaId""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY<Latest_areaId""", "QueriesBasicTestCase_TC_212")

  }


  // TC_213
  test("TC_213", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY<=Latest_areaId""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY<=Latest_areaId""", "QueriesBasicTestCase_TC_213")

  }


  // TC_214
  test("TC_214", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY>Latest_areaId""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY>Latest_areaId""", "QueriesBasicTestCase_TC_214")

  }


  // TC_215
  test("TC_215", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY>=Latest_areaId""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY>=Latest_areaId""", "QueriesBasicTestCase_TC_215")

  }


  // TC_216
  test("TC_216", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY NOT BETWEEN Latest_areaId AND  Latest_HOUR""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY NOT BETWEEN Latest_areaId AND  Latest_HOUR""", "QueriesBasicTestCase_TC_216")

  }


  // TC_217
  test("TC_217", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY BETWEEN Latest_areaId AND  Latest_HOUR""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY BETWEEN Latest_areaId AND  Latest_HOUR""", "QueriesBasicTestCase_TC_217")

  }


  // TC_218
  test("TC_218", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY IS NULL""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY IS NULL""", "QueriesBasicTestCase_TC_218")

  }


  // TC_219
  test("TC_219", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY IS NOT NULL""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY IS NOT NULL""", "QueriesBasicTestCase_TC_219")

  }


  // TC_220
  test("TC_220", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where imei IS NOT NULL""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where imei IS NOT NULL""", "QueriesBasicTestCase_TC_220")

  }


  // TC_221
  test("TC_221", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY NOT LIKE Latest_areaId AND Latest_DAY NOT LIKE  Latest_HOUR""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY NOT LIKE Latest_areaId AND Latest_DAY NOT LIKE  Latest_HOUR""", "QueriesBasicTestCase_TC_221")

  }


  // TC_222
  test("TC_222", Include) {

    checkAnswer(s"""select imei, Latest_DAY from Carbon_automation where Latest_DAY  LIKE Latest_areaId AND  Latest_DAY  LIKE Latest_HOUR""",
      s"""select imei, Latest_DAY from Carbon_automation_hive where Latest_DAY  LIKE Latest_areaId AND  Latest_DAY  LIKE Latest_HOUR""", "QueriesBasicTestCase_TC_222")

  }


  // TC_225
  test("TC_225", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where gamePointId >505""",
      s"""select imei,gamePointId from Carbon_automation_hive where gamePointId >505""", "QueriesBasicTestCase_TC_225")

  }


  // TC_226
  test("TC_226", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where gamePointId <505""",
      s"""select imei,gamePointId from Carbon_automation_hive where gamePointId <505""", "QueriesBasicTestCase_TC_226")

  }


  // TC_227
  test("TC_227", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where channelsId <2""",
      s"""select imei,gamePointId from Carbon_automation_hive where channelsId <2""", "QueriesBasicTestCase_TC_227")

  }


  // TC_228
  test("TC_228", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where channelsId >2""",
      s"""select imei,gamePointId from Carbon_automation_hive where channelsId >2""", "QueriesBasicTestCase_TC_228")

  }


  // TC_229
  test("TC_229", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where gamePointId >=505""",
      s"""select imei,gamePointId from Carbon_automation_hive where gamePointId >=505""", "QueriesBasicTestCase_TC_229")

  }


  // TC_230
  test("TC_230", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where gamePointId <=505""",
      s"""select imei,gamePointId from Carbon_automation_hive where gamePointId <=505""", "QueriesBasicTestCase_TC_230")

  }


  // TC_231
  test("TC_231", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where channelsId <=2""",
      s"""select imei,gamePointId from Carbon_automation_hive where channelsId <=2""", "QueriesBasicTestCase_TC_231")

  }


  // TC_232
  test("TC_232", Include) {

    checkAnswer(s"""select imei,gamePointId from Carbon_automation where channelsId >=2""",
      s"""select imei,gamePointId from Carbon_automation_hive where channelsId >=2""", "QueriesBasicTestCase_TC_232")

  }


  // TC_233
  test("TC_233", Include) {

    checkAnswer(s"""select imei,gamePointId, channelsId,series  from Carbon_automation where channelsId >=10 OR channelsId <=1 and series='7Series'""",
      s"""select imei,gamePointId, channelsId,series  from Carbon_automation_hive where channelsId >=10 OR channelsId <=1 and series='7Series'""", "QueriesBasicTestCase_TC_233")

  }


  // TC_234
  test("TC_234", Include) {

    checkAnswer(s"""select imei,gamePointId, channelsId,series  from Carbon_automation where channelsId >=10 OR channelsId <=1 or series='7Series'""",
      s"""select imei,gamePointId, channelsId,series  from Carbon_automation_hive where channelsId >=10 OR channelsId <=1 or series='7Series'""", "QueriesBasicTestCase_TC_234")

  }


  // TC_236
  test("TC_236", Include) {

    checkAnswer(s"""select sum(gamePointId) a from Carbon_automation where channelsId >=10 OR (channelsId <=1 and series='1Series')""",
      s"""select sum(gamePointId) a from Carbon_automation_hive where channelsId >=10 OR (channelsId <=1 and series='1Series')""", "QueriesBasicTestCase_TC_236")

  }


  // TC_237
  test("TC_237", Include) {

    checkAnswer(s"""select * from (select imei,if(imei='1AA100060',NULL,imei) a from Carbon_automation) aa  where a IS NULL""",
      s"""select * from (select imei,if(imei='1AA100060',NULL,imei) a from Carbon_automation_hive) aa  where a IS NULL""", "QueriesBasicTestCase_TC_237")

  }


  // TC_257
  test("TC_257", Include) {

    checkAnswer(s"""select imei,internalModels,series from Carbon_automation where (series='8Series' and internalModels='8Internal models') OR (series='7Series' and internalModels='7Internal models')""",
      s"""select imei,internalModels,series from Carbon_automation_hive where (series='8Series' and internalModels='8Internal models') OR (series='7Series' and internalModels='7Internal models')""", "QueriesBasicTestCase_TC_257")

  }


  // TC_258
  test("TC_258", Include) {

    checkAnswer(s"""select imei,internalModels,series from Carbon_automation where (series='8Series' or internalModels='8Internal models') or (series='7Series' or internalModels='7Internal models')
  """,
      s"""select imei,internalModels,series from Carbon_automation_hive where (series='8Series' or internalModels='8Internal models') or (series='7Series' or internalModels='7Internal models')
  """, "QueriesBasicTestCase_TC_258")

  }


  // TC_259
  test("TC_259", Include) {

    checkAnswer(s"""select imei,internalModels,series from Carbon_automation where (series='8Series' or internalModels='8Internal models') and (series='7Series' or internalModels='7Internal models')
  """,
      s"""select imei,internalModels,series from Carbon_automation_hive where (series='8Series' or internalModels='8Internal models') and (series='7Series' or internalModels='7Internal models')
  """, "QueriesBasicTestCase_TC_259")

  }


  // TC_260
  test("TC_260", Include) {

    checkAnswer(s"""select imei,internalModels,series from Carbon_automation where (series='8Series' and internalModels='8Internal models') or (deviceInformationId is not NULL)""",
      s"""select imei,internalModels,series from Carbon_automation_hive where (series='8Series' and internalModels='8Internal models') or (deviceInformationId is not NULL)""", "QueriesBasicTestCase_TC_260")

  }


  // TC_261
  test("TC_261", Include) {

    checkAnswer(s"""select  imei from Carbon_automation where UPPER(Latest_province) == 'GUANGDONG PROVINCE'""",
      s"""select  imei from Carbon_automation_hive where UPPER(Latest_province) == 'GUANGDONG PROVINCE'""", "QueriesBasicTestCase_TC_261")

  }


  // TC_262
  test("TC_262", Include) {

    checkAnswer(s"""select count(imei) ,series from Carbon_automation group by series having sum (Latest_DAY) == 99""",
      s"""select count(imei) ,series from Carbon_automation_hive group by series having sum (Latest_DAY) == 99""", "QueriesBasicTestCase_TC_262")

  }


  // TC_274
  test("TC_274", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamepointid) AS Sum_gamepointid FROM  Carbon_automation group by ActiveCountry,ActiveDistrict,Activecity""",
      s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamepointid) AS Sum_gamepointid FROM  Carbon_automation_hive group by ActiveCountry,ActiveDistrict,Activecity""", "QueriesBasicTestCase_TC_274")

  }


  // TC_283
  test("TC_283", Include) {

    checkAnswer(s"""select  AMSize,sum( gamePointId+ contractNumber) as total from Carbon_automation where AMSize='0RAM size' and  ActiveProvince='Guangdong Province' group by AMSize""",
      s"""select  AMSize,sum( gamePointId+ contractNumber) as total from Carbon_automation_hive where AMSize='0RAM size' and  ActiveProvince='Guangdong Province' group by AMSize""", "QueriesBasicTestCase_TC_283")

  }


  // TC_284
  test("TC_284", Include) {

    checkAnswer(s"""select AMSize,sum(gamePointId+contractNumber) as total from Carbon_automation where  CUPAudit='0CPU Audit' group by AMSize having total > 10 order by total desc
  """,
      s"""select AMSize,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where  CUPAudit='0CPU Audit' group by AMSize having total > 10 order by total desc
  """, "QueriesBasicTestCase_TC_284")

  }


  // TC_285
  test("TC_285", Include) {

    checkAnswer(s"""select AMSize,sum(gamePointId+contractNumber) as total from Carbon_automation where CUPAudit='0CPU Audit' group by AMSize having total > 10 order by total desc""",
      s"""select AMSize,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where CUPAudit='0CPU Audit' group by AMSize having total > 10 order by total desc""", "QueriesBasicTestCase_TC_285")

  }


  // TC_286
  test("TC_286", Include) {

    checkAnswer(s"""select  ActiveAreaId,count(distinct AMSize) as AMSize_number, sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveAreaId""",
      s"""select  ActiveAreaId,count(distinct AMSize) as AMSize_number, sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveAreaId""", "QueriesBasicTestCase_TC_286")

  }


  // TC_287
  test("TC_287", Include) {

    checkAnswer(s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where ActiveAreaId='6'group by ActiveAreaId order by AMSize_number desc""",
      s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where ActiveAreaId='6'group by ActiveAreaId order by AMSize_number desc""", "QueriesBasicTestCase_TC_287")

  }


  // TC_288
  test("TC_288", Include) {

    checkAnswer(s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveAreaId""",
      s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveAreaId""", "QueriesBasicTestCase_TC_288")

  }


  // TC_289
  test("TC_289", Include) {

    checkAnswer(s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where ActiveAreaId='6' and ActiveProvince='Hubei Province' group by ActiveAreaId order by AMSize_number desc""",
      s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where ActiveAreaId='6' and ActiveProvince='Hubei Province' group by ActiveAreaId order by AMSize_number desc""", "QueriesBasicTestCase_TC_289")

  }


  // TC_290
  test("TC_290", Include) {

    checkAnswer(s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveProvince""",
      s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveProvince""", "QueriesBasicTestCase_TC_290")

  }


  // TC_291
  test("TC_291", Include) {

    checkAnswer(s"""select AMSize,count(distinct imei) as imei_number,sum(gamePointId+contractNumber) as total from Carbon_automation where AMSize='0RAM size' group by AMSize order by imei_number desc""",
      s"""select AMSize,count(distinct imei) as imei_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where AMSize='0RAM size' group by AMSize order by imei_number desc""", "QueriesBasicTestCase_TC_291")

  }


  // TC_292
  test("TC_292", Include) {

    checkAnswer(s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveProvince""",
      s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveProvince""", "QueriesBasicTestCase_TC_292")

  }


  // TC_293
  test("TC_293", Include) {

    checkAnswer(s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where CUPAudit='0CPU Audit' group by ActiveProvince order by total desc""",
      s"""select ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where CUPAudit='0CPU Audit' group by ActiveProvince order by total desc""", "QueriesBasicTestCase_TC_293")

  }


  // TC_294
  test("TC_294", Include) {

    checkAnswer(s"""select  ActiveOperatorId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by  ActiveOperatorId""",
      s"""select  ActiveOperatorId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by  ActiveOperatorId""", "QueriesBasicTestCase_TC_294")

  }


  // TC_295
  test("TC_295", Include) {

    checkAnswer(s"""select ActiveOperatorId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where ActiveOperatorId='100000' group by ActiveOperatorId order by total desc""",
      s"""select ActiveOperatorId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where ActiveOperatorId='100000' group by ActiveOperatorId order by total desc""", "QueriesBasicTestCase_TC_295")

  }


  // TC_296
  test("TC_296", Include) {

    checkAnswer(s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveAreaId""",
      s"""select ActiveAreaId,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveAreaId""", "QueriesBasicTestCase_TC_296")

  }


  // TC_297
  ignore("TC_297", Include) {

    checkAnswer(s"""select  Latest_DAY,Latest_HOUR,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by Latest_DAY,Latest_HOUR""",
      s"""select  Latest_DAY,Latest_HOUR,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by Latest_DAY,Latest_HOUR""", "QueriesBasicTestCase_TC_297")

  }


  // TC_298
  ignore("TC_298", Include) {

    checkAnswer(s"""select Latest_DAY,Latest_HOUR,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where Latest_HOUR between 12 and 15 group by Latest_DAY,Latest_HOUR order by total desc""",
      s"""select Latest_DAY,Latest_HOUR,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where Latest_HOUR between 12 and 15 group by Latest_DAY,Latest_HOUR order by total desc""", "QueriesBasicTestCase_TC_298")

  }


  // TC_299
  test("TC_299", Include) {

    checkAnswer(s"""select  Activecity,ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by Activecity,ActiveProvince""",
      s"""select  Activecity,ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by Activecity,ActiveProvince""", "QueriesBasicTestCase_TC_299")

  }


  // TC_300
  test("TC_300", Include) {

    checkAnswer(s"""select Activecity,ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where  ActiveProvince='Guangdong Province' group by Activecity,ActiveProvince order by total desc""",
      s"""select Activecity,ActiveProvince,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where  ActiveProvince='Guangdong Province' group by Activecity,ActiveProvince order by total desc""", "QueriesBasicTestCase_TC_300")

  }


  // TC_301
  test("TC_301", Include) {

    checkAnswer(s"""select ActiveOperatorId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by Activecity,ActiveOperatorId""",
      s"""select ActiveOperatorId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by Activecity,ActiveOperatorId""", "QueriesBasicTestCase_TC_301")

  }


  // TC_302
  test("TC_302", Include) {

    checkAnswer(s"""select ActiveOperatorId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where  ActiveAreaId='6' and ActiveOperatorId='100004' group by ActiveOperatorId,Activecity order by total desc""",
      s"""select ActiveOperatorId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where  ActiveAreaId='6' and ActiveOperatorId='100004' group by ActiveOperatorId,Activecity order by total desc""", "QueriesBasicTestCase_TC_302")

  }


  // TC_303
  test("TC_303", Include) {

    checkAnswer(s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation  group by Activecity,ActiveAreaId""",
      s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive  group by Activecity,ActiveAreaId""", "QueriesBasicTestCase_TC_303")

  }


  // TC_304
  test("TC_304", Include) {

    checkAnswer(s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where  ActiveAreaId='6' group by Activecity,ActiveAreaId order by total desc""",
      s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where  ActiveAreaId='6' group by Activecity,ActiveAreaId order by total desc""", "QueriesBasicTestCase_TC_304")

  }


  // TC_305
  test("TC_305", Include) {

    checkAnswer(s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation  group by Activecity,ActiveAreaId""",
      s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive  group by Activecity,ActiveAreaId""", "QueriesBasicTestCase_TC_305")

  }


  // TC_306
  test("TC_306", Include) {

    checkAnswer(s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation where  ActiveOperatorId in('100000','100004') group by Activecity,ActiveAreaId order by total desc""",
      s"""select ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive where  ActiveOperatorId in('100000','100004') group by Activecity,ActiveAreaId order by total desc""", "QueriesBasicTestCase_TC_306")

  }


  // TC_307
  test("TC_307", Include) {

    checkAnswer(s"""select ActiveOperatorId,ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation group by ActiveOperatorId,Activecity,ActiveAreaId""",
      s"""select ActiveOperatorId,ActiveAreaId,Activecity,count(distinct AMSize) as AMSize_number,sum(gamePointId+contractNumber) as total from Carbon_automation_hive group by ActiveOperatorId,Activecity,ActiveAreaId""", "QueriesBasicTestCase_TC_307")

  }


  // TC_308
  test("TC_308", Include) {

    sql(s"""select t2.AMSize,t1.Activecity,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation t1, Carbon_automation t2 where t1.AMSize=t2.AMSize group by t1.Activecity,t2.AMSize""").collect

  }


  // TC_309
  test("TC_309", Include) {

    checkAnswer(s"""select t2.AMSize,t1.Activecity,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation t1, Carbon_automation t2 where t1.ActiveOperatorId='100004' and t1.AMSize=t2.AMSize group by t1.Activecity,t2.AMSize""",
      s"""select t2.AMSize,t1.Activecity,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation_hive t1, Carbon_automation_hive t2 where t1.ActiveOperatorId='100004' and t1.AMSize=t2.AMSize group by t1.Activecity,t2.AMSize""", "QueriesBasicTestCase_TC_309")

  }


  // TC_310
  test("TC_310", Include) {

    checkAnswer(s"""select t2.AMSize,t1.Activecity,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation t1, Carbon_automation t2 where t1.ActiveOperatorId='100004' and t1.AMSize=t2.AMSize group by t1.Activecity,t2.AMSize order by total desc""",
      s"""select t2.AMSize,t1.Activecity,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation_hive t1, Carbon_automation_hive t2 where t1.ActiveOperatorId='100004' and t1.AMSize=t2.AMSize group by t1.Activecity,t2.AMSize order by total desc""", "QueriesBasicTestCase_TC_310")

  }


  // TC_311
  test("TC_311", Include) {

    checkAnswer(s"""select t2.AMSize,t1.ActiveAreaId,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation t1, Carbon_automation t2 where t1.AMSize=t2.AMSize group by t1.ActiveAreaId,t2.AMSize""",
      s"""select t2.AMSize,t1.ActiveAreaId,count(t1.AMSize) as AMSize_number,sum(t1.gamePointId+t1.contractNumber) as total from Carbon_automation_hive t1, Carbon_automation_hive t2 where t1.AMSize=t2.AMSize group by t1.ActiveAreaId,t2.AMSize""", "QueriesBasicTestCase_TC_311")

  }


  // TC_312
  ignore("TC_312", Include) {

    checkAnswer(s"""select ActiveOperatorId, sum(imeiupdown) as total, count(distinct AMSize) as AMSize_count from (select AMSize, t1.gamePointId+t1.contractNumber as imeiupdown, if((t1.gamePointId+t1.contractNumber)>100, '>50', if((t1.gamePointId+t1.contractNumber)>100,'50~10',if((t1.gamePointId+t1.contractNumber)>100, '10~1','<1'))) as ActiveOperatorId from Carbon_automation t1) t2 group by ActiveOperatorId""",
      s"""select ActiveOperatorId, sum(imeiupdown) as total, count(distinct AMSize) as AMSize_count from (select AMSize, t1.gamePointId+t1.contractNumber as imeiupdown, if((t1.gamePointId+t1.contractNumber)>100, '>50', if((t1.gamePointId+t1.contractNumber)>100,'50~10',if((t1.gamePointId+t1.contractNumber)>100, '10~1','<1'))) as ActiveOperatorId from Carbon_automation_hive t1) t2 group by ActiveOperatorId""", "QueriesBasicTestCase_TC_312")

  }


  // TC_314
  test("TC_314", Include) {

    checkAnswer(s"""SELECT AMSize, ActiveAreaId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation) SUB_QRY WHERE AMSize BETWEEN "0RAM size" AND "1RAM size" GROUP BY AMSize, ActiveAreaId ORDER BY AMSize ASC, ActiveAreaId ASC
  """,
      s"""SELECT AMSize, ActiveAreaId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation_hive) SUB_QRY WHERE AMSize BETWEEN "0RAM size" AND "1RAM size" GROUP BY AMSize, ActiveAreaId ORDER BY AMSize ASC, ActiveAreaId ASC
  """, "QueriesBasicTestCase_TC_314")

  }


  // TC_315
  test("TC_315", Include) {

    checkAnswer(s"""SELECT AMSize, ActiveAreaId, imei FROM (select * from Carbon_automation) SUB_QRY WHERE  Latest_DAY BETWEEN 1 AND 1""",
      s"""SELECT AMSize, ActiveAreaId, imei FROM (select * from Carbon_automation_hive) SUB_QRY WHERE  Latest_DAY BETWEEN 1 AND 1""", "QueriesBasicTestCase_TC_315")

  }


  // TC_316
  test("TC_316", Include) {

    checkAnswer(s"""select series,gamepointid from Carbon_automation where gamepointid between 1407 and 1407""",
      s"""select series,gamepointid from Carbon_automation_hive where gamepointid between 1407 and 1407""", "QueriesBasicTestCase_TC_316")

  }


  // TC_317
  test("TC_317", Include) {

    checkAnswer(s"""select channelsId from Carbon_automation order by  channelsId""",
      s"""select channelsId from Carbon_automation_hive order by  channelsId""", "QueriesBasicTestCase_TC_317")

  }


  // TC_318
  test("TC_318", Include) {

    checkAnswer(s"""select count(series),series from Carbon_automation group by series having series='6Series'""",
      s"""select count(series),series from Carbon_automation_hive group by series having series='6Series'""", "QueriesBasicTestCase_TC_318")

  }


  // TC_319
  test("TC_319", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""",
      s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""", "QueriesBasicTestCase_TC_319")

  }


  // TC_320
  test("TC_320", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE gamePointId > 1.0E9 GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""",
      s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE gamePointId > 1.0E9 GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""", "QueriesBasicTestCase_TC_320")

  }


  // TC_321
  test("TC_321", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE imei = "1AA100000" GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""",
      s"""SELECT ActiveCountry, ActiveDistrict, Activecity, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei = "1AA100000" GROUP BY ActiveCountry, ActiveDistrict, Activecity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, Activecity ASC""", "QueriesBasicTestCase_TC_321")

  }


  // TC_322
  test("TC_322", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series = "5Series" GROUP BY ActiveCountry, ActiveDistrict, deliveryCity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""",
      s"""SELECT ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series = "5Series" GROUP BY ActiveCountry, ActiveDistrict, deliveryCity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_322")

  }


  // TC_323
  test("TC_323", Include) {

    checkAnswer(s"""SELECT ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity = "zhuzhou" GROUP BY ActiveCountry, ActiveDistrict, deliveryCity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""",
      s"""SELECT ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity = "zhuzhou" GROUP BY ActiveCountry, ActiveDistrict, deliveryCity ORDER BY ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_323")

  }


  // TC_324
  test("TC_324", Include) {

    checkAnswer(s"""SELECT modelId, ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE modelId > "2000" GROUP BY modelId, ActiveCountry, ActiveDistrict, deliveryCity ORDER BY modelId ASC, ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""",
      s"""SELECT modelId, ActiveCountry, ActiveDistrict, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE modelId > "2000" GROUP BY modelId, ActiveCountry, ActiveDistrict, deliveryCity ORDER BY modelId ASC, ActiveCountry ASC, ActiveDistrict ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_324")

  }


  // TC_325
  test("TC_325", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE modelId > "2000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE modelId > "2000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_325")

  }


  // TC_326
  test("TC_326", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_326")

  }


  // TC_327
  test("TC_327", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, COUNT(Latest_YEAR) AS Count_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, COUNT(Latest_YEAR) AS Count_Latest_YEAR, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_327")

  }


  // TC_328
  test("TC_328", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, Latest_YEAR, gamePointId FROM (select * from Carbon_automation) SUB_QRY WHERE imei >= "1AA1000000" ORDER BY imei, deliveryCity, series, Latest_YEAR, gamePointId""",
      s"""SELECT imei, deliveryCity, series, Latest_YEAR, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei >= "1AA1000000" ORDER BY imei, deliveryCity, series, Latest_YEAR, gamePointId""", "QueriesBasicTestCase_TC_328")

  }


  // TC_329
  test("TC_329", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(gamePointId) AS Sum_gamePointId, COUNT(Latest_DAY) AS Count_Latest_DAY FROM (select * from Carbon_automation) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(gamePointId) AS Sum_gamePointId, COUNT(Latest_DAY) AS Count_Latest_DAY FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei >= "1AA1000000" GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_329")

  }


  // TC_330
  test("TC_330", Include) {

    checkAnswer(s"""SELECT deliveryCity, channelsId, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation) SUB_QRY GROUP BY deliveryCity, channelsId ORDER BY deliveryCity ASC, channelsId ASC""",
      s"""SELECT deliveryCity, channelsId, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY deliveryCity, channelsId ORDER BY deliveryCity ASC, channelsId ASC""", "QueriesBasicTestCase_TC_330")

  }


  // TC_331
  test("TC_331", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, AVG(gamePointId) AS Avg_gamePointId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation) SUB_QRY GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, AVG(gamePointId) AS Avg_gamePointId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_331")

  }


  // TC_332
  test("TC_332", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId, SUM(gamepointid) AS Sum_gamepointid, COUNT(series) AS Count_series FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId, SUM(gamepointid) AS Sum_gamepointid, COUNT(series) AS Count_series FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_332")

  }


  // TC_333
  test("TC_333", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId, SUM(gamepointid) AS Sum_gamepointid, COUNT(DISTINCT series) AS DistinctCount_series FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, SUM(Latest_DAY) AS Sum_Latest_DAY, SUM(Latest_MONTH) AS Sum_Latest_MONTH, SUM(contractNumber) AS Sum_contractNumber, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId, SUM(gamepointid) AS Sum_gamepointid, COUNT(DISTINCT series) AS DistinctCount_series FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_333")

  }


  // TC_334
  test("TC_334", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series = "7Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series = "7Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_334")

  }


  // TC_335
  test("TC_335", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series > "5Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series > "5Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_335")

  }


  // TC_336
  test("TC_336", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series >= "4Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series >= "4Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_336")

  }


  // TC_337
  test("TC_337", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series < "3Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series < "3Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_337")

  }


  // TC_338
  test("TC_338", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE series <= "5Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE series <= "5Series" GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_338")

  }


  // TC_339
  test("TC_339", Include) {

    checkAnswer(s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity LIKE '%wuhan%' GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""",
      s"""SELECT series, imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity LIKE '%wuhan%' GROUP BY series, imei, deliveryCity ORDER BY series ASC, imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_339")

  }


  // TC_340
  test("TC_340", Include) {

    checkAnswer(s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(gamepointid > 2000.0)""",
      s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(gamepointid > 2000.0)""", "QueriesBasicTestCase_TC_340")

  }


  // TC_341
  test("TC_341", Include) {

    checkAnswer(s"""SELECT gamePointId, deviceInformationId, Latest_YEAR, series, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE imei = "1AA10000"""",
      s"""SELECT gamePointId, deviceInformationId, Latest_YEAR, series, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE imei = "1AA10000"""", "QueriesBasicTestCase_TC_341")

  }


  // TC_342
  test("TC_342", Include) {

    checkAnswer(s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(gamepointid = 1600)""",
      s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(gamepointid = 1600)""", "QueriesBasicTestCase_TC_342")

  }


  // TC_343
  test("TC_343", Include) {

    checkAnswer(s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE deliverycity IS NULL""",
      s"""SELECT latest_year, latest_day, imei, gamepointid, deviceinformationid, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliverycity IS NULL""", "QueriesBasicTestCase_TC_343")

  }


  // TC_344
  test("TC_344", Include) {

    checkAnswer(s"""SELECT gamePointId, deviceInformationId, Latest_YEAR, series, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity LIKE 'wu%'""",
      s"""SELECT gamePointId, deviceInformationId, Latest_YEAR, series, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity LIKE 'wu%'""", "QueriesBasicTestCase_TC_344")

  }


  // TC_345
  test("TC_345", Include) {

    checkAnswer(s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(imei LIKE '%1AA10%')""",
      s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(imei LIKE '%1AA10%')""", "QueriesBasicTestCase_TC_345")

  }


  // TC_346
  test("TC_346", Include) {

    checkAnswer(s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE gamepointid BETWEEN 1015 AND 1080""",
      s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE gamepointid BETWEEN 1015 AND 1080""", "QueriesBasicTestCase_TC_346")

  }


  // TC_347
  test("TC_347", Include) {

    checkAnswer(s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation) SUB_QRY WHERE deviceinformationid = 100031""",
      s"""SELECT gamepointid, deviceinformationid, latest_year, series, imei, deliverycity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deviceinformationid = 100031""", "QueriesBasicTestCase_TC_347")

  }


  // TC_348
  test("TC_348", Include) {

    checkAnswer(s"""SELECT latest_year, gamepointid FROM (select * from Carbon_automation) SUB_QRY""",
      s"""SELECT latest_year, gamepointid FROM (select * from Carbon_automation_hive) SUB_QRY""", "QueriesBasicTestCase_TC_348")

  }


  // TC_349
  test("TC_349", Include) {

    checkAnswer(s"""SELECT latest_year, gamepointid FROM (select * from Carbon_automation) SUB_QRY WHERE gamepointid BETWEEN 200.0 AND 300.0""",
      s"""SELECT latest_year, gamepointid FROM (select * from Carbon_automation_hive) SUB_QRY WHERE gamepointid BETWEEN 200.0 AND 300.0""", "QueriesBasicTestCase_TC_349")

  }


  // TC_350
  test("TC_350", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(deliveryCity = "wuhan") GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""",
      s"""SELECT imei, deliveryCity, SUM(gamePointId) AS Sum_gamePointId, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(deliveryCity = "wuhan") GROUP BY imei, deliveryCity ORDER BY imei ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_350")

  }


  // TC_351
  test("TC_351", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity IN ("changsha")""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity IN ("changsha")""", "QueriesBasicTestCase_TC_351")

  }


  // TC_352
  test("TC_352", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity IS NOT NULL""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity IS NOT NULL""", "QueriesBasicTestCase_TC_352")

  }


  // TC_353
  test("TC_353", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(deliveryCity IN ("guangzhou","changsha"))""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(deliveryCity IN ("guangzhou","changsha"))""", "QueriesBasicTestCase_TC_353")

  }


  // TC_354
  test("TC_354", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(imei BETWEEN "1AA100" AND "1AA10000")""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(imei BETWEEN "1AA100" AND "1AA10000")""", "QueriesBasicTestCase_TC_354")

  }


  // TC_355
  test("TC_355", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(series BETWEEN "2Series" AND "5Series")""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(series BETWEEN "2Series" AND "5Series")""", "QueriesBasicTestCase_TC_355")

  }


  // TC_356
  test("TC_356", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(gamePointId >= 1000.0)""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(gamePointId >= 1000.0)""", "QueriesBasicTestCase_TC_356")

  }


  // TC_357
  test("TC_357", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(gamePointId < 500.0)""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(gamePointId < 500.0)""", "QueriesBasicTestCase_TC_357")

  }


  // TC_358
  test("TC_358", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(gamePointId <= 600.0)""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(gamePointId <= 600.0)""", "QueriesBasicTestCase_TC_358")

  }


  // TC_359
  test("TC_359", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(deliveryCity LIKE '%wuhan%')""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(deliveryCity LIKE '%wuhan%')""", "QueriesBasicTestCase_TC_359")

  }


  // TC_360
  test("TC_360", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE NOT(deliveryCity LIKE 'wu%')""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE NOT(deliveryCity LIKE 'wu%')""", "QueriesBasicTestCase_TC_360")

  }


  // TC_361
  test("TC_361", Include) {

    checkAnswer(s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation) SUB_QRY WHERE deliveryCity IN ("changsha")""",
      s"""SELECT gamePointId, Latest_YEAR, deviceInformationId, imei, deliveryCity, series FROM (select * from Carbon_automation_hive) SUB_QRY WHERE deliveryCity IN ("changsha")""", "QueriesBasicTestCase_TC_361")

  }


  // TC_362
  test("TC_362", Include) {

    checkAnswer(s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation) SUB_QRY""",
      s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY""", "QueriesBasicTestCase_TC_362")

  }


  // TC_363
  test("TC_363", Include) {

    checkAnswer(s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation) SUB_QRY ORDER BY deviceInformationId ASC""",
      s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ORDER BY deviceInformationId ASC""", "QueriesBasicTestCase_TC_363")

  }


  // TC_364
  test("TC_364", Include) {

    checkAnswer(s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation) SUB_QRY ORDER BY deviceInformationId DESC""",
      s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ORDER BY deviceInformationId DESC""", "QueriesBasicTestCase_TC_364")

  }


  // TC_365
  test("TC_365", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_365")

  }


  // TC_366
  test("TC_366", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, AVG(deviceInformationId) AS Avg_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, AVG(deviceInformationId) AS Avg_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_366")

  }


  // TC_367
  test("TC_367", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, COUNT(deviceInformationId) AS Count_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, COUNT(deviceInformationId) AS Count_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_367")

  }


  // TC_368
  test("TC_368", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, COUNT(DISTINCT deviceInformationId) AS LONG_COL_0, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, COUNT(DISTINCT deviceInformationId) AS LONG_COL_0, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_368")

  }


  // TC_369
  test("TC_369", Include) {

    checkAnswer(s"""SELECT series, gamePointId, deviceInformationId, Latest_YEAR, imei, deliveryCity FROM (select * from Carbon_automation) SUB_QRY ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT series, gamePointId, deviceInformationId, Latest_YEAR, imei, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_369")

  }


  // TC_370
  test("TC_370", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, MAX(deviceInformationId) AS Max_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, MAX(deviceInformationId) AS Max_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_370")

  }


  // TC_371
  test("TC_371", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, MIN(deviceInformationId) AS Min_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, MIN(deviceInformationId) AS Min_deviceInformationId, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_371")

  }


  // TC_372
  test("TC_372", Include) {

    checkAnswer(s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation) SUB_QRY ORDER BY gamePointId ASC""",
      s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ORDER BY gamePointId ASC""", "QueriesBasicTestCase_TC_372")

  }


  // TC_373
  test("TC_373", Include) {

    checkAnswer(s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation) SUB_QRY ORDER BY gamePointId DESC""",
      s"""SELECT Latest_YEAR, deviceInformationId, imei, deliveryCity, series, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ORDER BY gamePointId DESC""", "QueriesBasicTestCase_TC_373")

  }


  // TC_374
  test("TC_374", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, AVG(gamePointId) AS Avg_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, AVG(gamePointId) AS Avg_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_374")

  }


  // TC_375
  test("TC_375", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(gamePointId) AS Count_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(gamePointId) AS Count_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_375")

  }


  // TC_376
  test("TC_376", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT gamePointId) AS DistinctCount_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT gamePointId) AS DistinctCount_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_376")

  }


  // TC_377
  test("TC_377", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MAX(gamePointId) AS Max_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MAX(gamePointId) AS Max_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_377")

  }


  // TC_378
  test("TC_378", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei ASC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_378")

  }


  // TC_379
  test("TC_379", Include) {

    checkAnswer(s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei DESC, deliveryCity ASC, series ASC""",
      s"""SELECT imei, deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, deliveryCity, series ORDER BY imei DESC, deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_379")

  }


  // TC_380
  test("TC_380", Include) {

    checkAnswer(s"""SELECT deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(imei) AS Count_imei, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY deliveryCity, series ORDER BY deliveryCity ASC, series ASC""",
      s"""SELECT deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(imei) AS Count_imei, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY deliveryCity, series ORDER BY deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_380")

  }


  // TC_381
  test("TC_381", Include) {

    checkAnswer(s"""SELECT deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT imei) AS DistinctCount_imei, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY deliveryCity, series ORDER BY deliveryCity ASC, series ASC""",
      s"""SELECT deliveryCity, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR, SUM(deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT imei) AS DistinctCount_imei, MIN(gamePointId) AS Min_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY deliveryCity, series ORDER BY deliveryCity ASC, series ASC""", "QueriesBasicTestCase_TC_381")

  }


  // TC_382
  test("TC_382", Include) {

    checkAnswer(s"""SELECT deliveryCity, Latest_YEAR, imei, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation) SUB_QRY GROUP BY deliveryCity, Latest_YEAR, imei ORDER BY deliveryCity ASC, Latest_YEAR ASC, imei ASC""",
      s"""SELECT deliveryCity, Latest_YEAR, imei, SUM(gamePointId) AS Sum_gamePointId, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY deliveryCity, Latest_YEAR, imei ORDER BY deliveryCity ASC, Latest_YEAR ASC, imei ASC""", "QueriesBasicTestCase_TC_382")

  }


  // TC_383
  test("TC_383", Include) {

    checkAnswer(s"""SELECT deliveryCity, imei, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation) SUB_QRY GROUP BY deliveryCity, imei, series ORDER BY deliveryCity ASC, imei ASC, series ASC""",
      s"""SELECT deliveryCity, imei, series, SUM(Latest_YEAR) AS Sum_Latest_YEAR FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY deliveryCity, imei, series ORDER BY deliveryCity ASC, imei ASC, series ASC""", "QueriesBasicTestCase_TC_383")

  }


  // TC_384
  test("TC_384", Include) {

    checkAnswer(s"""SELECT series, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation) SUB_QRY GROUP BY series ORDER BY series ASC""",
      s"""SELECT series, SUM(gamePointId) AS Sum_gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY series ORDER BY series ASC""", "QueriesBasicTestCase_TC_384")

  }


  // TC_386
  test("TC_386", Include) {

    checkAnswer(s"""SELECT channelsId, deliveryCity FROM (select * from Carbon_automation) SUB_QRY GROUP BY channelsId, deliveryCity ORDER BY channelsId ASC, deliveryCity ASC""",
      s"""SELECT channelsId, deliveryCity FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY channelsId, deliveryCity ORDER BY channelsId ASC, deliveryCity ASC""", "QueriesBasicTestCase_TC_386")

  }


  // TC_387
  test("TC_387", Include) {

    checkAnswer(s"""SELECT modelId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation) SUB_QRY GROUP BY modelId ORDER BY modelId ASC""",
      s"""SELECT modelId, SUM(gamepointid) AS Sum_gamepointid FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY modelId ORDER BY modelId ASC""", "QueriesBasicTestCase_TC_387")

  }


  // TC_388
  test("TC_388", Include) {

    checkAnswer(s"""SELECT imei, channelsId, COUNT(deliveryTime) AS Count_deliveryTime FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei, channelsId ORDER BY imei ASC, channelsId ASC""",
      s"""SELECT imei, channelsId, COUNT(deliveryTime) AS Count_deliveryTime FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei, channelsId ORDER BY imei ASC, channelsId ASC""", "QueriesBasicTestCase_TC_388")

  }


  // TC_389
  test("TC_389", Include) {

    checkAnswer(s"""SELECT imei, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation) SUB_QRY GROUP BY imei ORDER BY imei ASC""",
      s"""SELECT imei, SUM(deviceInformationId) AS Sum_deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY GROUP BY imei ORDER BY imei ASC""", "QueriesBasicTestCase_TC_389")

  }


  // TC_390
  test("TC_390", Include) {

    checkAnswer(s"""select Latest_DAY,imei,gamepointid  from carbon_automation where ( Latest_DAY+1) == 2 order by imei limit 5""",
      s"""select Latest_DAY,imei,gamepointid  from carbon_automation_hive where ( Latest_DAY+1) == 2 order by imei limit 5""", "QueriesBasicTestCase_TC_390")

  }


  // TC_391
  test("TC_391", Include) {

    checkAnswer(s"""select gamepointid,imei from carbon_automation where ( gamePointId+1) == 80 order by imei limit 5""",
      s"""select gamepointid,imei from carbon_automation_hive where ( gamePointId+1) == 80 order by imei limit 5""", "QueriesBasicTestCase_TC_391")

  }


  // TC_392
  test("TC_392", Include) {

    checkAnswer(s"""select deviceInformationId,imei from carbon_automation where ( deviceInformationId+1) == 100084 order by imei limit 5""",
      s"""select deviceInformationId,imei from carbon_automation_hive where ( deviceInformationId+1) == 100084 order by imei limit 5""", "QueriesBasicTestCase_TC_392")

  }


  // TC_393
  test("TC_393", Include) {

    checkAnswer(s"""select channelsId,imei from carbon_automation where ( channelsId+1) == 5 order by imei limit 5""",
      s"""select channelsId,imei from carbon_automation_hive where ( channelsId+1) == 5 order by imei limit 5""", "QueriesBasicTestCase_TC_393")

  }


  // TC_394
  test("TC_394", Include) {

    checkAnswer(s"""select contractNumber,imei from carbon_automation where (contractNumber+1) == 507230.0 order by imei limit 5""",
      s"""select contractNumber,imei from carbon_automation_hive where (contractNumber+1) == 507230.0 order by imei limit 5""", "QueriesBasicTestCase_TC_394")

  }


  // TC_395
  test("TC_395", Include) {

    checkAnswer(s"""select  Latest_YEAR,imei from carbon_automation where ( Latest_YEAR+1) == 2016 order by imei limit 5""",
      s"""select  Latest_YEAR,imei from carbon_automation_hive where ( Latest_YEAR+1) == 2016 order by imei limit 5""", "QueriesBasicTestCase_TC_395")

  }


  // TC_396
  test("TC_396", Include) {

    checkAnswer(s"""select Latest_province,imei from carbon_automation where UPPER(Latest_province) == 'GUANGDONG PROVINCE' order by imei limit 5""",
      s"""select Latest_province,imei from carbon_automation_hive where UPPER(Latest_province) == 'GUANGDONG PROVINCE' order by imei limit 5""", "QueriesBasicTestCase_TC_396")

  }


  // TC_397
  test("TC_397", Include) {

    checkAnswer(s"""select Latest_DAY,imei from carbon_automation where UPPER(Latest_DAY) == '1' order by imei limit 5""",
      s"""select Latest_DAY,imei from carbon_automation_hive where UPPER(Latest_DAY) == '1' order by imei limit 5""", "QueriesBasicTestCase_TC_397")

  }


  // TC_398
  test("TC_398", Include) {

    checkAnswer(s"""select Latest_DAY,imei from carbon_automation where LOWER(Latest_DAY) == '1' order by imei limit 5""",
      s"""select Latest_DAY,imei from carbon_automation_hive where LOWER(Latest_DAY) == '1' order by imei limit 5""", "QueriesBasicTestCase_TC_398")

  }


  // TC_399
  test("TC_399", Include) {

    checkAnswer(s"""select deviceInformationId,imei from carbon_automation where UPPER(deviceInformationId) == '1' order by imei limit 5""",
      s"""select deviceInformationId,imei from carbon_automation_hive where UPPER(deviceInformationId) == '1' order by imei limit 5""", "QueriesBasicTestCase_TC_399")

  }


  // TC_400
  test("TC_400", Include) {

    checkAnswer(s"""select deviceInformationId,imei from carbon_automation where LOWER(deviceInformationId) == '1' order by imei limit 5""",
      s"""select deviceInformationId,imei from carbon_automation_hive where LOWER(deviceInformationId) == '1' order by imei limit 5""", "QueriesBasicTestCase_TC_400")

  }


  // TC_401
  test("TC_401", Include) {

    checkAnswer(s"""select channelsId,imei from carbon_automation where UPPER(channelsId) == '4' order by imei limit 5""",
      s"""select channelsId,imei from carbon_automation_hive where UPPER(channelsId) == '4' order by imei limit 5""", "QueriesBasicTestCase_TC_401")

  }


  // TC_402
  test("TC_402", Include) {

    checkAnswer(s"""select channelsId,imei from carbon_automation where LOWER(channelsId) == '4' order by imei limit 5""",
      s"""select channelsId,imei from carbon_automation_hive where LOWER(channelsId) == '4' order by imei limit 5""", "QueriesBasicTestCase_TC_402")

  }


  // TC_403
  test("TC_403", Include) {

    checkAnswer(s"""select gamePointId,imei from carbon_automation where UPPER(gamePointId) == '136.0' order by imei limit 5""",
      s"""select gamePointId,imei from carbon_automation_hive where UPPER(gamePointId) == '136.0' order by imei limit 5""", "QueriesBasicTestCase_TC_403")

  }


  // TC_404
  test("TC_404", Include) {

    checkAnswer(s"""select gamePointId,imei from carbon_automation where LOWER(gamePointId) == '136.0' order by imei limit 5""",
      s"""select gamePointId,imei from carbon_automation_hive where LOWER(gamePointId) == '136.0' order by imei limit 5""", "QueriesBasicTestCase_TC_404")

  }


  // TC_405
  test("TC_405", Include) {

    checkAnswer(s"""select imei from carbon_automation where UPPER(imei) == '1AA100083' order by imei limit 5""",
      s"""select imei from carbon_automation_hive where UPPER(imei) == '1AA100083' order by imei limit 5""", "QueriesBasicTestCase_TC_405")

  }


  // TC_406
  test("TC_406", Include) {

    checkAnswer(s"""select imei from carbon_automation where LOWER(imei) == '1aa100083' order by imei limit 5""",
      s"""select imei from carbon_automation_hive where LOWER(imei) == '1aa100083' order by imei limit 5""", "QueriesBasicTestCase_TC_406")

  }


  // TC_407
  test("TC_407", Include) {

    checkAnswer(s"""select MAC,imei from carbon_automation where UPPER(MAC)='MAC' order by imei limit 10""",
      s"""select MAC,imei from carbon_automation_hive where UPPER(MAC)='MAC' order by imei limit 10""", "QueriesBasicTestCase_TC_407")

  }


  // TC_408
  test("TC_408", Include) {

    checkAnswer(s"""select imei,series from carbon_automation where series='7Series' order by imei limit 10""",
      s"""select imei,series from carbon_automation_hive where series='7Series' order by imei limit 10""", "QueriesBasicTestCase_TC_408")

  }


  // TC_409
  test("TC_409", Include) {

    checkAnswer(s"""select  gamePointId from carbon_automation where  modelId is  null                                 """,
      s"""select  gamePointId from carbon_automation_hive where  modelId is  null                                 """, "QueriesBasicTestCase_TC_409")

  }


  // TC_410
  test("TC_410", Include) {

    checkAnswer(s"""select  contractNumber from carbon_automation where bomCode is  null                """,
      s"""select  contractNumber from carbon_automation_hive where bomCode is  null                """, "QueriesBasicTestCase_TC_410")

  }


  // TC_411
  test("TC_411", Include) {

    checkAnswer(s"""select  imei from carbon_automation where AMSIZE is  null""",
      s"""select  imei from carbon_automation_hive where AMSIZE is  null""", "QueriesBasicTestCase_TC_411")

  }


  // TC_412
  test("TC_412", Include) {

    checkAnswer(s"""select  bomCode from carbon_automation where contractnumber is  null """,
      s"""select  bomCode from carbon_automation_hive where contractnumber is  null """, "QueriesBasicTestCase_TC_412")

  }


  // TC_413
  test("TC_413", Include) {

    checkAnswer(s"""select  latest_day from carbon_automation where  modelId is  null""",
      s"""select  latest_day from carbon_automation_hive where  modelId is  null""", "QueriesBasicTestCase_TC_413")

  }


  // TC_414
  test("TC_414", Include) {

    checkAnswer(s"""select  latest_day from carbon_automation where  deviceinformationid is  null""",
      s"""select  latest_day from carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_414")

  }


  // TC_415
  test("TC_415", Include) {

    checkAnswer(s"""select  deviceinformationid from carbon_automation where  modelId is  null""",
      s"""select  deviceinformationid from carbon_automation_hive where  modelId is  null""", "QueriesBasicTestCase_TC_415")

  }


  // TC_416
  test("TC_416", Include) {

    checkAnswer(s"""select  deviceinformationid from carbon_automation where  deviceinformationid is  null""",
      s"""select  deviceinformationid from carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_416")

  }


  // TC_417
  test("TC_417", Include) {

    checkAnswer(s"""select  imei from carbon_automation where  modelId is  null""",
      s"""select  imei from carbon_automation_hive where  modelId is  null""", "QueriesBasicTestCase_TC_417")

  }


  // TC_418
  test("TC_418", Include) {

    checkAnswer(s"""select  imei from carbon_automation where  deviceinformationid is  null""",
      s"""select  imei from carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_418")

  }


  // TC_419
  test("TC_419", Include) {

    checkAnswer(s"""select  count(channelsId) from carbon_automation where  modelId is  null""",
      s"""select  count(channelsId) from carbon_automation_hive where  modelId is  null""", "QueriesBasicTestCase_TC_419")

  }


  // TC_420
  test("TC_420", Include) {

    checkAnswer(s"""select  sum(channelsId) from carbon_automation where  deviceinformationid is  null""",
      s"""select  sum(channelsId) from carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_420")

  }


  // TC_421
  test("TC_421", Include) {

    checkAnswer(s"""select  avg(channelsName) from carbon_automation where  modelId is  null""",
      s"""select  avg(channelsName) from carbon_automation_hive where  modelId is  null""", "QueriesBasicTestCase_TC_421")

  }


  // TC_422
  test("TC_422", Include) {

    checkAnswer(s"""select  min(channelsName) from carbon_automation where  deviceinformationid is  null""",
      s"""select  min(channelsName) from carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_422")

  }


  // TC_423
  test("TC_423", Include) {

    checkAnswer(s"""select  max(channelsName) from  carbon_automation where  deviceinformationid is  null""",
      s"""select  max(channelsName) from  carbon_automation_hive where  deviceinformationid is  null""", "QueriesBasicTestCase_TC_423")

  }


  // TC_424
  test("TC_424", Include) {

    checkAnswer(s"""SELECT count(DISTINCT gamePointId) FROM carbon_automation where imei is null """,
      s"""SELECT count(DISTINCT gamePointId) FROM carbon_automation_hive where imei is null """, "QueriesBasicTestCase_TC_424")

  }


  // TC_425
  test("TC_425", Include) {

    checkAnswer(s"""select  imei from carbon_automation where contractNumber is NOT null""",
      s"""select  imei from carbon_automation_hive where contractNumber is NOT null""", "QueriesBasicTestCase_TC_425")

  }


  // TC_426
  test("TC_426", Include) {

    checkAnswer(s"""select  gamePointId from carbon_automation where deviceInformationId is NOT null""",
      s"""select  gamePointId from carbon_automation_hive where deviceInformationId is NOT null""", "QueriesBasicTestCase_TC_426")

  }


  // TC_427
  test("TC_427", Include) {

    checkAnswer(s"""select contractnumber from carbon_automation where AMSIZE is NOT null""",
      s"""select contractnumber from carbon_automation_hive where AMSIZE is NOT null""", "QueriesBasicTestCase_TC_427")

  }


  // TC_428
  test("TC_428", Include) {

    checkAnswer(s"""select gamePointId from carbon_automation where LATEST_YEAR is NOT null""",
      s"""select gamePointId from carbon_automation_hive where LATEST_YEAR is NOT null""", "QueriesBasicTestCase_TC_428")

  }


  // TC_429
  test("TC_429", Include) {

    checkAnswer(s"""select  count(gamePointId) from carbon_automation where imei is NOT null""",
      s"""select  count(gamePointId) from carbon_automation_hive where imei is NOT null""", "QueriesBasicTestCase_TC_429")

  }


  // TC_430
  test("TC_430", Include) {

    checkAnswer(s"""select  count(bomCode) from carbon_automation where contractNumber is NOT null""",
      s"""select  count(bomCode) from carbon_automation_hive where contractNumber is NOT null""", "QueriesBasicTestCase_TC_430")

  }


  // TC_431
  test("TC_431", Include) {

    checkAnswer(s"""select  channelsName from carbon_automation where contractNumber is NOT null""",
      s"""select  channelsName from carbon_automation_hive where contractNumber is NOT null""", "QueriesBasicTestCase_TC_431")

  }


  // TC_432
  test("TC_432", Include) {

    checkAnswer(s"""select  channelsId from carbon_automation where gamePointId is NOT null""",
      s"""select  channelsId from carbon_automation_hive where gamePointId is NOT null""", "QueriesBasicTestCase_TC_432")

  }


  // TC_433
  test("TC_433", Include) {

    checkAnswer(s"""select  channelsName from carbon_automation where gamePointId is NOT null""",
      s"""select  channelsName from carbon_automation_hive where gamePointId is NOT null""", "QueriesBasicTestCase_TC_433")

  }


  // TC_434
  test("TC_434", Include) {

    checkAnswer(s"""select  channelsId from carbon_automation where latest_day is NOT null""",
      s"""select  channelsId from carbon_automation_hive where latest_day is NOT null""", "QueriesBasicTestCase_TC_434")

  }


  // TC_435
  test("TC_435", Include) {

    checkAnswer(s"""select  channelsName from carbon_automation where latest_day is NOT null""",
      s"""select  channelsName from carbon_automation_hive where latest_day is NOT null""", "QueriesBasicTestCase_TC_435")

  }


  // TC_436
  test("TC_436", Include) {

    checkAnswer(s"""SELECT count(DISTINCT gamePointId) FROM  carbon_automation where imei is NOT null  """,
      s"""SELECT count(DISTINCT gamePointId) FROM  carbon_automation_hive where imei is NOT null  """, "QueriesBasicTestCase_TC_436")

  }


  // TC_437
  test("TC_437", Include) {

    checkAnswer(s"""SELECT sum(deviceInformationId) FROM carbon_automation where imei is NOT null""",
      s"""SELECT sum(deviceInformationId) FROM carbon_automation_hive where imei is NOT null""", "QueriesBasicTestCase_TC_437")

  }


  // TC_438
  test("TC_438", Include) {

    checkAnswer(s"""SELECT avg(contractNumber) FROM  carbon_automation  where imei is NOT null    """,
      s"""SELECT avg(contractNumber) FROM  carbon_automation_hive  where imei is NOT null    """, "QueriesBasicTestCase_TC_438")

  }


  // TC_439
  test("TC_439", Include) {

    checkAnswer(s"""SELECT min(AMSize) FROM carbon_automation where imei is NOT null""",
      s"""SELECT min(AMSize) FROM carbon_automation_hive where imei is NOT null""", "QueriesBasicTestCase_TC_439")

  }


  // TC_440
  test("TC_440", Include) {

    checkAnswer(s"""SELECT max(gamePointId) FROM carbon_automation  where contractNumber is NOT null  """,
      s"""SELECT max(gamePointId) FROM carbon_automation_hive  where contractNumber is NOT null  """, "QueriesBasicTestCase_TC_440")

  }


  // TC_441
  test("TC_441", Include) {

    sql(s"""select variance(gamepointid), var_pop(gamepointid)  from carbon_automation where channelsid>2""").collect

  }


  // TC_442
  test("TC_442", Include) {

    sql(s"""select variance(deviceInformationId), var_pop(imei)  from carbon_automation where activeareaid>3""").collect

  }


  // TC_443
  test("TC_443", Include) {

    sql(s"""select variance(contractNumber), var_pop(contractNumber)  from carbon_automation where deliveryareaid>5""").collect

  }


  // TC_444
  ignore("TC_444", Include) {

    checkAnswer(s"""select variance(AMSize), var_pop(channelsid)  from carbon_automation where channelsid>2""",
      s"""select variance(AMSize), var_pop(channelsid)  from carbon_automation_hive where channelsid>2""", "QueriesBasicTestCase_TC_444")

  }


  // TC_445
  test("TC_445", Include) {

    sql(s"""select variance(bomcode), var_pop(gamepointid)  from carbon_automation where activeareaid>3""").collect

  }


  // TC_446
  test("TC_446", Include) {

    sql(s"""select variance(deviceInformationId), var_pop(deviceInformationId)  from carbon_automation where activeareaid>3""").collect

  }


  // TC_447
  test("TC_447", Include) {

    sql(s"""select var_samp(contractNumber) from carbon_automation""").collect

  }


  // TC_448
  ignore("TC_448", Include) {

    checkAnswer(s"""select var_samp(Latest_YEAR) from carbon_automation""",
      s"""select var_samp(Latest_YEAR) from carbon_automation_hive""", "QueriesBasicTestCase_TC_448")

  }


  // TC_449
  test("TC_449", Include) {

    checkAnswer(s"""select var_samp(AMSize) from carbon_automation""",
      s"""select var_samp(AMSize) from carbon_automation_hive""", "QueriesBasicTestCase_TC_449")

  }


  // TC_450
  test("TC_450", Include) {

    sql(s"""select var_samp(gamepointId) from carbon_automation""").collect

  }


  // TC_451
  test("TC_451", Include) {

    sql(s"""select stddev_pop(bomcode)from carbon_automation""").collect

  }


  // TC_452
  test("TC_452", Include) {

    sql(s"""select stddev_pop(deviceInformationId)from carbon_automation""").collect

  }


  // TC_453
  test("TC_453", Include) {

    sql(s"""select stddev_pop(gamePointId)from carbon_automation""").collect

  }


  // TC_454
  test("TC_454", Include) {

    sql(s"""select stddev_pop(AMSIZE)from carbon_automation""").collect

  }


  // TC_455
  test("TC_455", Include) {

    sql(s"""select stddev_pop(contractNumber)from carbon_automation""").collect

  }


  // TC_456
  test("TC_456", Include) {

    sql(s"""select stddev_samp(contractNumber)from carbon_automation""").collect

  }


  // TC_457
  test("TC_457", Include) {

    sql(s"""select stddev_samp(deviceInformationId)from carbon_automation""").collect

  }


  // TC_459
  ignore("TC_459", Include) {

    checkAnswer(s"""select stddev_samp(Latest_MONTH)from carbon_automation""",
      s"""select stddev_samp(Latest_MONTH)from carbon_automation_hive""", "QueriesBasicTestCase_TC_459")

  }


  // TC_460
  test("TC_460", Include) {

    sql(s"""select stddev_samp(contractnumber)from carbon_automation""").collect

  }


  // TC_461
  ignore("TC_461", Include) {

    checkAnswer(s"""select covar_pop(gamePointId, Latest_MONTH) from carbon_automation""",
      s"""select covar_pop(gamePointId, Latest_MONTH) from carbon_automation_hive""", "QueriesBasicTestCase_TC_461")

  }


  // TC_462
  test("TC_462", Include) {

    sql(s"""select covar_pop(gamePointId, contractNumber) from carbon_automation""").collect

  }


  // TC_463
  ignore("TC_463", Include) {

    checkAnswer(s"""select covar_pop(gamePointId, Latest_DAY) from carbon_automation""",
      s"""select covar_pop(gamePointId, Latest_DAY) from carbon_automation_hive""", "QueriesBasicTestCase_TC_463")

  }


  // TC_464
  test("TC_464", Include) {

    sql(s"""select covar_pop(gamePointId,deviceInformationId ) from carbon_automation""").collect

  }


  // TC_465
  ignore("TC_465", Include) {

    checkAnswer(s"""select covar_samp(gamePointId, Latest_MONTH) from carbon_automation""",
      s"""select covar_samp(gamePointId, Latest_MONTH) from carbon_automation_hive""", "QueriesBasicTestCase_TC_465")

  }


  // TC_466
  test("TC_466", Include) {

    sql(s"""select covar_samp(gamePointId, contractNumber) from carbon_automation""").collect

  }


  // TC_467
  ignore("TC_467", Include) {

    checkAnswer(s"""select covar_samp(gamePointId, Latest_DAY) from carbon_automation""",
      s"""select covar_samp(gamePointId, Latest_DAY) from carbon_automation_hive""", "QueriesBasicTestCase_TC_467")

  }


  // TC_468
  ignore("TC_468", Include) {

    checkAnswer(s"""select covar_samp(gamePointId, Latest_YEAR) from carbon_automation""",
      s"""select covar_samp(gamePointId, Latest_YEAR) from carbon_automation_hive""", "QueriesBasicTestCase_TC_468")

  }


  // TC_469
  test("TC_469", Include) {

    sql(s"""select covar_samp(gamePointId, deviceInformationId) from carbon_automation""").collect

  }


  // TC_470
  test("TC_470", Include) {

    sql(s"""select corr(gamePointId, deviceInformationId) from carbon_automation""").collect

  }


  // TC_471
  ignore("TC_471", Include) {

    checkAnswer(s"""select corr(Latest_MONTH, gamePointId) from carbon_automation""",
      s"""select corr(Latest_MONTH, gamePointId) from carbon_automation_hive""", "QueriesBasicTestCase_TC_471")

  }


  // TC_472
  test("TC_472", Include) {

    checkAnswer(s"""Select percentile(1,1.0) from carbon_automation""",
      s"""Select percentile(1,1.0) from carbon_automation_hive""", "QueriesBasicTestCase_TC_472")

  }


  // TC_473
  test("TC_473", Include) {

    checkAnswer(s"""Select percentile(1,1.0) from carbon_automation""",
      s"""Select percentile(1,1.0) from carbon_automation_hive""", "QueriesBasicTestCase_TC_473")

  }


  // TC_474
  test("TC_474", Include) {

    checkAnswer(s"""select cast(series as int) as a from carbon_automation limit 10""",
      s"""select cast(series as int) as a from carbon_automation_hive limit 10""", "QueriesBasicTestCase_TC_474")

  }


  // TC_475
  test("TC_475", Include) {

    sql(s"""select cast(modelid as int) as a from carbon_automation limit 10""").collect

  }


  // TC_476
  test("TC_476", Include) {

    checkAnswer(s"""Select percentile(1,1.0) from carbon_automation""",
      s"""Select percentile(1,1.0) from carbon_automation_hive""", "QueriesBasicTestCase_TC_476")

  }


  // TC_477
  test("TC_477", Include) {

    checkAnswer(s"""select percentile(1,array(1)) from carbon_automation""",
      s"""select percentile(1,array(1)) from carbon_automation_hive""", "QueriesBasicTestCase_TC_477")

  }


  // TC_479
  test("TC_479", Include) {

    sql(s"""select percentile(1,array(0.5)) from carbon_automation""").collect

  }


  // TC_480
  test("TC_480", Include) {

    checkAnswer(s"""select percentile(1,array(1)) from carbon_automation""",
      s"""select percentile(1,array(1)) from carbon_automation_hive""", "QueriesBasicTestCase_TC_480")

  }


  // TC_481
  test("TC_481", Include) {

    checkAnswer(s"""select percentile_approx(1, 0.5 ,5000) from carbon_automation""",
      s"""select percentile_approx(1, 0.5 ,5000) from carbon_automation_hive""", "QueriesBasicTestCase_TC_481")

  }


  // TC_482
  test("TC_482", Include) {

    checkAnswer(s"""select percentile_approx(1, 0.5 ,1000) from carbon_automation""",
      s"""select percentile_approx(1, 0.5 ,1000) from carbon_automation_hive""", "QueriesBasicTestCase_TC_482")

  }


  // TC_483
  test("TC_483", Include) {

    checkAnswer(s"""select percentile_approx(1, 0.5 ,700) from carbon_automation""",
      s"""select percentile_approx(1, 0.5 ,700) from carbon_automation_hive""", "QueriesBasicTestCase_TC_483")

  }


  // TC_484
  test("TC_484", Include) {

    checkAnswer(s"""select percentile_approx(1, 0.5 ,500) from carbon_automation""",
      s"""select percentile_approx(1, 0.5 ,500) from carbon_automation_hive""", "QueriesBasicTestCase_TC_484")

  }


  // TC_485
  test("TC_485", Include) {

    checkAnswer(s"""select percentile_approx(1,array(0.5),5000) from carbon_automation""",
      s"""select percentile_approx(1,array(0.5),5000) from carbon_automation_hive""", "QueriesBasicTestCase_TC_485")

  }


  // TC_486
  test("TC_486", Include) {

    checkAnswer(s"""select percentile_approx(1,array(0.5),5000) from carbon_automation""",
      s"""select percentile_approx(1,array(0.5),5000) from carbon_automation_hive""", "QueriesBasicTestCase_TC_486")

  }


  // TC_487
  test("TC_487", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 5000) as A_hist from carbon_automation) t lateral view explode(A_hist) exploded_table as hist) group by x""",
     s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 5000)as A_hist from carbon_automation_hive) t lateral view explode(A_hist) exploded_table as hist) group by x""", "QueriesBasicTestCase_TC_487")

  }


  // TC_488
  test("TC_488", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 1000) as A_hist from carbon_automation) t lateral view explode(A_hist) exploded_table as hist) group by x""",
      s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 1000)as A_hist from carbon_automation_hive) t lateral view explode(A_hist) exploded_table as hist) group by x""", "QueriesBasicTestCase_TC_488")

  }


  // TC_489
  test("TC_489", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 500) as A_hist from carbon_automation) t lateral view explode(A_hist) exploded_table as hist) group by x""",
      s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 500)as A_hist from carbon_automation_hive) t lateral view explode(A_hist) exploded_table as hist) group by x""", "QueriesBasicTestCase_TC_489")

  }


  // TC_490
  test("TC_490", Include) {

    checkAnswer(s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 100) as A_hist from carbon_automation) t lateral view explode(A_hist) exploded_table as hist) group by x""",
      s"""select sum(y),x from (select cast(hist.x as int) as x, cast(hist.y as bigint) as y from (select histogram_numeric(1, 100)as A_hist from carbon_automation_hive) t lateral view explode(A_hist) exploded_table as hist) group by x""", "QueriesBasicTestCase_TC_490")

  }


  // TC_491
  test("TC_491", Include) {

    sql(s"""select collect_set(gamePointId) from carbon_automation""").collect

  }


  // TC_492
  test("TC_492", Include) {

    sql(s"""select collect_set(AMSIZE) from carbon_automation""").collect

  }


  // TC_493
  test("TC_493", Include) {

    sql(s"""select collect_set(bomcode) from carbon_automation""").collect

  }


  // TC_494
  test("TC_494", Include) {

    sql(s"""select collect_set(imei) from carbon_automation""").collect

  }


  // TC_495
  ignore("TC_495", Include) {

    checkAnswer(s"""select var_samp(Latest_YEAR) from carbon_automation""",
      s"""select var_samp(Latest_YEAR) from carbon_automation_hive""", "QueriesBasicTestCase_TC_495")

  }


  // TC_496
  ignore("TC_496", Include) {

    checkAnswer(s"""select stddev_pop(deviceInformationId)from carbon_automation""",
      s"""select stddev_pop(deviceInformationId)from carbon_automation_hive""", "QueriesBasicTestCase_TC_496")

  }


  // TC_497
  ignore("TC_497", Include) {

    checkAnswer(s"""select stddev_samp(deviceInformationId)from carbon_automation""",
      s"""select stddev_samp(deviceInformationId)from carbon_automation_hive""", "QueriesBasicTestCase_TC_497")

  }


  // TC_498
  test("TC_498", Include) {

    sql(s"""select covar_pop(gamePointId, contractNumber) from carbon_automation""").collect

  }


  // TC_499
  test("TC_499", Include) {

    sql(s"""select covar_samp(gamePointId, contractNumber) from carbon_automation""").collect

  }


  // TC_500
  test("TC_500", Include) {

    checkAnswer(s"""select percentile(1,array(0.5)) from carbon_automation""",
      s"""select percentile(1,array(0.5)) from carbon_automation_hive""", "QueriesBasicTestCase_TC_500")

  }


  // TC_501
  test("TC_501", Include) {

    checkAnswer(s"""select percentile_approx(1,array(0.5),5000) from carbon_automation""",
      s"""select percentile_approx(1,array(0.5),5000) from carbon_automation_hive""", "QueriesBasicTestCase_TC_501")

  }


  // TC_502
  test("TC_502", Include) {

    sql(s"""select collect_set(AMSIZE) from carbon_automation""").collect

  }


  // TC_503
  test("TC_503", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, ActiveDistrict, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize = "1RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, ActiveDistrict, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize = "1RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_503")

  }


  // TC_504
  test("TC_504", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize > "1RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize > "1RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_504")

  }


  // TC_505
  test("TC_505", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize >= "2RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry,Carbon_automation.gamePointId, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize >= "2RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry,Carbon_automation_hive.gamePointId, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_505")

  }


  // TC_506
  test("TC_506", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize < "3RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize < "3RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_506")

  }


  // TC_507
  test("TC_507", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize <= "5RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize <= "5RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_507")

  }


  // TC_508
  test("TC_508", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '%1%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation. gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '%1%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive. gamePointId ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_508")

  }


  // TC_509
  test("TC_509", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_509")

  }


  // TC_510
  test("TC_510", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '5RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '5RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_510")

  }


  // TC_511
  test("TC_511", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize BETWEEN "2RAM size" AND "6RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize BETWEEN "2RAM size" AND "6RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_511")

  }


  // TC_512
  test("TC_512", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IN ("4RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IN ("4RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_512")

  }


  // TC_513
  test("TC_513", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_513")

  }


  // TC_514
  test("TC_514", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize = "8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId  ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize = "8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId  ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_514")

  }


  // TC_515
  test("TC_515", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize > "6RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize > "6RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_515")

  }


  // TC_516
  test("TC_516", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize >= "5RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize >= "5RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_516")

  }


  // TC_517
  test("TC_517", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize < "4RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId  ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize < "4RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId  ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_517")

  }


  // TC_518
  test("TC_518", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize <= "3RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize <= "3RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_518")

  }


  // TC_519
  test("TC_519", Include) {

    checkAnswer(s"""SELECT Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.Activecity ORDER BY Carbon_automation.Activecity ASC LIMIT 5000""",
      s"""SELECT Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.Activecity ASC LIMIT 5000""", "QueriesBasicTestCase_TC_519")

  }


  // TC_520
  test("TC_520", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_520")

  }


  // TC_521
  test("TC_521", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.Activecity LIKE 'xian%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.Activecity LIKE 'xian%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_521")

  }


  // TC_522
  test("TC_522", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_522")

  }


  // TC_523
  test("TC_523", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_523")

  }


  // TC_524
  test("TC_524", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_524")

  }


  // TC_525
  test("TC_525", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize""", "QueriesBasicTestCase_TC_525")

  }


  // TC_526
  test("TC_526", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_526")

  }


  // TC_527
  test("TC_527", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_527")

  }


  // TC_528
  test("TC_528", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_528")

  }


  // TC_529
  test("TC_529", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, AVG(Carbon_automation.deviceInformationId) AS avg_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, AVG(Carbon_automation_hive.deviceInformationId) AS avg_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_529")

  }


  // TC_530
  test("TC_530", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_530")

  }


  // TC_531
  test("TC_531", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_531")

  }


  // TC_532
  test("TC_532", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_532")

  }


  // TC_533
  test("TC_533", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_533")

  }


  // TC_534
  test("TC_534", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_534")

  }


  // TC_535
  test("TC_535", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId ASC""", "QueriesBasicTestCase_TC_535")

  }


  // TC_536
  test("TC_536", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_536")

  }


  // TC_537
  test("TC_537", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_537")

  }


  // TC_538
  test("TC_538", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_538")

  }


  // TC_539
  test("TC_539", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_539")

  }


  // TC_540
  test("TC_540", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_540")

  }


  // TC_541
  test("TC_541", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_541")

  }


  // TC_542
  test("TC_542", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_542")

  }


  // TC_543
  test("TC_543", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_543")

  }


  // TC_544
  test("TC_544", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_544")

  }


  // TC_545
  test("TC_545", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_545")

  }


  // TC_546
  test("TC_546", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_546")

  }


  // TC_547
  test("TC_547", Include) {

    checkAnswer(s"""SELECT Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_547")

  }


  // TC_548
  test("TC_548", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_548")

  }


  // TC_549
  test("TC_549", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_549")

  }


  // TC_550
  test("TC_550", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_550")

  }


  // TC_551
  test("TC_551", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, First(Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_552
  test("TC_552", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_553
  test("TC_553", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, ActiveDistrict,  AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize = "1RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId  ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, ActiveDistrict,  AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize = "1RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId  ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_553")

  }


  // TC_554
  test("TC_554", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize > "1RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize > "1RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_554")

  }


  // TC_555
  test("TC_555", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize >= "2RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry,Carbon_automation.gamePointId, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize >= "2RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry,Carbon_automation_hive.gamePointId, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_555")

  }


  // TC_556
  test("TC_556", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize < "3RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize < "3RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_556")

  }


  // TC_557
  test("TC_557", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize <= "5RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize <= "5RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_557")

  }


  // TC_558
  test("TC_558", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '%1%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation. gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '%1%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive. gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_558")

  }


  // TC_559
  test("TC_559", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_559")

  }


  // TC_560
  test("TC_560", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '5RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '5RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_560")

  }


  // TC_561
  test("TC_561", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize BETWEEN "2RAM size" AND "6RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize BETWEEN "2RAM size" AND "6RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_561")

  }


  // TC_562
  test("TC_562", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IN ("4RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IN ("4RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_562")

  }


  // TC_563
  test("TC_563", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_563")

  }


  // TC_564
  test("TC_564", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize = "8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId  ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize = "8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId  ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_564")

  }


  // TC_565
  test("TC_565", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize > "6RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize > "6RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_565")

  }


  // TC_566
  test("TC_566", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize >= "5RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize >= "5RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_566")

  }


  // TC_567
  test("TC_567", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize < "4RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId  ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize < "4RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId  ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_567")

  }


  // TC_568
  test("TC_568", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize <= "3RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize <= "3RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_568")

  }


  // TC_569
  test("TC_569", Include) {

    checkAnswer(s"""SELECT Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.Activecity ORDER BY Carbon_automation.Activecity ASC LIMIT 5000""",
      s"""SELECT Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.Activecity ASC LIMIT 5000""", "QueriesBasicTestCase_TC_569")

  }


  // TC_570
  test("TC_570", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_570")

  }


  // TC_571
  test("TC_571", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.Activecity LIKE 'xian%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.Activecity LIKE 'xian%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_571")

  }


  // TC_572
  test("TC_572", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_572")

  }


  // TC_573
  test("TC_573", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_573")

  }


  // TC_574
  test("TC_574", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_574")

  }


  // TC_575
  test("TC_575", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize""", "QueriesBasicTestCase_TC_575")

  }


  // TC_576
  test("TC_576", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_576")

  }


  // TC_577
  test("TC_577", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_577")

  }


  // TC_578
  test("TC_578", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_578")

  }


  // TC_579
  test("TC_579", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_579")

  }


  // TC_580
  test("TC_580", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_580")

  }


  // TC_581
  test("TC_581", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_581")

  }


  // TC_582
  test("TC_582", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_582")

  }


  // TC_583
  test("TC_583", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_583")

  }


  // TC_584
  test("TC_584", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_584")

  }


  // TC_585
  test("TC_585", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId ASC""", "QueriesBasicTestCase_TC_585")

  }


  // TC_586
  test("TC_586", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_586")

  }


  // TC_587
  test("TC_587", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_587")

  }


  // TC_588
  test("TC_588", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_588")

  }


  // TC_589
  test("TC_589", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_589")

  }


  // TC_590
  test("TC_590", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_590")

  }


  // TC_591
  test("TC_591", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_591")

  }


  // TC_592
  test("TC_592", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_592")

  }


  // TC_593
  test("TC_593", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_593")

  }


  // TC_594
  test("TC_594", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_594")

  }


  // TC_595
  test("TC_595", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_595")

  }


  // TC_596
  test("TC_596", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_596")

  }


  // TC_597
  test("TC_597", Include) {

    checkAnswer(s"""SELECT Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_597")

  }


  // TC_598
  test("TC_598", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_598")

  }


  // TC_599
  test("TC_599", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_599")

  }


  // TC_600
  test("TC_600", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_600")

  }


  // TC_601
  test("TC_601", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, First(Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_602
  test("TC_602", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_609
  test("TC_609", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_609")

  }


  // TC_610
  test("TC_610", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '5RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId, Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '5RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_610")

  }


  // TC_618
  test("TC_618", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize <= "3RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize <= "3RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_618")

  }


  // TC_619
  test("TC_619", Include) {

    checkAnswer(s"""SELECT Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.Activecity ORDER BY Carbon_automation.Activecity ASC LIMIT 5000""",
      s"""SELECT Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.Activecity ASC LIMIT 5000""", "QueriesBasicTestCase_TC_619")

  }


  // TC_620
  test("TC_620", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_620")

  }


  // TC_621
  test("TC_621", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.Activecity LIKE 'xian%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.Activecity LIKE 'xian%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_621")

  }


  // TC_622
  test("TC_622", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_622")

  }


  // TC_623
  test("TC_623", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_623")

  }


  // TC_624
  test("TC_624", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_624")

  }


  // TC_625
  test("TC_625", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize""", "QueriesBasicTestCase_TC_625")

  }


  // TC_626
  test("TC_626", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_626")

  }


  // TC_627
  test("TC_627", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_627")

  }


  // TC_628
  ignore("TC_628", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_628")

  }


  // TC_629
  ignore("TC_629", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_629")

  }


  // TC_630
  ignore("TC_630", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_630")

  }


  // TC_631
  ignore("TC_631", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_631")

  }


  // TC_632
  test("TC_632", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_632")

  }


  // TC_633
  ignore("TC_633", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_633")

  }


  // TC_634
  ignore("TC_634", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_634")

  }


  // TC_635
  test("TC_635", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId, Carbon_automation.gamePointId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId,Carbon_automation_hive.gamePointId ASC""", "QueriesBasicTestCase_TC_635")

  }


  // TC_636
  test("TC_636", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_636")

  }


  // TC_637
  ignore("TC_637", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_637")

  }


  // TC_638
  test("TC_638", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""").collect

  }


  // TC_639
  test("TC_639", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_639")

  }


  // TC_640
  test("TC_640", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_640")

  }


  // TC_641
  test("TC_641", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_641")

  }


  // TC_642
  test("TC_642", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_642")

  }


  // TC_643
  test("TC_643", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_643")

  }


  // TC_644
  test("TC_644", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_644")

  }


  // TC_645
  test("TC_645", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_645")

  }


  // TC_646
  test("TC_646", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_646")

  }


  // TC_647
  test("TC_647", Include) {

    checkAnswer(s"""SELECT Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_647")

  }


  // TC_648
  test("TC_648", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.deviceInformationId, Carbon_automation.Activecity, Carbon_automation.AMSize""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.Activecity, Carbon_automation_hive.AMSize""", "QueriesBasicTestCase_TC_648")

  }


  // TC_649
  test("TC_649", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_649")

  }


  // TC_650
  ignore("TC_650", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_650")

  }


  // TC_651
  test("TC_651", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, First(Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_652
  test("TC_652", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Right Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_659
  test("TC_659", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.deviceInformationId, Carbon_automation.Activecity, Carbon_automation.AMSize""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize, gamePointId ,deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.Activecity, Carbon_automation_hive.AMSize""", "QueriesBasicTestCase_TC_659")

  }


  // TC_660
  test("TC_660", Include) {

    checkAnswer(s"""SELECT  Carbon_automation.gamePointId AS gamePointId,Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize LIKE '5RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity,Carbon_automation.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity""",
      s"""SELECT  Carbon_automation_hive.gamePointId AS gamePointId,Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize LIKE '5RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity,Carbon_automation_hive.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_660")

  }


  // TC_668
  test("TC_668", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity , SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize <= "3RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity , SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize <= "3RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_668")

  }


  // TC_669
  test("TC_669", Include) {

    checkAnswer(s"""SELECT Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.Activecity ORDER BY Carbon_automation.Activecity ASC LIMIT 5000""",
      s"""SELECT Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.Activecity ASC LIMIT 5000""", "QueriesBasicTestCase_TC_669")

  }


  // TC_670
  test("TC_670", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.AMSize, Carbon_automation.Activecity""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, gamePointId,Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.AMSize, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_670")

  }


  // TC_671
  test("TC_671", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.Activecity LIKE 'xian%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.Activecity LIKE 'xian%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_671")

  }


  // TC_672
  test("TC_672", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "4RAM size" AND "7RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_672")

  }


  // TC_673
  test("TC_673", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_673")

  }


  // TC_674
  test("TC_674", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity,gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_674")

  }


  // TC_675
  test("TC_675", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity,gamePointId, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize""", "QueriesBasicTestCase_TC_675")

  }


  // TC_676
  test("TC_676", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_676")

  }


  // TC_677
  test("TC_677", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT  AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_677")

  }


  // TC_678
  ignore("TC_678", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_678")

  }


  // TC_679
  ignore("TC_679", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_679")

  }


  // TC_680
  ignore("TC_680", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize, ActiveCountry,gamePointId, Activecity,deviceInformationId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_680")

  }


  // TC_681
  test("TC_681", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize, ActiveCountry,gamePointId,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_681")

  }


  // TC_682
  test("TC_682", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.deviceInformationId, Carbon_automation.AMSize, Carbon_automation.Activecity""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.AMSize, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_682")

  }


  // TC_683
  ignore("TC_683", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_683")

  }


  // TC_684
  ignore("TC_684", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_684")

  }


  // TC_685
  test("TC_685", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId, Carbon_automation.gamePointId""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.gamePointId""", "QueriesBasicTestCase_TC_685")

  }


  // TC_686
  test("TC_686", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId, Carbon_automation.gamePointId""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry, deviceInformationId,gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER by Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.gamePointId""", "QueriesBasicTestCase_TC_686")

  }


  // TC_687
  ignore("TC_687", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_687")

  }


  // TC_688
  ignore("TC_688", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_688")

  }


  // TC_689
  test("TC_689", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, gamePointId,ActiveCountry, deviceInformationId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_689")

  }


  // TC_690
  test("TC_690", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize,deviceInformationId,gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_690")

  }


  // TC_691
  test("TC_691", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.AMSize AS AMSize, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.deviceInformationId, Carbon_automation.AMSize, Carbon_automation.Activecity""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.AMSize, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_691")

  }


  // TC_692
  test("TC_692", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_692")

  }


  // TC_693
  test("TC_693", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize,gamePointId,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_693")

  }


  // TC_694
  test("TC_694", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_694")

  }


  // TC_695
  test("TC_695", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, deviceInformationId,gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_695")

  }


  // TC_696
  test("TC_696", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.gamePointId AS gamePointId FROM ( SELECT AMSize, ActiveCountry,deviceInformationId, gamePointId,Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId DESC""", "QueriesBasicTestCase_TC_696")

  }


  // TC_697
  ignore("TC_697", Include) {

    checkAnswer(s"""SELECT Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,deviceInformationId, gamePointId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_697")

  }


  // TC_698
  test("TC_698", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity, Carbon_automation.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize ORDER BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.deviceInformationId, Carbon_automation.Activecity, Carbon_automation.AMSize""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.AMSize AS AMSize FROM ( SELECT AMSize,gamePointId, ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize ORDER BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.deviceInformationId, Carbon_automation_hive.Activecity, Carbon_automation_hive.AMSize""", "QueriesBasicTestCase_TC_698")

  }


  // TC_699
  test("TC_699", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, gamePointId,ActiveCountry,deviceInformationId, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_699")

  }


  // TC_700
  test("TC_700", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize,gamePointId, deviceInformationId,ActiveCountry, Activecity FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.AMSize = Carbon_automation_hive1.AMSize GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_700")

  }


  // TC_701
  test("TC_701", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId, First(Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize,deviceInformationId, gamePointId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_702
  test("TC_702", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize,gamePointId ,deviceInformationId, ActiveCountry, Activecity FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Full outer Join ( SELECT ActiveCountry, Activecity, AMSize FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.AMSize = Carbon_automation1.AMSize GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_703
  test("TC_703", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize = "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize = "5RAM size"""", "QueriesBasicTestCase_TC_703")

  }


  // TC_704
  test("TC_704", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize > "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize > "5RAM size"""", "QueriesBasicTestCase_TC_704")

  }


  // TC_705
  test("TC_705", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize >= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize >= "5RAM size"""", "QueriesBasicTestCase_TC_705")

  }


  // TC_706
  test("TC_706", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize < "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize < "5RAM size"""", "QueriesBasicTestCase_TC_706")

  }


  // TC_707
  test("TC_707", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize <= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize <= "5RAM size"""", "QueriesBasicTestCase_TC_707")

  }


  // TC_708
  test("TC_708", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_708")

  }


  // TC_709
  test("TC_709", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '6RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '6RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_709")

  }


  // TC_710
  test("TC_710", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_710")

  }


  // TC_711
  test("TC_711", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_711")

  }


  // TC_712
  test("TC_712", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_712")

  }


  // TC_713
  test("TC_713", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize = "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize = "5RAM size")""", "QueriesBasicTestCase_TC_713")

  }


  // TC_714
  test("TC_714", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize > "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize > "5RAM size")""", "QueriesBasicTestCase_TC_714")

  }


  // TC_715
  test("TC_715", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize >= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize >= "5RAM size")""", "QueriesBasicTestCase_TC_715")

  }


  // TC_716
  test("TC_716", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize < "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize < "5RAM size")""", "QueriesBasicTestCase_TC_716")

  }


  // TC_717
  test("TC_717", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize <= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize <= "5RAM size")""", "QueriesBasicTestCase_TC_717")

  }


  // TC_718
  test("TC_718", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_718")

  }


  // TC_719
  test("TC_719", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '7RAM%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '7RAM%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_719")

  }


  // TC_720
  test("TC_720", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_720")

  }


  // TC_721
  test("TC_721", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_721")

  }


  // TC_722
  test("TC_722", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_722")

  }


  // TC_723
  test("TC_723", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_723")

  }


  // TC_724
  test("TC_724", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_724")

  }


  // TC_725
  test("TC_725", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_725")

  }


  // TC_726
  test("TC_726", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_726")

  }


  // TC_727
  test("TC_727", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_727")

  }


  // TC_728
  test("TC_728", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_728")

  }


  // TC_729
  test("TC_729", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_729")

  }


  // TC_730
  test("TC_730", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_730")

  }


  // TC_731
  test("TC_731", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_731")

  }


  // TC_732
  test("TC_732", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_732")

  }


  // TC_733
  test("TC_733", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_733")

  }


  // TC_734
  test("TC_734", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_734")

  }


  // TC_735
  test("TC_735", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_735")

  }


  // TC_736
  test("TC_736", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_736")

  }


  // TC_737
  test("TC_737", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_737")

  }


  // TC_738
  test("TC_738", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_738")

  }


  // TC_739
  test("TC_739", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.gamePointId,Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.gamePointId,Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_739")

  }


  // TC_740
  test("TC_740", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_740")

  }


  // TC_741
  test("TC_741", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_741")

  }


  // TC_742
  test("TC_742", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_742")

  }


  // TC_743
  test("TC_743", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_743")

  }


  // TC_744
  test("TC_744", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_744")

  }


  // TC_745
  test("TC_745", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_745")

  }


  // TC_746
  test("TC_746", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_746")

  }


  // TC_747
  test("TC_747", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_747")

  }


  // TC_748
  test("TC_748", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_748")

  }


  // TC_749
  test("TC_749", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First( Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_750
  test("TC_750", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation INNER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""").collect

  }


  // TC_751
  test("TC_751", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize = "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize = "5RAM size"""", "QueriesBasicTestCase_TC_751")

  }


  // TC_752
  test("TC_752", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize > "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize > "5RAM size"""", "QueriesBasicTestCase_TC_752")

  }


  // TC_753
  test("TC_753", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize >= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize >= "5RAM size"""", "QueriesBasicTestCase_TC_753")

  }


  // TC_754
  test("TC_754", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize < "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize < "5RAM size"""", "QueriesBasicTestCase_TC_754")

  }


  // TC_755
  test("TC_755", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize <= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize <= "5RAM size"""", "QueriesBasicTestCase_TC_755")

  }


  // TC_756
  test("TC_756", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_756")

  }


  // TC_757
  test("TC_757", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '6RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '6RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_757")

  }


  // TC_758
  test("TC_758", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_758")

  }


  // TC_759
  test("TC_759", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_759")

  }


  // TC_760
  test("TC_760", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_760")

  }


  // TC_761
  test("TC_761", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize = "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize = "5RAM size")""", "QueriesBasicTestCase_TC_761")

  }


  // TC_762
  test("TC_762", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize > "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize > "5RAM size")""", "QueriesBasicTestCase_TC_762")

  }


  // TC_763
  test("TC_763", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize >= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize >= "5RAM size")""", "QueriesBasicTestCase_TC_763")

  }


  // TC_764
  test("TC_764", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize < "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize < "5RAM size")""", "QueriesBasicTestCase_TC_764")

  }


  // TC_765
  test("TC_765", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize <= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize <= "5RAM size")""", "QueriesBasicTestCase_TC_765")

  }


  // TC_766
  test("TC_766", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_766")

  }


  // TC_767
  test("TC_767", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '7RAM%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '7RAM%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_767")

  }


  // TC_768
  test("TC_768", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_768")

  }


  // TC_769
  test("TC_769", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_769")

  }


  // TC_770
  test("TC_770", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_770")

  }


  // TC_771
  test("TC_771", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_771")

  }


  // TC_772
  test("TC_772", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_772")

  }


  // TC_773
  test("TC_773", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_773")

  }


  // TC_774
  test("TC_774", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_774")

  }


  // TC_775
  test("TC_775", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_775")

  }


  // TC_776
  test("TC_776", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_776")

  }


  // TC_777
  test("TC_777", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_777")

  }


  // TC_778
  test("TC_778", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_778")

  }


  // TC_779
  test("TC_779", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_779")

  }


  // TC_780
  test("TC_780", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_780")

  }


  // TC_781
  test("TC_781", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_781")

  }


  // TC_782
  test("TC_782", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_782")

  }


  // TC_783
  test("TC_783", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_783")

  }


  // TC_784
  test("TC_784", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_784")

  }


  // TC_785
  test("TC_785", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_785")

  }


  // TC_786
  test("TC_786", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_786")

  }


  // TC_787
  test("TC_787", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_787")

  }


  // TC_788
  test("TC_788", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_788")

  }


  // TC_789
  test("TC_789", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_789")

  }


  // TC_790
  test("TC_790", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_790")

  }


  // TC_791
  test("TC_791", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_791")

  }


  // TC_792
  test("TC_792", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_792")

  }


  // TC_793
  test("TC_793", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_793")

  }


  // TC_794
  test("TC_794", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive LEFT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_794")

  }


  // TC_795
  test("TC_795", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_795")

  }


  // TC_796
  test("TC_796", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_796")

  }


  // TC_797
  test("TC_797", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First( Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC
  """).collect

  }


  // TC_798
  test("TC_798", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation Left Join ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""").collect

  }


  // TC_799
  test("TC_799", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize = "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize = "5RAM size"""", "QueriesBasicTestCase_TC_799")

  }


  // TC_800
  test("TC_800", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize > "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize > "5RAM size"""", "QueriesBasicTestCase_TC_800")

  }


  // TC_801
  test("TC_801", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize >= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize >= "5RAM size"""", "QueriesBasicTestCase_TC_801")

  }


  // TC_802
  test("TC_802", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize < "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize < "5RAM size"""", "QueriesBasicTestCase_TC_802")

  }


  // TC_803
  test("TC_803", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize <= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize <= "5RAM size"""", "QueriesBasicTestCase_TC_803")

  }


  // TC_804
  test("TC_804", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_804")

  }


  // TC_805
  test("TC_805", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '6RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '6RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_805")

  }


  // TC_806
  test("TC_806", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_806")

  }


  // TC_807
  test("TC_807", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_807")

  }


  // TC_808
  test("TC_808", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_808")

  }


  // TC_809
  test("TC_809", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize = "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize = "5RAM size")""", "QueriesBasicTestCase_TC_809")

  }


  // TC_810
  test("TC_810", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize > "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize > "5RAM size")""", "QueriesBasicTestCase_TC_810")

  }


  // TC_811
  test("TC_811", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize >= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize >= "5RAM size")""", "QueriesBasicTestCase_TC_811")

  }


  // TC_812
  test("TC_812", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize < "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize < "5RAM size")""", "QueriesBasicTestCase_TC_812")

  }


  // TC_813
  test("TC_813", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize <= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize <= "5RAM size")""", "QueriesBasicTestCase_TC_813")

  }


  // TC_814
  test("TC_814", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_814")

  }


  // TC_815
  test("TC_815", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '7RAM%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '7RAM%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_815")

  }


  // TC_816
  test("TC_816", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_816")

  }


  // TC_817
  test("TC_817", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_817")

  }


  // TC_818
  test("TC_818", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NOT NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_818")

  }


  // TC_819
  test("TC_819", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId ASC""", "QueriesBasicTestCase_TC_819")

  }


  // TC_820
  test("TC_820", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, Carbon_automation.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity, Carbon_automation.deviceInformationId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC, Carbon_automation.deviceInformationId DESC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, Carbon_automation_hive.deviceInformationId AS deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity, Carbon_automation_hive.deviceInformationId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC, Carbon_automation_hive.deviceInformationId DESC""", "QueriesBasicTestCase_TC_820")

  }


  // TC_821
  test("TC_821", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.deviceInformationId) AS Sum_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_821")

  }


  // TC_822
  test("TC_822", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.deviceInformationId) AS Avg_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_822")

  }


  // TC_823
  test("TC_823", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.deviceInformationId) AS Count_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_823")

  }


  // TC_824
  test("TC_824", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.deviceInformationId) AS LONG_COL_0 FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_824")

  }


  // TC_825
  test("TC_825", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.deviceInformationId AS deviceInformationId, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.deviceInformationId AS deviceInformationId, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_825")

  }


  // TC_826
  test("TC_826", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.deviceInformationId) AS Max_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_826")

  }


  // TC_827
  test("TC_827", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.deviceInformationId) AS Min_deviceInformationId FROM ( SELECT AMSize,deviceInformationId,  ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_827")

  }


  // TC_828
  test("TC_828", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_828")

  }


  // TC_829
  test("TC_829", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_829")

  }


  // TC_830
  test("TC_830", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId DESC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId DESC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_830")

  }


  // TC_831
  test("TC_831", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_831")

  }


  // TC_832
  test("TC_832", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, AVG(Carbon_automation.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, AVG(Carbon_automation_hive.gamePointId) AS Avg_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_832")

  }


  // TC_833
  test("TC_833", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.gamePointId) AS Count_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_833")

  }


  // TC_834
  test("TC_834", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.gamePointId) AS DistinctCount_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_834")

  }


  // TC_835
  test("TC_835", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity""", "QueriesBasicTestCase_TC_835")

  }


  // TC_836
  test("TC_836", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MAX(Carbon_automation.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MAX(Carbon_automation_hive.gamePointId) AS Max_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_836")

  }


  // TC_837
  test("TC_837", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_837")

  }


  // TC_838
  test("TC_838", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, MIN(Carbon_automation.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, MIN(Carbon_automation_hive.gamePointId) AS Min_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_838")

  }


  // TC_839
  test("TC_839", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize DESC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize DESC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_839")

  }


  // TC_840
  test("TC_840", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(Carbon_automation.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(Carbon_automation_hive.AMSize) AS Count_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_840")

  }


  // TC_841
  test("TC_841", Include) {

    checkAnswer(s"""SELECT Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, COUNT(DISTINCT Carbon_automation_hive.AMSize) AS DistinctCount_AMSize FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_841")

  }


  // TC_842
  test("TC_842", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId ORDER BY Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId ORDER BY Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_842")

  }


  // TC_843
  test("TC_843", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.deviceInformationId) AS Sum_distinct_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.gamePointId, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.gamePointId ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_843")

  }


  // TC_844
  test("TC_844", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(distinct Carbon_automation.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(distinct Carbon_automation_hive.gamePointId) AS Sum_distinct_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_844")

  }


  // TC_845
  test("TC_845", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First( Carbon_automation.deviceInformationId) AS First_deviceInformationId FROM ( SELECT AMSize, deviceInformationId, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.gamePointId, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.gamePointId ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""").collect

  }


  // TC_846
  test("TC_846", Include) {

    sql(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, First(Carbon_automation.gamePointId) AS First_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation RIGHT JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""").collect

  }


  // TC_847
  test("TC_847", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize = "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize = "5RAM size"""", "QueriesBasicTestCase_TC_847")

  }


  // TC_848
  test("TC_848", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize > "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize > "5RAM size"""", "QueriesBasicTestCase_TC_848")

  }


  // TC_849
  test("TC_849", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize >= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize >= "5RAM size"""", "QueriesBasicTestCase_TC_849")

  }


  // TC_850
  test("TC_850", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize < "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize < "5RAM size"""", "QueriesBasicTestCase_TC_850")

  }


  // TC_851
  test("TC_851", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize <= "5RAM size"""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize <= "5RAM size"""", "QueriesBasicTestCase_TC_851")

  }


  // TC_852
  test("TC_852", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '%7RAM size%' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_852")

  }


  // TC_853
  test("TC_853", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize LIKE '6RAM %' GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize LIKE '6RAM %' GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_853")

  }


  // TC_854
  test("TC_854", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize BETWEEN "6RAM size" AND "9RAM size" GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_854")

  }


  // TC_855
  test("TC_855", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IN ("6RAM size","8RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_855")

  }


  // TC_856
  test("TC_856", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE Carbon_automation_hive.AMSize IS NULL GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_856")

  }


  // TC_857
  test("TC_857", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize = "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize = "5RAM size")""", "QueriesBasicTestCase_TC_857")

  }


  // TC_858
  test("TC_858", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE  NOT(Carbon_automation.AMSize > "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE  NOT(Carbon_automation_hive.AMSize > "5RAM size")""", "QueriesBasicTestCase_TC_858")

  }


  // TC_859
  test("TC_859", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize >= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize >= "5RAM size")""", "QueriesBasicTestCase_TC_859")

  }


  // TC_860
  test("TC_860", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT( Carbon_automation.AMSize < "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT( Carbon_automation_hive.AMSize < "5RAM size")""", "QueriesBasicTestCase_TC_860")

  }


  // TC_861
  test("TC_861", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.gamePointId AS gamePointId, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize <= "5RAM size")""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.gamePointId AS gamePointId, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity FROM ( SELECT AMSize,  ActiveCountry,  Activecity, gamePointId  FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize,  ActiveCountry,  Activecity,  gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize <= "5RAM size")""", "QueriesBasicTestCase_TC_861")

  }


  // TC_862
  test("TC_862", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '%6RAM size%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_862")

  }


  // TC_863
  test("TC_863", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize LIKE '7RAM%') GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize LIKE '7RAM%') GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_863")

  }


  // TC_864
  test("TC_864", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize BETWEEN "7RAM size" AND "9RAM size") GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_864")

  }


  // TC_865
  test("TC_865", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE NOT(Carbon_automation.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePointId = Carbon_automation_hive1.gamePointId WHERE NOT(Carbon_automation_hive.AMSize IN ("5RAM size","8RAM size","7RAM size")) GROUP BY Carbon_automation_hive.AMSize, Carbon_automation_hive.ActiveCountry, Carbon_automation_hive.Activecity ORDER BY Carbon_automation_hive.AMSize ASC, Carbon_automation_hive.ActiveCountry ASC, Carbon_automation_hive.Activecity ASC""", "QueriesBasicTestCase_TC_865")

  }


  // TC_866
  test("TC_866", Include) {

    checkAnswer(s"""SELECT Carbon_automation.AMSize AS AMSize, Carbon_automation.ActiveCountry AS ActiveCountry, Carbon_automation.Activecity AS Activecity, SUM(Carbon_automation.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation) SUB_QRY ) Carbon_automation1 ON Carbon_automation.gamePointId = Carbon_automation1.gamePointId WHERE Carbon_automation.AMSize IS NOT NULL GROUP BY Carbon_automation.AMSize, Carbon_automation.ActiveCountry, Carbon_automation.Activecity ORDER BY Carbon_automation.AMSize ASC, Carbon_automation.ActiveCountry ASC, Carbon_automation.Activecity ASC""",
      s"""SELECT Carbon_automation_hive.AMSize AS AMSize, Carbon_automation_hive.ActiveCountry AS ActiveCountry, Carbon_automation_hive.Activecity AS Activecity, SUM(Carbon_automation_hive.gamePointId) AS Sum_gamePointId FROM ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive FULL OUTER JOIN ( SELECT AMSize, ActiveCountry, Activecity, gamePointId FROM (select * from Carbon_automation_hive) SUB_QRY ) Carbon_automation_hive1 ON Carbon_automation_hive.gamePoin