/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationPlatformStatus;
import org.apache.camel.v1.integrationplatformstatus.Build;
import org.apache.camel.v1.integrationplatformstatus.BuildBuilder;
import org.apache.camel.v1.integrationplatformstatus.BuildFluent;
import org.apache.camel.v1.integrationplatformstatus.Conditions;
import org.apache.camel.v1.integrationplatformstatus.ConditionsBuilder;
import org.apache.camel.v1.integrationplatformstatus.ConditionsFluent;
import org.apache.camel.v1.integrationplatformstatus.Configuration;
import org.apache.camel.v1.integrationplatformstatus.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformstatus.ConfigurationFluent;
import org.apache.camel.v1.integrationplatformstatus.Kamelet;
import org.apache.camel.v1.integrationplatformstatus.KameletBuilder;
import org.apache.camel.v1.integrationplatformstatus.KameletFluent;
import org.apache.camel.v1.integrationplatformstatus.Traits;
import org.apache.camel.v1.integrationplatformstatus.TraitsBuilder;
import org.apache.camel.v1.integrationplatformstatus.TraitsFluent;

public class IntegrationPlatformStatusFluent<A extends IntegrationPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private BuildBuilder build;
    private String cluster;
    private ArrayList<ConditionsBuilder> conditions;
    private ArrayList<ConfigurationBuilder> configuration;
    private Map<String, String> info;
    private KameletBuilder kamelet;
    private Long observedGeneration;
    private String phase;
    private String profile;
    private TraitsBuilder traits;
    private String version;

    public IntegrationPlatformStatusFluent() {
    }

    public IntegrationPlatformStatusFluent(IntegrationPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationPlatformStatus instance) {
        IntegrationPlatformStatus integrationPlatformStatus = instance = instance != null ? instance : new IntegrationPlatformStatus();
        if (instance != null) {
            this.withBuild(instance.getBuild());
            this.withCluster(instance.getCluster());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withInfo(instance.getInfo());
            this.withKamelet(instance.getKamelet());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withProfile(instance.getProfile());
            this.withTraits(instance.getTraits());
            this.withVersion(instance.getVersion());
        }
    }

    public Build buildBuild() {
        return this.build != null ? this.build.build() : null;
    }

    public A withBuild(Build build) {
        this._visitables.remove((Object)"build");
        if (build != null) {
            this.build = new BuildBuilder(build);
            this._visitables.get((Object)"build").add(this.build);
        } else {
            this.build = null;
            this._visitables.get((Object)"build").remove((Object)this.build);
        }
        return (A)((Object)this);
    }

    public boolean hasBuild() {
        return this.build != null;
    }

    public BuildNested<A> withNewBuild() {
        return new BuildNested(null);
    }

    public BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNested(item);
    }

    public BuildNested<A> editIntegrationplatformstatusBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(null));
    }

    public BuildNested<A> editOrNewBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(new BuildBuilder().build()));
    }

    public BuildNested<A> editOrNewBuildLike(Build item) {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(item));
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)((Object)this);
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationplatformstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationplatformstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationplatformstatusConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? IntegrationPlatformStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").add(index, builder);
            this.configuration.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
            this.configuration.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationBuilder> predicate) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigurationBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Configuration> buildConfiguration() {
        return this.configuration != null ? IntegrationPlatformStatusFluent.build(this.configuration) : null;
    }

    public Configuration buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public Configuration buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public Configuration buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    public Configuration buildMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfiguration(List<Configuration> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").clear();
        }
        if (configuration != null) {
            this.configuration = new ArrayList();
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)((Object)this);
    }

    public A withConfiguration(Configuration ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
            this._visitables.remove((Object)"configuration");
        }
        if (configuration != null) {
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    public ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNested(-1, null);
    }

    public ConfigurationNested<A> addNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(-1, item);
    }

    public ConfigurationNested<A> setNewConfigurationLike(int index, Configuration item) {
        return new ConfigurationNested(index, item);
    }

    public ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    public ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public A addToInfo(String key, String value) {
        if (this.info == null && key != null && value != null) {
            this.info = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.info.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToInfo(Map<String, String> map) {
        if (this.info == null && map != null) {
            this.info = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.info.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromInfo(String key) {
        if (this.info == null) {
            return (A)((Object)this);
        }
        if (key != null && this.info != null) {
            this.info.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromInfo(Map<String, String> map) {
        if (this.info == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.info == null) continue;
                this.info.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public <K, V> A withInfo(Map<String, String> info) {
        this.info = info == null ? null : new LinkedHashMap<String, String>(info);
        return (A)((Object)this);
    }

    public boolean hasInfo() {
        return this.info != null;
    }

    public Kamelet buildKamelet() {
        return this.kamelet != null ? this.kamelet.build() : null;
    }

    public A withKamelet(Kamelet kamelet) {
        this._visitables.remove((Object)"kamelet");
        if (kamelet != null) {
            this.kamelet = new KameletBuilder(kamelet);
            this._visitables.get((Object)"kamelet").add(this.kamelet);
        } else {
            this.kamelet = null;
            this._visitables.get((Object)"kamelet").remove((Object)this.kamelet);
        }
        return (A)((Object)this);
    }

    public boolean hasKamelet() {
        return this.kamelet != null;
    }

    public KameletNested<A> withNewKamelet() {
        return new KameletNested(null);
    }

    public KameletNested<A> withNewKameletLike(Kamelet item) {
        return new KameletNested(item);
    }

    public KameletNested<A> editIntegrationplatformstatusKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(null));
    }

    public KameletNested<A> editOrNewKamelet() {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(new KameletBuilder().build()));
    }

    public KameletNested<A> editOrNewKameletLike(Kamelet item) {
        return this.withNewKameletLike(Optional.ofNullable(this.buildKamelet()).orElse(item));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public Traits buildTraits() {
        return this.traits != null ? this.traits.build() : null;
    }

    public A withTraits(Traits traits) {
        this._visitables.remove((Object)"traits");
        if (traits != null) {
            this.traits = new TraitsBuilder(traits);
            this._visitables.get((Object)"traits").add(this.traits);
        } else {
            this.traits = null;
            this._visitables.get((Object)"traits").remove((Object)this.traits);
        }
        return (A)((Object)this);
    }

    public boolean hasTraits() {
        return this.traits != null;
    }

    public TraitsNested<A> withNewTraits() {
        return new TraitsNested(null);
    }

    public TraitsNested<A> withNewTraitsLike(Traits item) {
        return new TraitsNested(item);
    }

    public TraitsNested<A> editIntegrationplatformstatusTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(null));
    }

    public TraitsNested<A> editOrNewTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(new TraitsBuilder().build()));
    }

    public TraitsNested<A> editOrNewTraitsLike(Traits item) {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(item));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationPlatformStatusFluent that = (IntegrationPlatformStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.build, (Object)that.build)) {
            return false;
        }
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.info, that.info)) {
            return false;
        }
        if (!Objects.equals((Object)this.kamelet, (Object)that.kamelet)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals((Object)this.traits, (Object)that.traits)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.build, this.cluster, this.conditions, this.configuration, this.info, this.kamelet, this.observedGeneration, this.phase, this.profile, this.traits, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.build != null) {
            sb.append("build:");
            sb.append(this.build + ",");
        }
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.info != null && !this.info.isEmpty()) {
            sb.append("info:");
            sb.append(this.info + ",");
        }
        if (this.kamelet != null) {
            sb.append("kamelet:");
            sb.append(this.kamelet + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.traits != null) {
            sb.append("traits:");
            sb.append(this.traits + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BuildNested<N>
    extends BuildFluent<BuildNested<N>>
    implements Nested<N> {
        BuildBuilder builder;

        BuildNested(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformStatusFluent.this.withBuild(this.builder.build());
        }

        public N endIntegrationplatformstatusBuild() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endIntegrationplatformstatusCondition() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;
        int index;

        ConfigurationNested(int index, Configuration item) {
            this.index = index;
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformStatusFluent.this.setToConfiguration(this.index, this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class KameletNested<N>
    extends KameletFluent<KameletNested<N>>
    implements Nested<N> {
        KameletBuilder builder;

        KameletNested(Kamelet item) {
            this.builder = new KameletBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformStatusFluent.this.withKamelet(this.builder.build());
        }

        public N endIntegrationplatformstatusKamelet() {
            return this.and();
        }
    }

    public class TraitsNested<N>
    extends TraitsFluent<TraitsNested<N>>
    implements Nested<N> {
        TraitsBuilder builder;

        TraitsNested(Traits item) {
            this.builder = new TraitsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationPlatformStatusFluent.this.withTraits(this.builder.build());
        }

        public N endIntegrationplatformstatusTraits() {
            return this.and();
        }
    }
}

