/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.AbstractExecutionContext;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.InterruptingImmediateSupplier;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionContext
extends AbstractExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutionContext.class);
    static final ThreadLocal<BasicExecutionContext> perThreadExecutionContext = new ThreadLocal();
    public static final String ENTITY_IDS = "entity.ids";
    public static final String TASK_ID = "task.id";
    final ExecutionManager executionManager;
    final Set<Object> tags = new LinkedHashSet<Object>();

    public static BasicExecutionContext getCurrentExecutionContext() {
        return perThreadExecutionContext.get();
    }

    public BasicExecutionContext(ExecutionManager executionManager) {
        this(executionManager, null);
    }

    @Deprecated
    public BasicExecutionContext(Map<?, ?> flags, ExecutionManager executionManager) {
        this(executionManager, (Iterable<?>)MutableSet.of().put(flags.remove("tag")).putAll((Iterable)flags.remove("tag")));
        if (!flags.isEmpty()) {
            log.warn("Unexpected flags passed to execution context (" + this.tags + "): " + flags, new Throwable("Trace for unexpected flags passed to execution context"));
        }
    }

    public BasicExecutionContext(ExecutionManager executionManager, Iterable<?> tagsForThisContext) {
        this.executionManager = executionManager;
        if (tagsForThisContext != null) {
            Iterables.addAll(this.tags, tagsForThisContext);
        }
        for (Object tag : this.tags) {
            if (!(tag instanceof BrooklynTaskTags.WrappedItem) || !Proxy.isProxyClass(((BrooklynTaskTags.WrappedItem)tag).unwrap().getClass())) continue;
            log.warn("" + this + " has entity proxy in " + tag);
        }
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public Set<Task<?>> getTasks() {
        return this.executionManager.getTasksWithAllTags(this.tags);
    }

    public <T> T get(TaskAdaptable<T> task) {
        final TaskInternal t = (TaskInternal)task.asTask();
        if (t.isQueuedOrSubmitted()) {
            return (T)t.getUnchecked();
        }
        ContextSwitchingInfo<T> switchContextWrapper = this.getContextSwitchingTask(t, Collections.emptyList(), false);
        if (switchContextWrapper != null) {
            return (T)switchContextWrapper.context.get(switchContextWrapper.wrapperTask);
        }
        try {
            return (T)this.runInSameThread(t, new Callable<Maybe<T>>(){

                @Override
                public Maybe<T> call() throws Exception {
                    return Maybe.of(t.getJob().call());
                }
            }).get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> Maybe<T> runInSameThread(Task<T> task, Callable<Maybe<T>> job) {
        Set<Object> mutableTags = ((TaskInternal)task).getMutableTags();
        mutableTags.addAll(this.tags);
        Task currentTask = Tasks.current();
        if (currentTask != null && BrooklynTaskTags.isTransient(currentTask) && !mutableTags.contains("NON-TRANSIENT") && !mutableTags.contains("TRANSIENT")) {
            mutableTags.add("TRANSIENT");
        }
        Task<?> previousTask = BasicExecutionManager.getPerThreadCurrentTask().get();
        BasicExecutionContext oldExecutionContext = BasicExecutionContext.getCurrentExecutionContext();
        this.registerPerThreadExecutionContext();
        ((BasicExecutionManager)this.executionManager).beforeSubmitInSameThreadTask(null, task);
        SimpleFuture<T> future = new SimpleFuture<T>();
        Exception error = null;
        if (currentTask instanceof BasicTask) {
            ((BasicTask)currentTask).setBlockingTask(task);
        }
        try {
            Maybe maybe;
            Throwable throwable;
            BasicExecutionManager.BrooklynTaskLoggingMdc mdc;
            block27: {
                block28: {
                    mdc = BasicExecutionManager.BrooklynTaskLoggingMdc.create(task).start();
                    throwable = null;
                    ((BasicExecutionManager)this.executionManager).afterSubmitRecordFuture(task, future);
                    ((BasicExecutionManager)this.executionManager).beforeStartInSameThreadTask(null, task);
                    maybe = future.set(job.call());
                    if (mdc == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        mdc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block27;
                }
                mdc.close();
            }
            return maybe;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (mdc != null) {
                            if (throwable != null) {
                                try {
                                    mdc.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                mdc.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    future.set(Maybe.absent((Throwable)e));
                    Exceptions.propagateIfInterrupt((Throwable)e);
                    error = e;
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            if (currentTask instanceof BasicTask) {
                ((BasicTask)currentTask).resetBlockingTask();
            }
            try {
                ((BasicExecutionManager)this.executionManager).afterEndInSameThreadTask(null, task, error);
            }
            finally {
                BasicExecutionManager.getPerThreadCurrentTask().set(previousTask);
                perThreadExecutionContext.set(oldExecutionContext);
            }
        }
    }

    public <T> Maybe<T> getImmediately(Task<T> callableOrSupplier) {
        return this.getImmediately((Object)callableOrSupplier);
    }

    public <T> Maybe<T> getImmediately(Object callableOrSupplier) {
        BasicTask fakeTaskForContext;
        if (callableOrSupplier instanceof BasicTask) {
            fakeTaskForContext = (BasicTask)((Object)callableOrSupplier);
            if (fakeTaskForContext.isQueuedOrSubmitted()) {
                if (fakeTaskForContext.isDone()) {
                    return Maybe.of(fakeTaskForContext.getUnchecked());
                }
                throw new ImmediateSupplier.ImmediateUnsupportedException("Task is in progress and incomplete: " + fakeTaskForContext);
            }
            callableOrSupplier = fakeTaskForContext.getJob();
        } else {
            if (callableOrSupplier instanceof TaskAdaptable) {
                Task task = ((TaskAdaptable)callableOrSupplier).asTask();
                if (task == callableOrSupplier) {
                    if (task.isDone()) {
                        return Maybe.of((Object)task.getUnchecked());
                    }
                    if (task.isSubmitted() || task.isBegun()) {
                        throw new ImmediateSupplier.ImmediateUnsupportedException("Task is in progress and incomplete: " + task);
                    }
                    throw new ImmediateSupplier.ImmediateUnsupportedException("Task not a 'BasicTask', so cannot extract job to get immediately: " + task);
                }
                return this.getImmediately(task);
            }
            fakeTaskForContext = new BasicTask((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)"Immediate evaluation"));
        }
        final InterruptingImmediateSupplier job = callableOrSupplier instanceof ImmediateSupplier ? (InterruptingImmediateSupplier)((Object)callableOrSupplier) : InterruptingImmediateSupplier.of(callableOrSupplier);
        fakeTaskForContext.tags.add("IMMEDIATE");
        fakeTaskForContext.tags.add("TRANSIENT");
        ContextSwitchingInfo<T> switchContextWrapper = this.getContextSwitchingTask(fakeTaskForContext, Collections.emptyList(), true);
        if (switchContextWrapper != null) {
            return switchContextWrapper.context.getImmediately(switchContextWrapper.wrapperTask);
        }
        try {
            return this.runInSameThread(fakeTaskForContext, new Callable<Maybe<T>>(){

                @Override
                public Maybe<T> call() throws Exception {
                    try {
                        Maybe maybe = (Maybe)Threads.runTemporarilyUninterrupted(job::getImmediately);
                        return maybe;
                    }
                    finally {
                        fakeTaskForContext.cancel();
                    }
                }
            });
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected <T> Task<T> submitInternal(Map<?, ?> propertiesQ, Object task) {
        ContextSwitchingInfo<T> switchContextWrapper;
        if (task instanceof TaskAdaptable && !(task instanceof Task)) {
            return this.submitInternal(propertiesQ, ((TaskAdaptable)task).asTask());
        }
        MutableMap properties = MutableMap.copyOf(propertiesQ);
        ArrayList<Object> taskTags = properties.get("tags") == null ? new ArrayList<Object>() : new ArrayList((Collection)properties.get("tags"));
        properties.put("tags", taskTags);
        if (task instanceof Task) {
            taskTags.addAll(((Task)task).getTags());
        }
        if ((switchContextWrapper = this.getContextSwitchingTask(task, taskTags, false)) != null) {
            return switchContextWrapper.context.submit(switchContextWrapper.wrapperTask);
        }
        EntitlementContext entitlementContext = BrooklynTaskTags.getEntitlement(taskTags);
        if (entitlementContext == null) {
            entitlementContext = Entitlements.getEntitlementContext();
        }
        if (entitlementContext != null) {
            taskTags.add(BrooklynTaskTags.tagForEntitlement(entitlementContext));
        }
        taskTags.addAll(this.tags);
        if (Tasks.current() != null && BrooklynTaskTags.isTransient(Tasks.current()) && !taskTags.contains("NON-TRANSIENT") && !taskTags.contains("TRANSIENT")) {
            taskTags.add("TRANSIENT");
        }
        if (task instanceof ScheduledTask) {
            ((ScheduledTask)task).executionContext = this;
        } else {
            final Object startCallback = properties.get("newTaskStartCallback");
            properties.put("newTaskStartCallback", new Function<Task<?>, Void>(){

                public Void apply(Task<?> it) {
                    BasicExecutionContext.this.registerPerThreadExecutionContext();
                    if (startCallback != null) {
                        BasicExecutionManager.invokeCallback(startCallback, it);
                    }
                    return null;
                }
            });
            final Object endCallback = properties.get("newTaskEndCallback");
            properties.put("newTaskEndCallback", new Function<Task<?>, Void>(){

                public Void apply(Task<?> it) {
                    try {
                        if (endCallback != null) {
                            BasicExecutionManager.invokeCallback(endCallback, it);
                        }
                    }
                    finally {
                        BasicExecutionContext.this.clearPerThreadExecutionContext();
                    }
                    return null;
                }
            });
        }
        if (task instanceof Task) {
            return this.executionManager.submit((Map)properties, (TaskAdaptable)((Task)task));
        }
        if (task instanceof Callable) {
            return this.executionManager.submit((Map)properties, (Callable)task);
        }
        if (task instanceof Runnable) {
            return this.executionManager.submit((Map)properties, (Runnable)task);
        }
        throw new IllegalArgumentException("Unhandled task type: task=" + task + "; type=" + (task != null ? task.getClass() : "null"));
    }

    private String idStack(Entity target) {
        ArrayDeque<String> ids = new ArrayDeque<String>();
        Entity e = target;
        ids.push(e.getId());
        while (e.getParent() != null) {
            e = e.getParent();
            ids.push(e.getId());
        }
        return ((Object)ids).toString().replace(" ", "");
    }

    protected <T> ContextSwitchingInfo<T> getContextSwitchingTask(Object task, Collection<Object> taskTags, boolean immediate) {
        Task t;
        this.checkUserSuppliedContext(task, taskTags);
        Entity target = BrooklynTaskTags.getWrappedEntityOfType(taskTags, "targetEntity");
        if (target == null || this.tags.contains(BrooklynTaskTags.tagForContextEntity(target))) {
            return null;
        }
        ExecutionContext tc = ((EntityInternal)target).getExecutionContext();
        if (log.isDebugEnabled()) {
            log.debug("Switching task context on execution of " + task + ": from " + this + " to " + target + " (in " + Tasks.current() + ")");
        }
        if (task instanceof Task) {
            t = (Task)task;
            if (Tasks.isQueuedOrSubmitted(t) || Tasks.current() instanceof HasTaskChildren && Iterables.contains((Iterable)((HasTaskChildren)Tasks.current()).getChildren(), t)) {
                return new ContextSwitchingInfo(tc, t);
            }
        } else if (task instanceof Callable) {
            t = Tasks.builder().dynamic(false).body((Callable)task).build();
        } else if (task instanceof Runnable) {
            t = Tasks.builder().dynamic(false).body((Runnable)task).build();
        } else {
            throw new IllegalArgumentException("Unhandled task type: " + task + "; type=" + (task != null ? task.getClass() : "null"));
        }
        return new ContextSwitchingInfo(tc, t);
    }

    private void registerPerThreadExecutionContext() {
        perThreadExecutionContext.set(this);
    }

    @Beta
    public static BasicExecutionContext setPerThreadExecutionContext(BasicExecutionContext ec) {
        BasicExecutionContext old = perThreadExecutionContext.get();
        perThreadExecutionContext.set(ec);
        return old;
    }

    private void clearPerThreadExecutionContext() {
        perThreadExecutionContext.remove();
    }

    private void checkUserSuppliedContext(Object task, Collection<Object> taskTags) {
        Entity taskContext = BrooklynTaskTags.getWrappedEntityOfType(taskTags, "contextEntity");
        Entity defaultContext = BrooklynTaskTags.getWrappedEntityOfType(this.tags, "contextEntity");
        if (taskContext != null) {
            if (log.isWarnEnabled()) {
                String msg = "Deprecated since 0.10.0. Task " + task + " is submitted for execution but has context entity (" + taskContext + ") tag set by the caller. ";
                if (taskContext != defaultContext) {
                    msg = msg + "The context entity of the execution context (" + this + ") the task is submitted on is " + defaultContext + " which is different. This will cause any of them to be used at random at runtime. ";
                    if (task instanceof BasicTask) {
                        msg = msg + "Fixing the context entity to the latter. ";
                    }
                }
                msg = msg + "Setting the context entity by the caller is not allowed. See the documentation on BrooklynTaskTags.tagForContextEntity(Entity) method for more details. Future Apache Brooklyn releases will throw an exception instead of logging a warning.";
                log.warn(msg);
            }
            BrooklynTaskTags.WrappedEntity contextTag = BrooklynTaskTags.tagForContextEntity(taskContext);
            while (taskTags.remove(contextTag)) {
            }
            if (task instanceof BasicTask) {
                Set<Object> mutableTags = ((BasicTask)BasicTask.class.cast(task)).getMutableTags();
                mutableTags.remove(contextTag);
            }
        }
    }

    public boolean isShutdown() {
        return this.getExecutionManager().isShutdown();
    }

    public String toString() {
        return super.toString() + "(" + this.tags + ")";
    }

    private static class ContextSwitchingInfo<T> {
        final ExecutionContext context;
        final Task<T> wrapperTask;

        ContextSwitchingInfo(ExecutionContext context, Task<T> wrapperTask) {
            this.context = context;
            this.wrapperTask = wrapperTask;
        }
    }

    private static class SimpleFuture<T>
    implements Future<T> {
        boolean cancelled = false;
        boolean done = false;
        Maybe<T> result;

        private SimpleFuture() {
        }

        public synchronized Maybe<T> set(Maybe<T> result) {
            this.result = result;
            this.done = true;
            this.notifyAll();
            return result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                SimpleFuture simpleFuture = this;
                synchronized (simpleFuture) {
                    while (!this.isDone()) {
                        this.wait(1000L);
                    }
                }
            }
            if (this.isCancelled() && !this.done) {
                throw new CancellationException();
            }
            return (T)this.result.get();
        }

        @Override
        public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isDone()) {
                return this.get();
            }
            CountdownTimer time = CountdownTimer.newInstanceStarted((Duration)Duration.of((long)timeout, (TimeUnit)unit));
            while (!time.isExpired()) {
                this.wait(time.getDurationRemaining().lowerBound(Duration.ONE_MILLISECOND).toMilliseconds());
                if (!this.isDone()) continue;
                return this.get();
            }
            throw new TimeoutException();
        }
    }
}

