/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReparentEntityWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(ReparentEntityWorkflowStep.class);
    public static final String SHORTHAND = "[ \" child \" ${child} ] [ \" under \" ${parent} ]";
    public static final ConfigKey<Object> CHILD = ConfigKeys.newConfigKey(Object.class, "child");
    public static final ConfigKey<Object> PARENT = ConfigKeys.newConfigKey(Object.class, "parent");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (!this.getInput().containsKey(CHILD.getName())) {
            throw new IllegalArgumentException("Missing required argument: " + CHILD.getName());
        }
        if (!this.getInput().containsKey(PARENT.getName())) {
            throw new IllegalArgumentException("Missing required argument: " + PARENT.getName());
        }
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Entity child = (Entity)WorkflowStepResolution.findEntity(context, context.getInput(CHILD)).get();
        Entity parent = (Entity)WorkflowStepResolution.findEntity(context, context.getInput(PARENT)).get();
        Entity oldParent = child.getParent();
        if (!Objects.equals(oldParent, parent)) {
            oldParent.removeChild(child);
            parent.addChild(child);
        }
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

