/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.internal.ApiObjectsFactory;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.core.relations.ByObjectBasicRelationSupport;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObject
implements BrooklynObjectInternal {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrooklynObject.class);
    private boolean _legacyConstruction;
    private boolean hasWarnedOfNoManagementContextWhenPersistRequested;
    @SetFromFlag(value="id")
    private String id = Identifiers.makeRandomLowercaseId((int)10);
    private String catalogItemId;
    private Collection<String> searchPath = MutableSet.of();
    @SetFromFlag(value="tags")
    private final Set<Object> tags = Sets.newLinkedHashSet();
    private final BrooklynObjectInternal.RelationSupportInternal relations = new ByObjectBasicRelationSupport<AbstractBrooklynObject>(this, new RelationChangedCallback());
    private volatile ManagementContext managementContext;

    public abstract void setDisplayName(String var1);

    public AbstractBrooklynObject() {
        this(Maps.newLinkedHashMap());
    }

    protected AbstractBrooklynObject(String id) {
        this.id = id;
    }

    public AbstractBrooklynObject(Map<?, ?> properties) {
        boolean bl = this._legacyConstruction = !InternalFactory.FactoryConstructionTracker.isConstructing();
        if (!this._legacyConstruction && properties != null && !properties.isEmpty()) {
            log.warn("Forcing use of deprecated old-style construction for {} because properties were specified ({}); instead use specs (e.g. LocationSpec, EntitySpec, etc)", (Object)this.getClass().getName(), properties);
            if (log.isDebugEnabled()) {
                log.debug("Source of use of old-style construction", new Throwable("Source of use of old-style construction"));
            }
            this._legacyConstruction = true;
        }
        this.addSearchPath((List<String>)MutableList.of().appendIfNotNull((Object)ApiObjectsFactory.get().getCatalogItemIdFromContext()));
    }

    protected Object readResolve() {
        if (this.searchPath == null) {
            this.searchPath = MutableList.of();
        }
        return this;
    }

    @Deprecated
    protected BrooklynObjectInternal configure() {
        return this.configure(Collections.emptyMap());
    }

    @Deprecated
    protected abstract BrooklynObjectInternal configure(Map<?, ?> var1);

    protected boolean isLegacyConstruction() {
        return this._legacyConstruction;
    }

    public void init() {
    }

    public void rebind() {
    }

    public void setManagementContext(ManagementContextInternal managementContext) {
        this.managementContext = managementContext;
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    protected boolean isRebinding() {
        return RebindManagerImpl.RebindTracker.isRebinding();
    }

    protected void requestPersist() {
        if (this.getManagementContext() != null) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        } else if (log.isTraceEnabled() && !this.hasWarnedOfNoManagementContextWhenPersistRequested) {
            log.trace("Cannot fulfil request to persist {} because it has no management context. This warning will not be logged for this object again.", (Object)this);
            this.hasWarnedOfNoManagementContextWhenPersistRequested = true;
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setCatalogItemId(String id) {
        this.catalogItemId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalogItemIdAndSearchPath(String catalogItemId, List<String> ids) {
        this.setCatalogItemId(catalogItemId);
        Collection<String> collection = this.searchPath;
        synchronized (collection) {
            this.searchPath.clear();
            this.searchPath.addAll(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchPath(List<String> ids) {
        if (ids != null) {
            Collection<String> collection = this.searchPath;
            synchronized (collection) {
                this.searchPath.addAll(ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stackCatalogItemId(String id) {
        if (null != id) {
            if (null != this.catalogItemId && !this.catalogItemId.equals(id)) {
                Collection<String> collection = this.searchPath;
                synchronized (collection) {
                    MutableSet newPath = MutableSet.of();
                    newPath.add(this.catalogItemId);
                    newPath.addAll(this.searchPath);
                    this.searchPath.clear();
                    this.searchPath.addAll((Collection<String>)newPath);
                }
            }
            this.setCatalogItemId(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCatalogItemIdSearchPath() {
        Collection<String> collection = this.searchPath;
        synchronized (collection) {
            return ImmutableList.copyOf(this.searchPath);
        }
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    protected void onTagsChanged() {
        this.requestPersist();
    }

    public BrooklynObject.TagSupport tags() {
        return new BasicTagSupport();
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<?> relations() {
        return this.relations;
    }

    private class RelationChangedCallback
    implements Runnable {
        private RelationChangedCallback() {
        }

        @Override
        public void run() {
            AbstractBrooklynObject.this.requestPersist();
        }
    }

    protected class BasicTagSupport
    implements BrooklynObject.TagSupport {
        protected BasicTagSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Object> getTags() {
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                return ImmutableSet.copyOf((Collection)AbstractBrooklynObject.this.tags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsTag(Object tag) {
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                return AbstractBrooklynObject.this.tags.contains(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTag(Object tag) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = AbstractBrooklynObject.this.tags.add(tag);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTags(Iterable<?> newTags) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = Iterables.addAll((Collection)AbstractBrooklynObject.this.tags, newTags);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTagsAtStart(Iterable<?> newTags) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                MutableSet oldTags = MutableSet.copyOf((Iterable)AbstractBrooklynObject.this.tags);
                AbstractBrooklynObject.this.tags.clear();
                Iterables.addAll((Collection)AbstractBrooklynObject.this.tags, newTags);
                result = Iterables.addAll((Collection)AbstractBrooklynObject.this.tags, (Iterable)oldTags);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeTag(Object tag) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = AbstractBrooklynObject.this.tags.remove(tag);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }
    }
}

