/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.config.external.ExternalConfigSupplier;
import org.apache.brooklyn.core.config.external.InPlaceExternalConfigSupplier;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.ExternalConfigSupplierRegistry;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExternalConfigSupplierRegistry
implements ExternalConfigSupplierRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(BasicExternalConfigSupplierRegistry.class);
    public static final String DEMO_SAMPLE_PROVIDER = "brooklyn-demo-sample";
    public static final String DEMO_SAMPLE_PROVIDER_PASSWORD_KEY = "hidden-brooklyn-password";
    public static final String DEMO_SAMPLE_PROVIDER_PASSWORD_VALUE = "br00k11n";
    private final Map<String, ExternalConfigSupplier> providersByName = Maps.newLinkedHashMap();
    private final Object providersMapMutex = new Object();

    public BasicExternalConfigSupplierRegistry(ManagementContext mgmt) {
        this.addProvider(DEMO_SAMPLE_PROVIDER, new InPlaceExternalConfigSupplier(mgmt, DEMO_SAMPLE_PROVIDER, (Map<String, String>)MutableMap.of((Object)DEMO_SAMPLE_PROVIDER_PASSWORD_KEY, (Object)DEMO_SAMPLE_PROVIDER_PASSWORD_VALUE)));
        this.updateFromBrooklynProperties(mgmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProvider(String name, ExternalConfigSupplier supplier) {
        Object object = this.providersMapMutex;
        synchronized (object) {
            if (this.providersByName.containsKey(name) && !DEMO_SAMPLE_PROVIDER.equals(name)) {
                throw new IllegalArgumentException("Provider already registered with name '" + name + "'");
            }
            this.providersByName.put(name, supplier);
        }
        LOG.debug("Added external config supplier named '" + name + "': " + supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProvider(String name) {
        Object object = this.providersMapMutex;
        synchronized (object) {
            ExternalConfigSupplier supplier = this.providersByName.remove(name);
            LOG.info("Removed external config supplier named '" + name + "': " + supplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfig(String providerName, String key) {
        Object object = this.providersMapMutex;
        synchronized (object) {
            ExternalConfigSupplier provider = this.providersByName.get(providerName);
            if (provider == null) {
                throw new IllegalArgumentException("No provider found with name '" + providerName + "'");
            }
            return provider.get(key);
        }
    }

    private void updateFromBrooklynProperties(ManagementContext mgmt) {
        String EXTERNAL_PROVIDER_PREFIX = "brooklyn.external.";
        Map externalProviderProperties = mgmt.getConfig().submap(ConfigPredicates.nameStartsWith(EXTERNAL_PROVIDER_PREFIX)).asMapWithStringKeys();
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (String key : externalProviderProperties.keySet()) {
            String strippedKey = key.substring(EXTERNAL_PROVIDER_PREFIX.length());
            if (strippedKey.contains(".")) continue;
            String name = strippedKey;
            String providerClassname = (String)externalProviderProperties.get(key);
            BrooklynProperties config = ConfigUtils.filterForPrefixAndStrip(externalProviderProperties, key + ".");
            try {
                Class<?> supplierClass = new ClassLoaderUtils((Object)this, mgmt).loadClass(providerClassname);
                Maybe configSupplier = Reflections.invokeConstructorFromArgs(supplierClass, (Object[])new Object[]{mgmt, name, config});
                if (!configSupplier.isPresent()) {
                    configSupplier = Reflections.invokeConstructorFromArgs(supplierClass, (Object[])new Object[]{mgmt, name, config.asMapWithStringKeys()});
                }
                if (!configSupplier.isPresent()) {
                    configSupplier = Reflections.invokeConstructorFromArgs(supplierClass, (Object[])new Object[]{mgmt, name});
                }
                if (!configSupplier.isPresent()) {
                    throw new IllegalStateException("No matching constructor found in " + providerClassname);
                }
                this.addProvider(name, (ExternalConfigSupplier)configSupplier.get());
            }
            catch (Exception e) {
                LOG.error("Failed to instantiate external config supplier named '" + name + "': " + e, (Throwable)e);
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            Exceptions.propagate(exceptions);
        }
    }
}

