/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Functionals;

public class EntityFunctions {
    @Deprecated
    private static <T> Function<Entity, T> attributeOld(AttributeSensor<T> attribute) {
        class GetEntityAttributeFunction
        implements Function<Entity, T> {
            final /* synthetic */ AttributeSensor val$attribute;

            GetEntityAttributeFunction(AttributeSensor attributeSensor) {
                this.val$attribute = attributeSensor;
            }

            public T apply(Entity input) {
                return input == null ? null : input.getAttribute(this.val$attribute);
            }
        }
        return new GetEntityAttributeFunction(attribute);
    }

    @Deprecated
    private static <T> Function<Entity, T> configOld(ConfigKey<T> key) {
        class GetEntityConfigFunction
        implements Function<Entity, T> {
            final /* synthetic */ ConfigKey val$key;

            GetEntityConfigFunction(ConfigKey configKey) {
                this.val$key = configKey;
            }

            public T apply(Entity input) {
                return input == null ? null : input.getConfig(this.val$key);
            }
        }
        return new GetEntityConfigFunction(key);
    }

    @Deprecated
    private static Function<Entity, String> displayNameOld() {
        class GetEntityDisplayName
        implements Function<Entity, String> {
            GetEntityDisplayName() {
            }

            public String apply(Entity input) {
                return input == null ? null : input.getDisplayName();
            }
        }
        return new GetEntityDisplayName();
    }

    @Deprecated
    private static Function<Identifiable, String> idOld() {
        class GetIdFunction
        implements Function<Identifiable, String> {
            GetIdFunction() {
            }

            public String apply(Identifiable input) {
                return input == null ? null : input.getId();
            }
        }
        return new GetIdFunction();
    }

    @Deprecated
    private static Function<Entity, Void> settingSensorsConstantOld(Map<AttributeSensor<?>, Object> values) {
        class SettingSensorsConstantFunction
        implements Function<Entity, Void> {
            final /* synthetic */ Map val$values;

            SettingSensorsConstantFunction(Map map) {
                this.val$values = map;
            }

            public Void apply(Entity input) {
                for (Map.Entry entry : this.val$values.entrySet()) {
                    AttributeSensor sensor = (AttributeSensor)entry.getKey();
                    Object value = entry.getValue();
                    if (value == Entities.UNCHANGED) continue;
                    if (value == Entities.REMOVE) {
                        ((EntityInternal)input).sensors().remove(sensor);
                        continue;
                    }
                    value = TypeCoercions.coerce(value, sensor.getTypeToken());
                    ((EntityInternal)input).sensors().set(sensor, value);
                }
                return null;
            }
        }
        return new SettingSensorsConstantFunction(values);
    }

    @Deprecated
    private static <K, V> Function<Entity, Void> updatingSensorMapEntryOld(final AttributeSensor<Map<K, V>> mapSensor, final K key, final Supplier<? extends V> valueSupplier) {
        class UpdatingSensorMapEntryFunction
        implements Function<Entity, Void> {
            UpdatingSensorMapEntryFunction() {
            }

            public Void apply(Entity input) {
                ServiceStateLogic.updateMapSensorEntry(input, mapSensor, key, valueSupplier.get());
                return null;
            }
        }
        return new UpdatingSensorMapEntryFunction();
    }

    @Deprecated
    private static Supplier<Collection<Application>> applicationsOld(ManagementContext mgmt) {
        class AppsSupplier
        implements Supplier<Collection<Application>> {
            final /* synthetic */ ManagementContext val$mgmt;

            AppsSupplier(ManagementContext managementContext) {
                this.val$mgmt = managementContext;
            }

            public Collection<Application> get() {
                return this.val$mgmt.getApplications();
            }
        }
        return new AppsSupplier(mgmt);
    }

    public static Function<Entity, Object> attribute(String attributeName) {
        return EntityFunctions.attribute(Sensors.newSensor(Object.class, attributeName));
    }

    public static <T> Function<Entity, T> attribute(AttributeSensor<T> attribute) {
        return new GetEntityAttributeFunction((AttributeSensor)Preconditions.checkNotNull(attribute, (Object)"attribute"));
    }

    public static Function<Entity, String> attribute(String attributeName, String format) {
        return EntityFunctions.attribute(Sensors.newSensor(Object.class, attributeName), format);
    }

    public static Function<Entity, String> attribute(AttributeSensor<?> attribute, String format) {
        return new FormatEntityAttributeFunction((AttributeSensor)Preconditions.checkNotNull(attribute, (Object)"attribute"), (String)Preconditions.checkNotNull((Object)format, (Object)"format"));
    }

    public static <T> Function<Object, T> attribute(Entity entity, AttributeSensor<T> attribute) {
        return new GetFixedEntityAttributeFunction<T>(entity, attribute);
    }

    public static Function<Entity, Object> config(String keyName) {
        return EntityFunctions.config(ConfigKeys.newConfigKey(Object.class, keyName));
    }

    public static <T> Function<Entity, T> config(ConfigKey<T> key) {
        return new GetEntityConfigFunction((ConfigKey)Preconditions.checkNotNull(key, (Object)"key"));
    }

    public static Function<Entity, String> config(String keyName, String format) {
        return EntityFunctions.config(ConfigKeys.newConfigKey(Object.class, keyName), format);
    }

    public static Function<Entity, String> config(ConfigKey<?> key, String format) {
        return new FormatEntityConfigFunction((ConfigKey)Preconditions.checkNotNull(key, (Object)"key"), (String)Preconditions.checkNotNull((Object)format, (Object)"format"));
    }

    public static Function<Entity, String> displayName() {
        return GetEntityDisplayName.INSTANCE;
    }

    public static Function<Identifiable, String> id() {
        return GetIdFunction.INSTANCE;
    }

    public static Function<Entity, Void> settingSensorsConstant(Map<AttributeSensor<?>, Object> values) {
        return new SettingSensorsConstantFunction((Map)Preconditions.checkNotNull(values, (Object)"values"));
    }

    public static Runnable settingSensorsConstant(Entity entity, Map<AttributeSensor<?>, Object> values) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkNotNull(values, (Object)"values");
        return Functionals.runnable((Supplier)Suppliers.compose(EntityFunctions.settingSensorsConstant(values), (Supplier)Suppliers.ofInstance((Object)entity)));
    }

    public static <K, V> Function<Entity, Void> updatingSensorMapEntry(AttributeSensor<Map<K, V>> mapSensor, K key, Supplier<? extends V> valueSupplier) {
        return new UpdatingSensorMapEntryFunction<K, V>(mapSensor, key, valueSupplier);
    }

    public static <K, V> Runnable updatingSensorMapEntry(Entity entity, AttributeSensor<Map<K, V>> mapSensor, K key, Supplier<? extends V> valueSupplier) {
        return Functionals.runnable((Supplier)Suppliers.compose(EntityFunctions.updatingSensorMapEntry(mapSensor, key, valueSupplier), (Supplier)Suppliers.ofInstance((Object)entity)));
    }

    public static Supplier<Collection<Application>> applications(ManagementContext mgmt) {
        return new AppsSupplier((ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt"));
    }

    public static Function<Entity, Location> locationMatching(Predicate<? super Location> filter) {
        return new LocationMatching(filter);
    }

    public static Function<Entity, Entity> parent() {
        return new EntityParent();
    }

    public static <T> Function<Entity, ConfigKey<T>> configKeyFinder(ConfigKey<T> queryKey, @Nullable ConfigKey<T> defaultValue) {
        return new EntityKeyFinder<T>(queryKey, defaultValue);
    }

    public static <T> Function<Entity, ConfigKey<T>> configKeyFinder(ConfigKey<T> queryKey) {
        return new EntityKeyFinder<T>(queryKey, queryKey);
    }

    private static class EntityKeyFinder<T>
    implements Function<Entity, ConfigKey<T>> {
        private ConfigKey<T> queryKey;
        private ConfigKey<T> defaultValue;

        private EntityKeyFinder() {
        }

        public EntityKeyFinder(ConfigKey<T> queryKey, ConfigKey<T> defaultValue) {
            this.queryKey = queryKey;
            this.defaultValue = defaultValue;
        }

        public ConfigKey<T> apply(Entity entity) {
            return entity != null ? (ConfigKey)JavaGroovyEquivalents.elvis((Object)entity.getEntityType().getConfigKey(this.queryKey.getName()), this.defaultValue) : this.defaultValue;
        }
    }

    private static class EntityParent
    implements Function<Entity, Entity> {
        private EntityParent() {
        }

        public Entity apply(Entity input) {
            return input == null ? null : input.getParent();
        }
    }

    private static class LocationMatching
    implements Function<Entity, Location> {
        private Predicate<? super Location> filter;

        private LocationMatching() {
        }

        public LocationMatching(Predicate<? super Location> filter) {
            this.filter = filter;
        }

        public Location apply(Entity input) {
            return (Location)Iterables.find((Iterable)input.getLocations(), this.filter);
        }
    }

    protected static class AppsSupplier
    implements Supplier<Collection<Application>> {
        private final ManagementContext mgmt;

        public AppsSupplier(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public Collection<Application> get() {
            return this.mgmt.getApplications();
        }
    }

    protected static class UpdatingSensorMapEntryFunction<K, V>
    implements Function<Entity, Void> {
        private final AttributeSensor<Map<K, V>> mapSensor;
        private final K key;
        private final Supplier<? extends V> valueSupplier;

        public UpdatingSensorMapEntryFunction(AttributeSensor<Map<K, V>> mapSensor, K key, Supplier<? extends V> valueSupplier) {
            this.mapSensor = mapSensor;
            this.key = key;
            this.valueSupplier = valueSupplier;
        }

        public Void apply(Entity input) {
            ServiceStateLogic.updateMapSensorEntry(input, this.mapSensor, this.key, this.valueSupplier.get());
            return null;
        }
    }

    protected static class SettingSensorsConstantFunction
    implements Function<Entity, Void> {
        private final Map<AttributeSensor<?>, Object> values;

        protected SettingSensorsConstantFunction(Map<AttributeSensor<?>, Object> values) {
            this.values = values;
        }

        public Void apply(Entity input) {
            for (Map.Entry<AttributeSensor<?>, Object> entry : this.values.entrySet()) {
                AttributeSensor<?> sensor = entry.getKey();
                Object value = entry.getValue();
                if (value == Entities.UNCHANGED) continue;
                if (value == Entities.REMOVE) {
                    ((EntityInternal)input).sensors().remove(sensor);
                    continue;
                }
                value = TypeCoercions.coerce(value, sensor.getTypeToken());
                ((EntityInternal)input).sensors().set(sensor, value);
            }
            return null;
        }
    }

    protected static class GetIdFunction
    implements Function<Identifiable, String> {
        public static final GetIdFunction INSTANCE = new GetIdFunction();

        protected GetIdFunction() {
        }

        public String apply(Identifiable input) {
            return input == null ? null : input.getId();
        }
    }

    protected static class GetEntityDisplayName
    implements Function<Entity, String> {
        public static final GetEntityDisplayName INSTANCE = new GetEntityDisplayName();

        protected GetEntityDisplayName() {
        }

        public String apply(Entity input) {
            return input == null ? null : input.getDisplayName();
        }
    }

    protected static class FormatEntityConfigFunction
    implements Function<Entity, String> {
        private final ConfigKey<?> key;
        private final String format;

        protected FormatEntityConfigFunction(ConfigKey<?> key, String format) {
            this.key = key;
            this.format = format;
        }

        public String apply(Entity input) {
            return input == null ? null : String.format(this.format, input.getConfig(this.key));
        }
    }

    protected static class GetEntityConfigFunction<T>
    implements Function<Entity, T> {
        private final ConfigKey<T> key;

        protected GetEntityConfigFunction(ConfigKey<T> key) {
            this.key = key;
        }

        public T apply(Entity input) {
            return (T)(input == null ? null : input.getConfig(this.key));
        }
    }

    protected static class GetFixedEntityAttributeFunction<T>
    implements Function<Object, T> {
        private final Entity entity;
        private final AttributeSensor<T> attribute;

        protected GetFixedEntityAttributeFunction(Entity entity, AttributeSensor<T> attribute) {
            this.entity = entity;
            this.attribute = attribute;
        }

        public T apply(Object input) {
            return (T)this.entity.getAttribute(this.attribute);
        }
    }

    protected static class FormatEntityAttributeFunction
    implements Function<Entity, String> {
        private final AttributeSensor<?> attribute;
        private final String format;

        protected FormatEntityAttributeFunction(AttributeSensor<?> attribute, String format) {
            this.attribute = attribute;
            this.format = format;
        }

        public String apply(Entity input) {
            return input == null ? null : String.format(this.format, input.getAttribute(this.attribute));
        }
    }

    protected static class GetEntityAttributeFunction<T>
    implements Function<Entity, T> {
        private final AttributeSensor<T> attribute;

        protected GetEntityAttributeFunction(AttributeSensor<T> attribute) {
            this.attribute = attribute;
        }

        public T apply(Entity input) {
            return (T)(input == null ? null : input.getAttribute(this.attribute));
        }
    }
}

