/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractStructuredConfigKey;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapConfigKey<V>
extends AbstractStructuredConfigKey<Map<String, V>, Map<String, Object>, V> {
    private static final long serialVersionUID = -6126481503795562602L;
    private static final Logger log = LoggerFactory.getLogger(MapConfigKey.class);

    public static <V> Builder<V> builder(MapConfigKey<V> key) {
        return new Builder<V>(key);
    }

    private static <V> TypeToken<Map<String, V>> typeTokenFor(TypeToken<V> subType) {
        return new TypeToken<Map<String, V>>(){}.where(new TypeParameter<V>(){}, subType);
    }

    protected MapConfigKey(Builder<V> builder) {
        super(builder, builder.subType);
    }

    public MapConfigKey(TypeToken<V> subType, String name) {
        this(subType, name, name, null);
    }

    public MapConfigKey(TypeToken<V> subType, String name, String description) {
        this(subType, name, description, null);
    }

    public MapConfigKey(TypeToken<V> subType, String name, String description, Map<String, V> defaultValue) {
        super(MapConfigKey.typeTokenFor(subType), subType, name, description, defaultValue);
    }

    public MapConfigKey(Class<V> subType, String name) {
        this((TypeToken<V>)TypeToken.of(subType), name);
    }

    public MapConfigKey(Class<V> subType, String name, String description) {
        this((TypeToken<V>)TypeToken.of(subType), name, description);
    }

    public MapConfigKey(Class<V> subType, String name, String description, Map<String, V> defaultValue) {
        this(TypeToken.of(subType), name, description, defaultValue);
    }

    @Override
    public String toString() {
        return String.format("%s[MapConfigKey:%s]", this.name, this.getTypeName());
    }

    @Override
    public ConfigKey<V> subKey(String subName) {
        return super.subKey(subName);
    }

    @Override
    public ConfigKey<V> subKey(String subName, String description) {
        return super.subKey(subName, description);
    }

    @Override
    protected Map<String, Object> extractValueMatchingThisKey(Object potentialBase, ExecutionContext exec, boolean coerce) throws InterruptedException, ExecutionException {
        if (coerce) {
            potentialBase = this.resolveValue(potentialBase, exec);
        }
        if (potentialBase == null) {
            return null;
        }
        if (potentialBase instanceof Map) {
            return Maps.newLinkedHashMap((Map)((Map)potentialBase));
        }
        log.warn("Unable to extract " + this.getName() + " as Map; it is " + potentialBase.getClass().getName() + " " + potentialBase);
        return null;
    }

    @Override
    protected Map<String, Object> merge(Map<String, Object> base, Map<String, Object> subkeys, boolean unmodifiable) {
        Object result = MutableMap.copyOf(base).add(subkeys);
        if (unmodifiable) {
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    @Override
    public Object applyValueToMap(Object value, Map target) {
        if (value == null) {
            return null;
        }
        if (value instanceof StructuredConfigKey.StructuredModification) {
            return ((StructuredConfigKey.StructuredModification)value).applyToKeyInMap(this, target);
        }
        if (value instanceof Map.Entry) {
            return this.applyEntryValueToMap((Map.Entry)value, target);
        }
        if (!(value instanceof Map)) {
            if (ValueResolver.isDeferredOrTaskInternal(value)) {
                boolean isSet = this.isSet(target);
                if (isSet) {
                    String warning = "Discouraged undecorated setting of a task to in-use StructuredConfigKey " + this + ": use MapModification.{set,add}. Defaulting to replacing root. Look at debug logging for call stack.";
                    log.warn(warning);
                    if (log.isDebugEnabled()) {
                        log.debug("Trace for: " + warning, new Throwable("Trace for: " + warning));
                    }
                }
                return target.put(this, value);
            }
            Maybe<Map> coercedValue = TypeCoercions.tryCoerce(value, Map.class);
            if (coercedValue.isPresent()) {
                log.trace("Coerced value for {} from type {} to map", (Object)this, (Object)value.getClass().getName());
                value = coercedValue.get();
            } else {
                throw new IllegalArgumentException("Cannot set non-map entries on " + this + ", given type " + value.getClass().getName() + ", value " + value);
            }
        }
        MutableMap result = new MutableMap();
        Iterator iterator = ((Map)value).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entryT = entry = iterator.next();
            result.put(entryT.getKey(), this.applyEntryValueToMap(entryT, target));
        }
        if (((Map)value).isEmpty() && !this.isSet(target)) {
            target.put(this, MutableMap.of());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object applyEntryValueToMap(Map.Entry value, Map target) {
        Object k = value.getKey();
        if (!this.acceptsSubkeyStronglyTyped(k)) {
            if (k instanceof ConfigKey) {
                k = this.subKey(((ConfigKey)k).getName());
            } else if (k instanceof String) {
                k = this.subKey((String)k);
            } else {
                if (k instanceof Supplier) {
                    Object mapAtRoot = target.get(this);
                    if (mapAtRoot == null) {
                        mapAtRoot = new LinkedHashMap();
                        target.put(this, mapAtRoot);
                    }
                    if (mapAtRoot instanceof Map) {
                        if (mapAtRoot instanceof ConcurrentMap) {
                            return ((Map)mapAtRoot).put(k, value.getValue());
                        }
                        Object object = mapAtRoot;
                        synchronized (object) {
                            return ((Map)mapAtRoot).put(k, value.getValue());
                        }
                    }
                }
                log.warn("Unexpected subkey " + k + " being inserted into " + this + "; ignoring");
                k = null;
            }
        }
        if (k != null) {
            return target.put(k, value.getValue());
        }
        return null;
    }

    public static class MapModificationBase<V>
    extends LinkedHashMap<String, V>
    implements MapModification<V> {
        private static final long serialVersionUID = -1670820613292286486L;
        private final boolean clearFirst;

        public MapModificationBase(Map<String, V> delegate, boolean clearFirst) {
            super(delegate);
            this.clearFirst = clearFirst;
        }

        @Override
        public Object applyToKeyInMap(MapConfigKey<V> key, Map target) {
            if (this.clearFirst) {
                MapConfigKey<V> clearing = StructuredConfigKey.StructuredModifications.clearing();
                clearing.applyToKeyInMap(key, target);
            }
            return key.applyValueToMap(new LinkedHashMap(this), target);
        }
    }

    public static class MapModifications
    extends StructuredConfigKey.StructuredModifications {
        public static final <V> MapModification<V> put(Map<String, V> itemsToPutInMapReplacing) {
            return new MapModificationBase<V>(itemsToPutInMapReplacing, false);
        }

        public static final <V> MapModification<V> set(Map<String, V> itemsToPutInMapAfterClearing) {
            return new MapModificationBase<V>(itemsToPutInMapAfterClearing, true);
        }

        public static final <V> MapModification<V> add(Map<String, V> itemsToAdd) {
            return new MapModificationBase<V>((Map)itemsToAdd, false){
                private static final long serialVersionUID = 1L;

                @Override
                public Object applyToKeyInMap(MapConfigKey<V> key, Map target) {
                    return key.applyValueToMap(Jsonya.of((Map)((Map)key.rawValue(target))).add((Object)this, new Object[0]).getRootMap(), target);
                }
            };
        }
    }

    public static interface MapModification<V>
    extends StructuredConfigKey.StructuredModification<MapConfigKey<V>>,
    Map<String, V> {
    }

    public static class Builder<V>
    extends BasicConfigKey.Builder<Map<String, V>, Builder<V>> {
        protected TypeToken<V> subType;

        public Builder(TypeToken<V> subType, String name) {
            super(MapConfigKey.typeTokenFor(subType), name);
            this.subType = subType;
        }

        public Builder(Class<V> subType, String name) {
            this((TypeToken<V>)TypeToken.of(subType), name);
        }

        public Builder(MapConfigKey<V> key) {
            this(key.getName(), key);
        }

        public Builder(String newName, MapConfigKey<V> key) {
            super(newName, key);
            this.subType = ((MapConfigKey)key).getSubTypeToken();
        }

        @Override
        public Builder<V> self() {
            return this;
        }

        @Override
        @Deprecated
        public Builder<V> name(String val) {
            throw new UnsupportedOperationException("Builder must be constructed with name");
        }

        @Override
        @Deprecated
        public Builder<V> type(Class<Map<String, V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        @Deprecated
        public Builder<V> type(TypeToken<Map<String, V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        public MapConfigKey<V> build() {
            return new MapConfigKey(this);
        }
    }
}

