/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.postgresql;

import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.entity.database.postgresql.PostgreSqlDriver;
import org.apache.brooklyn.entity.database.postgresql.PostgreSqlNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlNodeImpl
extends SoftwareProcessImpl
implements PostgreSqlNode {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlNodeImpl.class);

    public Class<?> getDriverInterface() {
        return PostgreSqlDriver.class;
    }

    public PostgreSqlDriver getDriver() {
        return (PostgreSqlDriver)super.getDriver();
    }

    @Override
    public Integer getPostgreSqlPort() {
        return (Integer)this.getAttribute((AttributeSensor)POSTGRESQL_PORT);
    }

    @Override
    public String getSharedMemory() {
        return (String)this.getConfig(SHARED_MEMORY);
    }

    @Override
    public Integer getMaxConnections() {
        return (Integer)this.getConfig(MAX_CONNECTIONS);
    }

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return PostgreSqlNodeImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        });
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.sensors().set(DATASTORE_URL, (Object)String.format("postgresql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)POSTGRESQL_PORT)));
    }

    protected void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    public String getShortName() {
        return "PostgreSQL";
    }

    @Override
    public String executeScript(String commands) {
        return this.getDriver().executeScriptAsync(commands).block().getStdout();
    }
}

