/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.binders;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.auth.domain.PasswordCredentials;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.v3.binders.BindAuthToJsonPayload;
import org.jclouds.openstack.keystone.v3.domain.Auth;

@Singleton
public class BindPasswordAuthToJsonPayload
extends BindAuthToJsonPayload<PasswordCredentials> {
    @Inject
    BindPasswordAuthToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    protected Auth buildAuth(TenantOrDomainAndCredentials<PasswordCredentials> credentials, Object scope) {
        PasswordCredentials creds = credentials.credentials();
        Auth.Identity.PasswordAuth.UserAuth.DomainAuth domain = Auth.Identity.PasswordAuth.UserAuth.DomainAuth.create(credentials.tenantOrDomainName());
        Auth.Identity.PasswordAuth.UserAuth user = Auth.Identity.PasswordAuth.UserAuth.create(creds.username(), domain, creds.password());
        return Auth.create(Auth.Identity.create(Collections.singletonList("password"), null, Auth.Identity.PasswordAuth.create(user)), scope);
    }
}

