/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.camp.commontypes.RepresentationSkew;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Time;

public class AbstractResource {
    public static final String CAMP_TYPE = "Resource";
    private String id = Identifiers.makeRandomId((int)8);
    private String name;
    private String type;
    private String description;
    private String sourceCode;
    private Date created = Time.dropMilliseconds((Date)new Date());
    private List<String> tags = Collections.emptyList();
    private RepresentationSkew representationSkew;
    private Map<String, Object> customAttributes = new MutableMap();

    protected AbstractResource() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public Date getCreated() {
        return this.created;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public RepresentationSkew getRepresentationSkew() {
        return this.representationSkew;
    }

    public Map<String, Object> getCustomAttributes() {
        return MutableMap.copyOf(this.customAttributes).asUnmodifiable();
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    private void setCreated(Date created) {
        this.created = Time.dropMilliseconds((Date)created);
    }

    private void setTags(List<String> tags) {
        this.tags = ImmutableList.copyOf(tags);
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setRepresentationSkew(RepresentationSkew representationSkew) {
        this.representationSkew = representationSkew;
    }

    public void setCustomAttribute(String key, Object value) {
        this.customAttributes.put(key, value);
    }

    public static Builder<? extends AbstractResource, ? extends Builder> builder() {
        AbstractResource abstractResource = new AbstractResource();
        abstractResource.getClass();
        return abstractResource.new AbstractResourceBuilder(CAMP_TYPE);
    }

    public String toString() {
        return super.toString() + "[id=" + this.getId() + "; type=" + this.getType() + "]";
    }

    @VisibleForTesting
    protected class AbstractResourceBuilder
    extends Builder<AbstractResource, AbstractResourceBuilder> {
        protected AbstractResourceBuilder(String type) {
            super(type);
        }
    }

    public abstract class Builder<T extends AbstractResource, U extends Builder<T, U>> {
        private boolean built = false;
        private String type = null;
        private boolean initialized = false;

        protected Builder(String type) {
            this.type = type;
        }

        protected final synchronized void check() {
            if (this.built) {
                throw new IllegalStateException("Builder instance from " + this + " cannot be access after build");
            }
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
        }

        protected void initialize() {
            if (this.type != null) {
                this.type(this.type);
            }
        }

        public synchronized T build() {
            this.check();
            this.built = true;
            return (T)AbstractResource.this;
        }

        protected U thisBuilder() {
            return (U)this;
        }

        public U type(String x) {
            this.check();
            AbstractResource.this.setType(x);
            return this.thisBuilder();
        }

        public U id(String x) {
            this.check();
            AbstractResource.this.setId(x);
            return this.thisBuilder();
        }

        public U name(String x) {
            this.check();
            AbstractResource.this.setName(x);
            return this.thisBuilder();
        }

        public U description(String x) {
            this.check();
            AbstractResource.this.setDescription(x);
            return this.thisBuilder();
        }

        public U created(Date x) {
            this.check();
            AbstractResource.this.setCreated(x);
            return this.thisBuilder();
        }

        public U tags(List<String> x) {
            this.check();
            AbstractResource.this.setTags(x);
            return this.thisBuilder();
        }

        public U representationSkew(RepresentationSkew x) {
            this.check();
            AbstractResource.this.setRepresentationSkew(x);
            return this.thisBuilder();
        }

        public U customAttribute(String key, Object value) {
            this.check();
            AbstractResource.this.setCustomAttribute(key, value);
            return this.thisBuilder();
        }

        public U sourceCode(String x) {
            this.check();
            AbstractResource.this.setSourceCode(x);
            return this.thisBuilder();
        }
    }
}

