/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.nic;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.http.parser.firewall.FirewallResponseHandler;
import org.jclouds.profitbricks.http.parser.nic.BaseNicResponseHandler;
import org.xml.sax.SAXException;

public class NicListResponseHandler
extends BaseNicResponseHandler<List<Nic>> {
    private List<Nic> nics = Lists.newArrayList();

    @Inject
    public NicListResponseHandler(FirewallResponseHandler firewallResponseHandler) {
        super(firewallResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.useFirewallParser) {
            this.firewallResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName) || "nics".equals(qName)) {
                this.nics.add(this.builder.ips(this.ips).firewall(this.firewallResponseHandler.getResult()).build());
                this.builder = Nic.builder();
                this.ips = new ArrayList();
                this.firewallResponseHandler.reset();
            }
            this.clearTextBuffer();
        }
        if ("firewall".equals(qName)) {
            this.useFirewallParser = false;
        }
    }

    @Override
    public void reset() {
        this.ips = new ArrayList();
        this.nics = Lists.newArrayList();
    }

    public List<Nic> getResult() {
        return this.nics;
    }
}

