/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class BrooklynFeatureSummary
implements Serializable {
    private static final long serialVersionUID = 4595452639602650453L;
    private final String name;
    private final String symbolicName;
    private final String version;
    private final String lastModified;
    private Map<String, String> additionalData = Maps.newHashMap();

    public BrooklynFeatureSummary(@JsonProperty(value="name") String name, @JsonProperty(value="symbolicName") String symbolicName, @JsonProperty(value="version") String version, @JsonProperty(value="lastModified") String lastModified) {
        this.symbolicName = (String)Preconditions.checkNotNull((Object)symbolicName, (Object)"symbolicName");
        this.name = name;
        this.version = version;
        this.lastModified = lastModified;
    }

    public BrooklynFeatureSummary(String name, String symbolicName, String version, String lastModified, Map<String, String> additionalData) {
        this(name, symbolicName, version, lastModified);
        this.additionalData = additionalData;
    }

    @JsonIgnore
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    @JsonAnyGetter
    private Map<String, String> any() {
        return this.additionalData;
    }

    @JsonAnySetter
    private void set(String name, String value) {
        this.additionalData.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrooklynFeatureSummary)) {
            return false;
        }
        BrooklynFeatureSummary that = (BrooklynFeatureSummary)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.symbolicName, that.symbolicName) && Objects.equals(this.version, that.version) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.additionalData, that.additionalData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.symbolicName, this.version, this.lastModified, this.additionalData);
    }

    public String toString() {
        return "BrooklynFeatureSummary{name='" + this.name + '\'' + ", symbolicName='" + this.symbolicName + '\'' + ", version='" + this.version + '\'' + ", lastModified='" + this.lastModified + '\'' + ", additionalData=" + this.additionalData + '}';
    }
}

