/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.slf4j;

import org.jclouds.logging.BaseLogger;
import org.jclouds.logging.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
extends BaseLogger {
    private final org.slf4j.Logger logger;
    private final String category;

    public SLF4JLogger(String category, org.slf4j.Logger logger) {
        this.category = category;
        this.logger = logger;
    }

    protected void logTrace(String message) {
        this.logger.trace(message);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    protected void logDebug(String message) {
        this.logger.debug(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    protected void logInfo(String message) {
        this.logger.info(message);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    protected void logWarn(String message) {
        this.logger.warn(message);
    }

    protected void logWarn(String message, Throwable e) {
        this.logger.warn(message, e);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    protected void logError(String message) {
        this.logger.error(message);
    }

    protected void logError(String message, Throwable e) {
        this.logger.error(message, e);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public String getCategory() {
        return this.category;
    }

    static {
        LoggerFactory.getILoggerFactory();
    }

    public static class SLF4JLoggerFactory
    implements Logger.LoggerFactory {
        public Logger getLogger(String category) {
            return new SLF4JLogger(category, LoggerFactory.getLogger((String)category));
        }
    }
}

