/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.utils;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class WorkflowConcurrencyParser {
    String concurrencyExpression;
    String rest;
    boolean negated = true;

    public static Function<Double, Double> parse(String concurrencyExpression) {
        return new WorkflowConcurrencyParser(concurrencyExpression).parse();
    }

    protected WorkflowConcurrencyParser(String concurrencyExpression) {
        this.concurrencyExpression = concurrencyExpression;
    }

    public Function<Double, Double> parse() {
        this.rest = Strings.trimStart((String)this.concurrencyExpression.toLowerCase());
        Term result = this.parseExpression(true);
        if (!Strings.isBlank((CharSequence)this.rest)) {
            throw this.error("Unexpected content");
        }
        return result::apply;
    }

    public Term parseExpression(boolean required) {
        MutableList totot = MutableList.of();
        boolean first = true;
        while (true) {
            Term t;
            if (!first) {
                Op op = this.parseOp(false);
                if (op == null) break;
                totot.add(op);
            }
            if ((t = this.parseTerm(first ? required : false)) == null) {
                return null;
            }
            totot.add(t);
            first = false;
        }
        return this.orderOpsInExpression((List<Object>)totot);
    }

    private Term orderOpsInExpression(List<Object> totot) {
        if (totot.size() <= 1) {
            return (Term)Iterables.getOnlyElement(totot);
        }
        Op max = null;
        for (Object i : totot) {
            if (!(i instanceof Op) || max != null && ((Op)i).precedance < max.precedance) continue;
            max = (Op)i;
        }
        return max.build(this.orderOpsInExpression(totot.subList(0, totot.indexOf(max))), this.orderOpsInExpression(totot.subList(totot.indexOf(max) + 1, totot.size())));
    }

    Maybe<Op> eatOp(String name, int precedance, BiFunction<Double, Double, Double> fn) {
        if (this.eat(name)) {
            return Maybe.of((Object)Op.of(name, precedance, fn));
        }
        return Maybe.absent();
    }

    Maybe<Term> eatFn(String word, Function<List<Double>, Double> fn) {
        if (this.eatNA(word)) {
            List<Term> args = this.parseGroupedList(false);
            return Maybe.of((Object)Fn.of(word + "(" + args.stream().map(t -> t.name).collect(Collectors.joining(",")) + ")", args, fn));
        }
        return Maybe.absent();
    }

    public <T> T notNull(T value, String message) {
        if (value != null) {
            return value;
        }
        throw this.error(message);
    }

    public boolean eat(String word) {
        return this.eat(word, false);
    }

    public boolean eat(String word, boolean requireNextNonAlpha) {
        if (this.rest.startsWith(word)) {
            this.rest = this.rest.substring(word.length());
            if (requireNextNonAlpha && !this.rest.isEmpty() && Character.isJavaIdentifierPart(this.rest.charAt(0))) {
                this.rest = word + this.rest;
                return false;
            }
            this.rest = Strings.trimStart((String)this.rest);
            return true;
        }
        return false;
    }

    public boolean eatNA(String word) {
        return this.eat(word, true);
    }

    protected RuntimeException error(String prefix) {
        throw new IllegalArgumentException(prefix + " at position " + (this.concurrencyExpression.length() - this.rest.length()));
    }

    public List<Term> parseGroupedList(boolean consumedStart) {
        Term expr;
        if (!consumedStart && !this.eat("(")) {
            throw new IllegalStateException("Expected '('");
        }
        MutableList terms = MutableList.of();
        while ((expr = this.parseExpression(false)) != null) {
            terms.add(expr);
            if (this.eat(",")) continue;
            break;
        }
        if (!this.eat(")")) {
            throw new IllegalStateException("Expected ')'");
        }
        return terms;
    }

    public Term parseGroupedTerm(boolean consumedStart) {
        if (!consumedStart && !this.eat("(")) {
            throw new IllegalStateException("Expected '('");
        }
        Term result = this.parseTerm(true);
        if (!this.eat(")")) {
            throw new IllegalStateException("Expected ')'");
        }
        return result;
    }

    public Term parseTerm(boolean required) {
        if (this.eat("-")) {
            if (this.negated) {
                throw this.error("Unpermitted double negative");
            }
            this.negated = true;
            final Term target = this.parseTerm(true);
            Term t = new Term(){

                @Override
                Double apply(Double value) {
                    return WorkflowConcurrencyParser.fromEndIfNeg(-target.apply(value).doubleValue(), value);
                }
            };
            t.name = "-";
            return t;
        }
        this.negated = false;
        Maybe<Term> term = this.eatFn("min", WorkflowConcurrencyParser::min);
        if (term.isPresent()) {
            return (Term)term.get();
        }
        term = this.eatFn("max", WorkflowConcurrencyParser::max);
        if (term.isPresent()) {
            return (Term)term.get();
        }
        if (this.eat("(")) {
            return this.parseGroupedTerm(true);
        }
        if (this.eatNA("all")) {
            return Term.of("all", d -> d);
        }
        char c = this.rest.charAt(0);
        if (Character.isDigit(this.rest.charAt(0))) {
            int i;
            for (i = 1; i < this.rest.length() && WorkflowConcurrencyParser.isNumberChar(this.rest.charAt(i)); ++i) {
            }
            double d2 = Double.parseDouble(this.rest.substring(0, i));
            this.rest = Strings.trimStart((String)this.rest.substring(i));
            if (this.eat("%")) {
                return Term.of("%", value -> WorkflowConcurrencyParser.fromEndIfNeg(value * d2 / 100.0, value));
            }
            return Term.of("#", value -> WorkflowConcurrencyParser.fromEndIfNeg(d2, value));
        }
        if (required) {
            throw this.error("Expression required");
        }
        return null;
    }

    static double fromEndIfNeg(double valueComputed, double valueAll) {
        if (valueComputed < 0.001) {
            valueComputed = valueAll + valueComputed;
        }
        if (valueComputed < 0.0) {
            return 0.0;
        }
        return valueComputed;
    }

    static boolean isNumberChar(char c) {
        return Character.isDigit(c) || c == '.';
    }

    public static Double min(List<Double> values) {
        Double result = null;
        for (Double d : values) {
            if (d == null || result != null && !(d < result)) continue;
            result = d;
        }
        return result;
    }

    public static Double max(List<Double> values) {
        Double result = null;
        for (Double d : values) {
            if (d == null || result != null && !(d > result)) continue;
            result = d;
        }
        return result;
    }

    public Op parseOp(boolean required) {
        Maybe<Op> term = this.eatOp("+", 1, (a, b) -> a + b);
        if (term.isPresent()) {
            return (Op)term.get();
        }
        term = this.eatOp("-", 1, (a, b) -> a - b);
        if (term.isPresent()) {
            return (Op)term.get();
        }
        if (required) {
            throw this.error("Valid operation expected (+ or -)");
        }
        return null;
    }

    static abstract class Fn {
        Fn() {
        }

        abstract Term build(List<Term> var1);

        static Term of(final String name, List<Term> terms, final Function<List<Double>, Double> fn) {
            return new Fn(){

                @Override
                Term build(List<Term> terms) {
                    Term t = Term.of(name + "(" + terms.stream().map(ti -> ti.name).collect(Collectors.joining(",")) + ")", value -> (Double)fn.apply(terms.stream().map(ti -> ti.apply((Double)value)).collect(Collectors.toList())));
                    t.name = name;
                    return t;
                }
            }.build(terms);
        }
    }

    static abstract class Op {
        String name;
        int precedance;

        Op() {
        }

        abstract Term build(Term var1, Term var2);

        static Op of(String name, int precedance, final BiFunction<Double, Double, Double> fn) {
            Op result = new Op(){

                @Override
                Term build(Term t1, Term t2) {
                    return Term.of(this.name + "(" + t1.name + "," + t2.name + ")", value -> (Double)fn.apply(t1.apply((Double)value), t2.apply((Double)value)));
                }
            };
            result.name = name;
            result.precedance = precedance;
            return result;
        }
    }

    static abstract class Term {
        String name;

        Term() {
        }

        abstract Double apply(Double var1);

        static Term of(String name, final Function<Double, Double> fn) {
            Term t = new Term(){

                @Override
                Double apply(Double value) {
                    return (Double)fn.apply(value);
                }
            };
            t.name = name;
            return t;
        }
    }
}

