/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.internal;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.core.config.internal.LazyContainerAndKeyValue;
import org.apache.brooklyn.util.guava.Maybe;

public class AncestorContainerAndKeyValueIterator<TContainer, TValue>
implements Iterator<ConfigValueAtContainer<TContainer, TValue>> {
    private TContainer lastContainer;
    private final Function<TContainer, ConfigKey<TValue>> keyFindingFunction;
    private final Function<TContainer, Maybe<Object>> lookupResolutionFunction;
    private final Function<Maybe<Object>, Maybe<TValue>> coercionFunction;
    private final Function<TContainer, TContainer> parentFunction;

    public AncestorContainerAndKeyValueIterator(TContainer childContainer, Function<TContainer, ConfigKey<TValue>> keyFindingFunction, Function<TContainer, Maybe<Object>> lookupResolutionFunction, Function<Maybe<Object>, Maybe<TValue>> coercionFunction, Function<TContainer, TContainer> parentFunction) {
        this.lastContainer = childContainer;
        this.keyFindingFunction = keyFindingFunction;
        this.lookupResolutionFunction = lookupResolutionFunction;
        this.coercionFunction = coercionFunction;
        this.parentFunction = parentFunction;
    }

    @Override
    public boolean hasNext() {
        return this.parentFunction.apply(this.lastContainer) != null;
    }

    @Override
    public ConfigValueAtContainer<TContainer, TValue> next() {
        Object nextContainer = this.parentFunction.apply(this.lastContainer);
        if (nextContainer == null) {
            throw new NoSuchElementException("Cannot search ancestors further than " + this.lastContainer);
        }
        this.lastContainer = nextContainer;
        return new LazyContainerAndKeyValue<TContainer, TValue>((ConfigKey)this.keyFindingFunction.apply(this.lastContainer), this.lastContainer, this.lookupResolutionFunction, this.coercionFunction);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removal");
    }
}

