/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBSshDriver;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClient;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientDriver;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeployment;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.math.MathPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBClientSshDriver
extends AbstractMongoDBSshDriver
implements MongoDBClientDriver {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBClientSshDriver.class);
    private boolean isRunning = false;

    public MongoDBClientSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public void customize() {
        String command = String.format("mkdir -p %s", this.getUserScriptDir());
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
        Map scripts = (Map)this.entity.getConfig(MongoDBClient.JS_SCRIPTS);
        for (String scriptName : scripts.keySet()) {
            this.copyResource((String)scripts.get(scriptName), this.getUserScriptDir() + scriptName + ".js");
        }
    }

    public void launch() {
        AbstractMongoDBServer server = this.getServer();
        String host = (String)server.getAttribute(AbstractMongoDBServer.HOSTNAME);
        Integer port = (Integer)server.getAttribute((AttributeSensor)AbstractMongoDBServer.PORT);
        List scripts = (List)this.entity.getConfig(MongoDBClient.STARTUP_JS_SCRIPTS);
        if (scripts != null) {
            for (String scriptName : scripts) {
                try {
                    LOG.debug("Running MongoDB script " + scriptName + " at " + this.getEntity());
                    this.runScript("", scriptName, host, port);
                }
                catch (Exception e) {
                    LOG.warn("Error running MongoDB script " + scriptName + " at " + this.getEntity() + ", throwing: " + e);
                    this.isRunning = false;
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new IllegalStateException("Error running MongoDB script " + scriptName + " at " + this.entity + ": " + e, e);
                }
            }
        }
        this.isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            this.isRunning = false;
        }
    }

    private String getUserScriptDir() {
        return this.getRunDir() + "/userScripts/";
    }

    @Override
    public void runScript(String preStart, String scriptName) {
        AbstractMongoDBServer server = this.getServer();
        String host = (String)server.getAttribute(AbstractMongoDBServer.HOSTNAME);
        Integer port = (Integer)server.getAttribute((AttributeSensor)AbstractMongoDBServer.PORT);
        this.runScript(preStart, scriptName, host, port);
    }

    private void runScript(String preStart, String scriptName, String host, Integer port) {
        String command = String.format("%s/bin/mongo %s:%s --eval \"%s\" %s/%s > out.log 2> err.log < /dev/null", this.getExpandedInstallDir(), host, port, preStart, this.getUserScriptDir(), scriptName + ".js");
        this.newScript((String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }

    private AbstractMongoDBServer getServer() {
        AbstractMongoDBServer server = (AbstractMongoDBServer)this.entity.getConfig(MongoDBClient.SERVER);
        MongoDBShardedDeployment deployment = (MongoDBShardedDeployment)this.entity.getConfig(MongoDBClient.SHARDED_DEPLOYMENT);
        if (server == null) {
            Preconditions.checkNotNull((Object)deployment, (String)"Either server or shardedDeployment must be specified for %s", (Object)this);
            server = (AbstractMongoDBServer)DependentConfiguration.builder().attributeWhenReady((Entity)deployment.getRouterCluster(), MongoDBRouterCluster.ANY_ROUTER).blockingDetails("any available router").runNow();
            DependentConfiguration.builder().attributeWhenReady((Entity)server, MongoDBRouter.SHARD_COUNT).readiness(MathPredicates.greaterThan((double)0.0)).runNow();
        } else {
            if (deployment != null) {
                log.warn("Server and ShardedDeployment defined for {}; using server ({} instead of {})", new Object[]{this, server, deployment});
            }
            DependentConfiguration.builder().attributeWhenReady((Entity)server, Startable.SERVICE_UP).readiness(Predicates.equalTo((Object)true)).runNow();
        }
        return server;
    }
}

