/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.xml.HostedZoneHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ListHostedZonesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<HostedZone>> {
    private final HostedZoneHandler zoneHandler;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableList.Builder<HostedZone> zones = ImmutableList.builder();
    private boolean inHostedZones;
    private String afterMarker;

    @Inject
    public ListHostedZonesResponseHandler(HostedZoneHandler zoneHandler) {
        this.zoneHandler = zoneHandler;
    }

    public IterableWithMarker<HostedZone> getResult() {
        try {
            IterableWithMarker iterableWithMarker = IterableWithMarkers.from((Iterable)this.zones.build(), (Object)this.afterMarker);
            return iterableWithMarker;
        }
        finally {
            this.zones = ImmutableList.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"HostedZones")) {
            this.inHostedZones = true;
        }
        if (this.inHostedZones) {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inHostedZones) {
            if (qName.equals("HostedZones")) {
                this.inHostedZones = false;
            } else if (qName.equals("HostedZone")) {
                this.zones.add((Object)this.zoneHandler.getResult());
            } else {
                this.zoneHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextMarker")) {
            this.afterMarker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inHostedZones) {
            this.zoneHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

