/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.postgresql;

import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.chef.ChefConfig;
import org.apache.brooklyn.entity.chef.ChefLifecycleEffectorTasks;
import org.apache.brooklyn.entity.chef.ChefServerTasks;
import org.apache.brooklyn.entity.database.postgresql.PostgreSqlNode;
import org.apache.brooklyn.entity.stock.EffectorStartableImpl;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlNodeChefImplFromScratch
extends EffectorStartableImpl
implements PostgreSqlNode {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlNodeChefImplFromScratch.class);
    public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(String.class, (String)"executeScript").description("invokes a script").parameter(ExecuteScriptEffectorBody.SCRIPT).impl((EffectorBody)new ExecuteScriptEffectorBody()).build();
    private SshFeed feed;

    public void init() {
        super.init();
        new ChefPostgreSqlLifecycle().attachLifecycleEffectors(this);
    }

    @Override
    public Integer getPostgreSqlPort() {
        return (Integer)this.getAttribute((AttributeSensor)POSTGRESQL_PORT);
    }

    @Override
    public String getSharedMemory() {
        return (String)this.getConfig(SHARED_MEMORY);
    }

    @Override
    public Integer getMaxConnections() {
        return (Integer)this.getConfig(MAX_CONNECTIONS);
    }

    public String getShortName() {
        return "PostgreSQL";
    }

    protected void connectSensors() {
        this.sensors().set(DATASTORE_URL, (Object)String.format("postgresql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)POSTGRESQL_PORT)));
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        if (machine.isPresent()) {
            this.feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).machine((MachineLocation)machine.get())).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(SERVICE_UP).command("ps -ef | grep [p]ostgres").setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }

    @Override
    public String executeScript(String commands) {
        return (String)Entities.invokeEffector((Entity)this, (Entity)this, EXECUTE_SCRIPT, (Map)ConfigBag.newInstance().configure(ExecuteScriptEffectorBody.SCRIPT, (Object)commands).getAllConfig()).getUnchecked();
    }

    public void populateServiceNotUpDiagnostics() {
    }

    public static class ExecuteScriptEffectorBody
    extends EffectorBody<String> {
        public static final ConfigKey<String> SCRIPT = ConfigKeys.newStringConfigKey((String)"script", (String)"contents of script to run");

        public String call(ConfigBag parameters) {
            return ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.pipeTextTo((String)((String)parameters.get(SCRIPT)), (String)BashCommands.sudoAsUser((String)"postgres", (String)"psql --file -"))}).requiringExitCodeZero())).getStdout();
        }
    }

    public static class ChefPostgreSqlLifecycle
    extends ChefLifecycleEffectorTasks {
        public ChefPostgreSqlLifecycle() {
            this.usePidFile("/var/run/postgresql/*.pid");
            this.useService("postgresql");
        }

        protected void startWithKnifeAsync() {
            Entities.warnOnIgnoringConfig((Entity)this.entity(), (ConfigKey)ChefConfig.CHEF_LAUNCH_RUN_LIST);
            Entities.warnOnIgnoringConfig((Entity)this.entity(), (ConfigKey)ChefConfig.CHEF_LAUNCH_ATTRIBUTES);
            DynamicTasks.queue((TaskFactory)ChefServerTasks.knifeConvergeRunList((String)"postgresql::server").knifeAddAttributes(Jsonya.at((Object[])new Object[]{"postgresql", "config"}).add((Object)"port", new Object[]{this.entity().getPostgreSqlPort(), "listen_addresses", "*"}).getRootMap()).knifeAddAttributes(Jsonya.at((Object[])new Object[]{"postgresql", "pg_hba"}).list().map().add((Object)"type", new Object[]{"host", "db", "all", "user", "all", "addr", "0.0.0.0/0", "method", "md5"}).getRootMap()));
        }

        protected void postStartCustom() {
            String creationScriptUrl = (String)this.entity().getConfig(PostgreSqlNode.CREATION_SCRIPT_URL);
            String creationScript = creationScriptUrl != null ? ResourceUtils.create((Object)this.entity()).getResourceAsString(creationScriptUrl) : (String)this.entity().getConfig(PostgreSqlNode.CREATION_SCRIPT_CONTENTS);
            this.entity().executeScript(creationScript);
            this.entity().connectSensors();
            super.postStartCustom();
        }

        protected void preStopCustom() {
            this.entity().disconnectSensors();
            super.preStopCustom();
        }

        protected PostgreSqlNodeChefImplFromScratch entity() {
            return (PostgreSqlNodeChefImplFromScratch)super.entity();
        }
    }
}

