/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerIndependentOuterClassFieldMapper
extends MapperWrapper
implements Caching {
    public static final Logger LOG = LoggerFactory.getLogger(CompilerIndependentOuterClassFieldMapper.class);
    private static final String OUTER_CLASS_FIELD_PREFIX = "this$";
    private final Map<String, Collection<String>> classOuterFields = new ConcurrentHashMap<String, Collection<String>>();

    public CompilerIndependentOuterClassFieldMapper(Mapper wrapped) {
        super(wrapped);
        this.classOuterFields.put(Object.class.getName(), Collections.emptyList());
    }

    public String realMember(Class type, String serialized) {
        String serializedFieldName = super.realMember(type, serialized);
        if (serializedFieldName.startsWith(OUTER_CLASS_FIELD_PREFIX)) {
            String deserializeFieldName;
            Collection<String> compiledFieldNames = this.findOuterClassFieldNames(type);
            if (compiledFieldNames.size() == 0) {
                throw new IllegalStateException("Unable to find any outer class fields in " + type + ", searching specifically for " + serializedFieldName);
            }
            HashSet<String> uniqueFieldNames = new HashSet<String>(compiledFieldNames);
            if (!compiledFieldNames.contains(serializedFieldName)) {
                String msg = "Unable to find outer class field " + serializedFieldName + " in class " + type + ". This could be caused by 1) changing the class (or one of its parents) to a static or 2) moving the class to a different lexical level (enclosing classes) or 3) using a different compiler (i.e eclipse vs oracle) at the time the object was serialized. ";
                if (uniqueFieldNames.size() == 1) {
                    deserializeFieldName = compiledFieldNames.iterator().next();
                    LOG.warn(msg + "Will use the field " + deserializeFieldName + " instead.");
                } else {
                    LOG.error(msg + "Will fail with a field not found exception. Edit the persistence state manually and update the field names. Existing field names are " + uniqueFieldNames);
                    deserializeFieldName = serializedFieldName;
                }
            } else {
                if (uniqueFieldNames.size() > 1) {
                    LOG.debug("Deserializing the non-static class " + type + " with multiple outer class fields " + uniqueFieldNames + ". When changing compilers it's possible that the instance won't be able to be deserialized due to changed outer class field names. In those cases deserialization could fail with field not found exception or class cast exception following this log line.");
                }
                deserializeFieldName = serializedFieldName;
            }
            return deserializeFieldName;
        }
        return serializedFieldName;
    }

    private Collection<String> findOuterClassFieldNames(Class<?> type) {
        Collection<String> fields = this.classOuterFields.get(type.getName());
        if (fields == null) {
            fields = new ArrayList<String>();
            this.addOuterClassFields(type, fields);
            this.classOuterFields.put(type.getName(), fields);
        }
        return fields;
    }

    private void addOuterClassFields(Class<?> type, Collection<String> fields) {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isSynthetic()) continue;
            fields.add(field.getName());
        }
        if (type.getSuperclass() != null) {
            this.addOuterClassFields(type.getSuperclass(), fields);
        }
    }

    public void flushCache() {
        this.classOuterFields.keySet().retainAll(Collections.singletonList(Object.class.getName()));
    }
}

