/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.util.collections.MutableList;

public abstract class AbstractMemento
implements Memento,
Serializable {
    private static final long serialVersionUID = -8091049282749284567L;
    private String brooklynVersion;
    private String type;
    private String id;
    private String displayName;
    protected String catalogItemId;
    private List<String> searchPath = Lists.newArrayList();
    private List<Object> tags;
    private Map<String, Set<String>> relations;
    private String uniqueTag;
    private transient Class<?> typeClass;

    protected AbstractMemento() {
    }

    protected AbstractMemento readResolve() {
        if (this.searchPath == null) {
            this.searchPath = Lists.newArrayList();
        }
        return this;
    }

    protected AbstractMemento(Builder<?> builder) {
        this.brooklynVersion = builder.brooklynVersion;
        this.id = builder.id;
        this.type = builder.type;
        this.typeClass = builder.typeClass;
        this.displayName = builder.displayName;
        this.catalogItemId = builder.catalogItemId;
        this.searchPath = builder.searchPath;
        this.setCustomFields(builder.customFields);
        this.tags = this.toPersistedList(builder.tags);
        this.relations = this.toPersistedMap(builder.relations);
        this.uniqueTag = builder.uniqueTag;
    }

    protected abstract void setCustomFields(Map<String, Object> var1);

    public void injectTypeClass(Class<?> clazz) {
        this.typeClass = clazz;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public String getBrooklynVersion() {
        return this.brooklynVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public List<String> getCatalogItemIdSearchPath() {
        return this.searchPath;
    }

    public List<Object> getTags() {
        return this.fromPersistedList(this.tags);
    }

    public Map<String, Set<String>> getRelations() {
        return this.fromPersistedMap(this.relations);
    }

    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Deprecated
    public Object getCustomField(String name) {
        if (this.getCustomFields() == null) {
            return null;
        }
        return this.getCustomFields().get(name);
    }

    @Deprecated
    public abstract Map<String, ? extends Object> getCustomFields();

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("id", (Object)this.getId()).toString();
    }

    public String toVerboseString() {
        return this.newVerboseStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("type", (Object)this.getType()).add("displayName", (Object)this.getDisplayName()).add("tags", (Object)this.getTags()).add("relations", this.getRelations()).add("customFields", Sanitizer.sanitize(this.getCustomFields()));
    }

    protected <T> List<T> fromPersistedList(List<T> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    protected <T> List<T> toPersistedList(List<T> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l;
    }

    protected <T> Set<T> fromPersistedSet(Set<T> l) {
        if (l == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(l);
    }

    protected <T> Set<T> toPersistedSet(Set<T> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l;
    }

    protected <K, V> Map<K, V> fromPersistedMap(Map<K, V> m) {
        if (m == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    protected <K, V> Map<K, V> toPersistedMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        return m;
    }

    protected <K, V> Multimap<K, V> fromPersistedMultimap(Multimap<K, V> m) {
        if (m == null) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.copyOf(m);
    }

    protected <K, V> Multimap<K, V> toPersistedMultimap(Multimap<K, V> m) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        return m;
    }

    protected static abstract class Builder<B extends Builder<?>> {
        protected String brooklynVersion = BrooklynVersion.get();
        protected String id;
        protected String type;
        protected Class<?> typeClass;
        protected String displayName;
        protected String catalogItemId;
        protected List<String> searchPath;
        protected Map<String, Object> customFields = Maps.newLinkedHashMap();
        protected List<Object> tags = Lists.newArrayList();
        protected Map<String, Set<String>> relations = Maps.newLinkedHashMap();
        protected String uniqueTag;

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        public B from(Memento other) {
            this.brooklynVersion = other.getBrooklynVersion();
            this.id = other.getId();
            this.type = other.getType();
            this.typeClass = other.getTypeClass();
            this.displayName = other.getDisplayName();
            this.catalogItemId = other.getCatalogItemId();
            this.searchPath = this.isEmpty(other.getCatalogItemIdSearchPath()) ? MutableList.of() : MutableList.copyOf((Iterable)other.getCatalogItemIdSearchPath());
            this.customFields.putAll(other.getCustomFields());
            this.tags.addAll(other.getTags());
            this.relations.putAll(other.getRelations());
            this.uniqueTag = other.getUniqueTag();
            return this.self();
        }

        private boolean isEmpty(List<String> ids) {
            return ids == null || ids.isEmpty();
        }

        @Deprecated
        public B customFields(Map<String, ?> vals) {
            this.customFields.putAll(vals);
            return this.self();
        }
    }
}

