/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.activemq;

import com.google.common.base.Preconditions;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQBroker;
import org.apache.brooklyn.entity.messaging.activemq.ActiveMQDestination;
import org.apache.brooklyn.entity.messaging.jms.JMSDestinationImpl;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.util.exceptions.Exceptions;

public abstract class ActiveMQDestinationImpl
extends JMSDestinationImpl
implements ActiveMQDestination {
    protected ObjectName brokerMBeanName;
    protected transient JmxHelper jmxHelper;
    protected volatile JmxFeed jmxFeed;

    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        String brokerName = this.getBrokerName();
        Preconditions.checkArgument((brokerName != null && !brokerName.isEmpty() ? 1 : 0) != 0, (Object)"ActiveMQ brokerName attribute must be specified");
        try {
            this.brokerMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + brokerName);
            this.jmxHelper = new JmxHelper(this.getParent());
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected void disconnectSensors() {
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected String getBrokerName() {
        Preconditions.checkNotNull((Object)this.getParent(), (Object)"JMS Destination must have a broker parent");
        return (String)this.getParent().getAttribute(ActiveMQBroker.BROKER_NAME);
    }
}

